/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.models;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="volumeDevice describes a mapping of a raw block device within a container.")
public class V1VolumeDevice {
    @SerializedName(value="devicePath")
    private String devicePath = null;
    @SerializedName(value="name")
    private String name = null;

    public V1VolumeDevice devicePath(String devicePath) {
        this.devicePath = devicePath;
        return this;
    }

    @ApiModelProperty(required=true, value="devicePath is the path inside of the container that the device will be mapped to.")
    public String getDevicePath() {
        return this.devicePath;
    }

    public void setDevicePath(String devicePath) {
        this.devicePath = devicePath;
    }

    public V1VolumeDevice name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(required=true, value="name must match the name of a persistentVolumeClaim in the pod")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1VolumeDevice v1VolumeDevice = (V1VolumeDevice)o;
        return Objects.equals(this.devicePath, v1VolumeDevice.devicePath) && Objects.equals(this.name, v1VolumeDevice.name);
    }

    public int hashCode() {
        return Objects.hash(this.devicePath, this.name);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1VolumeDevice {\n");
        sb.append("    devicePath: ").append(this.toIndentedString(this.devicePath)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

