package com.hyphenate.chat.adapter;

import java.util.List;

public class EMAPresenceManager extends EMABase{

    public void addListener(EMAPresenceManagerListener listener){
        nativeAddListener(listener);
    }

    public void publishPresence(String ext,EMAError error){
        nativePublishPresence(1,ext,error);
    }

    public List<EMAPresence> subscribePresences(List<String> members, long expiry ,EMAError error){
        return nativeSubscribePresences(members,expiry,error);
    }

    public void unsubscribePresences(List<String> members,EMAError error){
        nativeUnsubscribePresences(members,error);
    }

    public List<String> fetchSubscribedMembers(int pageNum,int pageSize,EMAError error){
        return nativeFetchSubscribedMembers(pageNum,pageSize,error);
    }

    public List<EMAPresence> fetchPresenceStatus(List<String> members,EMAError error){
        return nativeFetchPresenceStatus(members,error);
    }

    native void nativePublishPresence(int presenceStauts, String ext, EMAError error);
    native List<EMAPresence> nativeSubscribePresences(List<String> members, long expiry, EMAError error);
    native void nativeUnsubscribePresences(List<String> members, EMAError error) ;
    native List<String> nativeFetchSubscribedMembers(int pageNum, int pageSize, EMAError error) ;
    native List<EMAPresence> nativeFetchPresenceStatus(List<String> members, EMAError error) ;
    native void nativeAddListener(EMAPresenceManagerListener listener);
    native void nativeRemoveListener(EMAPresenceManagerListener listener);
    native void nativeClearListener();

}
