package com.hyphenate.chat;

import com.hyphenate.EMCallBack;
import com.hyphenate.EMValueCallBack;
import com.hyphenate.chat.adapter.EMASilentModeItem;
import com.hyphenate.chat.adapter.EMASilentModeTime;

/**
 * \~chinese
 * 离线推送免打扰结果类。
 *
 * \~english
 * The do-not-disturb result class for offline push.
 */
public class EMSilentModeResult extends EMBase<EMASilentModeItem> {

    public EMSilentModeResult(EMASilentModeItem item){
        emaObject = item;
    }

    /**
     * \~chinese
     * 获取离线推送免打扰过期时间戳。
     * 
     * @return 免打扰过期时间戳。
     *
     * \~english
     * Gets the do-not-disturb expiration timestamp for offline push.
     * 
     * @return The do-not-disturb expiration timestamp.
     */
    public long getExpireTimestamp(){
        return emaObject.getExpireTimestamp();
    }

    /**
     * \~chinese
     * 获取会话类型。
     * 
     * @return 会话类型。
     *
     * \~english
     * Gets the conversation type.
     * 
     * @return The conversation type.
     */
    public EMConversation.EMConversationType getConversationType(){
        return EMConversation.EMConversationType.values()[emaObject.getConversationType()];
    }

    /**
     * \~chinese
     * 获取会话 ID。
     * 
     * @return 会话 ID。
     *
     * \~english
     * Gets the conversation ID.
     * 
     * @return The conversation ID.
     */
    public String getConversationId(){
        return emaObject.getConversationId();
    }

    /**
     * \~chinese
     * 会话是否启用离线推送通知类型。
     * 
     * 调用 {@link EMPushManager#setSilentModeForConversation(String, EMConversation.EMConversationType, EMSilentModeParam, EMValueCallBack)} 设置离线推送通知类型后，返回 true。
     * 调用 {@link EMPushManager#clearRemindTypeForConversation(String, EMConversation.EMConversationType, EMCallBack)} 清空设置的离线推送通知类型后，返回 false。
     * @return boolean
     *
     * \~english
     * Whether to enable the offline push notification type for the conversation.
     * 
     * `true` is returned after {@link EMPushManager#setSilentModeForConversation(String, EMConversation.EMConversationType, EMSilentModeParam, EMValueCallBack)} is called to set the offline push notification type.
     * `false` is returned after {@link EMPushManager#clearRemindTypeForConversation(String, EMConversation.EMConversationType, EMCallBack)} is called to clear the setting of the offline push notification type.
     * @return boolean
     */
    public boolean isConversationRemindTypeEnabled(){
        return emaObject.getRemindType() != 0;
    }

    /**
     * \~chinese
     * 获取离线推送通知类型。
     * 
     * @return 离线推送通知类型。
     *
     * \~english
     * Gets the offline push notification type.
     * 
     * @return The offline push notification type.
     */
    public EMPushManager.EMPushRemindType getRemindType(){
        if(emaObject.getRemindType() != 0){
            return EMPushManager.EMPushRemindType.values()[emaObject.getRemindType() - 1];
        } else {
            return EMPushManager.EMPushRemindType.ALL;
        }
    }

    /**
     * \~chinese
     * 获取离线推送免打扰时间段的开始时间。
     * 
     * @return 免打扰开始时间。
     *
     * \~english
     * Gets the start time of the do-not-disturb time frame.
     * 
     * @return The start time of the do-not-disturb time frame
     */
    public EMSilentModeTime getSilentModeStartTime(){
        EMASilentModeTime time = emaObject.getSilentModeStartTime();
        return new EMSilentModeTime(time);
    }

    /**
     * \~chinese
     * 获取离线推送免打扰时间段的结束时间。
     * 
     * @return 免打扰结束时间。
     *
     * \~english
     * Gets the end time of the do-not-disturb time frame.
     * 
     * @return The end time of the do-not-disturb time frame.
     */
    public EMSilentModeTime getSilentModeEndTime(){
        EMASilentModeTime time = emaObject.getSilentModeEndTime();
        return new EMSilentModeTime(time);
    }
}
