package com.hyphenate.chat;

public class EMRecallMessageInfo {
   /**
    * \~chinese
    * 消息撤回者的唯一标示名, 即用户的 ID。
    * <p>
    * \~english
    * The user ID of the user that recalls the message.
    */
   protected String recallBy;
   /**
    * \~chinese
    * 撤回的消息ID。
    * <p>
    * \~english
    * A recall message ID.
    */
   protected String recallMessageId;
   /**
    * \~chinese
    * 撤回的消息对象 (离线时)为null。
    * <p>
    * \~english
    * A recall message.
    */
   protected EMMessage recallMessage;
   /**
    * \~chinese
    * 撤回消息时要透传的信息。
    * <p>
    * \~english
    * An extension info on recall message.
    */
   protected String ext;

   public EMRecallMessageInfo(String recallBy,String recallMessageId, EMMessage recallMessage, String ext ){
       this.recallBy = recallBy;
       this.recallMessageId = recallMessageId;
       this.recallMessage = recallMessage;
       this.ext = ext;
   }

   public EMMessage getRecallMessage() {
      return recallMessage;
   }

   public String getRecallMessageId() {return recallMessageId;}

   public String getRecallBy() {
      return recallBy;
   }

   public String getExt() {
      return ext;
   }

}
