package com.hyphenate.chat;

import android.support.annotation.IntDef;

/**
 * \~chinese
 * chat 服务诊断过程对应的过程量，包括账号是否有效，是否从服务器获取了 DNS list，是否获取了 token，是否已登陆，是否已登出等。
 * 
 * 配合 {@link EMClient#check(String, String, EMClient.CheckResultListener)} 使用。
 *
 * \~english
 * The Chat service diagnoses process, including account validation, whether the DNS LIST and token is got from the server, 
 * whether the user has logged in or logged out.
 *
 * This enum lists the server diagnostic tests which are run for the current user when you call {@link EMClient#check(String, String, EMClient.CheckResultListener)}. 
 * This is an asynchronous method. If there is an error, check the error code to know the error information.
 * 
 * Make sure not to update the existing data, because it is related to the native CheckType defined in emchatconfigs.h.
 */
public class EMCheckType {
    public static final int ACCOUNT_VALIDATION = 0; /* \~chinese 账号检查类型，账号是否有效的检查。  \~English The check of the account validity. */
    public static final int GET_DNS_LIST_FROM_SERVER = 1; /* \~chinese 获取服务列表检查类型。  \~english The check of getting DNS from the server. */
    public static final int GET_TOKEN_FROM_SERVER = 2; /* \~chinese 获取 token 检查类型。  \~english The check of getting the token from the server. */
    public static final int DO_LOGIN = 3; /* \~chinese 登录检查类型。  \~english The check of the login mode. */
    public static final int DO_MSG_SEND = 4; /* \~chinese 消息发送状态类型。  \~english The check of the message sending status mode. */
    public static final int DO_LOGOUT = 5; /* \~chinese 登出检查类型。  \~english The check of the logout mode. */

    @IntDef({ACCOUNT_VALIDATION, GET_DNS_LIST_FROM_SERVER, GET_TOKEN_FROM_SERVER, DO_LOGIN, DO_LOGOUT})
    public @interface CheckType {}
}
