/*
 * Decompiled with CFR 0.152.
 */
package com.hyphenate.util;

import com.hyphenate.util.EMLog;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.security.KeyStore;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;

public class EasyUtils {
    public static final String TAG = "EasyUtils";
    private static Hashtable<String, String> resourceTable = new Hashtable();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static X509Certificate[] convertToCerts(List<String> certschain) {
        ArrayList<X509Certificate> arrayList = new ArrayList<X509Certificate>();
        ByteArrayInputStream byteArrayInputStream = null;
        for (int i = 0; i < certschain.size(); ++i) {
            String string = certschain.get(i);
            try {
                byteArrayInputStream = new ByteArrayInputStream(string.getBytes(StandardCharsets.UTF_8));
                CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
                X509Certificate x509Certificate = (X509Certificate)certificateFactory.generateCertificate(byteArrayInputStream);
                arrayList.add(x509Certificate);
                continue;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                EMLog.e(TAG, exception.getMessage());
                continue;
            }
            finally {
                if (byteArrayInputStream != null) {
                    try {
                        ((InputStream)byteArrayInputStream).close();
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                }
            }
        }
        X509Certificate[] x509CertificateArray = new X509Certificate[arrayList.size()];
        arrayList.toArray(x509CertificateArray);
        return x509CertificateArray;
    }

    public static X509TrustManager getSystemDefaultTrustManager() {
        try {
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            trustManagerFactory.init((KeyStore)null);
            TrustManager[] trustManagerArray = trustManagerFactory.getTrustManagers();
            for (int i = 0; i < trustManagerArray.length; ++i) {
                if (!(trustManagerArray[i] instanceof X509TrustManager)) continue;
                return (X509TrustManager)trustManagerArray[i];
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return null;
    }
}

