/*
 * Decompiled with CFR 0.152.
 */
package com.hyphenate.util;

import android.content.Context;
import android.content.SharedPreferences;
import android.text.TextUtils;
import com.hyphenate.util.EMLog;
import java.util.Map;
import java.util.UUID;

public class DeviceUuidFactory {
    protected static final String PREFS_FILE = "device_id.xml";
    protected static final String PREFS_DEVICE_ID = "device_id";
    protected static final String PREFS_DEVICE_ID_BAK_FILE = "prefs_device_id_bak";
    protected static final String PREFS_DEVICE_ID_BAK = "device_id_bak";
    protected static UUID uuid;

    public DeviceUuidFactory(Context context) {
        if (uuid == null) {
            SharedPreferences sharedPreferences = context.getSharedPreferences(PREFS_FILE, 0);
            String string = sharedPreferences.getString(PREFS_DEVICE_ID, null);
            if (string != null) {
                uuid = UUID.fromString(string);
            } else {
                EMLog.e("DeviceUuidFactory", "Need to generate device uuid");
                uuid = this.generateDeviceUuid(context);
                sharedPreferences.edit().putString(PREFS_DEVICE_ID, uuid.toString()).commit();
            }
        }
    }

    private UUID generateDeviceUuid(Context context) {
        return UUID.randomUUID();
    }

    public UUID getDeviceUuid() {
        return uuid;
    }

    private static boolean isEmpty(Object s) {
        if (s == null) {
            return true;
        }
        if (s instanceof String && ((String)s).trim().length() == 0) {
            return true;
        }
        if (s instanceof Map) {
            return ((Map)s).isEmpty();
        }
        return false;
    }

    public static void saveBakDeviceId(Context context, String deviceId) {
        if (context == null || TextUtils.isEmpty((CharSequence)deviceId)) {
            return;
        }
        EMLog.e("DeviceUuidFactory", "saveBakDeviceId");
        SharedPreferences sharedPreferences = context.getSharedPreferences(PREFS_DEVICE_ID_BAK_FILE, 0);
        sharedPreferences.edit().putString(PREFS_DEVICE_ID_BAK, deviceId).commit();
    }

    public static String getBakDeviceId(Context context) {
        if (context == null) {
            return "";
        }
        SharedPreferences sharedPreferences = context.getSharedPreferences(PREFS_DEVICE_ID_BAK_FILE, 0);
        return sharedPreferences.getString(PREFS_DEVICE_ID_BAK, "");
    }
}

