/*
 * Decompiled with CFR 0.152.
 */
package com.hyphenate.cloud;

import android.content.Context;
import android.net.Uri;
import android.os.ParcelFileDescriptor;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import android.util.Pair;
import com.hyphenate.chat.EMClient;
import com.hyphenate.chat.adapter.EMARHttpCallback;
import com.hyphenate.cloud.EMHttpClient;
import com.hyphenate.cloud.HttpCallback;
import com.hyphenate.cloud.HttpClientConfig;
import com.hyphenate.cloud.HttpClientController;
import com.hyphenate.cloud.HttpResponse;
import com.hyphenate.exceptions.HyphenateException;
import com.hyphenate.util.EMFileHelper;
import com.hyphenate.util.EMLog;
import com.hyphenate.util.NetUtils;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.util.HashMap;
import java.util.Map;

public class HttpClientManager {
    private static final String TAG = "HttpClientManager";
    public static String Method_GET = "GET";
    public static String Method_POST = "POST";
    public static String Method_PUT = "PUT";
    public static String Method_DELETE = "DELETE";
    public static final int max_retries_times_on_connection_refused = 3;
    private static final int max_retry_times_on_connection_refused = 20;
    private static volatile long retrivedTokenTime = 0L;
    private static final int retriveInterval = 120000;
    private static int HIGH_SPEED_DOWNLOAD_BUF_SIZE = 30720;
    private static final int REQUEST_FAILED_CODE = 408;
    private static volatile boolean isRetring = false;

    public static Pair<Integer, String> sendGetRequest(String url, Map<String, String> headers) throws HyphenateException {
        return HttpClientManager.sendRequestWithToken(url, null, headers, Method_GET);
    }

    public static Pair<Integer, String> sendPostRequest(String url, String body, Map<String, String> headers) throws HyphenateException {
        return HttpClientManager.sendRequestWithToken(url, body, headers, Method_POST);
    }

    public static Pair<Integer, String> sendPutRequest(String url, String body, Map<String, String> headers) throws HyphenateException {
        return HttpClientManager.sendRequestWithToken(url, body, headers, Method_PUT);
    }

    public static int uploadFile(String localFilePath, String remoteFilePath, int fpaPort, String filename, Map<String, String> headers, StringBuilder responseBuf, EMARHttpCallback callback) {
        int n = new Builder(EMClient.getInstance().getContext()).uploadFile(localFilePath).setUrl(remoteFilePath).setFpaPort(fpaPort).setFilename(filename).setConnectTimeout(30000).setHeaders(headers).setHeader("app", EMClient.getInstance().getOptions().getAppKey()).setHeader("id", EMClient.getInstance().getCurrentUser()).execute(responseBuf, callback);
        EMLog.d(TAG, "upload code = " + n);
        return n;
    }

    public static int downloadFile(String remoteUrl, String localFilePath, Map<String, String> headers, EMARHttpCallback callback) {
        return new Builder(EMClient.getInstance().getContext()).downloadFile(localFilePath).setConnectTimeout(30000).setUrl(remoteUrl).setHeaders(headers).execute(null, callback);
    }

    public static int downloadFile(String remoteUrl, int fpaPort, String localFilePath, Map<String, String> headers, StringBuilder responseBuf, EMARHttpCallback callback) {
        return new Builder(EMClient.getInstance().getContext()).downloadFile(localFilePath).setConnectTimeout(30000).setUrl(remoteUrl).setFpaPort(fpaPort).setHeaders(headers).execute(responseBuf, callback);
    }

    public static Pair<Integer, String> sendDeleteRequest(String url, Map<String, String> headers) throws HyphenateException {
        return HttpClientManager.sendRequestWithToken(url, null, headers, Method_DELETE);
    }

    public static Pair<Integer, String> sendRequestWithToken(String url, String body, String method) throws HyphenateException {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("Authorization", "Bearer " + EMClient.getInstance().getOptions().getAccessToken());
        try {
            return HttpClientManager.sendHttpRequestWithRetryToken(url, hashMap, body, method);
        }
        catch (IOException iOException) {
            String string = " send request : " + url + " failed!";
            if (iOException != null && iOException.toString() != null) {
                string = iOException.toString();
            }
            EMLog.d(TAG, string);
            throw new HyphenateException(1, string);
        }
    }

    static Pair<Integer, String> sendRequestWithToken(String url, String body, Map<String, String> headers, String method) throws HyphenateException {
        if (headers == null) {
            headers = new HashMap<String, String>();
        }
        if (TextUtils.isEmpty((CharSequence)headers.get("Authorization"))) {
            headers.put("Authorization", "Bearer " + EMClient.getInstance().getOptions().getAccessToken());
        }
        try {
            return HttpClientManager.sendHttpRequestWithRetryToken(url, headers, body, method);
        }
        catch (IOException iOException) {
            String string = " send request : " + url + " failed!";
            if (iOException != null && iOException.toString() != null) {
                string = iOException.toString();
            }
            EMLog.d(TAG, string);
            throw new HyphenateException(1, string);
        }
    }

    static Pair<Integer, String> sendHttpRequestWithRetryToken(String reqURL, Map<String, String> headers, String body, String method) throws HyphenateException, IOException {
        return HttpClientManager.sendRequest(reqURL, headers, body, method);
    }

    public static Pair<Integer, String> sendRequest(String reqURL, Map<String, String> headers, String body, String method) throws IOException, HyphenateException {
        Pair pair = null;
        HttpResponse httpResponse = new Builder(EMClient.getInstance().getContext()).setRequestMethod(method).setUrl(reqURL).setHeaders(headers).setParams(body).execute();
        if (httpResponse != null) {
            pair = new Pair((Object)httpResponse.code, (Object)httpResponse.content);
        }
        return pair;
    }

    public static HttpResponse httpExecute(String reqURL, Map<String, String> headers, String body, String method, int timeout) throws IOException {
        return new Builder(EMClient.getInstance().getContext()).setRequestMethod(method).setUrl(reqURL).setConnectTimeout(timeout).setHeaders(headers).withToken(false).setParams(body).execute();
    }

    public static HttpResponse httpExecute(String reqURL, int fpaPort, Map<String, String> headers, String body, String method, int timeout) throws IOException {
        return new Builder(EMClient.getInstance().getContext()).setRequestMethod(method).setUrl(reqURL).setFpaPort(fpaPort).setConnectTimeout(timeout).setHeaders(headers).withToken(false).setParams(body).execute();
    }

    public static HttpResponse httpExecute(String reqURL, Map<String, String> headers, String body, String method) throws IOException {
        int n = HttpClientConfig.getTimeout(headers);
        return HttpClientManager.httpExecute(reqURL, headers, body, method, n);
    }

    public static HttpResponse httpExecute(String reqURL, int fpaPort, Map<String, String> headers, String body, String method) throws IOException {
        int n = HttpClientConfig.getTimeout(headers);
        return HttpClientManager.httpExecute(reqURL, fpaPort, headers, body, method, n);
    }

    static String getNewHost(String reqUrl, String baseUrl) {
        return HttpClientConfig.getNewHost(reqUrl, baseUrl);
    }

    private static long onDownloadCompleted(HttpResponse response, String localFilePath, HttpCallback callback) throws IOException, IllegalStateException {
        InputStream inputStream = null;
        FileOutputStream fileOutputStream = null;
        int n = 0;
        int n2 = 0;
        long l = response.contentLength;
        inputStream = response.inputStream;
        int n3 = inputStream.available();
        EMLog.d(TAG, "inputStream length = " + n3);
        File file = new File(localFilePath);
        try {
            fileOutputStream = new FileOutputStream(localFilePath);
        }
        catch (IOException iOException) {
            EMLog.e(TAG, iOException.getMessage());
            inputStream.close();
            throw iOException;
        }
        int n4 = HIGH_SPEED_DOWNLOAD_BUF_SIZE;
        byte[] byArray = new byte[n4];
        long l2 = 0L;
        try {
            while ((n = inputStream.read(byArray)) != -1) {
                int n5 = (int)((l2 += (long)n) * 100L / l);
                EMLog.d(TAG, n5 + "");
                if (n5 == 100 || n5 > n2 + 5) {
                    n2 = n5;
                    if (callback != null) {
                        callback.onProgress(l, l2);
                    }
                }
                fileOutputStream.write(byArray, 0, n);
            }
            long l3 = file.length();
            return l3;
        }
        catch (IOException iOException) {
            EMLog.e(TAG, iOException.getMessage());
            throw iOException;
        }
        finally {
            fileOutputStream.close();
            inputStream.close();
        }
    }

    private static long onDownloadCompleted(HttpResponse response, Uri localFilePath, HttpCallback callback) throws IOException, IllegalStateException {
        InputStream inputStream = null;
        FileOutputStream fileOutputStream = null;
        int n = 0;
        int n2 = 0;
        long l = response.contentLength;
        inputStream = response.inputStream;
        ParcelFileDescriptor parcelFileDescriptor = null;
        try {
            parcelFileDescriptor = EMClient.getInstance().getContext().getContentResolver().openFileDescriptor(localFilePath, "w");
            fileOutputStream = new FileOutputStream(parcelFileDescriptor.getFileDescriptor());
        }
        catch (Exception exception) {
            EMLog.e(TAG, exception.getMessage());
            inputStream.close();
            throw exception;
        }
        int n3 = HIGH_SPEED_DOWNLOAD_BUF_SIZE;
        byte[] byArray = new byte[n3];
        long l2 = 0L;
        try {
            int n4;
            while ((n = inputStream.read(byArray)) != -1) {
                n4 = (int)((l2 += (long)n) * 100L / l);
                EMLog.d(TAG, n4 + "");
                if (n4 == 100 || n4 > n2 + 5) {
                    n2 = n4;
                    if (callback != null) {
                        callback.onProgress(l, l2);
                    }
                }
                ((OutputStream)fileOutputStream).write(byArray, 0, n);
                EMLog.d(TAG, "\u6267\u884c\u5199\u5165\u64cd\u4f5c count = " + n);
            }
            n4 = EMFileHelper.getInstance().isFileExist(localFilePath);
            EMLog.d(TAG, "download by uri fileExistByUri = " + (n4 != 0));
            long l3 = inputStream.available();
            return l3;
        }
        catch (IOException iOException) {
            EMLog.e(TAG, iOException.getMessage());
            throw iOException;
        }
        finally {
            if (fileOutputStream != null) {
                ((OutputStream)fileOutputStream).close();
            }
            if (inputStream != null) {
                inputStream.close();
            }
        }
    }

    public static class Builder {
        private final HttpClientController.HttpParams p;

        public Builder() {
            this(EMClient.getInstance().getContext());
        }

        public Builder(Context context) {
            this.p = new HttpClientController.HttpParams(context);
        }

        public Builder get() {
            this.p.mRequestMethod = "GET";
            return this;
        }

        public Builder post() {
            this.p.mRequestMethod = "POST";
            return this;
        }

        public Builder put() {
            this.p.mRequestMethod = "PUT";
            return this;
        }

        public Builder delete() {
            this.p.mRequestMethod = "DELETE";
            return this;
        }

        public Builder uploadFile(String fileLocalPath) {
            this.p.mRequestMethod = "POST";
            this.p.mLocalFileUri = fileLocalPath;
            this.p.isUploadFile = true;
            return this;
        }

        public Builder uploadFile(String fileLocalPath, String filename, String fileKey) {
            this.p.mRequestMethod = "POST";
            this.p.mLocalFileUri = fileLocalPath;
            this.p.mFilename = filename;
            this.p.mFileKey = fileKey;
            this.p.isUploadFile = true;
            return this;
        }

        public Builder downloadFile(String downloadPath) {
            this.p.mRequestMethod = "GET";
            this.p.mDownloadPath = downloadPath;
            this.p.isDownloadFile = true;
            return this;
        }

        public Builder setRequestMethod(@NonNull String requestMethod) {
            this.p.mRequestMethod = requestMethod;
            return this;
        }

        public Builder setUrl(@NonNull String url) {
            this.p.mUrl = url;
            return this;
        }

        public Builder setUrl(@NonNull String url, int port) {
            this.p.mUrl = url;
            this.p.mPort = port;
            return this;
        }

        public Builder setFpaPort(int fpaPort) {
            this.p.fpaPort = fpaPort;
            return this;
        }

        public Builder setConnectTimeout(int timeout) {
            this.p.mConnectTimeout = timeout;
            return this;
        }

        public Builder setReadTimeout(int timeout) {
            this.p.mReadTimeout = timeout;
            return this;
        }

        public Builder setHeader(String key, String value) {
            this.p.mHeaders.put(key, value);
            return this;
        }

        public Builder setHeaders(Map<String, String> headers) {
            this.p.mHeaders.putAll(headers);
            return this;
        }

        public Builder setParam(String key, String value) {
            this.p.mParams.put(key, value);
            return this;
        }

        public Builder setParams(Map<String, String> params) {
            this.p.mParams.putAll(params);
            return this;
        }

        public Builder setParams(String params) {
            this.p.mParamsString = params;
            return this;
        }

        public Builder isCanRetry(boolean canRetry) {
            this.p.canRetry = canRetry;
            return this;
        }

        public Builder setRetryTimes(int retryTimes) {
            this.p.canRetry = true;
            this.p.mRetryTimes = retryTimes;
            return this;
        }

        public Builder setLocalFilePath(String fileUri) {
            this.p.mLocalFileUri = fileUri;
            return this;
        }

        public Builder setFilename(String filename) {
            this.p.mFilename = filename;
            return this;
        }

        public Builder setFileKey(String fileKey) {
            this.p.mFileKey = fileKey;
            return this;
        }

        public Builder setDownloadPath(String path) {
            this.p.mDownloadPath = path;
            return this;
        }

        public Builder checkAndProcessSSL(boolean checkSSL) {
            this.p.isCheckSSL = checkSSL;
            return this;
        }

        public Builder withToken(boolean withToken) {
            this.p.isNotUseToken = !withToken;
            return this;
        }

        public Builder followRedirect(boolean followRedirect) {
            this.p.followRedirect = followRedirect;
            return this;
        }

        public HttpClientController build() throws IOException {
            HttpClientController httpClientController = new HttpClientController(this.p.mContext);
            this.p.apply(httpClientController);
            return httpClientController;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private HttpResponse executePrivate(HttpCallback callback) throws Exception {
            HttpResponse httpResponse = null;
            HttpClientController httpClientController = null;
            try {
                Object object;
                boolean bl;
                block19: {
                    httpClientController = this.build();
                    HttpURLConnection httpURLConnection = httpClientController.i();
                    bl = false;
                    if (httpURLConnection.getDoOutput()) {
                        object = new DataOutputStream(httpURLConnection.getOutputStream());
                        httpClientController.a(this.p.mParamsString, (OutputStream)object);
                        httpClientController.a(this.p.mParams, (OutputStream)object);
                        try {
                            this.p.addFile(httpClientController, (OutputStream)object, callback);
                        }
                        catch (IOException iOException) {
                            if (!TextUtils.isEmpty((CharSequence)iOException.getMessage()) && iOException.getMessage().contains("Connection reset")) {
                                bl = true;
                                break block19;
                            }
                            throw iOException;
                        }
                        finally {
                            if (object != null) {
                                ((FilterOutputStream)object).close();
                            }
                        }
                    }
                }
                httpResponse = this.p.getResponse(httpClientController);
                if (bl && httpResponse.code != 413) {
                    object = "Connection reset but not 413";
                    if (callback != null) {
                        callback.onError(httpResponse.code, (String)object);
                    }
                    httpResponse.content = object;
                }
                if (httpResponse.code == 401) {
                    EMClient.getInstance().notifyTokenExpired(httpResponse.content);
                }
                if (httpResponse.code == 200) {
                    if (this.p.isDownloadFile) {
                        return this.download(httpResponse, callback);
                    }
                    if (callback != null) {
                        callback.onSuccess(httpResponse.content);
                    }
                } else if (callback != null) {
                    callback.onError(httpResponse.code, httpResponse.content);
                }
            }
            catch (IOException iOException) {
                EMLog.e(HttpClientManager.TAG, "exception: " + iOException.getClass().getSimpleName() + " error message = " + iOException.getMessage());
                throw iOException;
            }
            catch (IllegalStateException illegalStateException) {
                EMLog.e(HttpClientManager.TAG, "error message = " + illegalStateException.getMessage());
                throw illegalStateException;
            }
            return httpResponse;
        }

        public int execute(StringBuilder responseBuf, final EMARHttpCallback callback) {
            int n = 408;
            HttpResponse httpResponse = null;
            try {
                httpResponse = this.executePrivate(new HttpCallback(){

                    @Override
                    public void onSuccess(String result) {
                    }

                    @Override
                    public void onError(int code, String msg) {
                    }

                    @Override
                    public void onProgress(long total, long pos) {
                        if (callback != null) {
                            callback.onProgress(total, pos);
                        }
                    }
                });
                n = httpResponse.code;
                try {
                    if (responseBuf != null) {
                        responseBuf.append(httpResponse.content);
                    }
                }
                catch (Exception exception) {
                    EMLog.e(HttpClientManager.TAG, "json parse exception remotefilepath:" + this.p.mUrl);
                }
                return n;
            }
            catch (Exception exception) {
                String string = exception != null && exception.getMessage() != null ? exception.getMessage() : "failed to upload the files";
                EMLog.e(HttpClientManager.TAG, "error asyncExecute:" + string);
                if (string.toLowerCase().contains("refused") && NetUtils.hasNetwork(this.p.mContext) && this.p.canRetry && this.p.mRetryTimes > 0) {
                    String string2 = EMHttpClient.getInstance().chatConfig().l();
                    this.p.mUrl = HttpClientManager.getNewHost(this.p.mUrl, string2);
                    --this.p.mRetryTimes;
                    EMLog.d(HttpClientManager.TAG, "\u91cd\u8bd5\u4e2d\u3002\u3002\u3002");
                    return this.execute(responseBuf, callback);
                }
                try {
                    if (responseBuf != null) {
                        responseBuf.append(string);
                    }
                }
                catch (Exception exception2) {
                    // empty catch block
                }
                if (httpResponse != null) {
                    return httpResponse.code;
                }
                EMLog.e(HttpClientManager.TAG, exception.getMessage());
                return n;
            }
        }

        public HttpResponse execute() {
            return this.execute(null);
        }

        public HttpResponse execute(HttpCallback callback) {
            if (this.p.isUploadFile || this.p.isDownloadFile) {
                return this.executeFile(callback);
            }
            return this.executeNormal(callback);
        }

        public void asyncExecute(HttpCallback callback) {
            if (this.p.isUploadFile || this.p.isDownloadFile) {
                this.asyncExecuteFile(callback);
            } else {
                this.asyncExecuteNormal(callback);
            }
        }

        private void asyncExecuteNormal(final HttpCallback callback) {
            new Thread(){

                @Override
                public void run() {
                    this.executeNormal(callback);
                }
            }.start();
        }

        private HttpResponse executeNormal(HttpCallback callback) {
            HttpResponse httpResponse = null;
            try {
                httpResponse = this.executePrivate(callback);
                if (httpResponse.code != 200 && this.p.canRetry && this.p.mRetryTimes > 0) {
                    --this.p.mRetryTimes;
                    return this.executeNormal(callback);
                }
                return httpResponse;
            }
            catch (Exception exception) {
                String string = exception != null && exception.getMessage() != null ? exception.getMessage() : "failed to request";
                EMLog.e(HttpClientManager.TAG, "error execute:" + string);
                if (this.p.canRetry && this.p.mRetryTimes > 0) {
                    --this.p.mRetryTimes;
                    return this.executeNormal(callback);
                }
                if (httpResponse == null) {
                    httpResponse = new HttpResponse();
                }
                if (httpResponse.code == 0) {
                    httpResponse.code = 408;
                }
                httpResponse.content = string;
                if (callback != null) {
                    callback.onError(httpResponse.code, string);
                }
                return httpResponse;
            }
        }

        private HttpResponse executeFile(HttpCallback callback) {
            HttpResponse httpResponse = null;
            try {
                httpResponse = this.executePrivate(callback);
                int n = httpResponse.code;
                String string = "";
                switch (n) {
                    case 401: {
                        long l = EMHttpClient.getInstance().chatConfig().n();
                        if (System.currentTimeMillis() - l <= 600000L) {
                            string = "unauthorized file";
                            if (callback != null) {
                                callback.onError(n, string);
                            }
                            httpResponse.content = string;
                        }
                        if (this.p.canRetry && this.p.mRetryTimes > 0) {
                            String string2 = EMHttpClient.getInstance().chatConfig().l();
                            this.p.mUrl = HttpClientManager.getNewHost(this.p.mUrl, string2);
                            --this.p.mRetryTimes;
                            return this.executeFile(callback);
                        }
                        return httpResponse;
                    }
                }
                return httpResponse;
            }
            catch (Exception exception) {
                String string = exception != null && exception.getMessage() != null ? exception.getMessage() : (this.p.isUploadFile ? "failed to upload the file" : "failed to download file");
                EMLog.e(HttpClientManager.TAG, "error execute:" + string);
                if (string.toLowerCase().contains("refused") && NetUtils.hasNetwork(this.p.mContext)) {
                    if (!this.p.isDefaultRetry) {
                        this.p.isDefaultRetry = true;
                        this.p.mRetryTimes = 20;
                        this.p.canRetry = true;
                        String string3 = EMHttpClient.getInstance().chatConfig().l();
                        this.p.mUrl = HttpClientManager.getNewHost(this.p.mUrl, string3);
                        return this.executeFile(callback);
                    }
                    if (this.p.canRetry && this.p.mRetryTimes > 0) {
                        String string4 = EMHttpClient.getInstance().chatConfig().l();
                        this.p.mUrl = HttpClientManager.getNewHost(this.p.mUrl, string4);
                        --this.p.mRetryTimes;
                        return this.executeFile(callback);
                    }
                }
                if (httpResponse == null) {
                    httpResponse = new HttpResponse();
                }
                if (httpResponse.code == 0) {
                    httpResponse.code = 408;
                }
                httpResponse.content = string;
                if (callback != null) {
                    callback.onError(httpResponse.code, httpResponse.content);
                }
                return httpResponse;
            }
        }

        private void asyncExecuteFile(final HttpCallback callback) {
            new Thread(){

                @Override
                public void run() {
                    this.executeFile(callback);
                }
            }.start();
        }

        private HttpResponse download(HttpResponse response, HttpCallback callback) throws IOException, IllegalStateException {
            File file;
            String string = EMFileHelper.getInstance().getFilePath(this.p.mDownloadPath);
            if (!TextUtils.isEmpty((CharSequence)string) && !(file = new File(string)).getParentFile().exists()) {
                file.getParentFile().mkdirs();
            }
            long l = 0L;
            String string2 = "";
            l = this.p.mDownloadPath.startsWith("content") ? HttpClientManager.onDownloadCompleted(response, EMFileHelper.getInstance().formatInUri(this.p.mLocalFileUri), callback) : HttpClientManager.onDownloadCompleted(response, string, callback);
            if (l <= 0L) {
                string2 = "downloaded content size is zero!";
                if (callback != null) {
                    callback.onError(408, string2);
                }
                response.code = 408;
                response.content = string2;
                return response;
            }
            string2 = "download successfully";
            if (callback != null) {
                EMLog.e(HttpClientManager.TAG, "download successfully");
                callback.onSuccess(string2);
            }
            return response;
        }
    }
}

