/*
 * Decompiled with CFR 0.152.
 */
package com.hyphenate.chat.adapter;

import android.text.TextUtils;
import com.hyphenate.chat.adapter.EMARHttpCallback;
import com.hyphenate.cloud.HttpClientManager;
import com.hyphenate.cloud.HttpResponse;
import com.hyphenate.util.EMLog;
import java.io.IOException;
import java.util.Map;
import org.apache.http.conn.ConnectTimeoutException;

public class EMARHttpAPI {
    public static final String TAG = "EMARHttpAPI";
    public static int REQUEST_FAILED_CODE = 408;

    public static int upload(String localFilePath, String remoteFilePath, String filename, Map<String, String> headers, int fpaPort, StringBuilder responseBuf, EMARHttpCallback callback) {
        if (TextUtils.isEmpty((CharSequence)localFilePath)) {
            return 400;
        }
        EMLog.d(TAG, "upload uri = " + localFilePath + " remoteFilePath = " + remoteFilePath);
        return HttpClientManager.uploadFile(localFilePath, remoteFilePath, fpaPort, filename, headers, responseBuf, callback);
    }

    public static int download(String remoteUrl, String localFilePath, Map<String, String> headers, EMARHttpCallback callback) {
        if (TextUtils.isEmpty((CharSequence)localFilePath)) {
            return 400;
        }
        return HttpClientManager.downloadFile(remoteUrl, localFilePath, headers, callback);
    }

    public static int download(String remoteUrl, String localFilePath, Map<String, String> headers, int fpaPort, StringBuilder responseBuf, EMARHttpCallback callback) {
        if (TextUtils.isEmpty((CharSequence)localFilePath)) {
            return 400;
        }
        return HttpClientManager.downloadFile(remoteUrl, fpaPort, localFilePath, headers, responseBuf, callback);
    }

    public static int httpExecute(String reqURL, Map<String, String> headers, String body, String method, int fpaPort, StringBuilder strResponse) {
        int n = REQUEST_FAILED_CODE;
        try {
            HttpResponse httpResponse = EMARHttpAPI._httpExecute(reqURL, headers, body, method, fpaPort);
            strResponse.append(httpResponse.content);
            n = httpResponse.code;
            if (n == 408) {
                n = 301;
            }
            EMLog.d(TAG, "httpExecute code: " + n);
            return n;
        }
        catch (ConnectTimeoutException connectTimeoutException) {
            EMLog.e(TAG, "ConnectTimeoutException");
        }
        catch (Exception exception) {
            EMLog.e(TAG, exception.getClass().getSimpleName() + ": " + exception.getMessage());
            exception.printStackTrace();
        }
        EMLog.e(TAG, "can't catch exceptions");
        return n;
    }

    private static HttpResponse _httpExecute(String reqURL, Map<String, String> headers, String body, String method, int fpaPort) throws IOException {
        return HttpClientManager.httpExecute(reqURL, fpaPort, headers, body, method);
    }
}

