/*
 * Decompiled with CFR 0.152.
 */
package com.hyphenate.chat.adapter;

import com.hyphenate.chat.EMConversation;
import com.hyphenate.chat.EMCursorResult;
import com.hyphenate.chat.adapter.EMABase;
import com.hyphenate.chat.adapter.EMAChatManagerListener;
import com.hyphenate.chat.adapter.EMAConversation;
import com.hyphenate.chat.adapter.EMAError;
import com.hyphenate.chat.adapter.EMAFetchMessageOption;
import com.hyphenate.chat.adapter.message.EMAMessage;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class EMAChatManager
extends EMABase {
    private Set<EMAChatManagerListener> listeners = new HashSet<EMAChatManagerListener>();

    public void sendMessage(EMAMessage msg) {
        this.nativeSendMessage(msg);
    }

    public void recallMessage(EMAMessage msg, EMAError error) {
        this.nativeRecallMessage(msg, error);
    }

    public void sendReadAckForConversation(String conversationId, EMAError error) {
        this.nativeSendReadAckForConversation(conversationId, error);
    }

    public void sendReadAckForMessage(EMAMessage msg) {
        this.nativeSendReadAckForMessage(msg);
    }

    public void downloadMessageThumbnail(EMAMessage msg) {
        this.nativeDownloadMessageThumbnail(msg);
    }

    public void downloadMessageAttachments(EMAMessage msg) {
        this.nativeDownloadMessageAttachments(msg);
    }

    public void removeConversation(String conversationId, boolean isRemoveMessages, boolean isThread) {
        this.nativeRemoveConversation(conversationId, isRemoveMessages, isThread);
    }

    public EMAError deleteConversationFromServer(String conversationId, EMAConversation.EMAConversationType type, boolean isDeleteServerMessages) {
        return this.nativeDeleteConversationFromServer(conversationId, type.ordinal(), isDeleteServerMessages);
    }

    public EMAConversation conversationWithType(String conversationId, EMAConversation.EMAConversationType type, boolean createIfNotExist, boolean isThread) {
        return this.nativeConversationWithType(conversationId, type.ordinal(), createIfNotExist, isThread);
    }

    public List<EMAConversation> getConversations() {
        return this.nativeGetConversations();
    }

    public void addListener(EMAChatManagerListener listener) {
        this.listeners.add(listener);
        this.nativeAddListener(listener);
    }

    public void removeListener(EMAChatManagerListener listener) {
        this.listeners.remove(listener);
        this.nativeRemoveListener(listener);
    }

    public void clearListeners() {
        this.listeners.clear();
        this.nativeClearListeners();
    }

    public EMAMessage getMessage(String messageId) {
        return this.nativeGetMessage(messageId);
    }

    public EMAMessage getMessage(long nativeHandler) {
        return this.nativeGetMessageByHandler(nativeHandler);
    }

    public void uploadLog() {
        this.nativeUploadLog();
    }

    public EMAError deleteRoamMsgFromServerByTime(String conversationId, EMConversation.EMConversationType type, long startTimeStamp) {
        return this.nativeDeleteRoamMsgFromServerByTime(conversationId, type.ordinal(), startTimeStamp);
    }

    native void nativeSendMessage(EMAMessage var1);

    native void nativeRecallMessage(EMAMessage var1, EMAError var2);

    native void nativeSendReadAckForConversation(String var1, EMAError var2);

    native void nativeSendReadAckForMessage(EMAMessage var1);

    native void nativeDownloadMessageThumbnail(EMAMessage var1);

    native void nativeDownloadMessageAttachments(EMAMessage var1);

    native void nativeRemoveConversation(String var1, boolean var2, boolean var3);

    native EMAError nativeDeleteConversationFromServer(String var1, int var2, boolean var3);

    native EMAConversation nativeConversationWithType(String var1, int var2, boolean var3, boolean var4);

    native List<EMAConversation> nativeGetConversations();

    native void nativeAddListener(EMAChatManagerListener var1);

    native void nativeRemoveListener(EMAChatManagerListener var1);

    native void nativeClearListeners();

    native EMAMessage nativeGetMessage(String var1);

    native EMAMessage nativeGetMessageByHandler(long var1);

    native void nativeUploadLog();

    protected EMAChatManager() {
    }

    protected EMAChatManager(EMAChatManager manager) {
        this.nativeInit(manager);
    }

    native void nativeInit(EMAChatManager var1);

    public EMCursorResult<EMAMessage> fetchHistoryMessages(String conversationId, int type, int pageSize, String cursor, EMAFetchMessageOption option, EMAError error) {
        return this.nativeFetchHistoryMessagesByOption(conversationId, type, pageSize, cursor, option, error);
    }

    native EMCursorResult<EMAMessage> nativeFetchHistoryMessagesByOption(String var1, int var2, int var3, String var4, EMAFetchMessageOption var5, EMAError var6);

    native EMAError nativeDeleteRoamMsgFromServerByTime(String var1, int var2, long var3);

    public EMCursorResult<EMAConversation> fetchPinnedConversationsFromServer(int limit, String cursor, EMAError error) {
        return this.nativeFetchPinnedConversationsFromServer(limit, cursor, error);
    }

    native EMCursorResult<EMAConversation> nativeFetchPinnedConversationsFromServer(int var1, String var2, EMAError var3);

    public EMCursorResult<EMAConversation> fetchConversationsFromServerWithCursor(int limit, String cursor, EMAError error) {
        return this.nativeFetchConversationsFromServerWithCursor(limit, cursor, error);
    }

    native EMCursorResult<EMAConversation> nativeFetchConversationsFromServerWithCursor(int var1, String var2, EMAError var3);

    public void pinConversation(String conversationId, boolean isPinned, EMAError error) {
        this.nativePinConversation(conversationId, isPinned, error);
    }

    native void nativePinConversation(String var1, boolean var2, EMAError var3);
}

