/*
 * Decompiled with CFR 0.152.
 */
package com.hyphenate.chat.adapter;

import com.hyphenate.chat.adapter.EMABase;
import com.hyphenate.chat.adapter.EMAChatConfig;
import com.hyphenate.chat.adapter.EMAChatManager;
import com.hyphenate.chat.adapter.EMAChatRoomManager;
import com.hyphenate.chat.adapter.EMAConnectionListener;
import com.hyphenate.chat.adapter.EMAError;
import com.hyphenate.chat.adapter.EMALogCallbackListener;

public class EMAChatClient
extends EMABase {
    private EMAChatManager chatManager = null;
    private EMAChatRoomManager chatRoomManager = null;

    public static EMAChatClient create(EMAChatConfig chatConfig) {
        EMAChatClient eMAChatClient = new EMAChatClient();
        eMAChatClient.nativeHandler = EMAChatClient.native_create(chatConfig);
        if (eMAChatClient.getChatManager() == null) {
            eMAChatClient.chatManager = new EMAChatManager();
            eMAChatClient.getChatManager().nativeHandler = eMAChatClient.native_getChatManager();
        }
        if (eMAChatClient.getChatRoomManager() == null) {
            eMAChatClient.chatRoomManager = new EMAChatRoomManager();
            eMAChatClient.getChatRoomManager().nativeHandler = eMAChatClient.native_getChatRoomManager();
        }
        return eMAChatClient;
    }

    public void login(String username, String code, boolean autoLogin, int loginType, EMAError error) {
        this.native_login(username, code, autoLogin, loginType, error);
    }

    public String getUserToken(boolean fetchFromServer, EMAError error) {
        return this.native_getUserToken(fetchFromServer, error);
    }

    public void logout() {
        this.native_logout();
    }

    public EMAError createAccount(String username, String password) {
        return this.native_createAccount(username, password);
    }

    public EMAChatManager getChatManager() {
        return this.chatManager;
    }

    public EMAChatRoomManager getChatRoomManager() {
        return this.chatRoomManager;
    }

    public void addConnectionListener(EMAConnectionListener listener) {
        this.native_addConnectionListener(listener);
    }

    public void removeConnectionListener(EMAConnectionListener listener) {
        this.native_removeConnectionListener(listener);
    }

    public void addLogCallbackListener(EMALogCallbackListener listener) {
        this.native_addLogCallbackListener(listener);
    }

    public void removeLogCallbackListener(EMALogCallbackListener listener) {
        this.native_removeLogCallbackListener(listener);
    }

    public boolean sendPing(boolean waitPong, long timeout) {
        return this.native_sendPing(waitPong, timeout);
    }

    public void disconnect() {
        this.native_disconnect();
    }

    public void reconnect() {
        this.natvie_reconnect();
    }

    public void onNetworkChanged(EMANetwork network) {
        this.native_onNetworkChanged(network.ordinal());
    }

    public boolean isConnected() {
        return this.native_isConnected();
    }

    public boolean isLogout() {
        return this.native_isLogout();
    }

    public String compressLogs(EMAError error) {
        return this.native_compressLogs(error);
    }

    public boolean isLoggedIn() {
        return this.native_isLoggedIn();
    }

    public void renewToken(String newTokn) {
        this.native_renewToken(newTokn);
    }

    public long getTokenExpiredTs(String newToken, EMAError error) {
        return this.nativeGetTokenExpiredTs(newToken, error);
    }

    static native long native_create(EMAChatConfig var0);

    native EMAError native_createAccount(String var1, String var2);

    native void native_login(String var1, String var2, boolean var3, int var4, EMAError var5);

    native String native_getUserToken(boolean var1, EMAError var2);

    native void native_logout();

    native long native_getChatManager();

    native long native_getChatRoomManager();

    native long native_getPushManager();

    native void native_onNetworkChanged(int var1);

    native void native_addConnectionListener(EMAConnectionListener var1);

    native void native_removeConnectionListener(EMAConnectionListener var1);

    native void native_addLogCallbackListener(EMALogCallbackListener var1);

    native void native_removeLogCallbackListener(EMALogCallbackListener var1);

    native boolean native_sendPing(boolean var1, long var2);

    native void native_disconnect();

    native void natvie_reconnect();

    native boolean native_isConnected();

    native boolean native_isLogout();

    native boolean native_isLoggedIn();

    native void native_renewToken(String var1);

    native String native_compressLogs(EMAError var1);

    native long nativeGetTokenExpiredTs(String var1, EMAError var2);

    public static enum EMANetwork {
        NETWORK_NONE,
        NETWORK_CABLE,
        NETWORK_WIFI,
        NETWORK_MOBILE;

    }

    public static class CheckResultListener {
        public void onResult(int type, int result, String desc) {
        }
    }
}

