/*
 * Decompiled with CFR 0.152.
 */
package com.hyphenate.chat;

import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import com.hyphenate.EMCallBack;
import com.hyphenate.chat.EMBase;
import com.hyphenate.chat.EMClient;
import com.hyphenate.chat.EMCmdMessageBody;
import com.hyphenate.chat.EMCombineMessageBody;
import com.hyphenate.chat.EMCustomMessageBody;
import com.hyphenate.chat.EMImageMessageBody;
import com.hyphenate.chat.EMLocationMessageBody;
import com.hyphenate.chat.EMMessageBody;
import com.hyphenate.chat.EMNormalFileMessageBody;
import com.hyphenate.chat.EMSessionManager;
import com.hyphenate.chat.EMTextMessageBody;
import com.hyphenate.chat.EMVideoMessageBody;
import com.hyphenate.chat.EMVoiceMessageBody;
import com.hyphenate.chat.adapter.EMACallback;
import com.hyphenate.chat.adapter.message.EMACmdMessageBody;
import com.hyphenate.chat.adapter.message.EMACombineMessageBody;
import com.hyphenate.chat.adapter.message.EMACustomMessageBody;
import com.hyphenate.chat.adapter.message.EMAFileMessageBody;
import com.hyphenate.chat.adapter.message.EMAImageMessageBody;
import com.hyphenate.chat.adapter.message.EMALocationMessageBody;
import com.hyphenate.chat.adapter.message.EMAMessage;
import com.hyphenate.chat.adapter.message.EMAMessageBody;
import com.hyphenate.chat.adapter.message.EMATextMessageBody;
import com.hyphenate.chat.adapter.message.EMAVideoMessageBody;
import com.hyphenate.chat.adapter.message.EMAVoiceMessageBody;
import com.hyphenate.exceptions.HyphenateException;
import com.hyphenate.util.EMFileHelper;
import com.hyphenate.util.EMLog;
import java.lang.ref.WeakReference;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class EMMessage
extends EMBase<EMAMessage>
implements Parcelable,
Cloneable {
    static final String ATTR_ENCRYPTED = "isencrypted";
    private static final String TAG = "msg";
    EMMessageBody body;
    EMCallbackHolder messageStatusCallBack;
    public static final Parcelable.Creator<EMMessage> CREATOR = new Parcelable.Creator<EMMessage>(){

        public EMMessage createFromParcel(Parcel in) {
            EMMessage eMMessage = null;
            try {
                eMMessage = new EMMessage(in);
            }
            catch (HyphenateException hyphenateException) {
                hyphenateException.printStackTrace();
            }
            return eMMessage;
        }

        public EMMessage[] newArray(int size) {
            return new EMMessage[size];
        }
    };

    public Status status() {
        EMAMessage.EMAMessageStatus eMAMessageStatus = ((EMAMessage)this.emaObject)._status();
        Status status = Status.CREATE;
        switch (eMAMessageStatus) {
            case NEW: {
                status = Status.CREATE;
                break;
            }
            case SUCCESS: {
                status = Status.SUCCESS;
                break;
            }
            case FAIL: {
                status = Status.FAIL;
                break;
            }
            case DELIVERING: {
                status = Status.INPROGRESS;
            }
        }
        return status;
    }

    public EMMessage(EMAMessage message) {
        this.emaObject = message;
    }

    public void setStatus(Status status) {
        EMAMessage.EMAMessageStatus eMAMessageStatus = EMAMessage.EMAMessageStatus.SUCCESS;
        switch (status) {
            case CREATE: {
                eMAMessageStatus = EMAMessage.EMAMessageStatus.NEW;
                break;
            }
            case SUCCESS: {
                eMAMessageStatus = EMAMessage.EMAMessageStatus.SUCCESS;
                break;
            }
            case FAIL: {
                eMAMessageStatus = EMAMessage.EMAMessageStatus.FAIL;
                break;
            }
            case INPROGRESS: {
                eMAMessageStatus = EMAMessage.EMAMessageStatus.DELIVERING;
            }
        }
        ((EMAMessage)this.emaObject).setStatus(eMAMessageStatus.ordinal());
    }

    public Type getType() {
        List<EMAMessageBody> list = ((EMAMessage)this.emaObject).bodies();
        if (list.size() > 0) {
            int n = list.get(0).type();
            if (n == Type.TXT.ordinal()) {
                return Type.TXT;
            }
            if (n == Type.IMAGE.ordinal()) {
                return Type.IMAGE;
            }
            if (n == Type.CMD.ordinal()) {
                return Type.CMD;
            }
            if (n == Type.FILE.ordinal()) {
                return Type.FILE;
            }
            if (n == Type.VIDEO.ordinal()) {
                return Type.VIDEO;
            }
            if (n == Type.VOICE.ordinal()) {
                return Type.VOICE;
            }
            if (n == Type.LOCATION.ordinal()) {
                return Type.LOCATION;
            }
            if (n == Type.CUSTOM.ordinal()) {
                return Type.CUSTOM;
            }
            if (n == Type.COMBINE.ordinal()) {
                return Type.COMBINE;
            }
        }
        return Type.TXT;
    }

    public EMMessageBody getBody() {
        if (this.body != null) {
            return this.body;
        }
        List<EMAMessageBody> list = ((EMAMessage)this.emaObject).bodies();
        if (list.size() > 0) {
            EMAMessageBody eMAMessageBody = list.get(0);
            if (eMAMessageBody instanceof EMATextMessageBody) {
                this.body = new EMTextMessageBody((EMATextMessageBody)eMAMessageBody);
            } else if (eMAMessageBody instanceof EMACmdMessageBody) {
                this.body = new EMCmdMessageBody((EMACmdMessageBody)eMAMessageBody);
            } else if (eMAMessageBody instanceof EMAVideoMessageBody) {
                this.body = new EMVideoMessageBody((EMAVideoMessageBody)eMAMessageBody);
            } else if (eMAMessageBody instanceof EMAVoiceMessageBody) {
                this.body = new EMVoiceMessageBody((EMAVoiceMessageBody)eMAMessageBody);
            } else if (eMAMessageBody instanceof EMAImageMessageBody) {
                this.body = new EMImageMessageBody((EMAImageMessageBody)eMAMessageBody);
            } else if (eMAMessageBody instanceof EMACombineMessageBody) {
                this.body = new EMCombineMessageBody((EMACombineMessageBody)eMAMessageBody);
            } else if (eMAMessageBody instanceof EMALocationMessageBody) {
                this.body = new EMLocationMessageBody((EMALocationMessageBody)eMAMessageBody);
            } else if (eMAMessageBody instanceof EMAFileMessageBody) {
                this.body = new EMNormalFileMessageBody((EMAFileMessageBody)eMAMessageBody);
            } else if (eMAMessageBody instanceof EMACustomMessageBody) {
                this.body = new EMCustomMessageBody((EMACustomMessageBody)eMAMessageBody);
            }
            return this.body;
        }
        return null;
    }

    public long getMsgTime() {
        return ((EMAMessage)this.emaObject).timeStamp();
    }

    public void setMsgTime(long msgTime) {
        ((EMAMessage)this.emaObject).setTimeStamp(msgTime);
    }

    public long localTime() {
        return ((EMAMessage)this.emaObject).getLocalTime();
    }

    public void setLocalTime(long serverTime) {
        ((EMAMessage)this.emaObject).setLocalTime(serverTime);
    }

    public boolean isNeedGroupAck() {
        return ((EMAMessage)this.emaObject).isNeedGroupAck();
    }

    public void setIsNeedGroupAck(boolean need) {
        ((EMAMessage)this.emaObject).setIsNeedGroupAck(need);
    }

    public int groupAckCount() {
        return ((EMAMessage)this.emaObject).groupAckCount();
    }

    public void setGroupAckCount(int count) {
        ((EMAMessage)this.emaObject).setGroupAckCount(count);
    }

    public static EMMessage createSendMessage(Type type) {
        EMAMessage eMAMessage = EMAMessage.createSendMessage(EMMessage.self(), "", null, ChatType.Chat.ordinal());
        EMMessage eMMessage = new EMMessage(eMAMessage);
        return eMMessage;
    }

    public static EMMessage createReceiveMessage(Type type) {
        EMAMessage eMAMessage = EMAMessage.createReceiveMessage("", EMMessage.self(), null, ChatType.Chat.ordinal());
        EMMessage eMMessage = new EMMessage(eMAMessage);
        eMMessage.setTo(EMSessionManager.getInstance().currentUser);
        return eMMessage;
    }

    public static EMMessage createTextSendMessage(String content, String username) {
        if (content.length() > 0) {
            EMMessage eMMessage = EMMessage.createSendMessage(Type.TXT);
            EMTextMessageBody eMTextMessageBody = new EMTextMessageBody(content);
            eMMessage.addBody(eMTextMessageBody);
            eMMessage.setTo(username);
            return eMMessage;
        }
        EMLog.e(TAG, "text content size must be greater than 0");
        return null;
    }

    public static EMMessage createVoiceSendMessage(String filePath, int timeLength, String username) {
        return EMMessage.createVoiceSendMessage(EMFileHelper.getInstance().formatInUri(filePath), timeLength, username);
    }

    public static EMMessage createVoiceSendMessage(Uri filePath, int timeLength, String username) {
        if (!EMFileHelper.getInstance().isFileExist(filePath)) {
            EMLog.e(TAG, "voice file does not exsit");
            return null;
        }
        EMMessage eMMessage = EMMessage.createSendMessage(Type.VOICE);
        EMVoiceMessageBody eMVoiceMessageBody = new EMVoiceMessageBody(filePath, timeLength);
        eMMessage.addBody(eMVoiceMessageBody);
        eMMessage.setTo(username);
        return eMMessage;
    }

    public static EMMessage createImageSendMessage(String filePath, boolean sendOriginalImage, String username) {
        return EMMessage.createImageSendMessage(EMFileHelper.getInstance().formatInUri(filePath), sendOriginalImage, username);
    }

    public static EMMessage createImageSendMessage(Uri imgUri, boolean sendOriginalImage, String username) {
        if (!EMFileHelper.getInstance().isFileExist(imgUri)) {
            EMLog.e(TAG, "image file does not exsit");
            return null;
        }
        EMMessage eMMessage = EMMessage.createSendMessage(Type.IMAGE);
        eMMessage.setTo(username);
        EMImageMessageBody eMImageMessageBody = new EMImageMessageBody(imgUri);
        eMImageMessageBody.setSendOriginalImage(sendOriginalImage);
        eMMessage.addBody(eMImageMessageBody);
        return eMMessage;
    }

    public static EMMessage createVideoSendMessage(String videofilePath, String imageThumbPath, int timeLength, String username) {
        return EMMessage.createVideoSendMessage(EMFileHelper.getInstance().formatInUri(videofilePath), EMFileHelper.getInstance().formatInUri(imageThumbPath), timeLength, username);
    }

    public static EMMessage createVideoSendMessage(Uri videofilePath, String imageThumbPath, int timeLength, String username) {
        return EMMessage.createVideoSendMessage(videofilePath, EMFileHelper.getInstance().formatInUri(imageThumbPath), timeLength, username);
    }

    public static EMMessage createVideoSendMessage(Uri videofilePath, Uri imageThumbPath, int timeLength, String username) {
        if (!EMFileHelper.getInstance().isFileExist(videofilePath)) {
            EMLog.e(TAG, "video file does not exist");
            return null;
        }
        EMMessage eMMessage = EMMessage.createSendMessage(Type.VIDEO);
        eMMessage.setTo(username);
        EMVideoMessageBody eMVideoMessageBody = new EMVideoMessageBody(videofilePath, imageThumbPath, timeLength, EMFileHelper.getInstance().getFileLength(videofilePath));
        eMMessage.addBody(eMVideoMessageBody);
        return eMMessage;
    }

    public static EMMessage createLocationSendMessage(double latitude, double longitude, String locationAddress, String buildingName, String username) {
        EMMessage eMMessage = EMMessage.createSendMessage(Type.LOCATION);
        EMLocationMessageBody eMLocationMessageBody = new EMLocationMessageBody(locationAddress, latitude, longitude, buildingName);
        eMMessage.addBody(eMLocationMessageBody);
        eMMessage.setTo(username);
        return eMMessage;
    }

    public static EMMessage createLocationSendMessage(double latitude, double longitude, String locationAddress, String username) {
        EMMessage eMMessage = EMMessage.createSendMessage(Type.LOCATION);
        EMLocationMessageBody eMLocationMessageBody = new EMLocationMessageBody(locationAddress, latitude, longitude);
        eMMessage.addBody(eMLocationMessageBody);
        eMMessage.setTo(username);
        return eMMessage;
    }

    public static EMMessage createFileSendMessage(String filePath, String username) {
        return EMMessage.createFileSendMessage(EMFileHelper.getInstance().formatInUri(filePath), username);
    }

    public static EMMessage createFileSendMessage(Uri filePath, String username) {
        if (!EMFileHelper.getInstance().isFileExist(filePath)) {
            EMLog.e(TAG, "file does not exist");
            return null;
        }
        EMMessage eMMessage = EMMessage.createSendMessage(Type.FILE);
        eMMessage.setTo(username);
        EMNormalFileMessageBody eMNormalFileMessageBody = new EMNormalFileMessageBody(filePath);
        eMMessage.addBody(eMNormalFileMessageBody);
        return eMMessage;
    }

    public static EMMessage createCombinedSendMessage(String title, String summary, String compatibleText, List<String> messageIdList, String userId) {
        EMMessage eMMessage = EMMessage.createSendMessage(Type.COMBINE);
        eMMessage.setTo(userId);
        EMCombineMessageBody eMCombineMessageBody = new EMCombineMessageBody(title, summary, compatibleText, messageIdList);
        eMMessage.addBody(eMCombineMessageBody);
        return eMMessage;
    }

    public void setBody(EMMessageBody body) {
        if (this.body != body) {
            this.body = body;
            ((EMAMessage)this.emaObject).clearBodies();
            ((EMAMessage)this.emaObject).addBody((EMAMessageBody)body.emaObject);
        }
    }

    public void addBody(EMMessageBody body) {
        this.body = body;
        ((EMAMessage)this.emaObject).addBody((EMAMessageBody)body.emaObject);
    }

    public String getFrom() {
        return ((EMAMessage)this.emaObject).from();
    }

    public void setFrom(String from) {
        ((EMAMessage)this.emaObject).setFrom(from);
        if (!EMMessage.self().equals(from) && this.getTo() != null && this.getTo() != "" && this.getTo().equals(EMMessage.self())) {
            ((EMAMessage)this.emaObject).setConversationId(from);
        }
    }

    public String getRecaller() {
        return ((EMAMessage)this.emaObject).getRecaller();
    }

    public void setTo(String to) {
        ((EMAMessage)this.emaObject).setTo(to);
        ((EMAMessage)this.emaObject).setConversationId(to);
    }

    public String getTo() {
        return ((EMAMessage)this.emaObject).to();
    }

    public String getMsgId() {
        return ((EMAMessage)this.emaObject).msgId();
    }

    public void setMsgId(String msgId) {
        ((EMAMessage)this.emaObject).setMsgId(msgId);
    }

    synchronized void setInnerCallback(EMCallBack callback) {
        EMCallbackHolder eMCallbackHolder = this.messageStatusCallBack;
        if (eMCallbackHolder != null) {
            eMCallbackHolder.innerCallback = callback;
        } else {
            this.messageStatusCallBack = new EMCallbackHolder(null);
            this.messageStatusCallBack.innerCallback = callback;
        }
        this.setCallback(this.messageStatusCallBack);
    }

    public synchronized void setMessageStatusCallback(EMCallBack callback) {
        EMCallbackHolder eMCallbackHolder = this.messageStatusCallBack;
        if (eMCallbackHolder != null) {
            eMCallbackHolder.update(callback);
        } else {
            this.messageStatusCallBack = new EMCallbackHolder(callback);
        }
        this.setCallback(this.messageStatusCallBack);
    }

    void setCallback(final EMCallbackHolder holder) {
        ((EMAMessage)this.emaObject).setCallback(new EMACallback(new EMCallBack(){

            @Override
            public void onSuccess() {
                if (holder != null) {
                    holder.onSuccess();
                }
            }

            @Override
            public void onProgress(int progress, String status) {
                if (holder != null) {
                    holder.onProgress(progress, status);
                }
            }

            @Override
            public void onError(int code, String error) {
                if (holder != null) {
                    holder.onError(code, error);
                }
            }
        }));
    }

    void makeCallbackStrong() {
        EMCallbackHolder eMCallbackHolder = this.messageStatusCallBack;
        if (eMCallbackHolder != null) {
            eMCallbackHolder.makeItStrong();
        }
    }

    public String toString() {
        String string = "msg{from:" + this.getFrom() + ", to:" + this.getTo() + " body:" + this.getBody();
        return string;
    }

    public void setAttribute(String attribute, boolean value) {
        if (attribute == null || attribute.equals("")) {
            return;
        }
        ((EMAMessage)this.emaObject).setAttribute(attribute, value);
    }

    public void setAttribute(String attribute, int value) {
        if (attribute == null || attribute.equals("")) {
            return;
        }
        ((EMAMessage)this.emaObject).setAttribute(attribute, value);
    }

    public void setAttribute(String attribute, long value) {
        if (attribute == null || attribute.equals("")) {
            return;
        }
        ((EMAMessage)this.emaObject).setAttribute(attribute, value);
    }

    public void setAttribute(String attribute, float value) {
        if (attribute == null || attribute.equals("")) {
            return;
        }
        ((EMAMessage)this.emaObject).setAttribute(attribute, value);
    }

    public void setAttribute(String attribute, double value) {
        if (attribute == null || attribute.equals("")) {
            return;
        }
        ((EMAMessage)this.emaObject).setAttribute(attribute, value);
    }

    public void setAttribute(String attribute, JSONObject value) {
        if (attribute == null || attribute.equals("")) {
            return;
        }
        ((EMAMessage)this.emaObject).setJsonAttribute(attribute, value.toString());
    }

    public void setAttribute(String attribute, JSONArray value) {
        if (attribute == null || attribute.equals("")) {
            return;
        }
        ((EMAMessage)this.emaObject).setJsonAttribute(attribute, value.toString());
    }

    public void setAttribute(String attribute, String value) {
        if (attribute == null || attribute.equals("")) {
            return;
        }
        ((EMAMessage)this.emaObject).setAttribute(attribute, value);
    }

    public boolean getBooleanAttribute(String attribute) throws HyphenateException {
        if (attribute == null || attribute.equals("")) {
            throw new HyphenateException(1, "attribute " + attribute + " can not be null or empty");
        }
        AtomicBoolean atomicBoolean = new AtomicBoolean();
        boolean bl = ((EMAMessage)this.emaObject).getBooleanAttribute(attribute, false, atomicBoolean);
        if (!bl) {
            throw new HyphenateException(1, "attribute " + attribute + " not found");
        }
        return atomicBoolean.get();
    }

    public boolean getBooleanAttribute(String attribute, boolean defaultValue) {
        if (attribute == null || attribute.equals("")) {
            return defaultValue;
        }
        AtomicBoolean atomicBoolean = new AtomicBoolean();
        boolean bl = ((EMAMessage)this.emaObject).getBooleanAttribute(attribute, false, atomicBoolean);
        if (!bl) {
            return defaultValue;
        }
        return atomicBoolean.get();
    }

    public int getIntAttribute(String attribute, int defaultValue) {
        if (attribute == null || attribute.equals("")) {
            return defaultValue;
        }
        AtomicInteger atomicInteger = new AtomicInteger();
        boolean bl = ((EMAMessage)this.emaObject).getIntAttribute(attribute, -1, atomicInteger);
        if (!bl) {
            return defaultValue;
        }
        return atomicInteger.intValue();
    }

    public long getLongAttribute(String attribute, long defaultValue) {
        if (attribute == null || attribute.equals("")) {
            return defaultValue;
        }
        AtomicLong atomicLong = new AtomicLong();
        boolean bl = ((EMAMessage)this.emaObject).getLongAttribute(attribute, -1L, atomicLong);
        if (!bl) {
            return defaultValue;
        }
        return atomicLong.longValue();
    }

    public float getFloatAttribute(String attribute, float defaultValue) {
        if (attribute == null || attribute.equals("")) {
            return defaultValue;
        }
        AtomicReference atomicReference = new AtomicReference();
        boolean bl = ((EMAMessage)this.emaObject).getFloatAttribute(attribute, defaultValue, atomicReference);
        if (!bl) {
            return defaultValue;
        }
        return ((Float)atomicReference.get()).floatValue();
    }

    public double getDoubleAttribute(String attribute, double defaultValue) {
        if (attribute == null || attribute.equals("")) {
            return defaultValue;
        }
        AtomicReference atomicReference = new AtomicReference();
        boolean bl = ((EMAMessage)this.emaObject).getDoubleAttribute(attribute, defaultValue, atomicReference);
        if (!bl) {
            return defaultValue;
        }
        return (Double)atomicReference.get();
    }

    public int getIntAttribute(String attribute) throws HyphenateException {
        if (attribute == null || attribute.equals("")) {
            throw new HyphenateException(1, "attribute " + attribute + " can not be null or empty");
        }
        AtomicInteger atomicInteger = new AtomicInteger();
        boolean bl = ((EMAMessage)this.emaObject).getIntAttribute(attribute, -1, atomicInteger);
        if (!bl) {
            throw new HyphenateException(1, "attribute " + attribute + " not found");
        }
        return atomicInteger.intValue();
    }

    public long getLongAttribute(String attribute) throws HyphenateException {
        if (attribute == null || attribute.equals("")) {
            throw new HyphenateException(1, "attribute " + attribute + " can not be null or empty");
        }
        AtomicLong atomicLong = new AtomicLong();
        boolean bl = ((EMAMessage)this.emaObject).getLongAttribute(attribute, -1L, atomicLong);
        if (!bl) {
            throw new HyphenateException(1, "attribute " + attribute + " not found");
        }
        return atomicLong.longValue();
    }

    public float getFloatAttribute(String attribute) throws HyphenateException {
        if (attribute == null || attribute.equals("")) {
            throw new HyphenateException(1, "attribute " + attribute + " can not be null or empty");
        }
        AtomicReference atomicReference = new AtomicReference();
        boolean bl = ((EMAMessage)this.emaObject).getFloatAttribute(attribute, -1.0f, atomicReference);
        if (!bl) {
            throw new HyphenateException(1, "attribute " + attribute + " not found");
        }
        return ((Float)atomicReference.get()).floatValue();
    }

    public double getDoubleAttribute(String attribute) throws HyphenateException {
        if (attribute == null || attribute.equals("")) {
            throw new HyphenateException(1, "attribute " + attribute + " can not be null or empty");
        }
        AtomicReference atomicReference = new AtomicReference();
        boolean bl = ((EMAMessage)this.emaObject).getDoubleAttribute(attribute, -1.0, atomicReference);
        if (!bl) {
            throw new HyphenateException(1, "attribute " + attribute + " not found");
        }
        return (Double)atomicReference.get();
    }

    public String getStringAttribute(String attribute) throws HyphenateException {
        if (attribute == null || attribute.equals("")) {
            throw new HyphenateException(1, "attribute " + attribute + " can not be null or empty");
        }
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = ((EMAMessage)this.emaObject).getStringAttribute(attribute, "", stringBuilder);
        if (!bl) {
            throw new HyphenateException(1, "attribute " + attribute + " not found");
        }
        return stringBuilder.toString();
    }

    public String getStringAttribute(String attribute, String defaultValue) {
        if (attribute == null || attribute.equals("")) {
            return defaultValue;
        }
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = ((EMAMessage)this.emaObject).getStringAttribute(attribute, "", stringBuilder);
        if (!bl) {
            return defaultValue;
        }
        return stringBuilder.toString();
    }

    public JSONObject getJSONObjectAttribute(String attribute) throws HyphenateException {
        if (attribute == null || attribute.equals("")) {
            throw new HyphenateException(1, "attribute " + attribute + " can not be null or empty");
        }
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = ((EMAMessage)this.emaObject).getJsonAttribute(attribute, "{}", stringBuilder);
        if (bl) {
            try {
                JSONObject jSONObject = new JSONObject(stringBuilder.toString());
                return jSONObject;
            }
            catch (JSONException jSONException) {
                throw new HyphenateException(1, jSONException.getMessage());
            }
        }
        throw new HyphenateException(1, "attribute " + attribute + " not found");
    }

    public JSONArray getJSONArrayAttribute(String attribute) throws HyphenateException {
        if (attribute == null || attribute.equals("")) {
            throw new HyphenateException(1, "attribute " + attribute + " can not be null or empty");
        }
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = ((EMAMessage)this.emaObject).getJsonAttribute(attribute, "[]", stringBuilder);
        if (bl) {
            try {
                JSONArray jSONArray = new JSONArray(stringBuilder.toString());
                return jSONArray;
            }
            catch (JSONException jSONException) {
                throw new HyphenateException(1, jSONException.getMessage());
            }
        }
        throw new HyphenateException(1, "attribute " + attribute + " not found");
    }

    public ChatType getChatType() {
        EMAMessage.EMAChatType eMAChatType = ((EMAMessage)this.emaObject).chatType();
        ChatType chatType = ChatType.Chat;
        chatType = eMAChatType == EMAMessage.EMAChatType.SINGLE ? ChatType.Chat : (eMAChatType == EMAMessage.EMAChatType.GROUP ? ChatType.GroupChat : ChatType.ChatRoom);
        return chatType;
    }

    public void setChatType(ChatType chatType) {
        EMAMessage.EMAChatType eMAChatType = EMAMessage.EMAChatType.SINGLE;
        eMAChatType = chatType == ChatType.Chat ? EMAMessage.EMAChatType.SINGLE : (chatType == ChatType.GroupChat ? EMAMessage.EMAChatType.GROUP : EMAMessage.EMAChatType.CHATROOM);
        ((EMAMessage)this.emaObject).setChatType(eMAChatType);
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel out, int flags) {
        out.writeString(this.getMsgId());
        out.writeLong(((EMAMessage)this.emaObject).getNativeHandler());
    }

    public Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    public boolean isAcked() {
        return ((EMAMessage)this.emaObject).isAcked();
    }

    public void setAcked(boolean isAcked) {
        ((EMAMessage)this.emaObject).setIsAcked(isAcked);
    }

    public boolean isDelivered() {
        return ((EMAMessage)this.emaObject).isDeliverAcked();
    }

    public void setDelivered(boolean isDelivered) {
        ((EMAMessage)this.emaObject).setIsDeliverAcked(isDelivered);
    }

    public boolean isUnread() {
        return !((EMAMessage)this.emaObject).isRead();
    }

    public void setUnread(boolean unread) {
        EMLog.d(TAG, "setUnread unread: " + unread + " msgId: " + this.getMsgId());
        ((EMAMessage)this.emaObject).setIsRead(!unread);
    }

    public boolean isListened() {
        return ((EMAMessage)this.emaObject).isListened();
    }

    public void setListened(boolean isListened) {
        ((EMAMessage)this.emaObject).setListened(isListened);
    }

    public String getUserName() {
        String string = "";
        string = this.getFrom() != null && this.getFrom().equals(EMClient.getInstance().getCurrentUser()) ? this.getTo() : this.getFrom();
        return string;
    }

    public void setDeliverAcked(boolean isDeliverAcked) {
        ((EMAMessage)this.emaObject).setIsDeliverAcked(isDeliverAcked);
    }

    public int progress() {
        return ((EMAMessage)this.emaObject).progress();
    }

    public void setProgress(int progress) {
        ((EMAMessage)this.emaObject).setProgress(progress);
    }

    public Direct direct() {
        if (((EMAMessage)this.emaObject).direction() == EMAMessage.EMADirection.SEND) {
            return Direct.SEND;
        }
        return Direct.RECEIVE;
    }

    public void setDirection(Direct dir) {
        ((EMAMessage)this.emaObject).setDirection(dir.ordinal());
    }

    public String conversationId() {
        return ((EMAMessage)this.emaObject).conversationId();
    }

    static String self() {
        String string = EMClient.getInstance().getCurrentUser();
        if (string == null) {
            string = EMSessionManager.getInstance().getLastLoginUser();
        }
        return string;
    }

    private EMMessage(Parcel in) throws HyphenateException {
        String string = in.readString();
        long l = in.readLong();
        EMMessage eMMessage = EMClient.getInstance().chatManager().getMessage(l);
        if (eMMessage == null && (eMMessage = EMClient.getInstance().chatManager().getMessage(string)) == null) {
            throw new HyphenateException("EMMessage constructed from parcel failed");
        }
        this.emaObject = eMMessage.emaObject;
    }

    public Map<String, Object> ext() {
        return ((EMAMessage)this.emaObject).ext();
    }

    public Map<String, Object> getAttributes() {
        return ((EMAMessage)this.emaObject).getAttributes();
    }

    public boolean isOnlineState() {
        return ((EMAMessage)this.emaObject).isOnlineState();
    }

    public void setPriority(EMChatRoomMessagePriority priority) {
        ((EMAMessage)this.emaObject).setPriority(priority);
    }

    public boolean isDeliverOnlineOnly() {
        return ((EMAMessage)this.emaObject).isDeliverOnlineOnly();
    }

    public void deliverOnlineOnly(boolean onlineOnly) {
        ((EMAMessage)this.emaObject).deliverOnlineOnly(onlineOnly);
    }

    public void setReceiverList(List<String> receiverList) {
        ((EMAMessage)this.emaObject).setReceiverList(receiverList);
    }

    public List<String> receiverList() {
        return ((EMAMessage)this.emaObject).receiverList();
    }

    public static enum EMChatRoomMessagePriority {
        PriorityHigh,
        PriorityNormal,
        PriorityLow;

    }

    static class EMCallbackHolder
    implements EMCallBack {
        private EMCallBack strong;
        private WeakReference<EMCallBack> weak;
        EMCallBack innerCallback = null;

        EMCallbackHolder(EMCallBack callback) {
            this.weak = new WeakReference<EMCallBack>(callback);
        }

        synchronized void update(EMCallBack callback) {
            if (this.strong != null) {
                this.strong = callback;
                return;
            }
            this.weak = new WeakReference<EMCallBack>(callback);
        }

        synchronized void makeItStrong() {
            if (this.strong != null) {
                return;
            }
            if (this.weak != null && this.weak.get() != null) {
                this.strong = (EMCallBack)this.weak.get();
            }
        }

        synchronized void release() {
            if (this.strong == null) {
                return;
            }
            this.weak = new WeakReference<EMCallBack>(this.strong);
            this.strong = null;
        }

        synchronized EMCallBack getRef() {
            if (this.strong != null) {
                return this.strong;
            }
            if (this.weak != null) {
                EMCallBack eMCallBack = (EMCallBack)this.weak.get();
                if (eMCallBack == null) {
                    EMLog.d(EMMessage.TAG, "getRef weak:" + eMCallBack);
                }
                return eMCallBack;
            }
            return null;
        }

        @Override
        public void onSuccess() {
            EMCallBack eMCallBack;
            if (this.innerCallback != null) {
                this.innerCallback.onSuccess();
            }
            if ((eMCallBack = this.getRef()) != null) {
                eMCallBack.onSuccess();
                this.release();
            } else {
                EMLog.d(EMMessage.TAG, "CallbackHolder getRef: null");
            }
        }

        @Override
        public void onError(int code, String error) {
            EMCallBack eMCallBack;
            if (this.innerCallback != null) {
                this.innerCallback.onError(code, error);
            }
            if ((eMCallBack = this.getRef()) != null) {
                eMCallBack.onError(code, error);
                this.release();
            } else {
                EMLog.d(EMMessage.TAG, "CallbackHolder getRef: null");
            }
        }

        @Override
        public void onProgress(int progress, String status) {
            EMCallBack eMCallBack;
            if (this.innerCallback != null) {
                this.innerCallback.onProgress(progress, status);
            }
            if ((eMCallBack = this.getRef()) != null) {
                eMCallBack.onProgress(progress, status);
            }
        }
    }

    public static enum ChatType {
        Chat,
        GroupChat,
        ChatRoom;

    }

    public static enum Status {
        SUCCESS,
        FAIL,
        INPROGRESS,
        CREATE;

    }

    public static enum Direct {
        SEND,
        RECEIVE;

    }

    public static enum Type {
        TXT,
        IMAGE,
        VIDEO,
        LOCATION,
        VOICE,
        FILE,
        CMD,
        CUSTOM,
        COMBINE;

    }
}

