/*
 * Decompiled with CFR 0.152.
 */
package com.hyphenate.chat;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.Application;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.ConnectivityManager;
import android.net.http.X509TrustManagerExtensions;
import android.os.Build;
import android.os.Bundle;
import android.os.PowerManager;
import android.os.Process;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import android.util.Log;
import com.hyphenate.EMCallBack;
import com.hyphenate.EMConnectionListener;
import com.hyphenate.EMLogListener;
import com.hyphenate.a.a;
import com.hyphenate.chat.EMChatManager;
import com.hyphenate.chat.EMChatRoomManager;
import com.hyphenate.chat.EMEncryptProvider;
import com.hyphenate.chat.EMLoginType;
import com.hyphenate.chat.EMOptions;
import com.hyphenate.chat.EMSessionManager;
import com.hyphenate.chat.EMSmartHeartBeat;
import com.hyphenate.chat.EMTimeTag;
import com.hyphenate.chat.adapter.EMAChatClient;
import com.hyphenate.chat.adapter.EMAConnectionListener;
import com.hyphenate.chat.adapter.EMAError;
import com.hyphenate.chat.adapter.EMALogCallbackListener;
import com.hyphenate.chat.adapter.EMANetCallback;
import com.hyphenate.chat.core.EMChatConfigPrivate;
import com.hyphenate.cloud.EMHttpClient;
import com.hyphenate.exceptions.HyphenateException;
import com.hyphenate.util.DeviceUuidFactory;
import com.hyphenate.util.EMLog;
import com.hyphenate.util.EasyUtils;
import com.hyphenate.util.NetUtils;
import com.hyphenate.util.PathUtil;
import com.hyphenate.util.Utils;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.regex.Pattern;
import javax.net.ssl.X509TrustManager;
import org.json.JSONException;
import org.json.JSONObject;

public class EMClient {
    public static final String TAG = "EMClient";
    private static EMClient instance = null;
    static boolean libraryLoaded = false;
    private EMChatRoomManager chatroomManager;
    private EMChatManager chatManager;
    private EMAChatClient emaObject;
    private Context mContext;
    private ExecutorService executor = null;
    private ExecutorService logQueue = Executors.newSingleThreadExecutor();
    private ExecutorService mainQueue = Executors.newSingleThreadExecutor();
    private ExecutorService sendQueue = Executors.newSingleThreadExecutor();
    private EMEncryptProvider encryptProvider = null;
    private boolean sdkInited = false;
    private EMChatConfigPrivate mChatConfigPrivate;
    private List<EMConnectionListener> connectionListeners = Collections.synchronizedList(new ArrayList());
    private List<EMLogListener> logListeners = Collections.synchronizedList(new ArrayList());
    private ClientLogListener clientLogListener;
    private MyConnectionListener connectionListener;
    private EMSmartHeartBeat smartHeartbeat = null;
    private PowerManager.WakeLock wakeLock;
    private ConnectivityManager connManager;
    private EMAChatClient.EMANetwork currentNetworkType = EMAChatClient.EMANetwork.NETWORK_NONE;
    private boolean mIsLoginWithToken = false;
    public static final String VERSION = "4.2.3-lite";
    private BroadcastReceiver connectivityBroadcastReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            EMAChatClient.EMANetwork eMANetwork;
            String string = intent.getAction();
            if (!string.equals("android.net.conn.CONNECTIVITY_CHANGE")) {
                EMLog.d(EMClient.TAG, "skip no connectivity action");
                return;
            }
            EMLog.d(EMClient.TAG, "connectivity receiver onReceiver");
            NetUtils.Types types = NetUtils.getNetworkTypes(EMClient.this.getContext());
            switch (types) {
                case WIFI: 
                case OTHERS: {
                    eMANetwork = EMAChatClient.EMANetwork.NETWORK_WIFI;
                    break;
                }
                case MOBILE: {
                    eMANetwork = EMAChatClient.EMANetwork.NETWORK_MOBILE;
                    break;
                }
                case ETHERNET: {
                    eMANetwork = EMAChatClient.EMANetwork.NETWORK_CABLE;
                    break;
                }
                default: {
                    eMANetwork = EMAChatClient.EMANetwork.NETWORK_NONE;
                }
            }
            boolean bl = EMClient.this.currentNetworkType != EMAChatClient.EMANetwork.NETWORK_NONE;
            boolean bl2 = eMANetwork != EMAChatClient.EMANetwork.NETWORK_NONE;
            EMClient.this.currentNetworkType = eMANetwork;
            if (bl == bl2 && bl2) {
                EMClient.this.execute(new Runnable(){

                    @Override
                    public void run() {
                        if (EMClient.this.smartHeartbeat != null) {
                            EMLog.i(EMClient.TAG, "Network availability no change, just return. " + (Object)((Object)EMClient.this.currentNetworkType) + ", but check ping");
                            EMClient.this.smartHeartbeat.sendPingCheckConnection();
                        }
                    }
                });
                return;
            }
            EMLog.i(EMClient.TAG, "Network availability changed, notify... " + (Object)((Object)EMClient.this.currentNetworkType));
            EMClient.this.execute(new Runnable(){

                @Override
                public void run() {
                    EMClient.this.emaObject.onNetworkChanged(EMClient.this.currentNetworkType);
                }
            });
        }
    };
    private AppStateListener appStateListener;
    private List<Activity> resumeActivityList = new ArrayList<Activity>();
    private boolean duringChecking = false;

    private EMClient() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static EMClient getInstance() {
        if (instance != null) return instance;
        Class<EMClient> clazz = EMClient.class;
        synchronized (EMClient.class) {
            if (instance != null) return instance;
            instance = new EMClient();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public void init(Context context, EMOptions options) {
        if (this.sdkInited) {
            return;
        }
        this.executor = Executors.newCachedThreadPool();
        final EMTimeTag eMTimeTag = new EMTimeTag();
        eMTimeTag.start();
        this.mContext = context.getApplicationContext();
        this.connManager = (ConnectivityManager)this.mContext.getSystemService("connectivity");
        this.registerActivityLifecycleCallbacks();
        this.loadLibrary();
        this.mChatConfigPrivate = new EMChatConfigPrivate();
        this.mChatConfigPrivate.a(this.mContext, options);
        options.setConfig(this.mChatConfigPrivate);
        DeviceUuidFactory deviceUuidFactory = new DeviceUuidFactory(this.mContext);
        this.mChatConfigPrivate.e(deviceUuidFactory.getDeviceUuid().toString());
        String string = Build.MANUFACTURER + Build.MODEL;
        EMLog.e(TAG, "system device name :" + string);
        this.mChatConfigPrivate.h(string);
        this.mChatConfigPrivate.f(this.getDidInfo());
        this.mChatConfigPrivate.g(UUID.randomUUID().toString());
        this.emaObject = EMAChatClient.create(this.mChatConfigPrivate.a);
        this.connectionListener = new MyConnectionListener();
        this.emaObject.addConnectionListener(this.connectionListener);
        this.initManagers();
        this.mIsLoginWithToken = EMSessionManager.getInstance().isLastLoginWithToken();
        final String string2 = EMSessionManager.getInstance().getLastLoginUser();
        EMLog.e(TAG, "is autoLogin : " + options.getAutoLogin());
        EMLog.e(TAG, "lastLoginUser : " + string2);
        EMLog.e(TAG, "hyphenate SDK is initialized with version : " + this.getChatConfigPrivate().e());
        PowerManager powerManager = (PowerManager)this.mContext.getSystemService("power");
        this.wakeLock = powerManager.newWakeLock(1, "emclient");
        this.sdkInited = true;
        this.mContext.registerReceiver(this.connectivityBroadcastReceiver, new IntentFilter("android.net.conn.CONNECTIVITY_CHANGE"));
        this.onNetworkChanged();
        if (options.getAutoLogin() && this.isLoggedInBefore()) {
            String string3 = EMSessionManager.getInstance().getLastLoginToken();
            String string4 = EMSessionManager.getInstance().getLastLoginPwd();
            EMSessionManager.getInstance().currentUser = string2;
            EMCallBack eMCallBack = new EMCallBack(){

                @Override
                public void onSuccess() {
                    EMSessionManager.getInstance().currentUser = string2;
                    Log.d((String)EMClient.TAG, (String)"hyphenate login onSuccess");
                    eMTimeTag.stop();
                    EMLog.d(EMClient.TAG, "[Collector][sdk init]init time is : " + eMTimeTag.timeStr());
                }

                @Override
                public void onError(int code, String error) {
                    Log.d((String)EMClient.TAG, (String)"hyphenate login onError");
                    eMTimeTag.stop();
                    EMLog.d(EMClient.TAG, "[Collector][sdk init]init time is : " + eMTimeTag.timeStr());
                }

                @Override
                public void onProgress(int progress, String status) {
                }
            };
            this._login(string2, this.mIsLoginWithToken ? string3 : string4, eMCallBack, true, this.mIsLoginWithToken ? EMLoginType.LOGIN_TOKEN : EMLoginType.LOGIN_PASSWORD);
        } else {
            eMTimeTag.stop();
            EMLog.d(TAG, "[Collector][sdk init]init time is : " + eMTimeTag.timeStr());
        }
    }

    private String getDidInfo() {
        String string = Build.MANUFACTURER;
        String string2 = Build.MODEL;
        String string3 = Build.HARDWARE;
        int n = Build.VERSION.SDK_INT;
        String string4 = Build.VERSION.RELEASE;
        String string5 = string + "/" + string2 + "/" + string3 + "/" + n + "/" + string4;
        return string5;
    }

    public void createAccount(String username, String password) throws HyphenateException {
        username = username.toLowerCase();
        Pattern pattern = Pattern.compile("^[a-zA-Z0-9_.-]+$");
        boolean bl = pattern.matcher(username).find();
        if (!bl) {
            throw new HyphenateException(205, "illegal user name");
        }
        EMAError eMAError = this.emaObject.createAccount(username, password);
        this.handleError(eMAError);
    }

    public void login(String id, String password, @NonNull EMCallBack callback) {
        if (id == null || password == null || id.equals("") || password.equals("")) {
            callback.onError(110, "username or password is null or empty!");
            return;
        }
        if (TextUtils.isEmpty((CharSequence)this.getChatConfigPrivate().k())) {
            callback.onError(110, "please setup your App Key  either in AndroidManifest.xml or through the EMOptions");
            return;
        }
        if (!this.sdkInited) {
            callback.onError(1, "sdk not initialized");
            return;
        }
        id = id.toLowerCase();
        this.initLoginWithToken(false, "", 0L);
        this._login(id, password, callback, false, EMLoginType.LOGIN_PASSWORD);
    }

    public void loginWithToken(String username, String token, @NonNull EMCallBack callback) {
        if (TextUtils.isEmpty((CharSequence)this.getChatConfigPrivate().k())) {
            callback.onError(110, "please setup your App Key  either in AndroidManifest.xml or through the EMOptions");
            return;
        }
        if (username == null || token == null || username.equals("") || token.equals("")) {
            callback.onError(110, "username or token is null or empty!");
            return;
        }
        if (!this.sdkInited) {
            callback.onError(1, "sdk not initialized");
            return;
        }
        username = username.toLowerCase();
        this.initLoginWithToken(true, "", 0L);
        this._login(username, token, callback, false, EMLoginType.LOGIN_TOKEN);
    }

    private synchronized void initLoginWithToken(boolean isLoginWithToken, String expireTimestamp, long tokenAvailablePeriod) {
        this.mIsLoginWithToken = isLoginWithToken;
        if (isLoginWithToken) {
            EMSessionManager.getInstance().setLoginWithTokenData(isLoginWithToken, expireTimestamp, tokenAvailablePeriod);
            EMSessionManager.getInstance().startCountDownTokenAvailableTime(this.connectionListener);
        } else {
            EMSessionManager.getInstance().clearLoginWithTokenData();
        }
    }

    public void notifyTokenExpired(String response) {
        if (this.connectionListener != null && this.mIsLoginWithToken) {
            try {
                JSONObject jSONObject = new JSONObject(response);
                if (jSONObject != null) {
                    String string = jSONObject.optString("error_description");
                    EMLog.e(TAG, "notifyTokenExpired--errorDescription:" + string);
                    if (string.contains("milliseconds ago") || string.contains("has expired") || string.contains("Unable to authenticate due to expired access Token")) {
                        this.connectionListener.onTokenNotification(401);
                        EMLog.e(TAG, "notifyTokenExpired--onTokenNotification(401) ");
                    }
                }
            }
            catch (JSONException jSONException) {
                jSONException.printStackTrace();
            }
        }
    }

    public void renewToken(String newToken, @NonNull EMCallBack callback) {
        if (!this.sdkInited) {
            callback.onError(1, "SDK not initialized");
            return;
        }
        if (!this.emaObject.isLoggedIn()) {
            callback.onError(201, "User has not loggin.");
            return;
        }
        if (TextUtils.isEmpty((CharSequence)newToken)) {
            callback.onError(104, "New token is invalid");
            return;
        }
        this.execute(() -> {
            EMAError eMAError = new EMAError();
            long l = this.emaObject.getTokenExpiredTs(newToken, eMAError);
            if (eMAError.errCode() == 0) {
                EMLog.d(TAG, "getTokenExpiredTs success");
                this.emaObject.renewToken(newToken);
                long l2 = l - System.currentTimeMillis();
                this.initLoginWithToken(true, String.valueOf(l), l2);
                this.saveToken();
                callback.onSuccess();
                EMLog.d(TAG, "renewToken(): expireTimestamp = " + l + " tokenAvailablePeriod = " + l2);
            } else {
                callback.onError(eMAError.errCode(), eMAError.errMsg());
                EMLog.e(TAG, "getChatTokenbyAgoraToken failed error:" + eMAError.errCode() + "  errorMessage:" + eMAError.errMsg());
            }
        });
    }

    public int logout(boolean unbindToken) {
        this.logout();
        return 0;
    }

    void logout() {
        EMLog.d(TAG, " SDK Logout");
        try {
            if (this.connectivityBroadcastReceiver != null) {
                this.mContext.unregisterReceiver(this.connectivityBroadcastReceiver);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        EMSessionManager.getInstance().clearLastLoginUser();
        EMSessionManager.getInstance().clearLastLoginToken();
        EMSessionManager.getInstance().clearLoginWithTokenData();
        if (this.smartHeartbeat != null) {
            this.smartHeartbeat.stop();
        }
        this.releaseWakelock();
        if (this.emaObject != null) {
            this.emaObject.logout();
        }
        if (this.chatManager != null) {
            this.chatManager.onLogout();
        }
        if (this.chatroomManager != null) {
            this.chatroomManager.onLogout();
        }
        if (EMChatConfigPrivate.a()) {
            a.c();
        }
    }

    public void logout(final boolean unbindToken, final EMCallBack callback) {
        new Thread(){

            @Override
            public void run() {
                int n = EMClient.this.logout(unbindToken);
                if (n != 0) {
                    if (callback != null) {
                        callback.onError(n, "faild to unbind device token");
                    }
                } else if (callback != null) {
                    callback.onSuccess();
                }
            }
        }.start();
    }

    void logout(final EMCallBack callback) {
        Thread thread = new Thread(){

            @Override
            public void run() {
                if (callback != null) {
                    callback.onProgress(0, null);
                }
                EMClient.this.logout();
                if (callback != null) {
                    callback.onSuccess();
                }
            }
        };
        thread.setPriority(9);
        thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addConnectionListener(final EMConnectionListener listener) {
        if (listener == null) {
            return;
        }
        List<EMConnectionListener> list = this.connectionListeners;
        synchronized (list) {
            if (!this.connectionListeners.contains(listener)) {
                this.connectionListeners.add(listener);
            }
        }
        this.execute(new Runnable(){

            @Override
            public void run() {
                if (EMClient.this.isConnected()) {
                    listener.onConnected();
                } else if (EMClient.this.isLoggedIn()) {
                    listener.onDisconnected(2);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeConnectionListener(EMConnectionListener listener) {
        if (listener == null) {
            return;
        }
        List<EMConnectionListener> list = this.connectionListeners;
        synchronized (list) {
            this.connectionListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addLogListener(EMLogListener listener) {
        if (listener == null) {
            return;
        }
        List<EMLogListener> list = this.logListeners;
        synchronized (list) {
            if (!this.logListeners.contains(listener)) {
                this.logListeners.add(listener);
            }
        }
        if (this.clientLogListener == null) {
            this.clientLogListener = new ClientLogListener();
            this.emaObject.addLogCallbackListener(this.clientLogListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeLogListener(EMLogListener listener) {
        if (listener == null) {
            return;
        }
        List<EMLogListener> list = this.logListeners;
        synchronized (list) {
            this.logListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public EMChatRoomManager chatroomManager() {
        if (this.chatroomManager != null) return this.chatroomManager;
        Class<EMClient> clazz = EMClient.class;
        synchronized (EMClient.class) {
            if (this.chatroomManager != null) return this.chatroomManager;
            this.chatroomManager = new EMChatRoomManager(this, this.emaObject.getChatRoomManager());
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.chatroomManager;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public EMChatManager chatManager() {
        if (this.chatManager != null) return this.chatManager;
        Class<EMClient> clazz = EMClient.class;
        synchronized (EMClient.class) {
            if (this.chatManager != null) return this.chatManager;
            this.chatManager = new EMChatManager(this, this.emaObject.getChatManager());
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.chatManager;
        }
    }

    public Context getContext() {
        return this.mContext;
    }

    public synchronized String getCurrentUser() {
        if (TextUtils.isEmpty((CharSequence)EMSessionManager.getInstance().currentUser)) {
            return EMSessionManager.getInstance().getLastLoginUser();
        }
        return EMSessionManager.getInstance().currentUser;
    }

    public boolean isLoggedInBefore() {
        EMSessionManager eMSessionManager = EMSessionManager.getInstance();
        String string = eMSessionManager.getLastLoginUser();
        if (TextUtils.isEmpty((CharSequence)string)) {
            return false;
        }
        String string2 = eMSessionManager.getLastLoginPwd();
        String string3 = eMSessionManager.getLastLoginToken();
        return string != null && !string.isEmpty() && (string2 != null && !string2.isEmpty() || string3 != null && !string3.isEmpty());
    }

    public boolean isConnected() {
        return this.emaObject.isConnected();
    }

    public boolean isLoggedIn() {
        return this.emaObject.isLoggedIn();
    }

    public void setDebugMode(boolean debugMode) {
        EMLog.debugMode = debugMode;
        this.getChatConfigPrivate().c(debugMode);
    }

    public void uploadLog(EMCallBack callback) {
        this.chatManager().emaObject.uploadLog();
    }

    public EMOptions getOptions() {
        return this.mChatConfigPrivate.b();
    }

    public String compressLogs() throws HyphenateException {
        EMAError eMAError = new EMAError();
        String string = this.emaObject.compressLogs(eMAError);
        this.handleError(eMAError);
        return string;
    }

    private void initManagers() {
        EMHttpClient.getInstance().onInit(this.mChatConfigPrivate);
        this.chatManager();
        this.chatroomManager();
        this.setNatvieNetworkCallback();
        EMSessionManager.getInstance().init(this);
    }

    void _login(final String username, final String code, final EMCallBack callback, final boolean autoLogin, final EMLoginType loginType) {
        if (this.getChatConfigPrivate() == null || !this.sdkInited) {
            callback.onError(1, "");
            return;
        }
        EMLog.e(TAG, "emchat manager login in process:" + Process.myPid());
        this.execute(new Runnable(){

            @Override
            public void run() {
                EMLog.e(EMClient.TAG, "emchat manager login in process:" + Process.myPid() + " threadName:" + Thread.currentThread().getName() + " ID:" + Thread.currentThread().getId());
                if (username == null) {
                    callback.onError(101, "Invalid user name");
                    return;
                }
                EMAError eMAError = new EMAError();
                EMClient.this.emaObject.login(username, code, autoLogin, loginType.ordinal(), eMAError);
                if (eMAError.errCode() == 0) {
                    EMSessionManager.getInstance().setLastLoginUser(username);
                    if (loginType == EMLoginType.LOGIN_PASSWORD) {
                        EMSessionManager.getInstance().setLastLoginPwd(code);
                        EMSessionManager.getInstance().setLastLoginWithToken(false);
                        EMSessionManager.getInstance().clearLastLoginToken();
                    } else {
                        EMClient.this.saveToken();
                    }
                    EMClient.this.onNewLogin();
                    callback.onSuccess();
                } else {
                    callback.onError(eMAError.errCode(), eMAError.errMsg());
                }
                if (eMAError.errCode() == 202) {
                    EMSessionManager.getInstance().clearLastLoginPwd();
                    EMSessionManager.getInstance().clearLastLoginToken();
                    EMSessionManager.getInstance().clearLoginWithTokenData();
                }
            }
        });
    }

    private void saveToken() {
        if (this.emaObject == null) {
            return;
        }
        EMAError eMAError = new EMAError();
        String string = this.emaObject.getUserToken(false, eMAError);
        if (eMAError.errCode() == 0) {
            EMSessionManager.getInstance().setLastLoginToken(string);
            EMSessionManager.getInstance().setLastLoginWithToken(true);
            EMSessionManager.getInstance().clearLastLoginPwd();
        }
    }

    void onNewLogin() {
        EMLog.d(TAG, "on new login created");
        String string = EMSessionManager.getInstance().getLastLoginUser();
        PathUtil.getInstance().initDirs(this.getChatConfigPrivate().k(), string, this.mContext);
        if (this.smartHeartbeat == null) {
            this.smartHeartbeat = EMSmartHeartBeat.create(this.mContext);
        }
        if (this.getChatConfigPrivate().a.hasHeartBeatCustomizedParams()) {
            this.smartHeartbeat.setCustomizedParams(this.getChatConfigPrivate().a.getWifiHeartBeatCustomizedParams(), this.getChatConfigPrivate().a.getMobileHeartBeatCustomizedParams());
        }
        this.smartHeartbeat.onInit();
        if (this.getOptions().getFixedInterval() != -1) {
            this.smartHeartbeat.setFixedInterval(this.getOptions().getFixedInterval());
        }
    }

    public String getAccessToken() {
        return this.getChatConfigPrivate().m();
    }

    public boolean isSdkInited() {
        return this.sdkInited;
    }

    private boolean _loadLibrary(String library, boolean trace) {
        try {
            System.loadLibrary(library);
            return true;
        }
        catch (Throwable throwable) {
            if (trace) {
                throwable.printStackTrace();
            }
            return false;
        }
    }

    private boolean _loadLibrary(String library) {
        return this._loadLibrary(library, true);
    }

    private void loadLibrary() {
        if (!libraryLoaded) {
            this._loadLibrary("hyphenate");
            libraryLoaded = true;
        }
    }

    void execute(Runnable runnable) {
        this.executor.execute(runnable);
    }

    void executeOnMainQueue(Runnable runnable) {
        this.mainQueue.submit(runnable);
    }

    void executeOnSendQueue(Runnable runnable) {
        this.sendQueue.submit(runnable);
    }

    public EMChatConfigPrivate getChatConfigPrivate() {
        return this.mChatConfigPrivate;
    }

    void setNatvieNetworkCallback() {
        EMANetCallback eMANetCallback = new EMANetCallback(){

            @Override
            public int getNetState() {
                if (!NetUtils.hasDataConnection(EMClient.this.mContext)) {
                    return EMAChatClient.EMANetwork.NETWORK_NONE.ordinal();
                }
                if (NetUtils.isWifiConnected(EMClient.this.mContext) || NetUtils.isOthersConnected(EMClient.this.mContext)) {
                    return EMAChatClient.EMANetwork.NETWORK_WIFI.ordinal();
                }
                if (NetUtils.isMobileConnected(EMClient.this.mContext)) {
                    return EMAChatClient.EMANetwork.NETWORK_MOBILE.ordinal();
                }
                if (NetUtils.isEthernetConnected(EMClient.this.mContext)) {
                    return EMAChatClient.EMANetwork.NETWORK_CABLE.ordinal();
                }
                return EMAChatClient.EMANetwork.NETWORK_NONE.ordinal();
            }
        };
        this.mChatConfigPrivate.a.setNetCallback(eMANetCallback);
    }

    void setEncryptProvider(EMEncryptProvider provider) {
        this.encryptProvider = provider;
    }

    boolean sendPing(boolean waitPong, long timeout) {
        return this.emaObject.sendPing(waitPong, timeout);
    }

    void checkTokenAvailability() {
        if (this.mIsLoginWithToken) {
            EMSessionManager.getInstance().checkTokenAvailability(this.connectionListener);
        }
    }

    void forceReconnect() {
        EMLog.d(TAG, "forceReconnect");
        this.disconnect();
        this.reconnect();
    }

    void reconnect() {
        EMLog.d(TAG, "reconnect");
        try {
            this.wakeLock.acquire();
        }
        catch (Exception exception) {
            EMLog.e(TAG, exception.getMessage());
        }
        this.emaObject.reconnect();
        this.releaseWakelock();
    }

    void disconnect() {
        EMLog.d(TAG, "disconnect");
        this.emaObject.disconnect();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseWakelock() {
        EMClient eMClient = this;
        synchronized (eMClient) {
            if (this.wakeLock != null && this.wakeLock.isHeld()) {
                try {
                    this.wakeLock.release();
                }
                catch (Exception exception) {
                    EMLog.e(TAG, exception.getMessage());
                }
                EMLog.d(TAG, "released the wake lock");
            }
        }
    }

    private void handleError(EMAError error) throws HyphenateException {
        if (error.errCode() != 0) {
            throw new HyphenateException(error);
        }
    }

    void onNetworkChanged() {
        try {
            if (NetUtils.isWifiConnected(this.mContext) || NetUtils.isOthersConnected(this.mContext)) {
                EMLog.d(TAG, "has wifi connection");
                this.currentNetworkType = EMAChatClient.EMANetwork.NETWORK_WIFI;
                this.emaObject.onNetworkChanged(EMAChatClient.EMANetwork.NETWORK_WIFI);
                return;
            }
            if (NetUtils.isMobileConnected(this.mContext)) {
                EMLog.d(TAG, "has mobile connection");
                this.currentNetworkType = EMAChatClient.EMANetwork.NETWORK_MOBILE;
                this.emaObject.onNetworkChanged(EMAChatClient.EMANetwork.NETWORK_MOBILE);
                return;
            }
            if (NetUtils.isEthernetConnected(this.mContext)) {
                EMLog.d(TAG, "has ethernet connection");
                this.currentNetworkType = EMAChatClient.EMANetwork.NETWORK_CABLE;
                this.emaObject.onNetworkChanged(EMAChatClient.EMANetwork.NETWORK_CABLE);
                return;
            }
            this.currentNetworkType = EMAChatClient.EMANetwork.NETWORK_NONE;
            EMLog.d(TAG, "no data connection");
            this.emaObject.onNetworkChanged(EMAChatClient.EMANetwork.NETWORK_NONE);
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    void onNetworkChanged(EMAChatClient.EMANetwork network) {
        this.emaObject.onNetworkChanged(network);
    }

    void setAppStateListener(AppStateListener appStateListener) {
        this.appStateListener = appStateListener;
    }

    @TargetApi(value=14)
    private void registerActivityLifecycleCallbacks() {
        if (Utils.isSdk14()) {
            Application.ActivityLifecycleCallbacks activityLifecycleCallbacks = new Application.ActivityLifecycleCallbacks(){

                public void onActivityStopped(Activity activity) {
                    EMClient.this.resumeActivityList.remove(activity);
                    if (EMClient.this.resumeActivityList.isEmpty() && EMClient.this.appStateListener != null) {
                        EMClient.this.appStateListener.onBackground();
                    }
                }

                public void onActivityResumed(Activity activity) {
                }

                public void onActivityCreated(Activity activity, Bundle savedInstanceState) {
                }

                public void onActivityStarted(Activity activity) {
                    if (!EMClient.this.resumeActivityList.contains(activity)) {
                        EMClient.this.resumeActivityList.add(activity);
                        if (EMClient.this.resumeActivityList.size() == 1 && EMClient.this.appStateListener != null) {
                            EMClient.this.appStateListener.onForeground();
                        }
                    }
                }

                public void onActivitySaveInstanceState(Activity activity, Bundle outState) {
                }

                public void onActivityPaused(Activity activity) {
                }

                public void onActivityDestroyed(Activity activity) {
                }
            };
            ((Application)this.mContext).registerActivityLifecycleCallbacks(activityLifecycleCallbacks);
        }
    }

    static interface AppStateListener {
        public void onForeground();

        public void onBackground();
    }

    class ClientLogListener
    extends EMALogCallbackListener {
        ClientLogListener() {
        }

        @Override
        public void onLogCallback(String log) {
            EMClient.this.logQueue.submit(() -> {
                List list = EMClient.this.logListeners;
                synchronized (list) {
                    for (EMLogListener eMLogListener : EMClient.this.logListeners) {
                        try {
                            eMLogListener.onLog(log);
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                    }
                }
            });
        }
    }

    class MyConnectionListener
    extends EMAConnectionListener {
        MyConnectionListener() {
        }

        @Override
        public void onConnected() {
            EMClient.this.execute(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    List list = EMClient.this.connectionListeners;
                    synchronized (list) {
                        try {
                            for (EMConnectionListener eMConnectionListener : EMClient.this.connectionListeners) {
                                eMConnectionListener.onConnected();
                            }
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                    }
                }
            });
        }

        @Override
        public void onDisconnected(final int errCode, final String info) {
            EMLog.e(EMClient.TAG, "onDisconnected errcode = " + errCode + ",info = " + info);
            EMClient.this.execute(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    List list = EMClient.this.connectionListeners;
                    synchronized (list) {
                        switch (errCode) {
                            case 207: {
                                EMSessionManager.getInstance().clearLastLoginUser();
                                EMSessionManager.getInstance().clearLastLoginToken();
                                EMSessionManager.getInstance().clearLastLoginPwd();
                                break;
                            }
                            case 8: 
                            case 206: 
                            case 213: 
                            case 214: 
                            case 216: 
                            case 217: 
                            case 220: 
                            case 305: {
                                EMSessionManager.getInstance().clearLastLoginToken();
                                EMSessionManager.getInstance().clearLastLoginPwd();
                            }
                        }
                        try {
                            for (EMConnectionListener eMConnectionListener : EMClient.this.connectionListeners) {
                                eMConnectionListener.onDisconnected(errCode);
                            }
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                        if (errCode == 206 || errCode == 207 || errCode == 213 || errCode == 220 || errCode == 305 || errCode == 214 || errCode == 216 || errCode == 217 || errCode == 8) {
                            for (EMConnectionListener eMConnectionListener : EMClient.this.connectionListeners) {
                                try {
                                    eMConnectionListener.onLogout(errCode, info);
                                }
                                catch (Exception exception) {
                                    exception.printStackTrace();
                                }
                            }
                        }
                    }
                }
            });
        }

        @Override
        public boolean verifyServerCert(List<String> certschain, String domain) {
            if (certschain == null) {
                EMLog.d(EMClient.TAG, "List<String> certschain : null ");
                return false;
            }
            if (TextUtils.isEmpty((CharSequence)domain)) {
                EMLog.d(EMClient.TAG, "domain is empty or null ");
                return false;
            }
            EMLog.d(EMClient.TAG, "domain = " + domain);
            X509Certificate[] x509CertificateArray = EasyUtils.convertToCerts(certschain);
            try {
                X509TrustManager x509TrustManager = EasyUtils.getSystemDefaultTrustManager();
                X509TrustManagerExtensions x509TrustManagerExtensions = new X509TrustManagerExtensions(x509TrustManager);
                x509TrustManagerExtensions.checkServerTrusted(x509CertificateArray, x509CertificateArray[0].getType(), domain);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                EMLog.e(EMClient.TAG, exception.getMessage());
                EMLog.d(EMClient.TAG, "List<String> certschain :" + certschain.toString());
                return false;
            }
            return true;
        }

        @Override
        public void onTokenNotification(final int code) {
            EMClient.this.execute(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    List list = EMClient.this.connectionListeners;
                    synchronized (list) {
                        try {
                            if (code == 108 || code == 401) {
                                EMClient.this.logout();
                                for (EMConnectionListener eMConnectionListener : EMClient.this.connectionListeners) {
                                    EMLog.d(EMClient.TAG, "MyConnectionListener onToken has expired, code: " + code);
                                    eMConnectionListener.onTokenExpired();
                                }
                            } else {
                                for (EMConnectionListener eMConnectionListener : EMClient.this.connectionListeners) {
                                    EMLog.d(EMClient.TAG, "MyConnectionListener onToken will expire, code: " + code);
                                    eMConnectionListener.onTokenWillExpire();
                                }
                            }
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                            EMLog.e(EMClient.TAG, "MyConnectionListener onTokenNotification Exception: " + exception.getMessage());
                        }
                    }
                }
            });
        }

        @Override
        public void onReceiveToken(String token, long expireTimestamp) {
            if (TextUtils.isEmpty((CharSequence)token) || expireTimestamp <= 0L) {
                EMLog.e(EMClient.TAG, "onReceiveToken: params received is invalid token: " + token + " expireTimestamp: " + expireTimestamp);
                return;
            }
            long l = expireTimestamp - System.currentTimeMillis();
            EMClient.this.initLoginWithToken(true, String.valueOf(expireTimestamp), l);
            EMLog.d(EMClient.TAG, "onReceiveToken: token: " + token + " expireTimestamp: " + expireTimestamp + " tokenAvailablePeriod: " + l);
        }

        @Override
        public void onDatabaseOpened(int errCode) {
            EMLog.e(EMClient.TAG, "onDatabaseOpened: errCode: " + errCode);
        }
    }
}

