/*
 * Decompiled with CFR 0.152.
 */
package com.hyphenate.chat;

import android.text.TextUtils;
import com.hyphenate.EMCallBack;
import com.hyphenate.EMChatRoomChangeListener;
import com.hyphenate.EMValueCallBack;
import com.hyphenate.chat.EMChatRoom;
import com.hyphenate.chat.EMClient;
import com.hyphenate.chat.EMCursorResult;
import com.hyphenate.chat.EMOptions;
import com.hyphenate.chat.EMPageResult;
import com.hyphenate.chat.adapter.EMAChatRoom;
import com.hyphenate.chat.adapter.EMAChatRoomManager;
import com.hyphenate.chat.adapter.EMAChatRoomManagerListener;
import com.hyphenate.chat.adapter.EMAError;
import com.hyphenate.exceptions.HyphenateException;
import com.hyphenate.util.EMLog;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class EMChatRoomManager {
    EMAChatRoomManager emaObject;
    private List<EMChatRoomChangeListener> chatRoomListeners = Collections.synchronizedList(new ArrayList());
    private ExecutorService threadPool = null;
    private List<EMChatRoom> chatRooms = Collections.synchronizedList(new ArrayList());
    private static final String TAG = EMChatRoomManager.class.getSimpleName();
    EMClient mClient;
    EMAChatRoomManagerListener chatRoomListenerImpl = new EMAChatRoomManagerListener(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onLeaveChatRoom(EMAChatRoom chatroom, int leaveReason) {
            EMClient.getInstance().chatManager().caches.remove(chatroom.getId());
            List list = EMChatRoomManager.this.chatRoomListeners;
            synchronized (list) {
                try {
                    for (EMChatRoomChangeListener eMChatRoomChangeListener : EMChatRoomManager.this.chatRoomListeners) {
                        if (leaveReason == 1) {
                            eMChatRoomChangeListener.onChatRoomDestroyed(chatroom.getId(), chatroom.getName());
                            continue;
                        }
                        eMChatRoomChangeListener.onRemovedFromChatRoom(leaveReason, chatroom.getId(), chatroom.getName(), EMClient.getInstance().getCurrentUser());
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onMemberJoinedChatRoom(EMAChatRoom chatroom, String member, String ext) {
            List list = EMChatRoomManager.this.chatRoomListeners;
            synchronized (list) {
                try {
                    for (EMChatRoomChangeListener eMChatRoomChangeListener : EMChatRoomManager.this.chatRoomListeners) {
                        eMChatRoomChangeListener.onMemberJoined(chatroom.getId(), member);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                try {
                    for (EMChatRoomChangeListener eMChatRoomChangeListener : EMChatRoomManager.this.chatRoomListeners) {
                        eMChatRoomChangeListener.onMemberJoined(chatroom.getId(), member, ext);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onMemberLeftChatRoom(EMAChatRoom chatroom, String member) {
            List list = EMChatRoomManager.this.chatRoomListeners;
            synchronized (list) {
                try {
                    for (EMChatRoomChangeListener eMChatRoomChangeListener : EMChatRoomManager.this.chatRoomListeners) {
                        eMChatRoomChangeListener.onMemberExited(chatroom.getId(), chatroom.getName(), member);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onAddMuteList(EMAChatRoom chatRoom, List<String> mutes, long expireTime) {
            List list = EMChatRoomManager.this.chatRoomListeners;
            synchronized (list) {
                try {
                    for (EMChatRoomChangeListener eMChatRoomChangeListener : EMChatRoomManager.this.chatRoomListeners) {
                        eMChatRoomChangeListener.onMuteListAdded(chatRoom.getId(), mutes, expireTime);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onRemoveMutes(EMAChatRoom chatRoom, List<String> mutes) {
            List list = EMChatRoomManager.this.chatRoomListeners;
            synchronized (list) {
                try {
                    for (EMChatRoomChangeListener eMChatRoomChangeListener : EMChatRoomManager.this.chatRoomListeners) {
                        eMChatRoomChangeListener.onMuteListRemoved(chatRoom.getId(), mutes);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onWhiteListAdded(EMAChatRoom chatRoom, List<String> members) {
            List list = EMChatRoomManager.this.chatRoomListeners;
            synchronized (list) {
                try {
                    for (EMChatRoomChangeListener eMChatRoomChangeListener : EMChatRoomManager.this.chatRoomListeners) {
                        eMChatRoomChangeListener.onWhiteListAdded(chatRoom.getId(), members);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onWhiteListRemoved(EMAChatRoom chatRoom, List<String> members) {
            List list = EMChatRoomManager.this.chatRoomListeners;
            synchronized (list) {
                try {
                    for (EMChatRoomChangeListener eMChatRoomChangeListener : EMChatRoomManager.this.chatRoomListeners) {
                        eMChatRoomChangeListener.onWhiteListRemoved(chatRoom.getId(), members);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onAllMemberMuteStateChanged(EMAChatRoom chatRoom, boolean isMuted) {
            List list = EMChatRoomManager.this.chatRoomListeners;
            synchronized (list) {
                try {
                    for (EMChatRoomChangeListener eMChatRoomChangeListener : EMChatRoomManager.this.chatRoomListeners) {
                        eMChatRoomChangeListener.onAllMemberMuteStateChanged(chatRoom.getId(), isMuted);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onAddAdmin(EMAChatRoom chatRoom, String admin) {
            List list = EMChatRoomManager.this.chatRoomListeners;
            synchronized (list) {
                try {
                    for (EMChatRoomChangeListener eMChatRoomChangeListener : EMChatRoomManager.this.chatRoomListeners) {
                        eMChatRoomChangeListener.onAdminAdded(chatRoom.getId(), admin);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onRemoveAdmin(EMAChatRoom chatRoom, String admin) {
            List list = EMChatRoomManager.this.chatRoomListeners;
            synchronized (list) {
                try {
                    for (EMChatRoomChangeListener eMChatRoomChangeListener : EMChatRoomManager.this.chatRoomListeners) {
                        eMChatRoomChangeListener.onAdminRemoved(chatRoom.getId(), admin);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onOwnerChanged(EMAChatRoom chatRoom, String newOwner, String oldOwner) {
            List list = EMChatRoomManager.this.chatRoomListeners;
            synchronized (list) {
                try {
                    for (EMChatRoomChangeListener eMChatRoomChangeListener : EMChatRoomManager.this.chatRoomListeners) {
                        eMChatRoomChangeListener.onOwnerChanged(chatRoom.getId(), newOwner, oldOwner);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onAnnouncementChanged(EMAChatRoom chatRoom, String announcement) {
            List list = EMChatRoomManager.this.chatRoomListeners;
            synchronized (list) {
                try {
                    for (EMChatRoomChangeListener eMChatRoomChangeListener : EMChatRoomManager.this.chatRoomListeners) {
                        eMChatRoomChangeListener.onAnnouncementChanged(chatRoom.getId(), announcement);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onUpdateSpecificationFromChatroom(EMAChatRoom chatroom) {
            List list = EMChatRoomManager.this.chatRoomListeners;
            synchronized (list) {
                for (EMChatRoomChangeListener eMChatRoomChangeListener : EMChatRoomManager.this.chatRoomListeners) {
                    try {
                        if (null == chatroom) continue;
                        eMChatRoomChangeListener.onSpecificationChanged(new EMChatRoom(chatroom));
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onAttributesUpdate(String chatRoomId, String attributes, String from) {
            List list = EMChatRoomManager.this.chatRoomListeners;
            synchronized (list) {
                for (EMChatRoomChangeListener eMChatRoomChangeListener : EMChatRoomManager.this.chatRoomListeners) {
                    Map map = EMChatRoomManager.this.parseJsonUpdate(attributes);
                    try {
                        if (null == map || map.size() <= 0) continue;
                        eMChatRoomChangeListener.onAttributesUpdate(chatRoomId, map, from);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onAttributesRemoved(String chatRoomId, String attributes, String from) {
            List list = EMChatRoomManager.this.chatRoomListeners;
            synchronized (list) {
                for (EMChatRoomChangeListener eMChatRoomChangeListener : EMChatRoomManager.this.chatRoomListeners) {
                    List list2 = EMChatRoomManager.this.parseJsonRemove(attributes);
                    try {
                        if (null == list2 || list2.size() <= 0) continue;
                        eMChatRoomChangeListener.onAttributesRemoved(chatRoomId, list2, from);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            }
        }
    };

    public EMChatRoomManager(EMClient client, EMAChatRoomManager manager) {
        this.emaObject = manager;
        this.emaObject.addListener(this.chatRoomListenerImpl);
        this.mClient = client;
        this.threadPool = Executors.newCachedThreadPool();
    }

    public void addChatRoomChangeListener(EMChatRoomChangeListener listener) {
        this.chatRoomListeners.add(listener);
    }

    public void removeChatRoomListener(EMChatRoomChangeListener listener) {
        this.chatRoomListeners.remove(listener);
    }

    public void joinChatRoom(String roomId, EMValueCallBack<EMChatRoom> callback) {
        this.joinChatRoom(roomId, false, null, callback);
    }

    public void joinChatRoom(final String roomId, final boolean leaveOtherRooms, final String ext, final EMValueCallBack<EMChatRoom> callback) {
        this.threadPool.submit(new Runnable(){

            @Override
            public void run() {
                EMAError eMAError = new EMAError();
                EMAChatRoom eMAChatRoom = EMChatRoomManager.this.emaObject.joinChatRoom(roomId, leaveOtherRooms, ext, eMAError);
                EMChatRoom eMChatRoom = new EMChatRoom(eMAChatRoom);
                if (callback != null) {
                    if (eMAError.errCode() == 0 || eMAError.errCode() == 701) {
                        callback.onSuccess(eMChatRoom);
                    } else {
                        callback.onError(eMAError.errCode(), eMAError.errMsg());
                    }
                }
            }
        });
    }

    public void leaveChatRoom(final String roomId) {
        this.threadPool.submit(new Runnable(){

            @Override
            public void run() {
                EMAError eMAError = new EMAError();
                EMChatRoomManager.this.emaObject.leaveChatRoom(roomId, eMAError);
                if (eMAError.errCode() == 0) {
                    EMOptions eMOptions = EMClient.getInstance().getOptions();
                    boolean bl = eMOptions.deleteMessagesOnLeaveChatroom();
                    if (bl) {
                        EMClient.getInstance().chatManager().deleteConversation(roomId, true);
                    }
                } else {
                    EMLog.e(TAG, "leaveChatroom error: " + eMAError.errCode());
                }
            }
        });
    }

    public void leaveChatRoom(final String roomId, final EMCallBack callback) {
        final EMOptions eMOptions = EMClient.getInstance().getOptions();
        this.threadPool.submit(new Runnable(){

            @Override
            public void run() {
                EMAError eMAError = new EMAError();
                EMChatRoomManager.this.emaObject.leaveChatRoom(roomId, eMAError);
                if (callback != null) {
                    if (eMAError.errCode() == 0 || eMAError.errCode() == 705) {
                        boolean bl = eMOptions.deleteMessagesOnLeaveChatroom();
                        if (bl) {
                            EMClient.getInstance().chatManager().deleteConversation(roomId, true);
                        }
                        callback.onSuccess();
                    } else {
                        callback.onError(eMAError.errCode(), eMAError.errMsg());
                    }
                }
            }
        });
    }

    public EMPageResult<EMChatRoom> fetchPublicChatRoomsFromServer(int pageNum, int pageSize) throws HyphenateException {
        EMAError eMAError = new EMAError();
        EMPageResult<EMAChatRoom> eMPageResult = this.emaObject.fetchChatroomsWithPage(pageNum, pageSize, eMAError);
        this.handleError(eMAError);
        List list = (List)eMPageResult.getData();
        int n = eMPageResult.getPageCount();
        EMPageResult<EMChatRoom> eMPageResult2 = new EMPageResult<EMChatRoom>();
        ArrayList<EMChatRoom> arrayList = new ArrayList<EMChatRoom>();
        for (EMAChatRoom eMAChatRoom : list) {
            arrayList.add(new EMChatRoom(eMAChatRoom));
        }
        eMPageResult2.setPageCount(n);
        eMPageResult2.setData(arrayList);
        this.chatRooms.clear();
        this.chatRooms.addAll(arrayList);
        return eMPageResult2;
    }

    public void asyncFetchPublicChatRoomsFromServer(final int pageNum, final int pageSize, final EMValueCallBack<EMPageResult<EMChatRoom>> callback) {
        EMClient.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    EMPageResult<EMChatRoom> eMPageResult = EMChatRoomManager.this.fetchPublicChatRoomsFromServer(pageNum, pageSize);
                    callback.onSuccess(eMPageResult);
                }
                catch (HyphenateException hyphenateException) {
                    callback.onError(hyphenateException.getErrorCode(), hyphenateException.getDescription());
                }
            }
        });
    }

    public EMChatRoom fetchChatRoomFromServer(String roomId) throws HyphenateException {
        return this.fetchChatRoomFromServer(roomId, false);
    }

    public EMChatRoom fetchChatRoomFromServer(String roomId, boolean fetchMembers) throws HyphenateException {
        EMAError eMAError = new EMAError();
        EMAChatRoom eMAChatRoom = this.emaObject.fetchChatroomSpecification(roomId, eMAError, fetchMembers);
        this.handleError(eMAError);
        return new EMChatRoom(eMAChatRoom);
    }

    public void asyncFetchChatRoomFromServer(final String roomId, final EMValueCallBack<EMChatRoom> callback) {
        EMClient.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    EMChatRoom eMChatRoom = EMChatRoomManager.this.fetchChatRoomFromServer(roomId);
                    callback.onSuccess(eMChatRoom);
                }
                catch (HyphenateException hyphenateException) {
                    callback.onError(hyphenateException.getErrorCode(), hyphenateException.getDescription());
                }
            }
        });
    }

    public EMChatRoom getChatRoom(String roomId) {
        EMAChatRoom eMAChatRoom = this.emaObject.getChatroom(roomId);
        if (eMAChatRoom == null) {
            return null;
        }
        return new EMChatRoom(eMAChatRoom);
    }

    public EMCursorResult<String> fetchChatRoomMembers(String chatRoomId, String cursor, int pageSize) throws HyphenateException {
        EMAError eMAError = new EMAError();
        EMCursorResult<String> eMCursorResult = this.emaObject.fetchChatroomMembers(chatRoomId, cursor, pageSize, eMAError);
        this.handleError(eMAError);
        return eMCursorResult;
    }

    public void asyncFetchChatRoomMembers(final String chatRoomId, final String cursor, final int pageSize, final EMValueCallBack<EMCursorResult<String>> callBack) {
        EMClient.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    callBack.onSuccess(EMChatRoomManager.this.fetchChatRoomMembers(chatRoomId, cursor, pageSize));
                }
                catch (HyphenateException hyphenateException) {
                    callBack.onError(hyphenateException.getErrorCode(), hyphenateException.getDescription());
                }
            }
        });
    }

    public String fetchChatRoomAnnouncement(String chatRoomId) throws HyphenateException {
        EMAError eMAError = new EMAError();
        String string = this.emaObject.fetchChatRoomAnnouncement(chatRoomId, eMAError);
        this.handleError(eMAError);
        return string;
    }

    public void asyncFetchChatRoomAnnouncement(final String chatRoomId, final EMValueCallBack<String> callBack) {
        EMClient.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    callBack.onSuccess(EMChatRoomManager.this.fetchChatRoomAnnouncement(chatRoomId));
                }
                catch (HyphenateException hyphenateException) {
                    callBack.onError(hyphenateException.getErrorCode(), hyphenateException.getDescription());
                }
            }
        });
    }

    private void handleError(EMAError error) throws HyphenateException {
        if (error.errCode() != 0) {
            throw new HyphenateException(error);
        }
    }

    private void handlePartialError(EMAError error) throws HyphenateException {
        if (error.errCode() != 0 && error.errCode() != 7) {
            throw new HyphenateException(error);
        }
    }

    private Map<String, String> parseJson(String jsonString) throws HyphenateException {
        if (TextUtils.isEmpty((CharSequence)jsonString)) {
            return null;
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        try {
            JSONObject jSONObject = new JSONObject(jsonString);
            Iterator iterator = jSONObject.keys();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                String string2 = jSONObject.getString(string);
                hashMap.put(string, string2);
            }
            return hashMap;
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
            throw new HyphenateException(303, "Unknown server error");
        }
    }

    private Map<String, Integer> parseCodeJson(String jsonString) {
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        if (TextUtils.isEmpty((CharSequence)jsonString)) {
            return hashMap;
        }
        try {
            JSONObject jSONObject = new JSONObject(jsonString);
            Iterator iterator = jSONObject.keys();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                int n = jSONObject.getInt(string);
                hashMap.put(string, n);
            }
        }
        catch (JSONException jSONException) {
            EMLog.e("parseCodeJson", jSONException.getMessage());
        }
        return hashMap;
    }

    private Map<String, String> parseJsonUpdate(String jsonString) {
        if (TextUtils.isEmpty((CharSequence)jsonString)) {
            return null;
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        try {
            ArrayList<String> arrayList = new ArrayList<String>();
            JSONObject jSONObject = new JSONObject(jsonString);
            JSONObject jSONObject2 = jSONObject.getJSONObject("result");
            JSONArray jSONArray = jSONObject2.getJSONArray("successKeys");
            for (int i = 0; i < jSONArray.length(); ++i) {
                arrayList.add(jSONArray.getString(i));
            }
            JSONObject jSONObject3 = jSONObject.getJSONObject("properties");
            Iterator iterator = jSONObject3.keys();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                String string2 = jSONObject3.getString(string);
                if (!arrayList.contains(string)) continue;
                hashMap.put(string, string2);
            }
            return hashMap;
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
            return null;
        }
    }

    private List<String> parseJsonRemove(String jsonString) {
        if (TextUtils.isEmpty((CharSequence)jsonString)) {
            return null;
        }
        try {
            ArrayList<String> arrayList = new ArrayList<String>();
            JSONObject jSONObject = new JSONObject(jsonString);
            JSONObject jSONObject2 = jSONObject.getJSONObject("result");
            JSONArray jSONArray = jSONObject2.getJSONArray("successKeys");
            for (int i = 0; i < jSONArray.length(); ++i) {
                arrayList.add(jSONArray.getString(i));
            }
            return arrayList;
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
            return null;
        }
    }

    private String toJsonString(Map<String, String> extJson, boolean autoDelete) {
        JSONObject jSONObject = null;
        try {
            jSONObject = new JSONObject();
            jSONObject.put("metaData", (Object)new JSONObject(extJson));
            if (autoDelete) {
                jSONObject.put("autoDelete", (Object)"DELETE");
            } else {
                jSONObject.put("autoDelete", (Object)"NO_DELETE");
            }
            return jSONObject.toString();
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
            return "";
        }
    }

    void onLogout() {
    }
}

