/*
 * Decompiled with CFR 0.152.
 */
package com.hyphenate.chat;

import android.graphics.BitmapFactory;
import android.net.Uri;
import android.text.TextUtils;
import android.util.Log;
import com.hyphenate.EMCallBack;
import com.hyphenate.EMConversationListener;
import com.hyphenate.EMMessageListener;
import com.hyphenate.EMValueCallBack;
import com.hyphenate.chat.EMClient;
import com.hyphenate.chat.EMConversation;
import com.hyphenate.chat.EMCursorResult;
import com.hyphenate.chat.EMFetchMessageOption;
import com.hyphenate.chat.EMFileMessageBody;
import com.hyphenate.chat.EMImageMessageBody;
import com.hyphenate.chat.EMMessage;
import com.hyphenate.chat.EMOptions;
import com.hyphenate.chat.EMVideoMessageBody;
import com.hyphenate.chat.adapter.EMAChatManager;
import com.hyphenate.chat.adapter.EMAChatManagerListener;
import com.hyphenate.chat.adapter.EMAConversation;
import com.hyphenate.chat.adapter.EMAError;
import com.hyphenate.chat.adapter.EMAFetchMessageOption;
import com.hyphenate.chat.adapter.message.EMAFileMessageBody;
import com.hyphenate.chat.adapter.message.EMAImageMessageBody;
import com.hyphenate.chat.adapter.message.EMAMessage;
import com.hyphenate.chat.adapter.message.EMAMessageBody;
import com.hyphenate.exceptions.HyphenateException;
import com.hyphenate.util.EMFileHelper;
import com.hyphenate.util.EMLog;
import com.hyphenate.util.ImageUtils;
import com.hyphenate.util.PathUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;

public class EMChatManager {
    EMAChatManager emaObject;
    private static final String TAG = "EMChatManager";
    private static final String INTERNAL_ACTION_PREFIX = "em_";
    EMClient mClient;
    Map<String, EMConversation.MessageCache> caches = new Hashtable<String, EMConversation.MessageCache>();
    private List<EMMessageListener> messageListeners = new CopyOnWriteArrayList<EMMessageListener>();
    private List<EMConversationListener> conversationListeners = Collections.synchronizedList(new ArrayList());
    EMAChatManagerListener chatManagerListenerImpl = new EMAChatManagerListener(){

        @Override
        public void onReceiveMessages(final List<EMAMessage> messages) {
            EMChatManager.this.mClient.executeOnMainQueue(new Runnable(){

                @Override
                public void run() {
                    ArrayList<EMMessage> arrayList = new ArrayList<EMMessage>();
                    for (Iterator iterator : messages) {
                        arrayList.add(new EMMessage((EMAMessage)((Object)iterator)));
                    }
                    ArrayList arrayList2 = new ArrayList();
                    for (EMMessage object : arrayList) {
                        EMConversation eMConversation = EMChatManager.this.getConversation(object.conversationId(), EMConversation.msgType2ConversationType(object.getFrom(), object.getChatType()), true);
                        if (eMConversation == null) {
                            EMLog.d(EMChatManager.TAG, "no conversation");
                        }
                        if (object.getType() != EMMessage.Type.CMD) {
                            eMConversation.getCache().addMessage(object);
                        }
                        arrayList2.add(object);
                    }
                    if (arrayList2.size() <= 0) {
                        EMLog.d(EMChatManager.TAG, "no remainingMsgs");
                        return;
                    }
                    for (EMMessageListener eMMessageListener : EMChatManager.this.messageListeners) {
                        try {
                            EMLog.d(EMChatManager.TAG, "onMessageReceived\uff1a " + eMMessageListener);
                            eMMessageListener.onMessageReceived(arrayList2);
                        }
                        catch (Exception exception) {
                            EMLog.d(EMChatManager.TAG, "onMessageReceived has problem: " + exception.getMessage());
                            exception.printStackTrace();
                        }
                    }
                }
            });
        }

        @Override
        public void onReceiveCmdMessages(final List<EMAMessage> messages) {
            EMChatManager.this.mClient.executeOnMainQueue(new Runnable(){

                @Override
                public void run() {
                    ArrayList<EMMessage> arrayList = new ArrayList<EMMessage>();
                    for (Object object : messages) {
                        arrayList.add(new EMMessage((EMAMessage)object));
                    }
                    try {
                        for (Object object : EMChatManager.this.messageListeners) {
                            object.onCmdMessageReceived(arrayList);
                        }
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            });
        }

        @Override
        public void onMessageStatusChanged(EMAMessage message, EMAError error) {
        }

        @Override
        public void onMessageAttachmentsStatusChanged(EMAMessage message, EMAError error) {
        }

        @Override
        public void onReceiveRecallMessages(final List<EMAMessage> messages) {
            EMChatManager.this.mClient.executeOnMainQueue(new Runnable(){

                @Override
                public void run() {
                    ArrayList<EMMessage> arrayList = new ArrayList<EMMessage>();
                    for (Object object : messages) {
                        arrayList.add(new EMMessage((EMAMessage)object));
                        EMChatManager.this.getConversation(((EMAMessage)object).conversationId()).getCache().removeMessage(((EMAMessage)object).msgId());
                    }
                    try {
                        for (Object object : EMChatManager.this.messageListeners) {
                            object.onMessageRecalled(arrayList);
                        }
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            });
        }

        @Override
        public void onReceiveHasReadAcks(final List<EMAMessage> messages) {
            EMChatManager.this.mClient.executeOnMainQueue(new Runnable(){

                @Override
                public void run() {
                    ArrayList<EMMessage> arrayList = new ArrayList<EMMessage>();
                    for (Object object : messages) {
                        arrayList.add(new EMMessage((EMAMessage)object));
                    }
                    try {
                        for (Object object : EMChatManager.this.messageListeners) {
                            object.onMessageRead(arrayList);
                        }
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            });
        }

        @Override
        public void onReceiveHasDeliveredAcks(final List<EMAMessage> messages) {
            EMChatManager.this.mClient.executeOnMainQueue(new Runnable(){

                @Override
                public void run() {
                    ArrayList<EMMessage> arrayList = new ArrayList<EMMessage>();
                    for (Object object : messages) {
                        arrayList.add(new EMMessage((EMAMessage)object));
                    }
                    try {
                        for (Object object : EMChatManager.this.messageListeners) {
                            object.onMessageDelivered(arrayList);
                        }
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            });
        }

        @Override
        public void onReceiveReadAckForConversation(final String fromUsername, final String toUsername) {
            EMChatManager.this.mClient.executeOnMainQueue(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    EMLog.d(EMChatManager.TAG, "onReceiveConversationHasReadAcks");
                    List list = EMChatManager.this.conversationListeners;
                    synchronized (list) {
                        Object object;
                        if (!TextUtils.equals((CharSequence)fromUsername, (CharSequence)EMClient.getInstance().getCurrentUser()) && (object = EMClient.getInstance().chatManager().getConversation(fromUsername)) != null) {
                            ((EMConversation)object).loadMoreMsgFromDB(null, ((EMConversation)object).getAllMessages().size());
                        }
                        try {
                            for (EMConversationListener eMConversationListener : EMChatManager.this.conversationListeners) {
                                eMConversationListener.onConversationRead(fromUsername, toUsername);
                            }
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                    }
                }
            });
        }

        @Override
        public void onUpdateConversationList(List<EMAConversation> conversations) {
            EMChatManager.this.mClient.executeOnMainQueue(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    EMLog.d(EMChatManager.TAG, "onUpdateConversationList");
                    List list = EMChatManager.this.conversationListeners;
                    synchronized (list) {
                        try {
                            for (EMConversationListener eMConversationListener : EMChatManager.this.conversationListeners) {
                                eMConversationListener.onConversationUpdate();
                            }
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                    }
                }
            });
        }

        @Override
        public void onReceivePrivateMessages(List<EMAMessage> messages) {
        }

        @Override
        public void onUpdateGroupAcks() {
            EMChatManager.this.mClient.executeOnMainQueue(new Runnable(){

                @Override
                public void run() {
                    EMLog.d(EMChatManager.TAG, "onUpdateGroupAcks");
                    try {
                        for (EMMessageListener eMMessageListener : EMChatManager.this.messageListeners) {
                            eMMessageListener.onReadAckForGroupMessageUpdated();
                        }
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            });
        }

        @Override
        public void onMessageIdChanged(String convId, String oldId, String newId) {
            EMConversation eMConversation;
            EMAMessage eMAMessage = EMChatManager.this.emaObject.getMessage(newId);
            if (eMAMessage != null) {
                EMChatManager.this.deleteImageScaledPath(eMAMessage);
            }
            if ((eMConversation = EMChatManager.this.getConversation(convId)) != null) {
                eMConversation.getCache().replaceMsgId(oldId, newId);
            }
        }
    };
    private static final int LIST_SIZE = 512;

    protected EMChatManager() {
    }

    protected EMChatManager(EMClient client, EMAChatManager manager) {
        this.mClient = client;
        this.emaObject = manager;
        this.emaObject.addListener(this.chatManagerListenerImpl);
    }

    public void sendMessage(final EMMessage msg) {
        msg.makeCallbackStrong();
        boolean bl = msg.getType() != EMMessage.Type.CMD;
        final EMConversation eMConversation = this.getConversation(msg.conversationId(), EMConversation.msgType2ConversationType(msg.getTo(), msg.getChatType()), bl, false);
        if (eMConversation != null) {
            boolean bl2;
            boolean bl3 = bl2 = eMConversation.getCache().getMessage(msg.getMsgId()) != null;
            if (!bl2) {
                long l = System.currentTimeMillis();
                EMMessage eMMessage = eMConversation.getLastMessage();
                if (eMMessage != null) {
                    l = l < eMMessage.getMsgTime() ? eMMessage.getMsgTime() : l;
                }
                msg.setMsgTime(l + 1L);
                eMConversation.getCache().addMessage(msg);
            }
        }
        this.mClient.executeOnSendQueue(new Runnable(){

            @Override
            public void run() {
                class HandleError {
                    final /* synthetic */ EMMessage val$msg;

                    HandleError(int code, String desc) {
                        this.val$msg = eMMessage;
                        EMMessage.EMCallbackHolder eMCallbackHolder = this.val$msg.messageStatusCallBack;
                        if (eMCallbackHolder != null) {
                            eMCallbackHolder.onError(code, desc);
                        }
                    }
                }
                try {
                    Object object;
                    if (EMChatManager.this.mClient.getOptions().getAutoTransferMessageAttachments()) {
                        if (msg.getType() == EMMessage.Type.IMAGE) {
                            Object object2;
                            msg.setStatus(EMMessage.Status.INPROGRESS);
                            object = (EMImageMessageBody)msg.getBody();
                            if (object == null) {
                                new HandleError(EMChatManager.this, 1, "Message body can not be null", msg);
                                return;
                            }
                            String string = ((EMFileMessageBody)object).getLocalUrl();
                            String string2 = ((EMFileMessageBody)object).getRemoteUrl();
                            if (TextUtils.isEmpty((CharSequence)string2) && !EMFileHelper.getInstance().isFileExist(string)) {
                                new HandleError(EMChatManager.this, 401, "File not exists or can not be read", msg);
                                return;
                            }
                            if (!((EMImageMessageBody)object).isSendOriginalImage() && EMFileHelper.getInstance().isFileExist(string)) {
                                object2 = ImageUtils.getScaledImageByUri(EMChatManager.this.mClient.getContext(), string);
                                if (!TextUtils.equals((CharSequence)object2, (CharSequence)string)) {
                                    ((EMImageMessageBody)object).setOriginalLocalPath(string);
                                    long l = EMFileHelper.getInstance().getFileLength(string);
                                    long l2 = EMFileHelper.getInstance().getFileLength((String)object2);
                                    if (l == 0L) {
                                        EMLog.d(EMChatManager.TAG, "original image size:" + l);
                                        new HandleError(EMChatManager.this, 401, "original image size is 0", msg);
                                        return;
                                    }
                                    EMLog.d(EMChatManager.TAG, "original image size:" + l + " scaled image size:" + l2 + " ratio:" + (int)(l2 / l) + "%");
                                    string = object2;
                                    ((EMFileMessageBody)object).setLocalUrl(EMFileHelper.getInstance().formatInUri(string));
                                    ((EMFileMessageBody)object).setFileLength(l2);
                                }
                                ((EMFileMessageBody)object).setFileName(EMFileHelper.getInstance().getFilename(string));
                            }
                            if ((object2 = ImageUtils.getBitmapOptions(EMChatManager.this.mClient.getContext(), string)) != null) {
                                int n = object2.outWidth;
                                int n2 = object2.outHeight;
                                ((EMImageMessageBody)object).setSize(n, n2);
                            }
                        } else if (msg.getType() == EMMessage.Type.VIDEO) {
                            msg.setStatus(EMMessage.Status.INPROGRESS);
                            object = (EMVideoMessageBody)msg.getBody();
                            if (object == null) {
                                new HandleError(EMChatManager.this, 1, "Message body can not be null", msg);
                                return;
                            }
                            Uri uri = ((EMFileMessageBody)object).getLocalUri();
                            String string = ((EMFileMessageBody)object).getRemoteUrl();
                            if (TextUtils.isEmpty((CharSequence)string) && !EMFileHelper.getInstance().isFileExist(uri)) {
                                new HandleError(EMChatManager.this, 401, "File not exists or can not be read", msg);
                                return;
                            }
                            String string3 = EMFileHelper.getInstance().getFilePath(((EMVideoMessageBody)object).getLocalThumbUri());
                            if (!TextUtils.isEmpty((CharSequence)string3)) {
                                BitmapFactory.Options options = ImageUtils.getBitmapOptions(string3);
                                int n = options.outWidth;
                                int n3 = options.outHeight;
                                ((EMVideoMessageBody)object).setThumbnailSize(n, n3);
                            }
                        }
                    }
                    object = msg.getMsgId();
                    EMChatManager.this.setMessageSendCallback(msg, eMConversation, (String)object);
                    EMChatManager.this.emaObject.sendMessage((EMAMessage)msg.emaObject);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    new HandleError(EMChatManager.this, 1, "send message failed", msg);
                }
            }
        });
    }

    private void setMessageSendCallback(final EMMessage msg, final EMConversation conv, final String oldId) {
        if (msg == null) {
            return;
        }
        msg.setInnerCallback(new EMCallBack(){

            @Override
            public void onSuccess() {
                EMChatManager.this.deleteImageScaledPath((EMAMessage)msg.emaObject);
                if (conv != null) {
                    conv.getCache().replaceMsgId(oldId, msg.getMsgId());
                }
            }

            @Override
            public void onError(int code, String error) {
            }
        });
    }

    private void deleteImageScaledPath(EMAMessage msg) {
        if (msg == null) {
            return;
        }
        List<EMAMessageBody> list = msg.bodies();
        if (list.size() <= 0) {
            return;
        }
        EMAMessageBody eMAMessageBody = msg.bodies().get(0);
        if (eMAMessageBody instanceof EMAImageMessageBody) {
            String string = ((EMAImageMessageBody)eMAMessageBody).getOriginalLocalPath();
            if (!EMFileHelper.getInstance().isFileExist(string)) {
                return;
            }
            String string2 = ((EMAImageMessageBody)eMAMessageBody).getLocalUrl();
            EMLog.d(TAG, "origin: + " + string + ", scale:" + string2);
            if (string2 != null && !string2.equals(string)) {
                boolean bl = EMFileHelper.getInstance().deletePrivateFile(string2);
                EMLog.d(TAG, "Deleted the scale image file: " + bl + " the scale image file path: " + string2);
            }
            ((EMAImageMessageBody)eMAMessageBody).setLocalPath(string);
            EMConversation eMConversation = this.getConversation(msg.conversationId());
            if (eMConversation != null) {
                ((EMAConversation)eMConversation.emaObject).updateMessage(msg);
            }
        }
    }

    public void ackConversationRead(String conversationId) throws HyphenateException {
        EMAError eMAError = new EMAError();
        this.emaObject.sendReadAckForConversation(conversationId, eMAError);
        this.handleError(eMAError);
    }

    public void ackMessageRead(String to, String messageId) throws HyphenateException {
        EMOptions eMOptions = EMClient.getInstance().getChatConfigPrivate().b();
        if (!eMOptions.getRequireAck()) {
            EMLog.d(TAG, "As the chat option SetRequireAck is set to false, the read receipt is not sent.");
            return;
        }
        if (TextUtils.isEmpty((CharSequence)to)) {
            EMLog.e(TAG, "The to parameter cannot be null.");
            return;
        }
        EMAMessage eMAMessage = this.emaObject.getMessage(messageId);
        if (eMAMessage != null) {
            this.emaObject.sendReadAckForMessage(eMAMessage);
        } else {
            EMAMessage eMAMessage2 = EMAMessage.createReceiveMessage("", EMMessage.self(), null, EMMessage.ChatType.Chat.ordinal());
            eMAMessage2.setMsgId(messageId);
            eMAMessage2.setFrom(to);
            eMAMessage2.setConversationId(to);
            this.emaObject.sendReadAckForMessage(eMAMessage2);
        }
    }

    public void recallMessage(EMMessage message) throws HyphenateException {
        EMAError eMAError = new EMAError();
        if (message == null) {
            throw new HyphenateException(500, "The message was not found");
        }
        this.emaObject.recallMessage((EMAMessage)message.emaObject, eMAError);
        this.handleError(eMAError);
        EMConversation eMConversation = this.getConversation(message.getTo(), EMConversation.msgType2ConversationType(message.getMsgId(), message.getChatType()), true, false);
        if (eMConversation != null) {
            eMConversation.getCache().removeMessage(message.getMsgId());
        }
    }

    public void asyncRecallMessage(final EMMessage message, final EMCallBack callback) {
        EMClient.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    EMChatManager.this.recallMessage(message);
                    callback.onSuccess();
                }
                catch (HyphenateException hyphenateException) {
                    callback.onError(hyphenateException.getErrorCode(), hyphenateException.getDescription());
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EMMessage getMessage(String messageId) {
        Object object = this.caches;
        synchronized (object) {
            for (EMConversation.MessageCache messageCache : this.caches.values()) {
                EMMessage eMMessage = messageCache.getMessage(messageId);
                if (eMMessage == null) continue;
                return eMMessage;
            }
        }
        object = this.emaObject.getMessage(messageId);
        if (object == null) {
            return null;
        }
        EMMessage eMMessage = new EMMessage((EMAMessage)object);
        return eMMessage;
    }

    EMMessage getMessage(long nativeHandler) {
        EMAMessage eMAMessage = this.emaObject.getMessage(nativeHandler);
        if (eMAMessage == null) {
            return null;
        }
        return new EMMessage(eMAMessage);
    }

    public EMConversation getConversation(String id) {
        EMAConversation eMAConversation = this.emaObject.conversationWithType(id, EMAConversation.EMAConversationType.CHAT, false, false);
        if (eMAConversation == null) {
            eMAConversation = this.emaObject.conversationWithType(id, EMAConversation.EMAConversationType.GROUPCHAT, false, false);
        }
        if (eMAConversation == null) {
            eMAConversation = this.emaObject.conversationWithType(id, EMAConversation.EMAConversationType.GROUPCHAT, false, true);
        }
        if (eMAConversation == null) {
            eMAConversation = this.emaObject.conversationWithType(id, EMAConversation.EMAConversationType.CHATROOM, false, false);
        }
        if (eMAConversation == null) {
            eMAConversation = this.emaObject.conversationWithType(id, EMAConversation.EMAConversationType.CHATROOM, false, true);
        }
        if (eMAConversation == null) {
            eMAConversation = this.emaObject.conversationWithType(id, EMAConversation.EMAConversationType.DISCUSSIONGROUP, false, false);
        }
        if (eMAConversation == null) {
            eMAConversation = this.emaObject.conversationWithType(id, EMAConversation.EMAConversationType.HELPDESK, false, false);
        }
        return eMAConversation == null ? null : new EMConversation(eMAConversation);
    }

    public EMConversation getConversation(String id, EMConversation.EMConversationType type) {
        EMConversation eMConversation = this.getConversation(id, type, false);
        if (eMConversation == null) {
            return this.getConversation(id, type, false, true);
        }
        return eMConversation;
    }

    public EMConversation getConversation(String username, EMConversation.EMConversationType type, boolean createIfNotExists) {
        EMConversation eMConversation = this.getConversation(username, type, createIfNotExists, false);
        if (eMConversation == null) {
            return this.getConversation(username, type, createIfNotExists, true);
        }
        return eMConversation;
    }

    public EMConversation getConversation(String username, EMConversation.EMConversationType type, boolean createIfNotExists, boolean isChatThread) {
        EMAConversation.EMAConversationType eMAConversationType = EMAConversation.EMAConversationType.CHAT;
        switch (type) {
            case Chat: {
                eMAConversationType = EMAConversation.EMAConversationType.CHAT;
                break;
            }
            case GroupChat: {
                eMAConversationType = EMAConversation.EMAConversationType.GROUPCHAT;
                break;
            }
            case ChatRoom: {
                eMAConversationType = EMAConversation.EMAConversationType.CHATROOM;
                break;
            }
            case DiscussionGroup: {
                eMAConversationType = EMAConversation.EMAConversationType.DISCUSSIONGROUP;
                break;
            }
            case HelpDesk: {
                eMAConversationType = EMAConversation.EMAConversationType.HELPDESK;
            }
        }
        EMAConversation eMAConversation = this.emaObject.conversationWithType(username, eMAConversationType, createIfNotExists, isChatThread);
        if (eMAConversation == null) {
            return null;
        }
        Log.d((String)TAG, (String)("convID:" + eMAConversation.conversationId()));
        return new EMConversation(eMAConversation);
    }

    public int getUnreadMessageCount() {
        List<EMAConversation> list = this.emaObject.getConversations();
        int n = 0;
        for (EMAConversation eMAConversation : list) {
            if (eMAConversation._getType() == EMAConversation.EMAConversationType.CHATROOM) continue;
            n += eMAConversation.unreadMessagesCount();
        }
        return n;
    }

    public void saveMessage(EMMessage message) {
        EMMessage.ChatType chatType = message.getChatType();
        EMConversation.EMConversationType eMConversationType = EMConversation.EMConversationType.Chat;
        switch (chatType) {
            case Chat: {
                eMConversationType = EMConversation.EMConversationType.Chat;
                break;
            }
            case GroupChat: {
                eMConversationType = EMConversation.EMConversationType.GroupChat;
                break;
            }
            case ChatRoom: {
                eMConversationType = EMConversation.EMConversationType.ChatRoom;
            }
        }
        String string = message.getTo();
        if (eMConversationType == EMConversation.EMConversationType.Chat && message.direct() == EMMessage.Direct.RECEIVE) {
            string = message.getFrom();
        }
        if (message.getType() == EMMessage.Type.CMD) {
            return;
        }
        EMConversation eMConversation = this.getConversation(string, eMConversationType, true, false);
        if (eMConversation == null) {
            EMLog.e(TAG, "Failed to save message because conversation is null, convId: " + string);
            return;
        }
        eMConversation.insertMessage(message);
    }

    public void downloadAttachment(EMMessage msg) {
        if (msg == null) {
            return;
        }
        msg.makeCallbackStrong();
        this.checkContentAttachmentExist(msg);
        this.emaObject.downloadMessageAttachments((EMAMessage)msg.emaObject);
    }

    private void checkContentAttachmentExist(EMMessage msg) {
        List<EMAMessageBody> list = ((EMAMessage)msg.emaObject).bodies();
        if (list != null && !list.isEmpty()) {
            for (EMAMessageBody eMAMessageBody : list) {
                switch (eMAMessageBody.type()) {
                    case 1: 
                    case 2: 
                    case 4: 
                    case 5: {
                        EMAFileMessageBody eMAFileMessageBody = (EMAFileMessageBody)eMAMessageBody;
                        String string = eMAFileMessageBody.getLocalUrl();
                        EMLog.d(TAG, "download before check path = " + string);
                        if (!TextUtils.isEmpty((CharSequence)string) && string.contains("/Android/data/" + this.mClient.getContext().getPackageName() + "/")) break;
                        String string2 = eMAFileMessageBody.displayName();
                        String string3 = null;
                        switch (eMAMessageBody.type()) {
                            case 1: {
                                string3 = PathUtil.getInstance().getImagePath() + File.separator + string2;
                                break;
                            }
                            case 2: {
                                string3 = PathUtil.getInstance().getVideoPath() + File.separator + string2;
                                break;
                            }
                            case 4: {
                                string3 = PathUtil.getInstance().getVoicePath() + File.separator + string2;
                                break;
                            }
                            case 5: {
                                string3 = PathUtil.getInstance().getFilePath() + File.separator + string2;
                            }
                        }
                        if (TextUtils.isEmpty(string3)) break;
                        eMAFileMessageBody.setLocalPath(string3);
                        EMLog.d(TAG, "download:create new path , path is " + string3);
                    }
                }
            }
        }
    }

    public void downloadThumbnail(EMMessage msg) {
        msg.makeCallbackStrong();
        this.emaObject.downloadMessageThumbnail((EMAMessage)msg.emaObject);
    }

    public List<EMConversation> getConversationsByType(EMConversation.EMConversationType type) {
        List<EMAConversation> list = this.emaObject.getConversations();
        ArrayList<EMConversation> arrayList = new ArrayList<EMConversation>();
        for (EMAConversation eMAConversation : list) {
            if (type.ordinal() != eMAConversation._getType().ordinal()) continue;
            arrayList.add(new EMConversation(eMAConversation));
        }
        return arrayList;
    }

    public Map<String, EMConversation> getAllConversations() {
        List<EMAConversation> list = this.emaObject.getConversations();
        Hashtable<String, EMConversation> hashtable = new Hashtable<String, EMConversation>();
        for (EMAConversation eMAConversation : list) {
            hashtable.put(eMAConversation.conversationId(), new EMConversation(eMAConversation));
        }
        return hashtable;
    }

    public void asyncFetchPinnedConversationsFromServer(int limit, String cursor, EMValueCallBack<EMCursorResult<EMConversation>> callback) {
        this.mClient.execute(() -> {
            EMAError eMAError = new EMAError();
            EMCursorResult<EMAConversation> eMCursorResult = this.emaObject.fetchPinnedConversationsFromServer(limit, cursor, eMAError);
            try {
                this.handleError(eMAError);
            }
            catch (HyphenateException hyphenateException) {
                callback.onError(hyphenateException.getErrorCode(), hyphenateException.getDescription());
                return;
            }
            EMCursorResult eMCursorResult2 = new EMCursorResult();
            eMCursorResult2.setCursor(eMCursorResult.getCursor());
            ArrayList<EMConversation> arrayList = new ArrayList<EMConversation>();
            for (EMAConversation eMAConversation : (List)eMCursorResult.getData()) {
                arrayList.add(new EMConversation(eMAConversation));
            }
            eMCursorResult2.setData(arrayList);
            callback.onSuccess(eMCursorResult2);
        });
    }

    public void asyncFetchConversationsFromServer(int limit, String cursor, EMValueCallBack<EMCursorResult<EMConversation>> callback) {
        this.mClient.execute(() -> {
            EMAError eMAError = new EMAError();
            EMCursorResult<EMAConversation> eMCursorResult = this.emaObject.fetchConversationsFromServerWithCursor(limit, cursor, eMAError);
            try {
                this.handleError(eMAError);
            }
            catch (HyphenateException hyphenateException) {
                callback.onError(hyphenateException.getErrorCode(), hyphenateException.getDescription());
                return;
            }
            EMCursorResult eMCursorResult2 = new EMCursorResult();
            eMCursorResult2.setCursor(eMCursorResult.getCursor());
            ArrayList<EMConversation> arrayList = new ArrayList<EMConversation>();
            for (EMAConversation eMAConversation : (List)eMCursorResult.getData()) {
                arrayList.add(new EMConversation(eMAConversation));
            }
            eMCursorResult2.setData(arrayList);
            callback.onSuccess(eMCursorResult2);
        });
    }

    public void asyncPinConversation(String conversationId, boolean isPinned, EMCallBack callback) {
        this.mClient.execute(() -> {
            EMAError eMAError = new EMAError();
            this.emaObject.pinConversation(conversationId, isPinned, eMAError);
            try {
                this.handleError(eMAError);
                callback.onSuccess();
            }
            catch (HyphenateException hyphenateException) {
                callback.onError(hyphenateException.getErrorCode(), hyphenateException.getDescription());
            }
        });
    }

    public boolean deleteConversation(String username, boolean deleteMessages) {
        EMConversation eMConversation = this.getConversation(username);
        if (eMConversation == null) {
            return false;
        }
        if (!deleteMessages) {
            eMConversation.clear();
        } else {
            eMConversation.clearAllMessages();
        }
        this.emaObject.removeConversation(username, deleteMessages, eMConversation.isChatThread());
        return true;
    }

    public void deleteConversationFromServer(final String username, final EMConversation.EMConversationType type, final boolean isDeleteServerMessages, final EMCallBack deleteCallBack) {
        EMClient.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                EMAConversation.EMAConversationType eMAConversationType = EMAConversation.EMAConversationType.CHAT;
                switch (type) {
                    case Chat: {
                        eMAConversationType = EMAConversation.EMAConversationType.CHAT;
                        break;
                    }
                    case GroupChat: {
                        eMAConversationType = EMAConversation.EMAConversationType.GROUPCHAT;
                        break;
                    }
                    case ChatRoom: {
                        eMAConversationType = EMAConversation.EMAConversationType.CHATROOM;
                        break;
                    }
                    case DiscussionGroup: {
                        eMAConversationType = EMAConversation.EMAConversationType.DISCUSSIONGROUP;
                        break;
                    }
                    case HelpDesk: {
                        eMAConversationType = EMAConversation.EMAConversationType.HELPDESK;
                    }
                }
                EMAError eMAError = EMChatManager.this.emaObject.deleteConversationFromServer(username, eMAConversationType, isDeleteServerMessages);
                if (eMAError.errCode() == 0) {
                    deleteCallBack.onSuccess();
                } else {
                    deleteCallBack.onError(eMAError.errCode(), eMAError.errMsg());
                }
            }
        });
    }

    public void addMessageListener(EMMessageListener listener) {
        if (listener == null) {
            EMLog.d(TAG, "addMessageListener: listener is null");
            return;
        }
        if (!this.messageListeners.contains(listener)) {
            EMLog.d(TAG, "add message listener: " + listener);
            this.messageListeners.add(listener);
        }
    }

    public void removeMessageListener(EMMessageListener listener) {
        if (listener == null) {
            return;
        }
        this.messageListeners.remove(listener);
    }

    public void addConversationListener(EMConversationListener listener) {
        if (!this.conversationListeners.contains(listener)) {
            this.conversationListeners.add(listener);
        }
    }

    public void removeConversationListener(EMConversationListener listener) {
        if (listener == null) {
            return;
        }
        this.conversationListeners.remove(listener);
    }

    public void setVoiceMessageListened(EMMessage message) {
        message.setListened(true);
    }

    void onLogout() {
        this.caches.clear();
    }

    private EMCursorResult<EMMessage> fetchHistoryMessages(String conversationId, EMConversation.EMConversationType type, int pageSize, String cursor, EMFetchMessageOption option) throws HyphenateException {
        EMAError eMAError = new EMAError();
        EMCursorResult<EMAMessage> eMCursorResult = this.emaObject.fetchHistoryMessages(conversationId, type.ordinal(), pageSize, cursor, option == null ? new EMAFetchMessageOption() : (EMAFetchMessageOption)option.emaObject, eMAError);
        this.handleError(eMAError);
        EMCursorResult<EMMessage> eMCursorResult2 = new EMCursorResult<EMMessage>();
        eMCursorResult2.setCursor(eMCursorResult.getCursor());
        ArrayList<EMMessage> arrayList = new ArrayList<EMMessage>();
        for (EMAMessage eMAMessage : (List)eMCursorResult.getData()) {
            arrayList.add(new EMMessage(eMAMessage));
        }
        eMCursorResult2.setData(arrayList);
        return eMCursorResult2;
    }

    public void asyncFetchHistoryMessages(final String conversationId, final EMConversation.EMConversationType type, final int pageSize, final String cursor, final EMFetchMessageOption option, final EMValueCallBack<EMCursorResult<EMMessage>> callBack) {
        EMClient.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    callBack.onSuccess(EMChatManager.this.fetchHistoryMessages(conversationId, type, pageSize, cursor, option));
                }
                catch (HyphenateException hyphenateException) {
                    callBack.onError(hyphenateException.getErrorCode(), hyphenateException.getDescription());
                }
            }
        });
    }

    private void handleError(EMAError error) throws HyphenateException {
        if (error.errCode() != 0) {
            throw new HyphenateException(error);
        }
    }

    protected void removeMessagesFromServer(final String conversationId, final EMConversation.EMConversationType type, final long beforeTimeStamp, final EMCallBack callBack) {
        EMClient.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                EMAError eMAError = EMChatManager.this.emaObject.deleteRoamMsgFromServerByTime(conversationId, type, beforeTimeStamp);
                if (eMAError.errCode() == 0) {
                    EMChatManager.this.clearCaches(conversationId, beforeTimeStamp);
                    if (callBack != null) {
                        callBack.onSuccess();
                    }
                } else if (callBack != null) {
                    callBack.onError(eMAError.errCode(), eMAError.errMsg());
                }
            }
        });
    }

    void clearCaches(String conversationId, long beforeTimeStamp) {
        if (this.caches.containsKey(conversationId) && this.caches.get(conversationId) != null && this.caches.get(conversationId).getAllMessages().size() > 0) {
            for (EMMessage eMMessage : this.caches.get(conversationId).getAllMessages()) {
                if (eMMessage.getMsgTime() > beforeTimeStamp) continue;
                this.caches.get(conversationId).removeMessage(eMMessage.getMsgId());
            }
        }
    }

    void clearCaches(String conversationId, List<String> msgIdList) {
        if (msgIdList != null && msgIdList.size() > 0) {
            for (String string : msgIdList) {
                if (!this.caches.containsKey(conversationId) || this.caches.get(conversationId) == null) continue;
                this.caches.get(conversationId).removeMessage(string);
            }
        }
    }
}

