/*
 *  * EaseMob CONFIDENTIAL
 * __________________
 * Copyright (C) 2017 EaseMob Technologies. All rights reserved.
 *
 * NOTICE: All information contained herein is, and remains
 * the property of EaseMob Technologies.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from EaseMob Technologies.
 */
package com.hyphenate.util;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.security.KeyStore;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;

import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;

/**
 * various util class
 *
 */
public class EasyUtils {
    public final static String TAG = "EasyUtils";

    private static Hashtable<String, String> resourceTable = new Hashtable<String, String>();

   public static X509Certificate[] convertToCerts(List<String> certschain) {
        List<X509Certificate> certificates=new ArrayList<>();
        InputStream is=null;
        for (int i = 0; i < certschain.size(); i++) {
            String certString = certschain.get(i);
            try {
                is = new ByteArrayInputStream( certString.getBytes(StandardCharsets.UTF_8));
                CertificateFactory cf = CertificateFactory.getInstance("X.509");
                X509Certificate  ca = (X509Certificate) cf.generateCertificate(is);
                certificates.add(ca);
            } catch (Exception e){
                e.printStackTrace();
                EMLog.e(TAG,e.getMessage());
            }finally {
                if(is!=null) {
                    try {
                        is.close();
                    } catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        X509Certificate[] certsArray=new X509Certificate[certificates.size()];
        certificates.toArray(certsArray);
        return certsArray;
   }
   public static X509TrustManager getSystemDefaultTrustManager() {
        try {
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(
                    TrustManagerFactory.getDefaultAlgorithm());
            trustManagerFactory.init((KeyStore) null);
            TrustManager[] trustManagers = trustManagerFactory.getTrustManagers();
            for (int i = 0; i < trustManagers.length; i++) {
                if(trustManagers[i] instanceof X509TrustManager) {
                    return (X509TrustManager) trustManagers[i];
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        return null;
   }
}
