/*
 *  * EaseMob CONFIDENTIAL
 * __________________
 * Copyright (C) 2017 EaseMob Technologies. All rights reserved.
 *
 * NOTICE: All information contained herein is, and remains
 * the property of EaseMob Technologies.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from EaseMob Technologies.
 */
package com.hyphenate.cloud;

import java.io.IOException;
import java.util.Map;


import com.hyphenate.chat.EMClient;
import com.hyphenate.chat.core.EMChatConfigPrivate;
import com.hyphenate.exceptions.HyphenateException;
import com.hyphenate.util.EMLog;

import android.util.Pair;

/**
 * 这个类主要负责和后台的HTTP请求处理
 * 此类不对外开放
 * this is the interface which will talk with backend HTTP server
 *
 */
@SuppressWarnings("deprecation")
public class EMHttpClient {
	private final static String TAG = "EMHttpClient";
	public static String GET = "GET";
	public static String POST = "POST";
	public static String PUT = "PUT";
	public static String DELETE = "DELETE";
			
    private static EMHttpClient instance = null;
    private EMChatConfigPrivate configPrivate = null;
    private EMHttpClient(){
    }
    
    public synchronized static EMHttpClient getInstance(){
    	if(instance == null){
    		instance = new EMHttpClient();
    	}
    	
    	return instance;
    }
    
    public void onInit(EMChatConfigPrivate configPrivate){
    	this.configPrivate = configPrivate;
    }
    
    public EMChatConfigPrivate chatConfig(){
    	return configPrivate;
    }
    
    /**
     * 耗时操作，请在子线程调用
     * @param reqURL
     * @param headers
     * @param body
     * @param method
     * @return
     * @throws IOException
     * @throws HyphenateException
     */
	public Pair<Integer,String> sendRequest(final String reqURL, final Map<String, String> headers, final String body, final String method) throws IOException, HyphenateException{
    	return HttpClientManager.sendRequest(reqURL, headers, body, method);
    }
    
    //public Pair<Integer,String> postRequest(final String reqURL, final Map<String, String> headers, final String body){
    	
    //}
    
    /**
     * 内部使用，不对外提供
     * @param reqURL
     * @param headers
     * @param body
     * @param method
     * @return
     * @throws IOException
     */
    public HttpResponse httpExecute(String reqURL, Map<String, String> headers, String body, String method) throws IOException{
    	return HttpClientManager.httpExecute(reqURL, headers, body, method);
    }

    /**
     * 异步调用
     * 
     * @param remoteUrl 
     * @param localFilePath
     * @param headers
     * @param callback see {@link EMCloudOperationCallback}
     */
    public void downloadFile(final String remoteUrl, final String localFilePath, final Map<String, String> headers,final EMCloudOperationCallback callback){
    	new Thread(){
			@Override
    		public void run(){
    			try{
    				new HttpFileManager().downloadFile(remoteUrl, localFilePath, headers, callback);
    			}catch(Exception e){
    				if(callback != null){
    					callback.onError(e != null && e.getMessage() != null?e.getMessage():"failed to download the file : " + remoteUrl);
    				}
    			}
    		}
    	}.start();
    }
    
    /**
     * 
     * @param localFilePath
     * @param remoteUrl
     * @param headers
     * @param callback
     */
    public void uploadFile(final String localFilePath, final String remoteUrl, final Map<String, String> headers, final EMCloudOperationCallback callback){
    	EMLog.d(TAG, "upload file : " + " localFilePath : " + localFilePath + " remoteUrl : " + remoteUrl);
    	Thread temp = new Thread(){
			@Override
    		public void run(){
    			try{
    				EMLog.d(TAG, "run HttpFileManager().uploadFile");
    				new HttpFileManager().uploadFile(localFilePath, remoteUrl, EMClient.getInstance().getOptions().getAppKey(), EMClient.getInstance().getCurrentUser(), headers, callback);
    			}catch(Exception e){
    				if(callback != null){
    					callback.onError(e != null && e.getMessage() != null?e.getMessage():"failed to upload the file : " + remoteUrl);
    				}
    			}
    		}
    	};
    	
    	temp.start();
    }

    /**
     * 帮助API，和sendRequest的区别就是会在http header加上token
     * helper API wich add token in the header when sending the request
     * @param url
     * @param body
     * @param method
     * @return
     * @throws HyphenateException
     */
	public Pair<Integer, String> sendRequestWithToken(String url, String body, String method) throws HyphenateException {
		return HttpClientManager.sendRequestWithToken(url, body, method);
	}
}
