/*
 *  * EaseMob CONFIDENTIAL
 * __________________
 * Copyright (C) 2017 EaseMob Technologies. All rights reserved.
 *
 * NOTICE: All information contained herein is, and remains
 * the property of EaseMob Technologies.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from EaseMob Technologies.
 */
package com.hyphenate.chat;

import android.text.TextUtils;
import android.util.Pair;

import com.hyphenate.EMCallBack;
import com.hyphenate.EMError;
import com.hyphenate.chat.core.EMPreferenceUtils;
import com.hyphenate.cloud.EMHttpClient;
import com.hyphenate.exceptions.HyphenateException;
import com.hyphenate.util.DeviceUuidFactory;
import com.hyphenate.util.EMLog;

import org.json.JSONObject;

import java.net.HttpURLConnection;

/**
 * \~chinese
 * 离线消息推送管理类，针对 GCM、小米、华为等离线推送以及 APNS。
 *
 * \~english
 * The message push configuration options.
 */
public class EMPushManager {
    private static final String TAG = EMPushManager.class.getSimpleName();

//    /**
//     * \~chinese
//     * 推送消息展示样式：SimpleBanner 表示展示简单消息，MessageSummary 表示展示消息内容。
//     *
//     * \~english
//     * The push message presentation style: SimpleBanner represents the presentation of a simple message,
//     * and MessageSummary represents the presentation of message content.
//     */
//    public enum DisplayStyle {
//        SimpleBanner, MessageSummary
//    }
//
    EMClient mClient;
//    EMAPushManager emaObject;
//    EMPushManager(EMClient client, EMAPushManager pushManager) {
//        emaObject = pushManager;
//        mClient = client;
//    }
    EMPushManager(EMClient client) {
        mClient = client;
    }
//
//
//    /**
//     * \~chinese
//     * 开启离线消息推送。
//     *
//     * 同步方法，会阻塞当前线程。
//     *
//     * @throws HyphenateException
//     * @deprecated 使用 {@link EMPushManager#setSilentModeForAll(EMSilentModeParam, EMValueCallBack)} 替代。
//     *
//     * \~english
//     * Turns on the push notification.
//     *
//     * This is a synchronous method and blocks the current thread.
//     *
//     * @throws HyphenateException
//     * @deprecated Use {@link EMPushManager#setSilentModeForAll(EMSilentModeParam, EMValueCallBack)} instead.
//     */
//    @Deprecated
//    public void enableOfflinePush() throws HyphenateException {
//        EMAError error = new EMAError();
//        emaObject.enableOfflineNotification(error);
//        handleError(error);
//    }
//
//    /**
//     * \~chinese
//     * 在指定的时间段(24 小时制)内，不推送离线消息。
//     *
//     * 同步方法，会阻塞当前线程。
//     *
//     * @param start 开始时间。
//     * @param end 结束时间。
//     * @throws HyphenateException 如果有异常会在这里抛出，包含异常原因。
//     * @deprecated 使用 {@link EMPushManager#setSilentModeForAll(EMSilentModeParam, EMValueCallBack)} 替代。
//     *
//     * \~english
//     * Do not push the offline messages within the specified time period (24-hour clock).
//
//     *
//     * This is a synchronous method and blocks the current thread.
//     *
//     * @param start The start hour.
//     * @param end The end hour.
//     * @throws HyphenateException A description of the cause of the exception.
//     * @deprecated Use {@link EMPushManager#setSilentModeForAll(EMSilentModeParam, EMValueCallBack)} instead.
//     */
//    @Deprecated
//    public void disableOfflinePush(int start, int end) throws HyphenateException {
//        EMAError error = new EMAError();
//        emaObject.disableOfflineNotification(start, end, error);
//        handleError(error);
//    }
//
//    /**
//     * \~chinese
//     * 从缓存获取推送配置信息。
//     * @return 推送配置信息。
//     *
//     * \~english
//     * Get the push configs from cache.
//     * @return The push configs.
//     */
//    public EMPushConfigs getPushConfigs(){
//        EMAPushConfigs pushConfigs = emaObject.getPushConfigs();
//        if(pushConfigs == null){
//            return null;
//        }
//        return new EMPushConfigs(pushConfigs);
//    }
//
//    /**
//     * \~chinese
//     * 从服务器获取推送配置信息。
//     *
//     * 同步方法，会阻塞当前线程。
//     *
//     * @return 推送配置信息。
//     * @throws HyphenateException 如果有异常会在这里抛出，包含异常原因。
//     *
//     * \~english
//     * Get the push configs from the server.
//     *
//     * This is a synchronous method and blocks the current thread.
//     *
//     * @return The push configs.
//     * @throws HyphenateException A description of the cause of the exception.
//     */
//    public EMPushConfigs getPushConfigsFromServer() throws HyphenateException{
//        EMAError error = new EMAError();
//        EMAPushConfigs pushConfigs = emaObject.getPushConfigsFromServer(error);
//        handleError(error);
//
//        return new EMPushConfigs(pushConfigs);
//    }
//
//
//    /**
//     * \~chinese
//     * 设置指定的群组是否接受离线消息推送。
//     *
//     * 同步方法，会阻塞当前线程。
//     *
//     * @param groupIds 要设置的群组列表。
//     * @param noPush - `true`：不接收离线消息推送；
//     *               - `false`：接收推送。
//     * @throws HyphenateException 如果有异常会在这里抛出，包含异常原因。
//     * @deprecated 使用 {@link EMPushManager#setSilentModeForConversation(String, EMConversation.EMConversationType, EMSilentModeParam, EMValueCallBack)} 替代，设置每个会话的免打扰设置。
//     *
//     * \~english
//     * Sets whether to turn on or turn off the push notification for the the specified groups.
//     *
//     * This is a synchronous method and blocks the current thread.
//     *
//     * @param groupIds The list of groups to be set.
//     * @param noPush - `true`: Turns off the notification;
//     *               - `false`: Turns on the notification.
//     * @throws HyphenateException A description of the cause of the exception.
//     * @deprecated Use {@link EMPushManager#setSilentModeForConversation(String, EMConversation.EMConversationType, EMSilentModeParam, EMValueCallBack)} instead,set DND Settings for each session.
//     */
//    @Deprecated
//    public void updatePushServiceForGroup(List<String> groupIds, boolean noPush) throws HyphenateException {
//        EMAError error = new EMAError();
//        emaObject.updatePushServiceForGroup(groupIds, noPush, error);
//        handleError(error);
//    }
//    /**
//     * \~chinese
//     * 设置指定的用户是否接收离线消息推送。
//     * @param userIds 要设置的用户列表。
//     * @param noPush - `true`：不接收离线消息推送；
//     *               - `false`：接收推送。
//     * @throws HyphenateException 如果有异常会在这里抛出，包含异常原因。
//     * @deprecated 使用 {@link EMPushManager#setSilentModeForConversation(String, EMConversation.EMConversationType, EMSilentModeParam, EMValueCallBack)} 替代，设置每个会话的免打扰设置。
//     *
//     * \~english
//     * Sets whether the specified group accepts the offline message notification.
//     * @param userIds The list of users to be set.
//     * @param noPush - `true`：turn off the notification;
//     *               - `false`：turn on the notification.
//     * @throws HyphenateException A description of the cause of the exception.
//     * @deprecated Use {@link EMPushManager#setSilentModeForConversation(String, EMConversation.EMConversationType, EMSilentModeParam, EMValueCallBack)} instead,set DND Settings for each session
//     */
//    @Deprecated
//    public void updatePushServiceForUsers(List<String> userIds, boolean noPush) throws HyphenateException {
//        EMAError error = new EMAError();
//        emaObject.updatePushServiceForUsers(userIds, noPush, error);
//        handleError(error);
//    }
//
//    /**
//     * \~chinese
//     * 获取关闭了离线消息推送的群组。
//     *
//     * 同步方法，会阻塞当前线程。
//     *
//     * @return 群组列表。
//     * @deprecated 使用 {@link EMPushManager#getSilentModeForConversation(String, EMConversation.EMConversationType, EMValueCallBack)} 替代，获取每个会话的免打扰设置来判断。
//     *
//     * \~english
//     * Gets the list of groups which have blocked the push notification.
//     *
//     * This is a synchronous method and blocks the current thread.
//     *
//     * @return The list of groups that blocked the push notification.
//     * @deprecated Use {@link EMPushManager#getSilentModeForConversation(String, EMConversation.EMConversationType, EMValueCallBack)} instead,get the DND Settings for each conversation to determine
//     */
//    @Deprecated
//    public List<String> getNoPushGroups(){
//        return emaObject.getNoPushGroups();
//    }
//    /**
//     * \~chinese
//     * 从缓存中获取关闭了离线消息推送的用户。
//     *
//     * 注意：
//     * 如果需要获取最新的数据可先调用 {@link EMPushManager#getPushConfigsFromServer()} 后，再调用本方法。
//     * @return 关闭了离线消息推送的用户列表。
//     * @deprecated 使用 {@link EMPushManager#getSilentModeForConversation(String, EMConversation.EMConversationType, EMValueCallBack)} 替代，获取每个会话的免打扰设置来判断。
//     *
//     * \~english
//     * Gets the list of user ID which have blocked the push notification from the cache.
//     *
//     * Note:
//     * If you needs to get the latest data, call {@Link EmpushManager# getPushConfigsFromServer()} before calling this method.
//     * @return  The list of users who have blocked the push notification.
//     * @deprecated Use {@link EMPushManager#getSilentModeForConversation(String, EMConversation.EMConversationType, EMValueCallBack)} instead,get the DND Settings for each conversation to determine.
//     */
//    @Deprecated
//    public List<String> getNoPushUsers(){
//        return emaObject.getNoPushUsers();
//    }
//
//    /**
//	 * \~chinese
//	 * 更新当前用户的推送昵称。
//     * 离线消息推送的时候可以显示推送昵称而不是用户 ID。
//     * 当用户更改昵称（可通过 {@link EMUserInfoManager#updateOwnInfo(EMUserInfo, EMValueCallBack)} 或者
//     * {@link EMUserInfoManager#updateOwnInfoByAttribute(EMUserInfo.EMUserInfoType, String, EMValueCallBack)} 修改）时，
//     * 务必也调用此方法更新到 Chat 服务器，防止显示差异。
//     *
//     * 参考：
//     * 异步方法见 {@link #asyncUpdatePushNickname(String, EMCallBack)}
//	 *
//     * 同步方法，会阻塞当前线程。
//     *
//	 * @param nickname 推送昵称，需要与用户属性中的昵称区分开。
//	 *
//	 * \~english
//     * Updates the push display nickname of the current user.
//	 * This method can be used to set a push display nickname, the push display nickname will be used to show for offline push notification.
//     * When the app user changes the nickname in the user profile(use {@link EMUserInfoManager#updateOwnInfo(EMUserInfo, EMValueCallBack)
//     * or {@link EMUserInfoManager#updateOwnInfoByAttribute(EMUserInfo.EMUserInfoType, String, EMValueCallBack)} to set},
//     * be sure to also call this method to update to prevent the display differences.
//     *
//     * Reference:
//     * The asynchronous method see {@link #asyncUpdatePushNickname(String, EMCallBack)}
//	 *
//     * This is a synchronous method and blocks the current thread.
//     *
//	 * @param nickname The push display nickname, which is different from the nickname in the user profile.
//	 */
//    public boolean updatePushNickname(String nickname) throws IllegalArgumentException, HyphenateException {
//        if (TextUtils.isEmpty(nickname)) {
//            throw new IllegalArgumentException("nick name is null or empty");
//        }
//        String currentUser = EMClient.getInstance().getCurrentUser();
//        if (TextUtils.isEmpty(currentUser)) {
//            throw new IllegalArgumentException("currentUser is null or empty");
//        }
//        String accessToken = EMClient.getInstance().getAccessToken();
//        if (TextUtils.isEmpty(accessToken)) {
//            throw new IllegalArgumentException("token is null or empty");
//        }
//        EMAError error = new EMAError();
//        emaObject.updatePushNickname(nickname, error);
//        handleError(error);
//        return true;
//    }
//
//    /**
//	 * \~chinese
//	 * 更新当前用户的推送昵称。
//     *
//     * 异步方法。
//     *
//     * 离线消息推送的时候可以显示推送昵称而不是用户 ID。
//     * 当用户更改昵称（可通过 {@link EMUserInfoManager#updateOwnInfo(EMUserInfo, EMValueCallBack)} 或者
//     * {@link EMUserInfoManager#updateOwnInfoByAttribute(EMUserInfo.EMUserInfoType, String, EMValueCallBack)} 修改）时，
//
//     * 务必也调用此方法更新到环信服务器，防止显示差异。
//     *
//     * 参考：
//     * 同步方法见 {@link #updatePushNickname(String)}。
//	 *
//	 * @param nickname 推送昵称，需要与用户属性中的昵称区分开。
//	 *
//	 * \~english
//	 * Update the push display nickname of the current user.
//     *
//     * This is an asynchronous method.
//     *
//     * This method can be used to set a push nickname, the push nickname will be used for offline push notification.
//     * When the user changes the nickname in the user profile(use {@link EMUserInfoManager#updateOwnInfo(EMUserInfo, EMValueCallBack)
//     * or {@link EMUserInfoManager#updateOwnInfoByAttribute(EMUserInfo.EMUserInfoType, String, EMValueCallBack)} to set),
//     * be sure to also call this method to update the display nickname to prevent the display differences.
//     *
//     * Reference:
//     * The synchronous method see {@link #updatePushNickname(String)}.
//     *
//	 * @param nickname  The push nickname, which is different from the nickname in user profiles.
//	 */
//    public void asyncUpdatePushNickname(String nickname, EMCallBack callback) {
//        EMClient.getInstance().execute(new Runnable() {
//            @Override
//            public void run() {
//                try {
//                    updatePushNickname(nickname);
//                    callback.onSuccess();
//                } catch (IllegalArgumentException e) {
//                    callback.onError(EMError.USER_ILLEGAL_ARGUMENT, e.getMessage());
//                } catch (HyphenateException e) {
//                    callback.onError(e.getErrorCode(), e.getDescription());
//                }
//            }
//        });
//    }
//
//    /**
//	 * \~chinese
//	 * 更新推送消息样式，默认是 {@link DisplayStyle#SimpleBanner}。
//     *
//     * 参考：
//     * 异步方法见 {@link #asyncUpdatePushDisplayStyle(DisplayStyle, EMCallBack)}。
//	 *
//     * 同步方法，会阻塞当前线程。
//     *
//	 * @param style 推送消息样式。
//	 *
//	 * \~english
//	 * Update the push message style. The default value is {@link DisplayStyle#SimpleBanner}.
//     *
//     * Reference:
//     * The asynchronous method see {@link #asyncUpdatePushDisplayStyle(DisplayStyle, EMCallBack)}
//     *
//     * This is a synchronous method and blocks the current thread.
//	 *
//	 * @param style The push message display style.
//	 */
//    public void updatePushDisplayStyle(DisplayStyle style) throws IllegalArgumentException, HyphenateException
//    {
//        String currentUser = EMClient.getInstance().getCurrentUser();
//        if (TextUtils.isEmpty(currentUser)) {
//            throw new IllegalArgumentException("currentUser is null or empty");
//        }
//        String accessToken = EMClient.getInstance().getAccessToken();
//        if (TextUtils.isEmpty(accessToken)) {
//            throw new IllegalArgumentException("token is null or empty");
//        }
//        EMAError error = new EMAError();
//        emaObject.updatePushDisplayStyle(style.ordinal(), error);
//        handleError(error);
//    }
//
//    /**
//	 * \~chinese
//	 * 更新推送消息样式，默认是 {@link DisplayStyle#SimpleBanner}。
//     *
//     * 异步方法。
//     *
//     * 参考：
//     * 同步方法见 {@link #updatePushDisplayStyle(DisplayStyle)}。
//	 *
//	 * @param style 推送消息样式。
//	 *
//	 * \~english
//	 * Update the push message style. The default value is {@link DisplayStyle#SimpleBanner}.
//     *
//     * This is an asynchronous method.
//     *
//     * Reference:
//     * The synchronous method see {@link #updatePushDisplayStyle(DisplayStyle)}
//	 *
//	 * @param style The push message style.
//	 */
//    public void asyncUpdatePushDisplayStyle(DisplayStyle style, EMCallBack callback)
//    {
//        EMClient.getInstance().execute(new Runnable() {
//            @Override
//            public void run() {
//                try {
//                    updatePushDisplayStyle(style);
//                    callback.onSuccess();
//                } catch (IllegalArgumentException e) {
//                    callback.onError(EMError.USER_ILLEGAL_ARGUMENT, e.getMessage());
//                } catch (HyphenateException e) {
//                    callback.onError(e.getErrorCode(), e.getDescription());
//                }
//            }
//        });
//    }
//
//    private void reportPushAction(String parameters) throws IllegalArgumentException, HyphenateException
//    {
//        EMAError error = new EMAError();
//        emaObject.reportPushAction(parameters, error);
//        handleError(error);
//    }
//
//    private void handleError(EMAError error) throws HyphenateException {
//        if (error.errCode() != EMAError.EM_NO_ERROR) {
//            throw new HyphenateException(error);
//        }
//    }
//
//    /**
//     * \~chinese
//     * 推送事件枚举类。
//     *
//     * \~english
//     * The push actions.
//     */
//    public enum EMPushAction{
//        ARRIVE("arrive"),/** \~chinese 送达事件。  \~english Arrived event. */
//        CLICK("click");/** \~chinese 点击事件。  \~english Clicked event. */
//
//        private String name;
//
//        EMPushAction(String name){
//            this.name = name;
//        }
//    }
//
//    /**
//     * \~chinese
//     * 离线推送提醒类型枚举类。
//     *
//     * \~english
//     * Offline push notification type enumeration class.
//     */
//    public enum EMPushRemindType {
//        ALL, /** \～chinese 收取全部离线推送。 \~english  Collect all offline push.  */
//        MENTION_ONLY, /** \～chinese 只收取@我的离线推送。 \~english  Only receive @me offline push.  */
//        NONE /** \～chinese 不收取离线推送。 \~english  Offline push is not collected.  */
//    }
//
//    /**
//     * \~chinese
//     * 设置会话的免打扰。
//     * @param conversationId 会话id。
//     * @param type 会话类型。
//     * @param param 离线推送免打扰参数。
//     * @param callBack 完成回调。
//     *
//     * \~english
//     * Set the DND of the conversation.
//     * @param conversationId The conversation id.
//     * @param type The conversation type.
//     * @param param Push DND parameters offline.
//     * @param callBack Complete the callback.
//     */
//    public void setSilentModeForConversation(String conversationId, EMConversation.EMConversationType type, EMSilentModeParam param, EMValueCallBack<EMSilentModeResult> callBack){
//        mClient.execute(new Runnable() {
//            @Override
//            public void run() {
//                try {
//                    EMAError error = new EMAError();
//                    EMASilentModeItem item = emaObject.setSilentModeForConversation(conversationId, type.ordinal(), param.emaObject, error);
//                    handleError(error);
//                    callBack.onSuccess(new EMSilentModeResult(item));
//                }catch (HyphenateException e){
//                    callBack.onError(e.getErrorCode(), e.getDescription());
//                }
//            }
//        });
//    }
//
//    /**
//     * \~chinese
//     * 清除会话的离线推送提醒类型设置。
//     * 清除之后会话跟随当前登录用户的设置 {@link EMPushManager#setSilentModeForAll(EMSilentModeParam, EMValueCallBack)}。
//     * @param conversationId 会话id。
//     * @param type 会话类型。
//     * @param callBack 完成回调。
//     *
//     * \~english
//     * Clear the setting of offline push notification type for the conversation.
//     * After clearing, the session follows the Settings of the current logged-in user  {@link EMPushManager#setSilentModeForAll(EMSilentModeParam, EMValueCallBack)}.
//     * @param conversationId The conversation id.
//     * @param type The conversation type.
//     * @param callBack Complete the callback.
//     */
//    public void clearRemindTypeForConversation(String conversationId, EMConversation.EMConversationType type, EMCallBack callBack){
//        mClient.execute(new Runnable() {
//            @Override
//            public void run() {
//                try {
//                    EMAError error = new EMAError();
//                    emaObject.clearRemindTypeForConversation(conversationId, type.ordinal(), error);
//                    handleError(error);
//                    callBack.onSuccess();
//                }catch (HyphenateException e){
//                    callBack.onError(e.getErrorCode(), e.getDescription());
//                }
//            }
//        });
//    }
//
//    /**
//     * \~chinese
//     * 获取会话的免打扰设置。
//     * @param conversationId 会话id。
//     * @param type 会话类型。
//     * @param callBack 完成回调。
//     *
//     * \~english
//     * Gets the DND setting of the conversation.
//     * @param conversationId The conversation id.
//     * @param type The conversation type.
//     * @param callBack Complete the callback.
//     */
//    public void getSilentModeForConversation(String conversationId, EMConversation.EMConversationType type, EMValueCallBack<EMSilentModeResult> callBack){
//        mClient.execute(new Runnable() {
//            @Override
//            public void run() {
//                try {
//                    EMAError error = new EMAError();
//                    EMASilentModeItem item = emaObject.getSilentModeForConversation(conversationId, type.ordinal(), error);
//                    handleError(error);
//                    callBack.onSuccess(new EMSilentModeResult(item));
//                }catch (HyphenateException e){
//                    callBack.onError(e.getErrorCode(), e.getDescription());
//                }
//            }
//        });
//    }
//
//    /**
//     * \~chinese
//     * 设置当前登录用户的免打扰设置。
//     * @param param 离线推送免打扰参数。
//     * @param callBack 完成回调。
//     *
//     * \~english
//     * Example Set the DND Settings for the current login user.
//     * @param param Push DND parameters offline.
//     * @param callBack Complete the callback.
//     */
//    public void setSilentModeForAll(EMSilentModeParam param, EMValueCallBack<EMSilentModeResult> callBack){
//        mClient.execute(new Runnable() {
//            @Override
//            public void run() {
//                try {
//                    EMAError error = new EMAError();
//                    EMASilentModeItem item = emaObject.setSilentModeForAll(param.emaObject, error);
//                    handleError(error);
//                    callBack.onSuccess(new EMSilentModeResult(item));
//                }catch (HyphenateException e){
//                    callBack.onError(e.getErrorCode(), e.getDescription());
//                }
//            }
//        });
//    }
//
//    /**
//     * \~chinese
//     * 获取当前登录用户的免打扰设置。
//     * @param callBack 完成回调。
//     *
//     * \~english
//     * Gets the DND Settings of the current login user.
//     * @param callBack Complete the callback.
//     */
//    public void getSilentModeForAll(EMValueCallBack<EMSilentModeResult> callBack){
//        mClient.execute(new Runnable() {
//            @Override
//            public void run() {
//                try {
//                    EMAError error = new EMAError();
//                    EMASilentModeItem item = emaObject.getSilentModeForAll(error);
//                    handleError(error);
//                    callBack.onSuccess(new EMSilentModeResult(item));
//                }catch (HyphenateException e){
//                    callBack.onError(e.getErrorCode(), e.getDescription());
//                }
//            }
//        });
//    }
//
//    /**
//     * \~chinese
//     * 批量获取指定会话的免打扰设置。
//     * @param conversationList 会话列表。
//     * @param callBack 完成回调。
//     *
//     * \~english
//     * Obtain the DND Settings of specified conversations in batches.
//     * @param conversationList The conversation list.
//     * @param callBack Complete the callback.
//     */
//    public void getSilentModeForConversations(List<EMConversation> conversationList, EMValueCallBack<Map<String, EMSilentModeResult>> callBack){
//        mClient.execute(new Runnable() {
//            @Override
//            public void run() {
//                try {
//                    StringBuilder userIdStr = new StringBuilder();
//                    StringBuilder groupIdStr = new StringBuilder();
//                    for(EMConversation conversation : conversationList){
//                        if(conversation.getType() == EMConversation.EMConversationType.Chat){
//                            if(!userIdStr.toString().isEmpty()){
//                                userIdStr.append(",");
//                            }
//                            userIdStr.append(conversation.conversationId());
//                        } else {
//                            if(!groupIdStr.toString().isEmpty()){
//                                groupIdStr.append(",");
//                            }
//                            groupIdStr.append(conversation.conversationId());
//                        }
//                    }
//                    Map<String, String> map = new HashMap<>();
//                    map.put("user", userIdStr.toString());
//                    map.put("group", groupIdStr.toString());
//                    EMAError error = new EMAError();
//                    List<EMASilentModeItem> items = emaObject.getSilentModeForConversations(map,  error);
//                    handleError(error);
//                    Map<String, EMSilentModeResult> itemMap = new HashMap<>();
//                    for(EMASilentModeItem item : items){
//                        itemMap.put(item.getConversationId(), new EMSilentModeResult(item));
//                    }
//                    callBack.onSuccess(itemMap);
//                }catch (HyphenateException e){
//                    callBack.onError(e.getErrorCode(), e.getDescription());
//                }
//            }
//        });
//
//    }
//
//    /**
//     * \~chinese
//     * 设置用户推送翻译语言。
//     * @param languageCode 语言code。
//     * @param callBack 完成回调。
//     *
//     * \~english
//     * Set user push translation language.
//     * @param languageCode language code.
//     * @param callBack Complete the callback.
//     */
//    public void setPreferredNotificationLanguage(String languageCode, EMCallBack callBack){
//        mClient.execute(new Runnable() {
//            @Override
//            public void run() {
//                try {
//                    EMAError error = new EMAError();
//                    emaObject.setPushPerformLanguage(languageCode, error);
//                    handleError(error);
//                    callBack.onSuccess();
//                }catch (HyphenateException e){
//                    callBack.onError(e.getErrorCode(), e.getDescription());
//                }
//            }
//        });
//    }
//
//    /**
//     * \~chinese
//     * 获取用户设置的推送翻译语言。
//     * @param callBack 完成回调。
//     *
//     * \~english
//     * Gets the push translation language set by the user.
//     * @param callBack Complete the callback.
//     */
//    public void getPreferredNotificationLanguage(EMValueCallBack<String> callBack){
//        mClient.execute(new Runnable() {
//            @Override
//            public void run() {
//                try {
//                    EMAError error = new EMAError();
//                    String languageCode = emaObject.getPushPerformLanguage(error);
//                    handleError(error);
//                    callBack.onSuccess(languageCode);
//                }catch (HyphenateException e){
//                    callBack.onError(e.getErrorCode(), e.getDescription());
//                }
//            }
//        });
//    }

    /**
     * \~chinese
     * 绑定设备token到服务器。
     * 当deviceToken为空时，表示从服务器解绑当前设备的deviceToken
     * @param notifierName  表示当前设备的ID，具体如下：
     *                      FCM - Sender ID;
     *                      华为 - App ID;
     *                      小米 - App ID;
     *                      魅族 - App ID;
     *                      OPPO - App Key;
     *                      Vivo - App ID + "#" + App Key;
     * @param deviceToken   当前设备返回的设备 Token .
     * @param callBack
     *
     * \~english
     * Binds device token to chat server.
     * If device token is null or "", means that unbinding device token from chat server.
     * @param notifierName Means current device ID, follow:
     *                     FCM - Sender ID;
     *                     Hawei - App ID;
     *                     Xiaomi - App ID;
     *                     Meizu - App ID;
     *                     OPPO - App Key;
     *                     Vivo - App ID + "#" + App Key;
     * @param deviceToken  Device token generated by the device manufacture
     * @param callBack
     */
    public synchronized void bindDeviceToken(String notifierName, String deviceToken, EMCallBack callBack) {
        if(mClient == null || !mClient.isSdkInited()) {
            if(callBack != null) {
                callBack.onError(EMError.GENERAL_ERROR, "SDK should init first!");
            }
            return;
        }
        mClient.execute(()-> {
            try {
                bindDeviceToken(notifierName, deviceToken);
                if(callBack != null) {
                    callBack.onSuccess();
                }
            } catch (HyphenateException e) {
                if(callBack != null) {
                    callBack.onError(e.getErrorCode(), e.getDescription());
                }
            }
        });
    }

    void unBindDeviceToken() throws HyphenateException {
        bindDeviceToken(EMPreferenceUtils.getInstance().getPushNotifierName(), "");
    }

    synchronized void bindDeviceToken(String notifierName, String deviceToken) throws HyphenateException {
        if(mClient == null || !mClient.isSdkInited()) {
            throw new HyphenateException(EMError.GENERAL_ERROR, "SDK should init first!");
        }
        if(!mClient.isLoggedInBefore()) {
            throw new HyphenateException(EMError.GENERAL_ERROR, "You need to log in first!");
        }
        if(TextUtils.isEmpty(notifierName)) {
            throw new HyphenateException(EMError.INVALID_PARAM, "Notifier name should not be empty!");
        }
        EMPreferenceUtils preferenceUtils = EMPreferenceUtils.getInstance();
        String savedToken = preferenceUtils.getPushToken();
        if(!TextUtils.isEmpty(savedToken) && TextUtils.equals(savedToken, deviceToken)) {
            if (!EMClient.getInstance().getChatConfigPrivate().isNewLoginOnDevice()) {
                EMLog.e(TAG, TAG + " not first login, ignore token upload action.");
                return;
            }
            EMLog.d(TAG, "push token not change, but last login is not on this device, upload to server");
        }
        String remoteUrl = EMClient.getInstance().getChatConfigPrivate().getBaseUrl(true, false) + "/users/"
                + EMClient.getInstance().getCurrentUser() + "/push/binding";
        DeviceUuidFactory deviceFactory = new DeviceUuidFactory(EMClient.getInstance().getContext());
        JSONObject json = new JSONObject();
        try {
            json.put("device_token", TextUtils.isEmpty(notifierName)? "" : deviceToken);
            json.put("notifier_name", notifierName);
            json.put("device_id", deviceFactory.getDeviceUuid().toString());
        } catch (Exception e) {
            EMLog.e(TAG, "uploadTokenInternal put json exception: " + e.toString());
            throw new HyphenateException(EMError.GENERAL_ERROR, "uploadTokenInternal put json exception: " + e.getMessage());
        }
        int retry_times = 2;
        int statusCode = EMError.GENERAL_ERROR;
        String content = "";
        do{
            try {
                EMLog.e(TAG, "uploadTokenInternal, token=" + deviceToken + ", url=" + remoteUrl
                        + ", notifier name=" + notifierName);
                Pair<Integer, String> response = EMHttpClient.getInstance().sendRequestWithToken(remoteUrl,
                        json.toString(), EMHttpClient.PUT);
                statusCode = response.first;
                content = response.second;
                if (statusCode == HttpURLConnection.HTTP_OK) {
                    // Save token info after requested successfully
                    EMPreferenceUtils.getInstance().setPushToken(deviceToken);
                    EMPreferenceUtils.getInstance().setPushNotifierName(notifierName);
                    EMLog.e(TAG, "uploadTokenInternal success.");
                    return;
                }
                EMLog.e(TAG, "uploadTokenInternal failed: " + content);
                remoteUrl = EMClient.getInstance().getChatConfigPrivate().getBaseUrl(true, true) + "/users/"
                        + EMClient.getInstance().getCurrentUser();
            } catch (HyphenateException e) {
                EMLog.e(TAG, "uploadTokenInternal failed: " + e.getDescription());
                remoteUrl = EMClient.getInstance().getChatConfigPrivate().getBaseUrl(true, true) + "/users/"
                        + EMClient.getInstance().getCurrentUser();
            }
        }while (--retry_times > 0);

        throw new HyphenateException(statusCode, content);
    }

//    /**
//     * \~chinese
//     * 设置离线推送的推送模版。
//     * @param templateName 模版名称。
//     * @param callBack 完成回调。
//     *
//     * \~english
//     * Set the push template for offline push.
//     * @param templateName template name.
//     * @param callBack Complete the callback.
//     */
//    public void setPushTemplate(String templateName, EMCallBack callBack){
//        mClient.execute(new Runnable() {
//            @Override
//            public void run() {
//                try {
//                    EMAError error = new EMAError();
//                    emaObject.setPushTemplate(templateName, error);
//                    handleError(error);
//                    callBack.onSuccess();
//                }catch (HyphenateException e){
//                    callBack.onError(e.getErrorCode(), e.getDescription());
//                }
//            }
//        });
//    }
//
//    /**
//     * \~chinese
//     * 获取设置的离线推送模版。
//     * @param callBack 完成回调。
//     *
//     * \~english
//     * Gets the offline push template for Settings.
//     * @param callBack Complete the callback.
//     */
//    public void getPushTemplate(EMValueCallBack<String> callBack){
//        mClient.execute(new Runnable() {
//            @Override
//            public void run() {
//                try {
//                    EMAError error = new EMAError();
//                    String templateName = emaObject.getPushTemplate(error);
//                    handleError(error);
//                    callBack.onSuccess(templateName);
//                }catch (HyphenateException e){
//                    callBack.onError(e.getErrorCode(), e.getDescription());
//                }
//            }
//        });
//    }
//
//    /**
//     * \~chinese
//     * 上报推送事件。
//     *
//     * 异步方法。
//     *
//     * @param json 推送数据里携带的EPush字段对应的value。
//     * @param action 推送事件
//     * @param callBack 完成回调。
//     *
//     * \~english
//     * Reports the push events.
//     *
//     * This is an asynchronous method.
//     *
//     * @param json Value corresponding to the EPush field carried in the push data.
//     * @param action Push event
//     * @param callBack Complete the callback.
//     */
//    public void reportPushAction(JSONObject json, EMPushAction action, EMCallBack callBack)
//    {
//        EMClient.getInstance().execute(new Runnable() {
//            @Override
//            public void run() {
//                try {
//                    if(json != null){
//                        json.put("action", action.name);
//                        reportPushAction(json.toString());
//                    }
//                    callBack.onSuccess();
//                } catch (IllegalArgumentException e) {
//                    callBack.onError(EMError.USER_ILLEGAL_ARGUMENT, e.getMessage());
//                } catch (HyphenateException e) {
//                    callBack.onError(e.getErrorCode(), e.getDescription());
//                } catch (JSONException e) {
//                    e.printStackTrace();
//                }
//            }
//        });
//    }

}