/*
 *  * EaseMob CONFIDENTIAL
 * __________________
 * Copyright (C) 2017 EaseMob Technologies. All rights reserved.
 *
 * NOTICE: All information contained herein is, and remains
 * the property of EaseMob Technologies.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from EaseMob Technologies.
 */
package com.hyphenate.chat;

import com.hyphenate.EMValueCallBack;
import com.hyphenate.chat.adapter.EMAPushConfigs;

/**
 * \~chinese
 * 推送配置信息类。
 * \~english
 * The push configs info class.
 */
public class EMPushConfigs extends EMBase<EMAPushConfigs>{

    public EMPushConfigs(EMAPushConfigs pushConfigs){
        emaObject = pushConfigs;
    }


    /**
     * \~chinese
     * 获取推送昵称。
     * @return  推送昵称。
     *
     * \~english
     * Gets the push display name.
     * @return The display name for push.
     */
    public String getDisplayNickname() {
        return emaObject.getDisplayNickname();
    }

//    public void setDisplayNickname(String displayNickname) {
//        this.displayNickname = displayNickname;
//    }

    /**
     * \~chinese
     * 获取是否开启离线推送免打扰。
     * 可通过 {@link EMPushManager#disableOfflinePush(int, int)} 设置。
     * @return  是否开启离线推送免打扰。
     * @deprecated 使用 {@link EMPushConfigs#silentModeEnabled()} 替代。
     *
     * \~english
     * Gets whether to enable offline push without disturbing.
     * Sets it by {@link EMPushManager#disableOfflinePush(int, int)}.
     * @return Whether to enable offline push without disturbing.
     * @deprecated Use {@link EMPushConfigs#silentModeEnabled()} instead.
     */
    @Deprecated
    public boolean isNoDisturbOn() {
        return silentModeEnabled();
    }
    /**
     * \~chinese
     * 获取是否开启离线推送免打扰。
     * 可通过 {@link EMPushManager#disableOfflinePush(int, int)} 设置。
     * @return  是否开启离线推送免打扰。
     * @deprecated 使用 {@link EMPushManager#getSilentModeForAll(EMValueCallBack)} 替代。
     *
     * \~english
     * Gets whether to silent the offline push.
     * Sets it by {@link EMPushManager#disableOfflinePush(int, int)}.
     * @return WHether to silent the offline push.
     * @deprecated Use {@link EMPushManager#getSilentModeForAll(EMValueCallBack)} instead.
     */
    @Deprecated
    public boolean silentModeEnabled() {
        return emaObject.isNoDisturbOn();
    }

//    public void setNoDisturbOn(boolean noDisturbOn) {
//        isNoDisturbOn = noDisturbOn;
//    }

    /**
     * \~chinese
     * 获取离线推送免打扰开始的时间，24 小时制，以小时为单位。
     * @return  时间，24 小时制，以小时为单位。
     * @deprecated 使用 {@link EMPushConfigs#getSilentModeStart()} 替代。
     *
     * \~english
     * Gets the start hour of the offline push without disturbing(24-hour clock).
     * @return The start hour of the offline push without disturbing(24-hour clock).
     * @deprecated Use {@link EMPushConfigs#getSilentModeStart()} instead.
     */
    @Deprecated
    public int getNoDisturbStartHour() {
        return getSilentModeStart();
    }

    /**
     * \~chinese
     * 获取离线推送免打扰开始的时间。
     * @return  开启推送免打扰的时间。
     * @deprecated 使用 {@link EMPushManager#getSilentModeForAll(EMValueCallBack)} 替代。
     *
     * \~english
     * Gets the start hour of the offline push without disturbing.
     * @return The start hour of the offline push without disturbing.
     * @deprecated Use {@link EMPushManager#getSilentModeForAll(EMValueCallBack)} instead.
     */
    @Deprecated
    public int getSilentModeStart() {
        return emaObject.getNoDisturbStartHour();
    }

//    public void setNoDisturbStartHour(int noDisturbStartHour) {
//        this.noDisturbStartHour = noDisturbStartHour;
//    }

    /**
     * \~chinese
     * 获取离线推送免打扰结束的时间。
     * @return  获取离线推送免打扰结束的时间。
     * @deprecated 使用 {@link EMPushConfigs#getSilentModeEnd()} 替代。
     *
     * \~english
     * Gets the end hour of the offline push without disturbing.
     * @return The end hour of the offline push without disturbing.
     * @deprecated Use {@link EMPushConfigs#getSilentModeEnd()} instead.
     */
    @Deprecated
    public int getNoDisturbEndHour() {
        return getSilentModeEnd();
    }

    /**
     * \~chinese
     * 获取离线推送免打扰结束的时间。
     * @return  获取离线推送免打扰结束的时间。
     * @deprecated 使用 {@link EMPushManager#getSilentModeForAll(EMValueCallBack)} 替代。
     *
     * \~english
     * Gets the end hour of the offline push without disturbing.
     * @return The end hour of the offline push without disturbing.
     * @deprecated Use {@link EMPushManager#getSilentModeForAll(EMValueCallBack)} instead.
     */
    @Deprecated
    public int getSilentModeEnd() {
        return emaObject.getNoDisturbEndHour();
    }

//    public void setOnDisturbEndHour(int onDisturbEndHour) {
//        this.onDisturbEndHour = onDisturbEndHour;
//    }

    /**
     * \~chinese
     * 获取离线推送展示类型。
     * @return  离线推送展示类型。
     *
     * \~english
     * Gets the offline push display type.
     * @return The offline push display type.
     */
    public EMPushManager.DisplayStyle getDisplayStyle() {
        return EMPushManager.DisplayStyle.values()[emaObject.getDisplayStyle()];
    }
}
