package com.hyphenate.chat;

import com.hyphenate.EMCallBack;
import com.hyphenate.chat.adapter.EMAPresence;

import java.util.Map;

/**
 * \~chinese
 * 在线状态属性类，包含发布者的用户 ID、在线设备使用的平台、当前在线状态以及在线状态的扩展信息、更新时间和到期时间。
 * <p>
 * \~english
 * The presence property class that contains presence properties, including the publisher's user ID and current presence state, and the platform used by the online device, as well as the presence's extension information, update time, and subscription expiration time.
 */
public class EMPresence extends EMBase<EMAPresence> {

    public EMPresence(EMAPresence emaPresence) {
        emaObject = emaPresence;
    }


    /**
     * \~chinese
     * @return 状态发布者的用户ID。
     * \~english
     * @return The user ID of the presence publisher.
     */
    public String getPublisher() {
        return emaObject.getPublisher();
    }

    /**
     * \~chinese
     * @return 当前发布者的所有设备的状态信息。
     * key:发布者设备 ID，格式为设备平台_xxxxxxx。例如："android_34f0bbf7-8eab-46db-b572-b56b02405690"。
     * value：发布者设备的状态，0为离线，1为在线。
     *
     *\~english
     * @return  The current presence status of all devices of the publisher.
     * key:The device ID of the publisher, which is in the format of (device platform)_xxxxxxx,such as "android_34f0bbf7-8eab-46db-b572-b56b02405690".
     * value:The current presence state of the publisher, 0 is offline, 1 is online.
     */
    public Map<String, Integer> getStatusList() {
        return emaObject.getStatusList();
    }

    /**
     * \~chinese
     * @return 获取在线状态扩展信息。可通过{@link EMPresenceManager#publishPresence(String, EMCallBack)}来设置自定义在线状态。
     *
     * \~english
     * @return Gets the presence extension information.
     * A custom presence can be set with {@link EMPresenceManager#publishPresence(String, EMCallBack)}.
     */
    public String getExt() {
        return emaObject.getExt();
    }
    /**
     *  \~chinese
     * @return 在线状态更新时间。该时间由服务器自动生成。
     *
     *  \~english
     *  @return The presence update time, which is generated by the server.
     */
    public long getLatestTime() {
        return emaObject.getLatestTime();
    }
    /**
     *  \~chinese
     * @return  在线状态订阅到期时间。
     *
     *  \~english
     * @return  The expiration time of the presence subscription.
     */
    public long getExpiryTime() {
        return emaObject.getExpiryTime();
    }

    @Override
    public String toString() {
        return "EMPresence{" +
                " \n publisher=" + getPublisher() +
                "，\n ext=" + getExt() +
                "，\n latesttime=" + getLatestTime() +
                "，\n expirytime=" + getExpiryTime() +
                "，\n statusList=" + getStatuListString(getStatusList()) +
                " }";
    }

    private String getStatuListString(Map<String, Integer> map) {
        String statu = "";
        for (Map.Entry<String, Integer> entry : map.entrySet()) {
            statu += "platform=" + entry.getKey() + ",value=" + entry.getValue() + "\n";
        }
        return statu;
    }

}
