/************************************************************
  *  * EaseMob CONFIDENTIAL 
  * __________________ 
  * Copyright (C) 2013-2014 EaseMob Technologies. All rights reserved. 
  *  
  * NOTICE: All information contained herein is, and remains 
  * the property of EaseMob Technologies.
  * Dissemination of this information or reproduction of this material 
  * is strictly forbidden unless prior written permission is obtained
  * from EaseMob Technologies.
  */
package com.hyphenate.chat;

import android.os.Parcel;
import android.os.Parcelable;

import com.hyphenate.chat.adapter.message.EMALocationMessageBody;

/**
 * \~chinese
 * 位置信息消息体。
 * 
 * ```java
 * EMLocationMessageBody body = new EMLocationMessageBody(“地址”, 30.010378, 104.358878,"建筑物名称");
 * ```
 *
 * \~english
 * The location message body.
 * 
 * ```java
 * EMLocationMessageBody body = new EMLocationMessageBody(“location”, 30.010378, 104.358878, "建筑物名称");
 * ```
 */
public class EMLocationMessageBody extends EMMessageBody implements Parcelable {
    /**
     * \~chinese
     * 创建一个位置信息体。
     * @param address 地址。
     * @param latitude 纬度。
     * @param longitude 经度。
     * @param buildingName 建筑物名称。
     *
     * \~english
     * Creates a location message body.
     * @param address  The address.
     * @param latitude  The latitude.
     * @param longitude  The longitude.
     * @param buildingName The building name.
     */
    public EMLocationMessageBody(String address, double latitude, double longitude, String buildingName) {
    	emaObject = new EMALocationMessageBody(latitude, longitude, address, buildingName);
    }

    public EMLocationMessageBody(String address, double latitude, double longitude) {
        emaObject = new EMALocationMessageBody(latitude, longitude, address, "");
    }
    
    public EMLocationMessageBody(EMALocationMessageBody body) {
    	emaObject = body;
	}
    /**
     * \~chinese
     * 获取地址。
     *
     * \~english
     * Gets the address.
     */
    public String getAddress() {
        return ((EMALocationMessageBody)emaObject).address();
    }
    
    /**
     * \~chinese
     * 获取纬度。
     *
     * \~english
     * Gets the latitude.
     */
    public double getLatitude() {
        return ((EMALocationMessageBody)emaObject).latitude();
    }
    
    /**
     * \~chinese
     * 获取经度。
     *
     * \~english
     * Gets the longitude.
     */
    public double getLongitude() {
        return ((EMALocationMessageBody)emaObject).longitude();
    }

    /**
     * \~chinese
     * 获取建筑物名称。
     *
     * \~english
     * Gets the building name.
     */
    public String getBuildingName(){
        return ((EMALocationMessageBody)emaObject).buildingName();
    }
    
    public String toString() {
        return "location:" + ((EMALocationMessageBody)emaObject).address() + ",lat:" + ((EMALocationMessageBody)emaObject).latitude() + ""
            + ",lng:" + ((EMALocationMessageBody)emaObject).longitude() + ",build:" + ((EMALocationMessageBody)emaObject).buildingName();
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(((EMALocationMessageBody)emaObject).address());
        dest.writeDouble(((EMALocationMessageBody)emaObject).latitude());
        dest.writeDouble(((EMALocationMessageBody)emaObject).longitude());
        dest.writeString(((EMALocationMessageBody)emaObject).buildingName());
    }
    
    public static final Parcelable.Creator<EMLocationMessageBody> CREATOR
            = new Parcelable.Creator<EMLocationMessageBody>() {
        public EMLocationMessageBody createFromParcel(Parcel in) {
            return new EMLocationMessageBody(in);
        }

        public EMLocationMessageBody[] newArray(int size) {
            return new EMLocationMessageBody[size];
        }
    };

    private EMLocationMessageBody(Parcel in) {
    	emaObject = new EMALocationMessageBody(0.0, 0.0, "", "");
    	String address = in.readString();
    	double latitude = in.readDouble();
    	double longitude = in.readDouble();
    	String buildName = in.readString();
    	((EMALocationMessageBody)emaObject).setAddress(address);
    	((EMALocationMessageBody)emaObject).setLatitude(latitude);
    	((EMALocationMessageBody)emaObject).setLongitude(longitude);
        ((EMALocationMessageBody)emaObject).setBuildingName(buildName);
    }
}
