package com.hyphenate.chat;

import com.hyphenate.chat.adapter.EMADeviceInfo;
/**
 * \~chinese
 * 多设备登录信息类。
 * 可以通过 {@link EMClient#getLoggedInDevicesFromServer(String, String)} 获取相关信息。
 *
 * \~english
 * The Multi-device information.
 * You can call {@link EMClient#getLoggedInDevicesFromServer(String, String)} to get the related information.
 */
public class EMDeviceInfo extends EMBase<EMADeviceInfo> {

    EMADeviceInfo emaObject;

    EMDeviceInfo(EMADeviceInfo emaDeviceInfo) {
        this.emaObject = emaDeviceInfo;
    }

    /**
     * \~chinese
     * 获取其他登录的设备信息。
     * 可以通过设备信息区分设备类型，如：
     * 
     * ```java
     *     String deviceResource = getResource();
     *     String deviceType = deviceResource.substring(0, deviceResource.indexOf("_"));
     *     if(deviceType.equalsIgnoreCase("ios")) {
     *         // iOS device
     *     }else if(deviceType.equalsIgnoreCase("android")) {
     *         // android device
     *     }else if(deviceType.equalsIgnoreCase("web")) {
     *         // web device
     *     }else if(deviceType.equalsIgnoreCase("win")) {
     *         // win device
     *     }else if(deviceType.equalsIgnoreCase("iMac")) {
     *         // mac device
     *     }
     * ```
     * 
     * @return 其他登录的设备信息。
     *
     * \~english
     * Gets the information of the other logged in devices.
     * 
     * Through the device information, you can distinguish the device type, for example:

     * 
     * ```java
     *     String deviceResource = getResource();
     *     String deviceType = deviceResource.substring(0, deviceResource.indexOf("_"));
     *     if(deviceType.equalsIgnoreCase("ios")) {
     *         // iOS device
     *     }else if(deviceType.equalsIgnoreCase("android")) {
     *         // android device
     *     }else if(deviceType.equalsIgnoreCase("web")) {
     *         // web device
     *     }else if(deviceType.equalsIgnoreCase("win")) {
     *         // win device
     *     }else if(deviceType.equalsIgnoreCase("iMac")) {
     *         // mac device
     *     }
     * ```
     * 
     * @return     The other devices‘ information.
     */
    public String getResource() { return emaObject.getResource(); }

    /**
     * \~chinese
     * 获取设备的 UUID（唯一标识码）。
     * @return  设备的 UUID（唯一标识码）。
     *
     * \~english
     * Gets the UUID of the device.
     * @return  The UUID of the device.

     */
    public String getDeviceUUID() { return emaObject.getDeviceUUID(); }

    /**
     * \~chinese
     * 获取设备型号名称。如果用户自定义了设备名称，则该处获取的是自定义设备名称。
     * 例如："HUAWEICOL-AL10"。
     * 
     * @return  设备型号名称。
     *
     * \~english
     * Gets the device model name.If the user defines the device name, the device name is the user-defined one.
     * 
     * @return  The device type. For example: "Pixel 6 Pro".
     */
    public String getDeviceName() { return emaObject.getDeviceName(); }

    /*
    public void setResource(String resource)    { emaObject.setResource(resource); }
    public void setOsType(String osType)        { emaObject.setOsType(osType); }
    public void setOsVersion(String osVersion)  { emaObject.setOsVersion(osVersion); }
    public void setDeviceUUID(String deviceUUID) { emaObject.setDeviceUUID(deviceUUID); }
    public void setDeviceName(String deviceName) { emaObject.setDeviceName(deviceName); }
    */
}
