package com.hyphenate.notification.core;

import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.text.TextUtils;

import com.hyphenate.EMCallBack;
import com.hyphenate.chat.EMClient;
import com.hyphenate.chat.EMPushManager;
import com.hyphenate.notification.EMNotificationMessage;
import com.hyphenate.util.EMLog;

import org.json.JSONObject;

import java.util.Iterator;

public class EMNotificationIntentReceiver extends BroadcastReceiver {

    private static final String TAG = "em_notification";

    @Override
    public final void onReceive(Context context, Intent intent) {
        EMLog.d(TAG, "onReceive");
        if (intent == null) {
            return;
        }
        try {
            Bundle bundle = intent.getExtras();
            if(bundle != null){
                int event = bundle.getInt("event_type");
                String taskId = bundle.getString("task_id");
                EMNotificationMessage notificationMessage = bundle.getParcelable("message");

                if(event == 0){
                    onNotifyMessageArrived(context, notificationMessage);
                }

                if(event == 1){
                    // reported click event
                    JSONObject parameters = new JSONObject();
                    if(!taskId.isEmpty()){
                        JSONObject report = new JSONObject();
                        report.put("task_id", taskId);
                        parameters.put("report", report);
                    }
                    parameters.put("provider", "EASEMOB");
                    EMClient.getInstance().pushManager().reportPushAction(parameters, EMPushManager.EMPushAction.CLICK, new EMCallBack() {
                        @Override
                        public void onSuccess() {
                            EMLog.d(TAG, "report success");
                        }

                        @Override
                        public void onError(int code, String error) {
                            EMLog.d(TAG, "report failed: " + code + " : " + error);
                        }

                        @Override
                        public void onProgress(int progress, String status) {

                        }
                    });
                    onNotificationClick(context, notificationMessage);
                }
            }
        } catch (Exception e) {
            EMLog.d(TAG, e.getMessage());
        }
    }

    public void onNotifyMessageArrived(Context context, EMNotificationMessage notificationMessage){
        EMLog.d(TAG, "onNotifyMessageArrived");
    }

    public void onNotificationClick(Context context, EMNotificationMessage notificationMessage){
        try {
            Intent receiverIntent = null;
            if (notificationMessage.getOpenType() == 1) {
                if(!TextUtils.isEmpty(notificationMessage.getOpenUrl())){
                    if (notificationMessage.getOpenUrl().startsWith("http:") || notificationMessage.getOpenUrl().startsWith("https:")) {
                        receiverIntent = new Intent(Intent.ACTION_VIEW, Uri.parse(notificationMessage.getOpenUrl()));
                    }
                }
            } else if (notificationMessage.getOpenType() == 2) {
                if(!TextUtils.isEmpty(notificationMessage.getOpenAction())){
                    if (notificationMessage.getOpenAction().contains("://")) {
                        receiverIntent = new Intent(Intent.ACTION_VIEW, Uri.parse(notificationMessage.getOpenAction()));
                    } else {
                        receiverIntent = new Intent(notificationMessage.getOpenAction());
                    }
                }else if(!TextUtils.isEmpty(notificationMessage.getOpenActivity())){
                    receiverIntent = new Intent();
                    receiverIntent.setComponent(new ComponentName(context, notificationMessage.getOpenActivity()));
                }
            } else {
                receiverIntent = context.getPackageManager().getLaunchIntentForPackage(context.getPackageName());
            }
            if (!TextUtils.isEmpty(notificationMessage.getExtras()) && receiverIntent != null) {
                JSONObject extJson = new JSONObject(notificationMessage.getExtras());
                for (Iterator<String> it = extJson.keys(); it.hasNext(); ) {
                    String key = it.next();
                    receiverIntent.putExtra(key, extJson.getString(key));
                }
            }

            if (receiverIntent != null) {
                receiverIntent.setFlags(Intent.FLAG_ACTIVITY_NEW_TASK | Intent.FLAG_ACTIVITY_RESET_TASK_IF_NEEDED | Intent.FLAG_ACTIVITY_CLEAR_TOP);
                context.startActivity(receiverIntent);
            }
        }catch (Exception e){
            EMLog.d(TAG, "onNotificationClick:" + e.getMessage());
        }
    }
}
