/*
 *  * EaseMob CONFIDENTIAL
 * __________________
 * Copyright (C) 2017 EaseMob Technologies. All rights reserved.
 *
 * NOTICE: All information contained herein is, and remains
 * the property of EaseMob Technologies.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from EaseMob Technologies.
 */
package com.hyphenate.chat.adapter;

public class EMAGroupSetting extends EMABase {
	
	public final static int EMAGroupStyle_PRIVATE_OWNER_INVITE = 0;
	public final static int EMAGroupStyle_PRIVATE_MEMBER_INVITE = 1;
	public final static int EMAGroupStyle_PUBLIC_JOIN_APPROVAL = 2;
	public final static int EMAGroupStyle_PUBLIC_JOIN_OPEN = 3;
	public final static int EMAGroupStyle_PUBLIC_ANONYMOUS = 4;

	
	public EMAGroupSetting() {
		nativeInit(EMAGroupStyle_PRIVATE_OWNER_INVITE, 200, false, "");
	}
	
	public EMAGroupSetting(int style, int maxUserCount, boolean inviteNeedConfirm, String extension) {
		nativeInit(style, maxUserCount, inviteNeedConfirm, extension);
	}
	
	public EMAGroupSetting(EMAGroupSetting setting) {
		nativeInit(setting);
	}
	
	public int style() {
		return nativeStyle();
	}
	
	public int maxUserCount() {
		return nativeMaxUserCount();
	}

	public boolean inviteNeedConfirm() { return nativeInviteNeedConfirm(); }

	public String extension() { return nativeExtension(); }

	public void setStyle(int style) {
		nativeSetStyle(style);
	}
	
	public void setMaxUserCount(int maxUserCount) {
		nativeSetMaxUserCount(maxUserCount);
	}

	native int nativeStyle();
	native int nativeMaxUserCount();
	native boolean nativeInviteNeedConfirm();
	native String nativeExtension();
	
	native void nativeSetStyle(int style);
	native void nativeSetMaxUserCount(int maxUserCount);
	
	@Override
	public void finalize() throws Throwable {
		nativeFinalize();
		super.finalize();
	}
	
	native void nativeInit(int style, int maxUserCount, boolean inviteNeedConfirm, String extension);
	native void nativeInit(EMAGroupSetting setting);
	native void nativeFinalize();
}
