package com.hyphenate.notification.core;

import android.app.AlarmManager;
import android.app.Notification;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.ResolveInfo;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.support.v4.app.NotificationManagerCompat;
import android.os.HandlerThread;
import android.text.TextUtils;
import com.hyphenate.EMCallBack;
import com.hyphenate.EMError;
import com.hyphenate.chat.EMClient;
import com.hyphenate.chat.EMCmdMessageBody;
import com.hyphenate.chat.EMMessage;
import com.hyphenate.chat.EMPushManager;
import com.hyphenate.cloud.EMCloudOperationCallback;
import com.hyphenate.cloud.EMHttpClient;
import com.hyphenate.notification.EMNotificationBuilder;
import com.hyphenate.notification.EMNotificationMessage;
import com.hyphenate.push.common.PushUtil;
import com.hyphenate.util.EMLog;

import org.json.JSONObject;

import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public final class EMNotificationHelper {

    private Context appContext;

    private static final String CMD_ACTION = "em_custom_notification";
    private static final String EM_NOTIFICATION = "em_notification";
    private static final String NOTIFICATION_TITLE = "title";
    private static final String NOTIFICATION_CONTENT = "content";
    private static final String NOTIFICATION_ICON_URL = "icon_url";
    private static final String NOTIFICATION_OPERATION = "operation";
    private static final String NOTIFICATION_OPERATION_TYPE = "type";
    private static final String NOTIFICATION_OPERATION_OPEN_URL = "open_url";
    private static final String NOTIFICATION_OPERATION_OPEN_ACTION = "open_action";
    private static final String NOTIFICATION_OPERATION_OPEN_ACTIVITY = "open_activity";
    private static final String NOTIFICATION_CHANNEL_ID = "channel_id";
    private static final String NOTIFICATION_CHANNEL_NAME = "channel_name";
    private static final String NOTIFICATION_CHANNEL_LEVEL = "channel_level";
    private static final String NOTIFICATION_ID = "id";
    private static final String NOTIFICATION_EXPIRES_TIME = "expires_time";
    private static final String NOTIFICATION_CANCEL_TIME = "cancel_time";
    private static final String NOTIFICATION_AUTO_CLEAR = "auto_cancel";
    private static final String NOTIFICATION_SOUND = "sound";
    private static final String NOTIFICATION_VIBRATE = "vibrate";
    private static final String NOTIFICATION_BIG_STYLE = "style";
    private static final String NOTIFICATION_BIG_PICTURE = "big_picture";
    private static final String NOTIFICATION_BIG_TXT = "big_txt";
    private static final String REPORT = "report";
    private static final String TASK_ID = "task_id";
    private static final String NOTIFICATION_EXT = "ext";
    private static final String NOTIFICATION_MESSAGE = "message";
    private static final String RECEIVER_EVENT = "event_type";
    private static final String NOTIFICATION_BADGE = "badge";
    private static final String NOTIFICATION_BADGE_ADD = "add_num";
    private static final String NOTIFICATION_BADGE_SET = "set_num";
    private static final String NOTIFICATION_BADGE_CLASS = "activity";
    private static final String NOTIFICATION_NEED = "need_notification";

    private static final String NOTIFICATION_INTENT_ACTION_INTENT = "com.hyphenate.notification.intent.RECEIVE_MESSAGE";
    private static final String NOTIFICATION_INTENT_ACTION_CANCEL = "com.hyphenate.notification.cancel.";

    private Handler mHandler;

    private EMNotificationHelper() {
        HandlerThread handlerThread = new HandlerThread("notification-thread");
        handlerThread.start();
        mHandler = new Handler(handlerThread.getLooper());
    }

    public void onInit(Context context) {
        this.appContext = context.getApplicationContext();
        alarmManager = (AlarmManager) context.getSystemService(Context.ALARM_SERVICE);
    }

    private static EMNotificationHelper sInstance;

    public static EMNotificationHelper getInstance() {
        if (sInstance == null) {
            sInstance = new EMNotificationHelper();
        }
        return sInstance;
    }

    public void analyzeCmdMessage(EMMessage cmdMessage) {
        if (cmdMessage.getType() != EMMessage.Type.CMD) {
            return;
        }

        String action = ((EMCmdMessageBody)cmdMessage.getBody()).action();

        if (!CMD_ACTION.equalsIgnoreCase(action)) {
            return;
        }

        String taskId = "";
        try {
            Map<String, Object> ext = cmdMessage.ext();
            if(ext.containsKey(REPORT)){
                JSONObject report = new JSONObject(ext.get(REPORT).toString());
                taskId = report.optString(TASK_ID);
            }

            if (!ext.containsKey(EM_NOTIFICATION)){
                printLog(EM_NOTIFICATION + " is not found");
                return;
            }
            JSONObject notificationJson = cmdMessage.getJSONObjectAttribute(EM_NOTIFICATION);

            EMNotificationMessage notificationMessage = new EMNotificationMessage();
            notificationMessage.setNotificationTitle(notificationJson.optString(NOTIFICATION_TITLE));
            notificationMessage.setNotificationContent(notificationJson.optString(NOTIFICATION_CONTENT));
            notificationMessage.setNotificationStyle(notificationJson.optInt(NOTIFICATION_BIG_STYLE));
            notificationMessage.setNotificationIconUrl(notificationJson.optString(NOTIFICATION_ICON_URL));
            notificationMessage.setNotificationBigPicPath(notificationJson.optString(NOTIFICATION_BIG_PICTURE));
            notificationMessage.setNotificationBigText(notificationJson.optString(NOTIFICATION_BIG_TXT));
            notificationMessage.setNotificationChannelName(notificationJson.optString(NOTIFICATION_CHANNEL_NAME));
            notificationMessage.setNotificationChannelId(notificationJson.optString(NOTIFICATION_CHANNEL_ID));
            notificationMessage.setNotificationChannelLevel(notificationJson.optInt(NOTIFICATION_CHANNEL_LEVEL, 3));
            notificationMessage.setNotificationNotifyId(notificationJson.optInt(NOTIFICATION_ID));
            notificationMessage.setNotificationAutoClear(notificationJson.optInt(NOTIFICATION_AUTO_CLEAR, 1) == 1);
            notificationMessage.setNotificationSound(notificationJson.optInt(NOTIFICATION_SOUND) == 1);
            notificationMessage.setNotificationVibrate(notificationJson.optInt(NOTIFICATION_VIBRATE) == 1);
            notificationMessage.setNotificationExpiresTime(notificationJson.optLong(NOTIFICATION_EXPIRES_TIME));
            notificationMessage.setNotificationCancelTime(notificationJson.optLong(NOTIFICATION_CANCEL_TIME));
            JSONObject operationJson = notificationJson.optJSONObject(NOTIFICATION_OPERATION);
            if(operationJson != null){
                notificationMessage.setOpenType(operationJson.optInt(NOTIFICATION_OPERATION_TYPE));
                notificationMessage.setOpenUrl(operationJson.optString(NOTIFICATION_OPERATION_OPEN_URL));
                notificationMessage.setOpenAction(operationJson.optString(NOTIFICATION_OPERATION_OPEN_ACTION));
                notificationMessage.setOpenActivity(operationJson.optString(NOTIFICATION_OPERATION_OPEN_ACTIVITY));

            }
            notificationMessage.setExtras(notificationJson.optString(NOTIFICATION_EXT));
            JSONObject badgeJson = notificationJson.optJSONObject(NOTIFICATION_BADGE);
            if(badgeJson != null){
                notificationMessage.setBadgeAdd(badgeJson.optInt(NOTIFICATION_BADGE_ADD));
                notificationMessage.setBadgeSet(badgeJson.optInt(NOTIFICATION_BADGE_SET));
                notificationMessage.setBadgeClass(badgeJson.optString(NOTIFICATION_BADGE_CLASS));
            }
            notificationMessage.setNeedNotification(notificationJson.optBoolean(NOTIFICATION_NEED, true));

            if(notificationMessage.isNeedNotification()){
                parseNotificationParams(notificationMessage, taskId);
            } else {
                createSimpleNotification(notificationMessage, new EMNotificationBuilder.EMNotificationDefaultStyle(), "", taskId);
            }

            JSONObject parameters = new JSONObject();
            if(!taskId.isEmpty()){
                JSONObject report = new JSONObject();
                report.put("task_id", taskId);
                parameters.put("report", report);
            }
            parameters.put("provider", "EASEMOB");
            // reported arrival event
            EMClient.getInstance().pushManager().reportPushAction(parameters, EMPushManager.EMPushAction.ARRIVE, new EMCallBack() {
                @Override
                public void onSuccess() {
                    printLog("report success");
                }

                @Override
                public void onError(int code, String error) {
                    printLog("report failed: " + code + " : " + error);
                }

                @Override
                public void onProgress(int progress, String status) {

                }
            });
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void parseNotificationParams(EMNotificationMessage notificationMessage, String taskId) {
        long expires_time = notificationMessage.getNotificationExpiresTime();
        if (expires_time > 0 && System.currentTimeMillis() - expires_time > 0) {
            printLog("out of range time: task_id:"+taskId);
            return;
        }

        final int bigStyle = notificationMessage.getNotificationStyle();
        String iconUrl = notificationMessage.getNotificationIconUrl();
        if (!TextUtils.isEmpty(iconUrl)) {
            File iconFile = new File(appContext.getCacheDir(), UUID.randomUUID().toString() + ".png");
            String iconFilePath = iconFile.getPath();
            downloadFile(iconUrl, iconFilePath, new EMCallBack() {
                @Override
                public void onSuccess() {
                    if (bigStyle == 0) {
                        createSimpleNotification(notificationMessage, new EMNotificationBuilder.EMNotificationDefaultStyle(), iconFilePath, taskId);
                    } else if (bigStyle == 1) {
                        String bigTxt = notificationMessage.getNotificationBigText();
                        createSimpleNotification(notificationMessage, new EMNotificationBuilder.EMNotificationBigTextStyle().setBigTxt(bigTxt), iconFilePath, taskId);
                    } else if (bigStyle == 2) {
                        String pictureUrl = notificationMessage.getNotificationBigPicPath();
                        if (!TextUtils.isEmpty(pictureUrl)) {
                            File bigPicFile = new File(appContext.getCacheDir(), UUID.randomUUID().toString() + ".png");
                            downloadFile(pictureUrl, bigPicFile.getPath(), new EMCallBack() {
                                @Override
                                public void onSuccess() {
                                    Bitmap bigPicBitmap = BitmapFactory.decodeFile(bigPicFile.getPath());
                                    createSimpleNotification(notificationMessage, new EMNotificationBuilder.EMNotificationBigPicStyle().setBigPic(bigPicBitmap), iconFilePath, taskId);
                                }

                                @Override
                                public void onError(int code, String error) {
                                    // Large image download failed
                                    createSimpleNotification(notificationMessage, new EMNotificationBuilder.EMNotificationDefaultStyle(), iconFilePath, taskId);
                                }

                                @Override
                                public void onProgress(int progress, String status) {

                                }
                            });
                        }
                    }
                }

                @Override
                public void onError(int code, String error) {
                    // Icon download failed
                    if (bigStyle == 0) {
                        createSimpleNotification(notificationMessage, new EMNotificationBuilder.EMNotificationDefaultStyle(), "", taskId);
                    } else if (bigStyle == 1) {
                        String bigTxt = notificationMessage.getNotificationBigText();
                        createSimpleNotification(notificationMessage, new EMNotificationBuilder.EMNotificationBigTextStyle().setBigTxt(bigTxt), "", taskId);
                    } else if (bigStyle == 2) {
                        String pictureUrl = notificationMessage.getNotificationBigPicPath();
                        if (!TextUtils.isEmpty(pictureUrl)) {
                            File bigPicFile = new File(appContext.getCacheDir(), UUID.randomUUID().toString() + ".png");
                            downloadFile(pictureUrl, bigPicFile.getPath(), new EMCallBack() {
                                @Override
                                public void onSuccess() {
                                    Bitmap bigPicBitmap = BitmapFactory.decodeFile(bigPicFile.getPath());
                                    createSimpleNotification(notificationMessage, new EMNotificationBuilder.EMNotificationBigPicStyle().setBigPic(bigPicBitmap), "", taskId);
                                }

                                @Override
                                public void onError(int code, String error) {
                                    // Large image download failed
                                    createSimpleNotification(notificationMessage, new EMNotificationBuilder.EMNotificationDefaultStyle(), "", taskId);
                                }

                                @Override
                                public void onProgress(int progress, String status) {

                                }
                            });
                        }
                    }
                }

                @Override
                public void onProgress(int progress, String status) {

                }
            });
        }else{
            if (bigStyle == 0) {
                createSimpleNotification(notificationMessage, new EMNotificationBuilder.EMNotificationDefaultStyle(), "", taskId);
            } else if (bigStyle == 1) {
                String bigTxt = notificationMessage.getNotificationBigText();
                createSimpleNotification(notificationMessage, new EMNotificationBuilder.EMNotificationBigTextStyle().setBigTxt(bigTxt), "", taskId);
            } else if (bigStyle == 2) {
                String pictureUrl = notificationMessage.getNotificationBigPicPath();
                if (!TextUtils.isEmpty(pictureUrl)) {
                    File bigPicFile = new File(appContext.getCacheDir(), UUID.randomUUID().toString() + ".png");
                    downloadFile(pictureUrl, bigPicFile.getPath(), new EMCallBack() {
                        @Override
                        public void onSuccess() {
                            Bitmap bigPicBitmap = BitmapFactory.decodeFile(bigPicFile.getPath());
                            createSimpleNotification(notificationMessage, new EMNotificationBuilder.EMNotificationBigPicStyle().setBigPic(bigPicBitmap), "", taskId);
                        }

                        @Override
                        public void onError(int code, String error) {
                            // Large image download failed
                            createSimpleNotification(notificationMessage, new EMNotificationBuilder.EMNotificationDefaultStyle(), "", taskId);
                        }

                        @Override
                        public void onProgress(int progress, String status) {

                        }
                    });
                }
            }
        }
    }


    private void downloadFile(String remoteUrl, String localPath, EMCallBack callBack) {
        Map<String, String> headers = new HashMap<>();
        EMHttpClient.getInstance().downloadFile(remoteUrl, localPath,headers, new EMCloudOperationCallback(){

            @Override
            public void onSuccess(String result) {
                if (callBack != null) {
                    callBack.onSuccess();
                }

            }

            @Override
            public void onError(String msg) {
                if (callBack != null) {
                    callBack.onError(EMError.FILE_DOWNLOAD_FAILED, msg);
                }
            }

            @Override
            public void onProgress(int progress) {

            }
        });
    }
    private BroadcastReceiver intentReceiver;
    private int intentRequestCode = 1;
    int notificationId = 0125;

    private void realCreateNotification(EMNotificationMessage notificationMessage, EMNotificationBuilder.EMNotificationDefaultStyle style, String iconFilePath, String taskId) {

        String packageName = appContext.getPackageName();
        Intent receiverIntent = new Intent(NOTIFICATION_INTENT_ACTION_INTENT);
        receiverIntent.setPackage(packageName);
        receiverIntent.addCategory(packageName);
        List<ResolveInfo> list = appContext.getPackageManager().queryBroadcastReceivers(receiverIntent, 0);
        if(list.size() > 0){
            receiverIntent.setComponent(new ComponentName(appContext, list.get(0).activityInfo.name));
        }else {
            receiverIntent = new Intent(NOTIFICATION_INTENT_ACTION_INTENT);
            receiverIntent.setPackage(packageName);
            if(intentReceiver == null){
                intentReceiver = new EMNotificationIntentReceiver();
                IntentFilter filter = new IntentFilter(NOTIFICATION_INTENT_ACTION_INTENT);
                if(Build.VERSION.SDK_INT >= 33) {
                    appContext.registerReceiver(intentReceiver, filter, Context.RECEIVER_EXPORTED);
                }else {
                    appContext.registerReceiver(intentReceiver, filter);
                }
            }
        }
        receiverIntent.putExtra(NOTIFICATION_MESSAGE, notificationMessage);
        receiverIntent.putExtra(RECEIVER_EVENT, 0);
        appContext.sendBroadcast(receiverIntent);
        if(!notificationMessage.isNeedNotification()){
            return;
        }

        Intent clickIntent = new Intent(NOTIFICATION_INTENT_ACTION_INTENT);
        clickIntent.setPackage(packageName);
        clickIntent.addCategory(packageName);

        if(list.size() > 0){
            clickIntent.setComponent(new ComponentName(appContext, list.get(0).activityInfo.name));
        }else {
            clickIntent = new Intent(NOTIFICATION_INTENT_ACTION_INTENT);
            clickIntent.setPackage(packageName);
        }
        clickIntent.putExtra(TASK_ID, taskId);
        clickIntent.putExtra(NOTIFICATION_MESSAGE, notificationMessage);
        clickIntent.putExtra(RECEIVER_EVENT, 1);
        PendingIntent pendingIntent = null;
        if(Build.VERSION.SDK_INT >= Build.VERSION_CODES.M){
            pendingIntent = PendingIntent.getBroadcast(appContext, intentRequestCode++, clickIntent, PendingIntent.FLAG_CANCEL_CURRENT | PendingIntent.FLAG_IMMUTABLE);
        } else {
            pendingIntent = PendingIntent.getBroadcast(appContext, intentRequestCode++, clickIntent, PendingIntent.FLAG_CANCEL_CURRENT);
        }

        int smallIconId = appContext.getResources().getIdentifier("em_push_small_icon", "drawable", packageName);
        if(smallIconId <= 0){
            smallIconId = appContext.getResources().getIdentifier("em_push_small_icon", "mipmap", packageName);
        }
        if(smallIconId <= 0){
            smallIconId = appContext.getApplicationInfo().icon;
        }

        String notificationTitle = notificationMessage.getNotificationTitle();
        String notificationContent = notificationMessage.getNotificationContent();
        String channelId = notificationMessage.getNotificationChannelId();
        String channelName = notificationMessage.getNotificationChannelName();
        int channelLevel = notificationMessage.getNotificationChannelLevel();
        boolean autoClear = notificationMessage.isNotificationAutoClear();
        boolean sound = notificationMessage.isNotificationSound();
        boolean vibrate = notificationMessage.isNotificationVibrate();
        int notifyId = notificationMessage.getNotificationNotifyId();
        int badgeAdd = notificationMessage.getBadgeAdd();
        int badgeSet = notificationMessage.getBadgeSet();
        String activity = notificationMessage.getBadgeClass();

        NotificationManager notificationManager = (NotificationManager) appContext.getSystemService(Context.NOTIFICATION_SERVICE);
        EMNotificationBuilder builder = new EMNotificationBuilder(appContext);
        builder.setSmallIcon(smallIconId)
                .setAutoCancel(autoClear)
                .setSound(sound)
                .setVibrate(vibrate)
                .setTitle(notificationTitle)
                .setContent(notificationContent)
                .setChannelId(channelId)
                .setChannelName(channelName)
                .setLevel(channelLevel)
                .setStyle(style)
                .setPendingIntent(pendingIntent);
        if(!iconFilePath.isEmpty()){
            Bitmap iconBitmap = BitmapFactory.decodeFile(iconFilePath);
            builder.setIcon(iconBitmap);
        }

        if(badgeAdd > 0){
            builder.setBadgeNum(badgeAdd);
        }

        Notification notification = builder.build();

        if (notification == null) {
            return;
        }

        String os = PushUtil.getDeviceManufacturer();
        if(badgeAdd > 0) {
            if (os.contains("XIAOMI")) {
                try {
                    Field field = notification.getClass().getDeclaredField("extraNotification");
                    Object extraNotification = field.get(notification);
                    Method method = extraNotification.getClass().getDeclaredMethod("setMessageCount", int
                            .class);
                    method.invoke(extraNotification, badgeAdd);
                } catch (Exception e) {
                    printLog("Failed to set badge for Xiaomi:" + e.getMessage());
                }
            }
        }

        if(badgeSet > 0) {
            if(os.contains("HUAWEI")||os.contains("HONOR")){
                try {
                    Bundle bunlde = new Bundle();
                    bunlde.putString("package", packageName); // com.test.badge is your package name
                    bunlde.putString("class", activity); // com.test. badge.MainActivity is your apk main activity
                    bunlde.putInt("badgenumber", badgeSet);
                    appContext.getContentResolver().call(Uri.parse("content://com.huawei.android.launcher.settings/badge/"), "change_badge", null, bunlde);
                } catch (Exception e) {
                    printLog("Failed to set badge for Huawei:" + e.getMessage());
                }
            }
        }

        if (notifyId > 0) {
            notificationId = notifyId;
        }else{
            notificationId ++;
        }

        long cancelTime = notificationMessage.getNotificationCancelTime();
        if (cancelTime > 0) {
            cancelNotificationWhenCancelTime(notificationId, cancelTime);
        }
        // 第一个参数为Notification的id
        notificationManager.notify(String.valueOf(notificationId), notificationId, notification);
    }

    private void createSimpleNotification(EMNotificationMessage notificationMessage, EMNotificationBuilder.EMNotificationDefaultStyle style, String iconFilePath, String report) {
        mHandler.post(new Runnable() {
            @Override
            public void run() {
                realCreateNotification(notificationMessage, style, iconFilePath, report);
            }
        });
    }

    /**
     * 判断通知权限是否打开
     */
    private boolean notificationEnabled(Context context) {
        NotificationManagerCompat notification = NotificationManagerCompat.from(context);
        return notification.areNotificationsEnabled();
    }

    private AlarmManager alarmManager;
    private BroadcastReceiver alarmIntentReceiver;
    private int alarmRequestCode = 1;

    private void cancelNotificationWhenCancelTime(int notifyId, long cancelTime) {
        Intent intentForService = new Intent(NOTIFICATION_INTENT_ACTION_CANCEL + EMClient.getInstance().getChatConfigPrivate().getAppKey());
        intentForService.setPackage(appContext.getPackageName());
        intentForService.putExtra("notifyId", notifyId);
        PendingIntent alarmIntent = null;
        if(Build.VERSION.SDK_INT >= Build.VERSION_CODES.M){
            alarmIntent = PendingIntent.getBroadcast(appContext, alarmRequestCode++, intentForService, PendingIntent.FLAG_CANCEL_CURRENT | PendingIntent.FLAG_IMMUTABLE);
        } else {
            alarmIntent = PendingIntent.getBroadcast(appContext, alarmRequestCode++, intentForService, PendingIntent.FLAG_CANCEL_CURRENT);
        }

        if (alarmIntentReceiver == null) {
            alarmIntentReceiver = new EMNotificationCancelReceiver();
            IntentFilter filter = new IntentFilter(NOTIFICATION_INTENT_ACTION_CANCEL + EMClient.getInstance().getChatConfigPrivate().getAppKey());
            try {
                if(Build.VERSION.SDK_INT >= 33) {
                    appContext.registerReceiver(alarmIntentReceiver, filter, Context.RECEIVER_EXPORTED);
                }else {
                    appContext.registerReceiver(alarmIntentReceiver, filter);
                }
            } catch (Exception e) {
                e.printStackTrace();
                printLog(e.getMessage());
            }
        }
        if (Build.VERSION.SDK_INT >= 31) {
            if (alarmManager.canScheduleExactAlarms()) {
                alarmManager.setExactAndAllowWhileIdle(AlarmManager.RTC_WAKEUP, cancelTime, alarmIntent);
            } else {
                alarmManager.setAndAllowWhileIdle(AlarmManager.RTC_WAKEUP, cancelTime, alarmIntent);
            }
        }else if(Build.VERSION.SDK_INT >= Build.VERSION_CODES.M){
            // Wakes up the device in Doze Mode
            alarmManager.setExactAndAllowWhileIdle(AlarmManager.RTC_WAKEUP, cancelTime, alarmIntent);
        } else if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.KITKAT) {
            alarmManager.setExact(AlarmManager.RTC_WAKEUP,  cancelTime, alarmIntent);
        } else {
            alarmManager.set(AlarmManager.RTC_WAKEUP,  cancelTime, alarmIntent);
        }
    }

    private void printLog(String message) {
        EMLog.d("em_notification", message);
    }

}
