/*
 *  * EaseMob CONFIDENTIAL
 * __________________
 * Copyright (C) 2017 EaseMob Technologies. All rights reserved.
 *
 * NOTICE: All information contained herein is, and remains
 * the property of EaseMob Technologies.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from EaseMob Technologies.
 */
package com.hyphenate;

/**
 * \~chinese
 * SDK 中的错误常量类。
 * 
 * 定义了 SDK 中常用的错误码。
 *
 * \~english
 * The error constant class in the SDK, which defines common error codes in the SDK.
 */
public class EMError {
    
    /**
     * \~chinese
     * 无错误。
     * 
     * \~english
     * No error.
     */
    public final static int EM_NO_ERROR = 0;

    /**
     * \~chinese
     * 一般错误。
     * 
     * 未细分错误一般通过此错误码抛出。
     * 
     * \~english
     * The general error occurs. 
     * 
     * Undefined errors are generally thrown with this error code.
     */
    public final static int GENERAL_ERROR = 1;
    
    /**
     * \~chinese
     * 网络异常。
     * 
     * \~english
     * A network error occurs. 
     */
    public final static int NETWORK_ERROR = 2;

    /**
     * \~chinese
     * 数据库操作失败。
     *
     * \~english
     * A database operation fails.
     */
    public final static int DATABASE_ERROR = 3;

    /**
     * \~chinese
     * 超过服务限制。
     *
     * \~english
     * The service limit is exceeded. 
     */
    public final static int EXCEED_SERVICE_LIMIT = 4;

    /**
     * \~chinese
     * 余额不足。
     *
     * \~english
     * The balance is insufficient.
     */
    public final static int SERVICE_ARREARAGES = 5;

    /**
     * \~chinese
     * 向服务器上报推送信息失败。
     *
     * \~english
     * Fails to report push information to the server.
     */
    public final static int PUSH_REPORT_ACTION_FAILED = 6;


    /**
     * \~chinese
     * 请求返回成功，但有一些错误（举例：设置多个参数 有部分成功 部分失败）
     *
     * \~english
     * request success but had some error value
     */
    public final static int PARTIAL_SUCCESS = 7;


    /**
     * \~chinese
     * 应用程序的日活跃用户数量（DAU）或月活跃用户数量（MAU）达到上限。
     *
     * \~english
     * The number of daily active users (DAU) or monthly active users (MAU) for the app has reached the upper limit .
     */
    public final static int APP_ACTIVE_NUMBER_REACH_LIMITATION = 8;


    /**
     * \~chinese
     * App key 不正确。
     * 
     * \~english
     * The App Key is invalid.
     */
    public final static int INVALID_APP_KEY = 100;

    /**
     * \~chinese
     * 用户 ID 不正确。
     * 
     * \~english
     * The user ID is invalid.
     */
    public final static int INVALID_USER_NAME = 101;

    /**
     * \~chinese
     * 密码不正确。
     * 
     * \~english
     * The password is invalid.
     */
    public final static int INVALID_PASSWORD = 102;
    
    /**
     * \~chinese
     * URL 不正确。
     * 
     * \~english
     * The URL is invalid.
     */
    public final static int INVALID_URL = 103;

    /**
     * \~chinese
     * token 不正确。
     *
     * \~english
     * The token is invalid.
     */
    public final static int INVALID_TOKEN = 104;

    /**
     * \~chinese
     * 用户 ID 过长。
     *
     * \~english
     * The user ID is too long.
     */
    public final static int USER_NAME_TOO_LONG = 105;

    /**
     * \~chinese
     * 未开通拉取会话的功能。
     *
     * \~english
     * The function of getting conversations from the server has not been activated.
     */
    public final static int CHANNEL_SYNC_NOT_OPEN = 106;

    /**
     * \~chinese
     * 无效的会话。
     *
     * \~english
     * Invalid conversation.
     */
    public final static int INVALID_CONVERSATION = 107;


    /**
     * \~chinese
     *  token 已过期。
     *
     * \~english
     *  The  token has expired.
     */
    public final static int TOKEN_EXPIRED = 108;

    /**
     * \~chinese
     *  token 即将过期。
     *
     * \~english
     *  The  token is about to expire.
     */
    public final static int TOKEN_WILL_EXPIRE = 109;

    /**
     * \~chinese
     * 参数无效。
     *
     * \~english
     * The parameter is invalid.
     */
    public final static int INVALID_PARAM = 110;

    /**
     * \~chinese
     * 不支持的操作。
     *
     * \~english
     *  The operation is not supported.
     */
    public final static int OPERATION_UNSUPPORTED = 111;

    /**
     * \~chinese
     * 参数超过限制
     *
     * \~english
     *  Query param reaches limit
     */
    public final static int QUERY_PARAM_REACHES_LIMIT = 112;

    /**
     * \~chinese
     * 用户已登录。
     * 
     * \~english
     * The user is already logged in.
     */
    public final static int USER_ALREADY_LOGIN = 200;

    /**
     * \~chinese
     * 用户未登录。
     * 
     * \~english
     * The user is not logged in.
     */
    public final static int USER_NOT_LOGIN = 201;

    /**
     * \~chinese
     * 用户 ID 或密码不正确。
     * 
     * \~english
     * The user ID or password is incorrect.
     */
    public final static int USER_AUTHENTICATION_FAILED = 202;

    /**
     * \~chinese
     * 用户已存在。
     * 
     * \~english
     * The user already exists.
     */
    public final static int USER_ALREADY_EXIST = 203;

    /**
     * \~chinese
     * 用户不存在。
     * 
     * \~english
     * The user is not found.
     */
    public final static int USER_NOT_FOUND = 204;

    /**
     * \~chinese
     * 参数不合法。
     * 
     * \~english
     * Invalid parameter.
     */
    public final static int USER_ILLEGAL_ARGUMENT = 205;
    
    /**
     * \~chinese
     * 当前用户在其他设备登录。
     * 
     * \~english
     * The user is logged in from another device.
     */
    public final static int USER_LOGIN_ANOTHER_DEVICE = 206;

    /**
     * \~chinese
     * 当前用户从服务器端被删掉。
     * 
     * \~english
     * The user is removed from the server.
     */
    public final static int USER_REMOVED = 207;

    /**
     * \~chinese
     * 用户注册失败。
     * 
     * \~english
     * The user registration fails.
     */
    public final static int USER_REG_FAILED = 208;

    /**
     * \~chinese
     * 更新用户信息失败。
     * 
     * \~english
     * Fails to update user information.
     */
    public final static int USER_UPDATEINFO_FAILED = 209;

    /**
     * \~chinese
     * 用户无操作权限。
     * 
     * \~english
     * The user has no operation permission.
     */
    public final static int USER_PERMISSION_DENIED = 210;
    
    /**
     * \~chinese
     * 绑定设备 token 失败。
     * 
     * \~english
     * Fails to bind the device token.
     */
    public final static int USER_BINDDEVICETOKEN_FAILED = 211;
    
    /**
     * \~chinese
     * 解绑设备 token 失败。
     * 
     * \~english
     * Fails to unbind the device token.
     */
    public final static int USER_UNBIND_DEVICETOKEN_FAILED = 212;

    /**
     * \~chinese
     * 用户已与其他设备绑定，无法自动登录。
     *
     * \~english
     * The user is bound to another device and automatic login is not allowed.
     */
    public final static int USER_BIND_ANOTHER_DEVICE = 213;

    /**
     * \~chinese
     * 用户登录设备数超过限制。
     *
     * \~english
     * The user has logged in on too many devices. 
     */
    public final static int USER_LOGIN_TOO_MANY_DEVICES = 214;

    /**
     * \~chinese
     * 用户在群组或聊天室中被禁言。
     *
     * \~english
     * The user is muted in the chat group or chat room. 
     */
    public final static int USER_MUTED = 215;

    /**
     * \~chinese
     * 用户密码更新。
     *
     * \~english
     * The user has changed the password.
     */
    public final static int USER_KICKED_BY_CHANGE_PASSWORD = 216;

    /**
     * \~chinese
     * 用户在其他设备被踢下线。
     *
     * \~english
     * The user is kicked off from another device. 
     */
    public final static int USER_KICKED_BY_OTHER_DEVICE = 217;
    /**
     * \~chinese
     * 其他用户已登录。
     *
     * \~english
     * The other user has already logged in.
     */
    public final static int USER_ALREADY_LOGIN_ANOTHER = 218;
    /**
     * \~chinese
     * 当前用户被管理员禁言。
     *
     * \~english
     * The user is muted by the admin. 
     */
    public final static int USER_MUTED_BY_ADMIN = 219;

    /**
     * \~chinese
     * 用户登录设备与上次不一致，需重新登录。
     * 
     * 默认允许用户登录，但用户在其他设备会被踢下线。该错误在开启不踢掉其他设备上的登录开关后才会生效。
     *
     * \~english
     * The current login device is not the same as last time and you need to log in again.
     * 
     * By default, the user is allowed to log in to the current device, but will be kicked off from another device. This method works only when the switch of not kicking off users from other devices is turned on.
     */
    public final static int USER_DEVICE_CHANGED = 220;

    /**
     * \~chinese
     * 用户不是好友，不能够发送消息或者其他一些好友相关操作。
     * 
     * 默认可以给陌生人发送消息。在开启只有好友才能发送消息的功能时才会报此错误。
     *
     * \~english
     * The user is not on your contact list and you cannot send messages to the user, or some other friend related operations to the user.
     * 
     * By default, you can send messages to strangers.
     * 
     * This error will be reported only when you have turned on the function of allowing you to send messages only to your contacts.
     */
    public final static int USER_NOT_ON_ROSTER = 221;

    /**
     * \~chinese
     * 无法访问到服务器。
     *
     * \~english
     * Unable to access the server.
     */
    public final static int SERVER_NOT_REACHABLE = 300;
    
    /**
     * \~chinese
     * 等待服务器响应超时。
     * 
     * \~english
     * The server response times out. 
     */
    public final static int SERVER_TIMEOUT = 301;

    /**
     * \~chinese
     * 服务器繁忙。
     * 
     * \~english
     * The server is busy.
     */
    public final static int SERVER_BUSY = 302;
    
    /**
     * \~chinese
     * 未知服务器错误。
     * 
     * \~english
     * An unknown server error.
     */
    public final static int SERVER_UNKNOWN_ERROR = 303;

    /**
     * \~chinese
     * 获取 DNS 服务器列表失败。
     * 
     * \~english
     * Fails to get the DNS server list.
     */
    public final static int SERVER_GET_DNSLIST_FAILED = 304;

    /**
     * \~chinese
     * chat 功能限制。
     * 
     * \~english
     * The chat function is restricted.
     */
    public final static int SERVER_SERVICE_RESTRICTED = 305;

    /**
     * \~chinese
     * 服务端传输解密失败。
     *
     * \~english
     * Server transfer decryption failed.
     */
    public final static int SERVER_DECRYPTION_FAILED   = 306;

    /**
     * \~chinese
     * 服务端返回数据格式错误。
     *
     * \~english
     * The server returns data in an incorrect format.
     */
    public final static int SERVER_RESPONSE_ILLEGAL   = 309;


    /**
     * \~chinese
     * 文件未找到。
     * 
     * \~english
     * The file is not found. 
     */
    public final static int FILE_NOT_FOUND = 400;
    
    /**
     * \~chinese
     * 文件不合法。
     * 
     * \~english
     * The file is invalid.
     */
    public final static int FILE_INVALID = 401;
    
    /**
     * \~chinese
     * 文件上传失败。
     * 
     * \~english
     * The file upload fails.
     */
    public final static int FILE_UPLOAD_FAILED = 402;
    
    /**
     * \~chinese
     * 文件下载失败。
     * 
     * \~english
     * The file download fails.
     */
    public final static int FILE_DOWNLOAD_FAILED = 403;

    /**
     * \~chinese
     * 文件删除失败。
     *
     * \~english
     * The file deletion fails.
     */
    public final static int FILE_DELETE_FAILED = 404;

    /**
     * \~chinese
     * 文件太大。
     *
     * \~english
     * The file is too large.
     */
    public final static int FILE_TOO_LARGE = 405;

    /**
     * \~chinese
     * 文件内容不合规。
     *
     * \~english
     * The file contains improper content.
     */
    public final static int FILE_CONTENT_IMPROPER = 406;

    /**
     * \~chinese
     * 文件已过期。
     *
     * \~english
     * The file is expired.
     */
    public final static int FILE_IS_EXPIRED = 407;

    /**
     * \~chinese
     * 消息不合法。
     * 
     * \~english
     * The message is invalid.
     */
    public final static int MESSAGE_INVALID = 500;
 
    /**
     * \~chinese
     * 消息内容包含非法或敏感词。
     * 
     * \~english
     * The message contains invalid content or sensitive words.
     */
    public final static int MESSAGE_INCLUDE_ILLEGAL_CONTENT = 501;

    /**
     * \~chinese
     * 消息发送过快，触发限流。
     * 
     * \~english
     * The traffic limit for message sending is exceeded.
     */
    public final static int MESSAGE_SEND_TRAFFIC_LIMIT = 502;

    /**
     * \~chinese
     * 消息加解密错误。
     * 
     * \~english
     * The message encryption/decryption error.
     */
    public final static int MESSAGE_ENCRYPTION_ERROR = 503;

    /**
     * \~chinese
     * 消息撤回超时。
     *
     * \~english
     * The message recall times out.
     */
    public final static int MESSAGE_RECALL_TIME_LIMIT = 504;

    /**
     * \~chinese
     * 服务未开通。
     *
     * \~english
     * The service is not enabled.
     */
    public final static int SERVICE_NOT_ENABLED = 505;

    /**
     * \~chinese
     * 消息过期。
     *
     * \~english
     * The message has expired.
     */
    public final static int MESSAGE_EXPIRED = 506;

    /**
     * \~chinese
     * 群组或者聊天室开启了全员禁言且用户不在白名单中。
     *
     * \~english
     * All members in a group or chat room are muted and the current user is not on the allow list.
     */
    public final static int MESSAGE_ILLEGAL_WHITELIST = 507;

    /**
     * \~chinese
     * 消息执行发送前回调，被用户自己的逻辑拦截。
     *
     * \~english
     * A message is blocked by pre-delivery callback.
     */
    public final static int MESSAGE_EXTERNAL_LOGIC_BLOCKED = 508;

    /**
     * \~chinese
     * 超过了群聊消息发送频率限制。
     *
     * \~english
     * You have exceeded the maximum frequency of sending group messages.
     */
    public final static int MESSAGE_CURRENT_LIMITING = 509;

    /**
     * \~chinese
     * 消息体大小超过限制。
     *
     * \~english
     * You have exceeded the maximum allowed size of a message body.
     */
    public final static int MESSAGE_SIZE_LIMIT = 510; 

    /**
     * \~chinese
     * 消息修改失败。
     *
     * \~english
     * The message modification failed.
     */
    public final static int MESSAGE_EDIT_FAILED = 511;


    /**
     * \~chinese
     * 群组 ID 不正确。
     * 
     * \~english
     * The group ID is incorrect.
     */
    public final static int GROUP_INVALID_ID = 600;     
    /**
     * \~chinese
     * 用户已加入该群组。
     * 
     * \~english
     * The user is already in the group.
     */
    public final static int GROUP_ALREADY_JOINED = 601;
    /**
     * \~chinese
     * 用户未加入该群组。
     * 
     * \~english
     * The user is not in the group.
     */
    public final static int GROUP_NOT_JOINED = 602;
    /**
     * \~chinese
     * 无群组操作权限。
     * 
     * \~english
     * The user does not have group operation permissions.
     */
    public final static int GROUP_PERMISSION_DENIED = 603;      
    /**
     * \~chinese
     * 群成员已满。
     * 
     * \~english
     * The group has reached the maximum member capacity.
     */
    public final static int GROUP_MEMBERS_FULL = 604;

    /**
     * \~chinese
     * 群组共享文件 ID 不合法。
     *
     * \~english
     * The group shared file ID is invalid.
     */
    public final static int GROUP_SHARED_FILE_INVALIDID = 605;

    /**
     * \~chinese
     * 群组不存在。
     *
     * \~english
     * The group does not exist.
     */
    public final static int GROUP_NOT_EXIST = 606;

    /**
     * \~chinese
     * 群组被禁用。
     *
     * \~english
     * The group is disabled.
     */
    public final static int GROUP_DISABLED = 607;

    /**
     * \~chinese
     * 群组名称违规。
     *
     * \~english
     * The group name is inappropriate.
     */
    public final static int GROUP_NAME_VIOLATION = 608;
    /**
     * \~chinese
     * 该群成员的自定义属性总长度超限。
     *
     * \~english
     * The total length of custom attributes of the group member has exceeded the upper limit (4 KB).
     */
    public final static int GROUP_MEMBER_ATTRIBUTES_REACH_LIMIT = 609;
    /**
     * \~chinese
     * 设置群成员自定义属性失败。
     *
     * \~english
     * Fails to set the custom attribute(s) of the group member.
     */
    public final static int GROUP_MEMBER_ATTRIBUTES_UPDATE_FAILED = 610;
    /**
     * \~chinese
     * 设置的群成员自定义属性 key 长度（不能超过 16 字节）超限。
     *
     * \~english
     * The key of a custom attribute(s) of the group member has exceeded the maximum allowed length of 16 bytes.
     */
    public final static int GROUP_MEMBER_ATTRIBUTES_KEY_REACH_LIMIT = 611;
    /**
     * \~chinese
     * 设置群成员自定义属性 value 长度（不能超过 512 字节）超限。
     *
     * \~english
     * The value of a custom attribute(s) of the group member has exceeded the maximum allowed length of 512 bytes.
     */
    public final static int GROUP_MEMBER_ATTRIBUTES_VALUE_REACH_LIMIT = 612;

    /**
     * \~chinese
     * 用户在群组的黑名单中。
     *
     * \~english
     * The user is in the group blacklist.
     */
    public final static int GROUP_USER_IN_BLOCKLIST = 613;


    /**
     * \~chinese
     * 聊天室 ID 不正确。
     * 
     * \~english
     * The chat room ID is invalid.
     */
    public final static int CHATROOM_INVALID_ID = 700;

    /**
     * \~chinese
     * 已加入聊天室。
     * 
     * \~english
     * The user is already in the chat room.
     */
    public final static int CHATROOM_ALREADY_JOINED = 701;

    /**
     * \~chinese
     * 未加入聊天室。
     * 
     * \~english
     * The user is not in the chat room.
     */
    public final static int CHATROOM_NOT_JOINED = 702;

    /**
     * \~chinese
     * 没有权限进行该操作。
     * 
     * \~english
     * The user does not have the operation permission.
     */
    public final static int CHATROOM_PERMISSION_DENIED = 703;

    /**
     * \~chinese
     * 聊天室人数已满。
     * 
     * \~english
     * The chat room has reached the maximum member capacity.
     */
    public final static int CHATROOM_MEMBERS_FULL = 704;
    
    /**
     * \~chinese
     * 聊天室不存在。
     * 
     * \~english
     * The chat room does not exist.
     */
    public final static int CHATROOM_NOT_EXIST = 705;


    /**
     * \~chinese
     * 聊天室所有者不允许离开(canChatroomOwnerLeave为false时调用了leaveChatroom)。
     *
     * \~english
     * The owner of chat room is not allow to leave (call leaveChatroom API when canChatroomOwnerLeave option is false).
     */
    public final static int CHATROOM_OWNER_NOT_ALLOW_LEAVE = 706;

    /**
     * \~chinese
     * 用户在聊天室的黑名单中。
     *
     * \~english
     * The user is in the chat room blacklist.
     */
    public final static int CHATROOM_USER_IN_BLOCKLIST = 707;

    /**
     * \~chinese
     * 查询用户信息的数量超过上限。
     *
     * \~english
     * The number of users for user information retrieval exceeds the upper limit.
     */
    public final static int USERINFO_USERCOUNT_EXCEED  = 900;

    /**
     * \~chinese
     * 更新的用户信息长度超过上限。
     *
     * \~english
     * The length of the updated user information exceeds the upper limit.
     */
    public final static int USERINFO_DATALENGTH_EXCEED = 901;

    /**
     * \~chinese
     * 添加联系人失败。
     *
     * \~english
     * Failed to add a contact.
     */
    public final static int CONTACT_ADD_FAILED = 1000;
    /**
     * \~chinese
     * 邀请者好友达到上限。
     *
     * \~english
     * The inviter has reached the maximum number of contacts that can be added.
     */
    public final static int CONTACT_REACH_LIMIT = 1001;
    /**
     * \~chinese
     * 受邀请者好友达到上限。
     *
     * \~english
     * The invitee has reached the maximum number of contacts that can be added.
     */
    public final static int CONTACT_REACH_LIMIT_PEER = 1002;

    /**
     * \~chinese
     * 调用 Presence 相关方法时参数长度超出限制。
     *
     * \~english
     * The parameter length of the presence method exceeds the upper limit.
     */
    public final static int  PRESENCE_PARAM_LENGTH_EXCEED = 1100;

    /**
     * \~chinese
     * Presence 不能订阅自己。
     *
     * \~english
     * Presence can't subscribe yourself.
     */
    public final static int PRESENCE_CANNOT_SUBSCRIBE_YOURSELF = 1101;

    /**
     * \~chinese
     * 翻译参数错误。
     *
     * \~english
     * Translation parameter error.
     */
    public final static int TRANSLATE_PARAM_INVALID = 1110;

    /**
     * \~chinese
     * 翻译服务未启用。
     *
     * \~english
     * The translation service has not been enabled.
     */
    public final static int TRANSLATE_SERVICE_NOT_ENABLE = 1111;

    /**
     * \~chinese
     * 翻译用量达到上限。
     *
     * \~english
     * You have reached the maximum number of characters for translation.
     */
    public final static int TRANSLATE_USAGE_LIMIT = 1112;

    /**
     * \~chinese
     * 获取翻译服务失败。
     *
     * \~english
     * Failed to obtain the translation service.
     */
    public final static int TRANSLATE_MESSAGE_FAIL = 1113;

    /**
     * \~chinese
     * 第三方内容审核的消息审核结果为`拒绝`。
     *
     * \~english
     * The third-party content moderation service rates the message as "Reject".
     */
    public final static int MODERATION_FAILED = 1200;

    /**
     * \~chinese
     * 
     * 除第三方内容审核之外的其他审核服务的消息审核结果为`拒绝`
     *
     * \~english
     * Another third-party moderation service rather than the third-party content moderation service rates the message as "Reject".
     */
    public final static int THIRD_SERVER_FAILED = 1299;

    /**
     * \~chinese
     * Reaction 数量已达到限制。
     *
     * \~english
     * The number of Reactions has reached the upper limit.
     */
    public final static int REACTION_REACH_LIMIT = 1300;

    /**
     * \~chinese
     * Reaction 已存在。
     * 
     * \~english
     * The Reaction already exists.
     */
    public final static int REACTION_HAS_BEEN_OPERATED = 1301;

    /**
     * \~chinese
     * 用户对该 Reaction 没有操作权限。
     * 
     * 例如，没有添加过该 Reaction 的用户进行删除操作，或者单聊消息非发送者和非接收者进行添加 Reaction 操作。
     *
     * \~english
     * The user does not have the permission for the Reaction operation. 
     * 
     * For example, the user who does not add the reaction attempts to delete it, or the user that is neither the sender nor recipient of the one-to-one message attempts to add the Reaction.
     */
    public final static int REACTION_OPERATION_IS_ILLEGAL = 1302;

    /**
     * \~chinese
     * 子区不存在。
     *
     * \~english
     * The message thread does not exist.
     */
    public final static int THREAD_NOT_EXIST = 1400;

    /**
     * \~chinese
     * 子区已存在。
     *
     * \~english
     * 	The message thread you are attempting to create already exists in a chat group.
     */
    public final static int THREAD_ALREADY_EXIST = 1401;

    /**
     * \~chinese
     * 创建子区的消息无效。
     *
     * \~english
     * The parent message of the message thread is invalid.
     */
    public final static int THREAD_CREATE_MESSAGE_ILLEGAL = 1402;

    /**
     * \~chinese
     * 当前设备不支持推送。
     *
     * \~english
     * The current device does not support push.
     */
    public final static int PUSH_NOT_SUPPORT = 1500;

    /**
     * \~chinese
     * 推送 token 绑定失败。
     *
     * \~english
     * Fails to bind the push token.
     */
    public final static int PUSH_BIND_FAILED = 1501;

    /**
     * \~chinese
     * 推送 token 解除绑定失败。
     *
     * \~english
     * Fails to unbind the push token.
     */
    public final static int PUSH_UNBIND_FAILED = 1502;
}
