package com.hyphenate.chat.adapter;

import com.hyphenate.chat.EMMessage;

public class EMAMessageStatistics extends EMABase{

    public EMAMessageStatistics() {
        nativeInit();
    }

    public String getMsgId() {
        return nativeGetMsgId();
    }

    public String getTo() {
        return nativeGetTo();
    }

    public String getFrom() {
        return nativeGetFrom();
    }

    public EMMessage.Type getType() {
        int type = nativeGetType();
        EMMessage.Type msgType = EMMessage.Type.TXT;
        if(type == EMMessage.Type.IMAGE.ordinal()) {
            msgType = EMMessage.Type.IMAGE;
        }else if(type == EMMessage.Type.VIDEO.ordinal()) {
            msgType = EMMessage.Type.VIDEO;
        }else if(type == EMMessage.Type.LOCATION.ordinal()) {
            msgType = EMMessage.Type.LOCATION;
        }else if(type == EMMessage.Type.VOICE.ordinal()) {
            msgType = EMMessage.Type.VOICE;
        }else if(type == EMMessage.Type.FILE.ordinal()) {
            msgType = EMMessage.Type.FILE;
        }else if(type == EMMessage.Type.CMD.ordinal()) {
            msgType = EMMessage.Type.CMD;
        }else if(type == EMMessage.Type.CUSTOM.ordinal()) {
            msgType = EMMessage.Type.CUSTOM;
        }
        return msgType;
    }

    public EMMessage.ChatType getChatType() {
        int t = nativeGetChatType();
        EMMessage.ChatType type = EMMessage.ChatType.Chat;
        if (t == EMMessage.ChatType.Chat.ordinal()) {
            type = EMMessage.ChatType.Chat;
        } else if (t == EMMessage.ChatType.GroupChat.ordinal()) {
            type = EMMessage.ChatType.GroupChat;
        } else {
            type = EMMessage.ChatType.ChatRoom;
        }
        return type;
    }

    public long getMsgTime() {
        return nativeGetMsgTime();
    }

    public long getLocalTime() {
        return nativeLocalTime();
    }

    public EMMessage.Direct direct() {
        int direct = nativeDirect();
        if(direct == EMMessage.Direct.SEND.ordinal()) {
            return EMMessage.Direct.SEND;
        }
        return EMMessage.Direct.RECEIVE;
    }

    public long getMsgSize() {
        return nativeGetMsgSize();
    }

    public long getAttachmentSize() {
        return nativeGetAttachmentSize();
    }

    public long getThumbnailSize() {
        return nativeGetThumbnailSize();
    }

    @Override
    public void finalize() throws Throwable {
        nativeFinalize();
        super.finalize();
    }

    native void nativeInit();
    native void nativeFinalize();
    native String nativeGetMsgId();
    native String nativeGetTo();
    native String nativeGetFrom();
    native int nativeGetType();
    native int nativeGetChatType();
    native long nativeGetMsgTime();
    native long nativeLocalTime();
    native int nativeDirect();
    native long nativeGetMsgSize();
    native long nativeGetAttachmentSize();
    native long nativeGetThumbnailSize();
}
