package com.hyphenate.chat;

import com.hyphenate.chat.adapter.EMAMucShareFile;

/**
 * \~chinese
 * 共享文件信息类。
 * 
 * 例如：通过 {@link EMGroupManager#fetchGroupSharedFileList(String, int, int)} 接口获取群共享文件的相关信息：
 * ```java
 *     List<EMMucSharedFile> sharedFiles = EMClient.getInstance().groupManager().fetchGroupSharedFileList(groupId, pageNum, pageSize);
 * ```
 *
 * \~english
 * The shared file info class.
 * 
 * For example, you can use the following method to get information about the group shared file through {@link EMGroupManager#fetchGroupSharedFileList(String, int, int)}:


 * ```java
 *     List<EMMucSharedFile> sharedFiles = EMClient.getInstance().groupManager().fetchGroupSharedFileList(groupId, pageNum, pageSize);
 * ```
 */
public class EMMucSharedFile extends EMBase<EMAMucShareFile>{
    public EMMucSharedFile(){
        emaObject = new EMAMucShareFile();
    }

    public EMMucSharedFile(EMAMucShareFile shareFile){
        emaObject = new EMAMucShareFile(shareFile);
    }

    /**
     * \~chinese
     * 获取共享文件 ID。
     * @return  共享文件 ID。
     *
     * \~english
     * Gets the shared file ID.
     * @return  The shared file ID.
     */
    public String getFileId() {
        return emaObject.getFileId();
    }

    /**
     * \~chinese
     * 获取共享文件名称。
     * @return  共享文件名称。
     *
     * \~english
     * Gets the shared file name.
     * @return  The shared file name.
     */
    public String getFileName() {
        return emaObject.getFileName();
    }

    /**
     * \~chinese
     * 获取上传共享文件的成员 ID。
     * @return  上传共享文件的成员 ID。
     *
     * \~english
     * Gets the username who uploads the shared file.
     * @return  The username who uploads the shared file.
     */
    public String getFileOwner() {
        return emaObject.getFileOwner();
    }

    /**
     * \~chinese
     * 获取共享文件的更新时间，Unix 时间戳，单位为毫秒。
     * @return 共享文件的更新时间，Unix 时间戳，单位为毫秒。
     *
     * \~english
     * Gets the update Unix timestamp of the shared file, in ms.
     * @return  The update Unix timestamp of the shared file, in ms.
     */
    public long getFileUpdateTime() {
        return emaObject.getUpdateTime();
    }

    /**
     * \~chinese
     * 获取共享文件的大小，单位为字节。
     * @return 共享文件的大小，单位为字节。
     *
     * \~english
     * Gets the data length of the shared file, in bytes.
     * @return  The data length of the shared file, in bytes.
     */
    public long getFileSize() {
        return emaObject.getFileSize();
    }
}
