/*
 * Decompiled with CFR 0.152.
 */
package com.hyphenate.push;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.text.TextUtils;
import com.hyphenate.push.EMPushType;
import com.hyphenate.util.EMLog;
import java.util.ArrayList;

public class EMPushConfig {
    private static final String a = "EMPushConfig";
    private String b;
    private String c;
    private String d;
    private String e;
    private String f;
    private String g;
    private String h;
    private String i;
    private String j;
    private String k;
    private ArrayList<EMPushType> l;

    private EMPushConfig() {
    }

    public String getFcmSenderId() {
        return this.b;
    }

    public String getHwAppId() {
        return this.c;
    }

    public String getMiAppId() {
        return this.d;
    }

    public String getMiAppKey() {
        return this.e;
    }

    public String getMzAppId() {
        return this.f;
    }

    public String getMzAppKey() {
        return this.g;
    }

    public String getOppoAppKey() {
        return this.h;
    }

    public String getOppoAppSecret() {
        return this.i;
    }

    public String getVivoAppId() {
        return this.j;
    }

    public String getVivoAppKey() {
        return this.k;
    }

    public ArrayList<EMPushType> getEnabledPushTypes() {
        return this.l;
    }

    public String toString() {
        return "EMPushConfig{fcmSenderId='" + this.b + '\'' + ", hwAppId='" + this.c + '\'' + ", miAppId='" + this.d + '\'' + ", miAppKey='" + this.e + '\'' + ", mzAppId='" + this.f + '\'' + ", mzAppKey='" + this.g + '\'' + ", oppoAppKey='" + this.h + '\'' + ", oppoAppSecret='" + this.i + '\'' + ", vivoAppId='" + this.j + '\'' + ", vivoAppKey='" + this.k + '\'' + ", enabledPushTypes=" + this.l + '}';
    }

    public static class Builder {
        private Context a;
        private String b;
        private String c;
        private String d;
        private String e;
        private String f;
        private String g;
        private String h;
        private String i;
        private String j;
        private String k;
        private ArrayList<EMPushType> l = new ArrayList();

        public Builder(Context context) {
            this.a = context.getApplicationContext();
        }

        public Builder(Context context, EMPushConfig config) {
            this(context);
            if (config == null) {
                return;
            }
            if (config.l.contains((Object)EMPushType.MIPUSH)) {
                this.enableMiPush(config.d, config.e);
            }
            if (config.l.contains((Object)EMPushType.HMSPUSH)) {
                this.enableHWPush();
            }
            if (config.l.contains((Object)EMPushType.VIVOPUSH)) {
                this.enableVivoPush();
            }
            if (config.l.contains((Object)EMPushType.OPPOPUSH)) {
                this.enableOppoPush(config.h, config.i);
            }
            if (config.l.contains((Object)EMPushType.MEIZUPUSH)) {
                this.enableMeiZuPush(config.f, config.g);
            }
            if (config.l.contains((Object)EMPushType.FCM)) {
                this.enableFCM(config.b);
            }
        }

        public Builder enableMiPush(String appId, String appKey) {
            if (!TextUtils.isEmpty((CharSequence)appId) && !TextUtils.isEmpty((CharSequence)appKey)) {
                this.d = appId;
                this.e = appKey;
                this.l.add(EMPushType.MIPUSH);
                return this;
            }
            EMLog.e(EMPushConfig.a, "appId or appKey can't be empty when enable MI push !");
            return this;
        }

        public Builder enableHWPush() {
            try {
                ApplicationInfo applicationInfo = this.a.getPackageManager().getApplicationInfo(this.a.getPackageName(), 128);
                this.c = applicationInfo.metaData.getString("com.huawei.hms.client.appid");
                if (this.c != null && this.c.contains("=")) {
                    this.c = this.c.split("=")[1];
                } else {
                    int n = applicationInfo.metaData.getInt("com.huawei.hms.client.appid");
                    this.c = String.valueOf(n);
                }
                this.l.add(EMPushType.HMSPUSH);
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                nameNotFoundException.printStackTrace();
            }
            catch (NullPointerException nullPointerException) {
                EMLog.e(EMPushConfig.a, "Huawei push must config meta-data: com.huawei.hms.client.appid in AndroidManifest.xml.");
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                EMLog.e(EMPushConfig.a, "Huawei push meta-data: com.huawei.hms.client.appid value must be like this 'appid=xxxxxx'.");
            }
            return this;
        }

        public Builder enableFCM(String senderId) {
            if (!TextUtils.isEmpty((CharSequence)senderId)) {
                this.b = senderId;
                this.l.add(EMPushType.FCM);
                return this;
            }
            EMLog.e(EMPushConfig.a, "senderId can't be empty when enable FCM push !");
            return this;
        }

        public Builder enableMeiZuPush(String appId, String appKey) {
            if (!TextUtils.isEmpty((CharSequence)appId) && !TextUtils.isEmpty((CharSequence)appKey)) {
                this.f = appId;
                this.g = appKey;
                this.l.add(EMPushType.MEIZUPUSH);
                return this;
            }
            EMLog.e(EMPushConfig.a, "appId or appKey can't be empty when enable MEIZU push !");
            return this;
        }

        public Builder enableOppoPush(String appKey, String appSecret) {
            if (!TextUtils.isEmpty((CharSequence)appKey) && !TextUtils.isEmpty((CharSequence)appSecret)) {
                this.h = appKey;
                this.i = appSecret;
                this.l.add(EMPushType.OPPOPUSH);
                return this;
            }
            EMLog.e(EMPushConfig.a, "appKey or appSecret can't be empty when enable OPPO push !");
            return this;
        }

        public Builder enableVivoPush() {
            try {
                ApplicationInfo applicationInfo = this.a.getPackageManager().getApplicationInfo(this.a.getPackageName(), 128);
                this.j = applicationInfo.metaData.getInt("com.vivo.push.app_id") + "";
                this.k = applicationInfo.metaData.getString("com.vivo.push.api_key");
                this.l.add(EMPushType.VIVOPUSH);
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                EMLog.e(EMPushConfig.a, "NameNotFoundException: " + nameNotFoundException.getMessage());
            }
            return this;
        }

        public EMPushConfig build() {
            EMPushConfig eMPushConfig = new EMPushConfig();
            eMPushConfig.b = this.b;
            eMPushConfig.c = this.c;
            eMPushConfig.d = this.d;
            eMPushConfig.e = this.e;
            eMPushConfig.f = this.f;
            eMPushConfig.g = this.g;
            eMPushConfig.h = this.h;
            eMPushConfig.i = this.i;
            eMPushConfig.j = this.j;
            eMPushConfig.k = this.k;
            eMPushConfig.l = this.l;
            return eMPushConfig;
        }
    }
}

