/*
 * Decompiled with CFR 0.152.
 */
package com.hyphenate.chat.adapter.message;

import android.net.Uri;
import com.hyphenate.chat.adapter.message.EMAFileMessageBody;
import com.hyphenate.util.EMFileHelper;

public class EMAImageMessageBody
extends EMAFileMessageBody {
    public double width;
    public double height;
    public long fileLength;
    public String thumbnailLocalPath;
    public String thumbnailRemotePath;
    public String thumbnailSecretKey;
    public int thumbnailDownloadStatus;

    public EMAImageMessageBody(String localPath, String thumbnailLocalPath) {
        super(localPath, 1);
        this.nativeInit(localPath, thumbnailLocalPath);
    }

    public EMAImageMessageBody(Uri localPath, Uri thumbnailLocalPath) {
        super(localPath, 1);
        this.nativeInit(EMFileHelper.getInstance().uriToString(localPath), EMFileHelper.getInstance().uriToString(thumbnailLocalPath));
    }

    public EMAImageMessageBody(EMAImageMessageBody body) {
        super("", 1);
        this.nativeInit(body);
    }

    private EMAImageMessageBody() {
        super("", 1);
        this.nativeInit("", "");
    }

    @Override
    public void finalize() throws Throwable {
        this.nativeFinalize();
        super.finalize();
    }

    public void setThumbnailDisplayName(String displayName) {
        this.nativesetThumbnailDisplayName(displayName);
    }

    native void nativesetThumbnailDisplayName(String var1);

    public String thumbnailDisplayName() {
        return this.nativethumbnailDisplayName();
    }

    native String nativethumbnailDisplayName();

    public void setThumbnailLocalPath(String thumbnailLocalPath) {
        this.nativesetThumbnailLocalPath(thumbnailLocalPath);
    }

    native void nativesetThumbnailLocalPath(String var1);

    public String thumbnailLocalPath() {
        return this.nativethumbnailLocalPath();
    }

    native String nativethumbnailLocalPath();

    public void setThumbnailRemotePath(String thumbnailRemotePath) {
        this.nativesetThumbnailRemotePath(thumbnailRemotePath);
    }

    native void nativesetThumbnailRemotePath(String var1);

    public String thumbnailRemotePath() {
        return this.nativethumbnailRemotePath();
    }

    native String nativethumbnailRemotePath();

    public void setThumbnailSecretKey(String secretKey) {
        this.nativesetThumbnailSecretKey(secretKey);
    }

    native void nativesetThumbnailSecretKey(String var1);

    public String thumbnailSecretKey() {
        return this.nativethumbnailSecretKey();
    }

    native String nativethumbnailSecretKey();

    public void setThumbnailSize(int width, int height) {
        this.nativesetThumbnailSize(width, height);
    }

    native void nativesetThumbnailSize(int var1, int var2);

    public int thumbnailWidth() {
        return this.nativethumbnailWidth();
    }

    native int nativethumbnailWidth();

    int thumbnailHeight() {
        return this.nativethumbnailHeight();
    }

    native int nativethumbnailHeight();

    public void setThumbnailFileLength(long fileLength) {
        this.nativesetThumbnailFileLength(fileLength);
    }

    native void nativesetThumbnailFileLength(long var1);

    public long thumbnailFileLength() {
        return this.nativethumbnailFileLength();
    }

    native long nativethumbnailFileLength();

    public void setThumbnailDownloadStatus(EMAFileMessageBody.EMADownloadStatus status) {
        int n = status.ordinal();
        this.nativesetThumbnailDownloadStatus(n);
    }

    native void nativesetThumbnailDownloadStatus(int var1);

    public EMAFileMessageBody.EMADownloadStatus thumbnailDownloadStatus() {
        int n = this.nativethumbnailDownloadStatus();
        if (n == EMAFileMessageBody.EMADownloadStatus.DOWNLOADING.ordinal()) {
            return EMAFileMessageBody.EMADownloadStatus.DOWNLOADING;
        }
        if (n == EMAFileMessageBody.EMADownloadStatus.SUCCESSED.ordinal()) {
            return EMAFileMessageBody.EMADownloadStatus.SUCCESSED;
        }
        if (n == EMAFileMessageBody.EMADownloadStatus.FAILED.ordinal()) {
            return EMAFileMessageBody.EMADownloadStatus.FAILED;
        }
        return EMAFileMessageBody.EMADownloadStatus.PENDING;
    }

    native int nativethumbnailDownloadStatus();

    public void setSize(int width, int height) {
        this.nativesetSize(width, height);
    }

    native void nativesetSize(int var1, int var2);

    public int width() {
        return this.nativewidth();
    }

    native int nativewidth();

    public int height() {
        return this.nativeheight();
    }

    native int nativeheight();

    native void nativeInit(String var1, String var2);

    native void nativeInit(EMAImageMessageBody var1);

    @Override
    native void nativeFinalize();
}

