/*
 * Decompiled with CFR 0.152.
 */
package com.hyphenate.chat;

import com.hyphenate.EMCallBack;
import com.hyphenate.EMChatThreadChangeListener;
import com.hyphenate.EMValueCallBack;
import com.hyphenate.chat.EMChatThread;
import com.hyphenate.chat.EMChatThreadEvent;
import com.hyphenate.chat.EMClient;
import com.hyphenate.chat.EMCursorResult;
import com.hyphenate.chat.EMMessage;
import com.hyphenate.chat.adapter.EMAError;
import com.hyphenate.chat.adapter.EMAThreadInfo;
import com.hyphenate.chat.adapter.EMAThreadManager;
import com.hyphenate.chat.adapter.EMAThreadManagerListener;
import com.hyphenate.chat.adapter.message.EMAMessage;
import com.hyphenate.exceptions.HyphenateException;
import com.hyphenate.util.EMLog;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class EMChatThreadManager {
    private static String TAG = EMChatThreadManager.class.getSimpleName();
    EMAThreadManager emaObject;
    EMClient mClient;
    List<EMChatThreadChangeListener> threadChangeListeners;
    private EMAThreadManagerListener listenerImpl = new EMAThreadManagerListener(){

        @Override
        public void onThreadNameUpdated(EMAThreadInfo event) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onLeaveThread(EMAThreadInfo event, int reason) {
            List<EMChatThreadChangeListener> list = EMChatThreadManager.this.threadChangeListeners;
            synchronized (list) {
                for (EMChatThreadChangeListener eMChatThreadChangeListener : EMChatThreadManager.this.threadChangeListeners) {
                    try {
                        if (reason == EMAThreadInfo.LeaveReason.BE_KICKED.ordinal()) {
                            eMChatThreadChangeListener.onChatThreadUserRemoved(new EMChatThreadEvent(event));
                            continue;
                        }
                        eMChatThreadChangeListener.onChatThreadDestroyed(new EMChatThreadEvent(event));
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            }
        }

        @Override
        public void onMemberJoined(EMAThreadInfo event) {
        }

        @Override
        public void onMemberExited(EMAThreadInfo event) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onThreadNotifyChange(EMAThreadInfo event) {
            List<EMChatThreadChangeListener> list = EMChatThreadManager.this.threadChangeListeners;
            synchronized (list) {
                for (EMChatThreadChangeListener eMChatThreadChangeListener : EMChatThreadManager.this.threadChangeListeners) {
                    try {
                        switch (event.getType()) {
                            case CREATE: {
                                eMChatThreadChangeListener.onChatThreadCreated(new EMChatThreadEvent(event));
                                break;
                            }
                            case UPDATE: 
                            case UPDATE_MSG: {
                                eMChatThreadChangeListener.onChatThreadUpdated(new EMChatThreadEvent(event));
                                break;
                            }
                            case DELETE: {
                                eMChatThreadChangeListener.onChatThreadDestroyed(new EMChatThreadEvent(event));
                            }
                        }
                    }
                    catch (Exception exception) {
                        EMLog.e(TAG, exception.getMessage());
                    }
                }
            }
        }
    };

    EMChatThreadManager(EMClient client, EMAThreadManager threadManager) {
        this.emaObject = threadManager;
        this.mClient = client;
        this.threadChangeListeners = Collections.synchronizedList(new ArrayList());
        this.emaObject.addListener(this.listenerImpl);
        EMClient.getInstance().chatManager();
    }

    public void addChatThreadChangeListener(EMChatThreadChangeListener listener) {
        if (listener != null && !this.threadChangeListeners.contains(listener)) {
            this.threadChangeListeners.add(listener);
        }
    }

    public void removeChatThreadChangeListener(EMChatThreadChangeListener listener) {
        if (listener != null && this.threadChangeListeners.contains(listener)) {
            this.threadChangeListeners.remove(listener);
        }
    }

    public void createChatThread(final String parentId, final String messageId, final String chatThreadName, final EMValueCallBack<EMChatThread> callBack) {
        this.mClient.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    EMChatThread eMChatThread = EMChatThreadManager.this.createChatThread(parentId, messageId, chatThreadName);
                    if (callBack != null) {
                        callBack.onSuccess(eMChatThread);
                    }
                }
                catch (HyphenateException hyphenateException) {
                    if (callBack != null) {
                        callBack.onError(hyphenateException.getErrorCode(), hyphenateException.getDescription());
                    }
                    EMLog.e(TAG, "createChatThread error: " + hyphenateException.getErrorCode() + " " + hyphenateException.getDescription());
                }
            }
        });
    }

    private EMChatThread createChatThread(String parentId, String messageId, String chatThreadName) throws HyphenateException {
        EMAError eMAError = new EMAError();
        EMAThreadInfo eMAThreadInfo = this.emaObject.createThread(parentId, messageId, chatThreadName, eMAError);
        this.handleError(eMAError);
        return new EMChatThread(eMAThreadInfo);
    }

    public void getChatThreadFromServer(final String chatThreadId, final EMValueCallBack<EMChatThread> callBack) {
        this.mClient.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    EMChatThread eMChatThread = EMChatThreadManager.this.getChatThreadFromServer(chatThreadId);
                    if (callBack != null) {
                        callBack.onSuccess(eMChatThread);
                    }
                }
                catch (HyphenateException hyphenateException) {
                    if (callBack != null) {
                        callBack.onError(hyphenateException.getErrorCode(), hyphenateException.getDescription());
                    }
                    EMLog.e(TAG, "getChatThreadFromServer error: " + hyphenateException.getErrorCode() + " " + hyphenateException.getDescription());
                }
            }
        });
    }

    private EMChatThread getChatThreadFromServer(String chatThreadId) throws HyphenateException {
        EMAError eMAError = new EMAError();
        EMAThreadInfo eMAThreadInfo = this.emaObject.getThreadFromServer(chatThreadId, eMAError);
        this.handleError(eMAError);
        return new EMChatThread(eMAThreadInfo);
    }

    public void joinChatThread(final String chatThreadId, final EMValueCallBack<EMChatThread> callBack) {
        this.mClient.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    EMChatThread eMChatThread = EMChatThreadManager.this.joinChatThread(chatThreadId);
                    if (callBack != null) {
                        callBack.onSuccess(eMChatThread);
                    }
                }
                catch (HyphenateException hyphenateException) {
                    if (callBack != null) {
                        callBack.onError(hyphenateException.getErrorCode(), hyphenateException.getDescription());
                    }
                    EMLog.e(TAG, "joinChatThread error: " + hyphenateException.getErrorCode() + " " + hyphenateException.getDescription());
                }
            }
        });
    }

    private EMChatThread joinChatThread(String chatThreadId) throws HyphenateException {
        EMAError eMAError = new EMAError();
        EMAThreadInfo eMAThreadInfo = this.emaObject.joinThread(chatThreadId, eMAError);
        this.handleError(eMAError);
        return new EMChatThread(eMAThreadInfo);
    }

    public void destroyChatThread(final String chatThreadId, final EMCallBack callBack) {
        this.mClient.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    EMChatThreadManager.this.destroyChatThread(chatThreadId);
                    if (callBack != null) {
                        callBack.onSuccess();
                    }
                }
                catch (HyphenateException hyphenateException) {
                    if (callBack != null) {
                        callBack.onError(hyphenateException.getErrorCode(), hyphenateException.getDescription());
                    }
                    EMLog.e(TAG, "destroyChatThread error: " + hyphenateException.getErrorCode() + " " + hyphenateException.getDescription());
                }
            }
        });
    }

    private void destroyChatThread(String chatThreadId) throws HyphenateException {
        EMAError eMAError = new EMAError();
        this.emaObject.destroyThread(chatThreadId, eMAError);
        this.handleError(eMAError);
    }

    public void leaveChatThread(final String chatThreadId, final EMCallBack callBack) {
        this.mClient.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    EMChatThreadManager.this.leaveChatThread(chatThreadId);
                    if (callBack != null) {
                        callBack.onSuccess();
                    }
                }
                catch (HyphenateException hyphenateException) {
                    if (callBack != null) {
                        callBack.onError(hyphenateException.getErrorCode(), hyphenateException.getDescription());
                    }
                    EMLog.e(TAG, "leaveChatThread error: " + hyphenateException.getErrorCode() + " " + hyphenateException.getDescription());
                }
            }
        });
    }

    private void leaveChatThread(String chatThreadId) throws HyphenateException {
        EMAError eMAError = new EMAError();
        this.emaObject.leaveThread(chatThreadId, eMAError);
        this.handleError(eMAError);
    }

    public void updateChatThreadName(final String chatThreadId, final String chatThreadName, final EMCallBack callBack) {
        this.mClient.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    EMChatThreadManager.this.updateChatThreadName(chatThreadId, chatThreadName);
                    if (callBack != null) {
                        callBack.onSuccess();
                    }
                }
                catch (HyphenateException hyphenateException) {
                    if (callBack != null) {
                        callBack.onError(hyphenateException.getErrorCode(), hyphenateException.getDescription());
                    }
                    EMLog.e(TAG, "changeChatThreadName error: " + hyphenateException.getErrorCode() + " " + hyphenateException.getDescription());
                }
            }
        });
    }

    private void updateChatThreadName(String chatThreadId, String chatThreadName) throws HyphenateException {
        EMAError eMAError = new EMAError();
        this.emaObject.updateChatThreadName(chatThreadId, chatThreadName, eMAError);
        this.handleError(eMAError);
    }

    public void removeMemberFromChatThread(final String chatThreadId, final String member, final EMCallBack callBack) {
        this.mClient.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    EMChatThreadManager.this.removeMemberFromChatThread(chatThreadId, member);
                    if (callBack != null) {
                        callBack.onSuccess();
                    }
                }
                catch (HyphenateException hyphenateException) {
                    if (callBack != null) {
                        callBack.onError(hyphenateException.getErrorCode(), hyphenateException.getDescription());
                    }
                    EMLog.e(TAG, "removeMemberFromThread error: " + hyphenateException.getErrorCode() + " " + hyphenateException.getDescription());
                }
            }
        });
    }

    private void removeMemberFromChatThread(String chatThreadId, String member) throws HyphenateException {
        EMAError eMAError = new EMAError();
        this.emaObject.removeMemberFromThread(chatThreadId, member, eMAError);
        this.handleError(eMAError);
    }

    public void getChatThreadMembers(final String chatThreadId, final int limit, final String cursor, final EMValueCallBack<EMCursorResult<String>> callBack) {
        this.mClient.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    EMCursorResult eMCursorResult = EMChatThreadManager.this.getChatThreadMembers(chatThreadId, limit, cursor);
                    if (callBack != null) {
                        callBack.onSuccess(eMCursorResult);
                    }
                }
                catch (HyphenateException hyphenateException) {
                    if (callBack != null) {
                        callBack.onError(hyphenateException.getErrorCode(), hyphenateException.getDescription());
                    }
                    EMLog.e(TAG, "getThreadMembers error: " + hyphenateException.getErrorCode() + " " + hyphenateException.getDescription());
                }
            }
        });
    }

    private EMCursorResult<String> getChatThreadMembers(String chatThreadId, int limit, String cursor) throws HyphenateException {
        EMAError eMAError = new EMAError();
        EMCursorResult<String> eMCursorResult = this.emaObject.fetchThreadMembers(chatThreadId, limit, cursor, eMAError);
        this.handleError(eMAError);
        return eMCursorResult;
    }

    public void getJoinedChatThreadsFromServer(final int limit, final String cursor, final EMValueCallBack<EMCursorResult<EMChatThread>> callBack) {
        this.mClient.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    EMCursorResult eMCursorResult = EMChatThreadManager.this.getJoinedChatThreadsFromServer(limit, cursor);
                    if (callBack != null) {
                        callBack.onSuccess(eMCursorResult);
                    }
                }
                catch (HyphenateException hyphenateException) {
                    if (callBack != null) {
                        callBack.onError(hyphenateException.getErrorCode(), hyphenateException.getDescription());
                    }
                    EMLog.e(TAG, "getJoinedThreadsFromServer error: " + hyphenateException.getErrorCode() + " " + hyphenateException.getDescription());
                }
            }
        });
    }

    private EMCursorResult<EMChatThread> getJoinedChatThreadsFromServer(int limit, String cursor) throws HyphenateException {
        EMAError eMAError = new EMAError();
        EMCursorResult<EMAThreadInfo> eMCursorResult = this.emaObject.getJoinedThreadsFromServer(limit, cursor, eMAError);
        this.handleError(eMAError);
        EMCursorResult<EMChatThread> eMCursorResult2 = new EMCursorResult<EMChatThread>();
        ArrayList<EMChatThread> arrayList = new ArrayList<EMChatThread>();
        List list = (List)eMCursorResult.getData();
        for (int i = 0; i < list.size(); ++i) {
            arrayList.add(new EMChatThread((EMAThreadInfo)list.get(i)));
        }
        eMCursorResult2.setData(arrayList);
        eMCursorResult2.setCursor(eMCursorResult.getCursor());
        return eMCursorResult2;
    }

    public void getJoinedChatThreadsFromServer(final String parentId, final int limit, final String cursor, final EMValueCallBack<EMCursorResult<EMChatThread>> callBack) {
        this.mClient.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    EMCursorResult eMCursorResult = EMChatThreadManager.this.getJoinedChatThreadsFromServer(parentId, limit, cursor);
                    if (callBack != null) {
                        callBack.onSuccess(eMCursorResult);
                    }
                }
                catch (HyphenateException hyphenateException) {
                    if (callBack != null) {
                        callBack.onError(hyphenateException.getErrorCode(), hyphenateException.getDescription());
                    }
                    EMLog.e(TAG, "getJoinedThreadsFromServer error: " + hyphenateException.getErrorCode() + " " + hyphenateException.getDescription());
                }
            }
        });
    }

    private EMCursorResult<EMChatThread> getJoinedChatThreadsFromServer(String parentId, int limit, String cursor) throws HyphenateException {
        EMAError eMAError = new EMAError();
        EMCursorResult<EMAThreadInfo> eMCursorResult = this.emaObject.getJoinedThreadsFromServer(parentId, limit, cursor, eMAError);
        this.handleError(eMAError);
        EMCursorResult<EMChatThread> eMCursorResult2 = new EMCursorResult<EMChatThread>();
        ArrayList<EMChatThread> arrayList = new ArrayList<EMChatThread>();
        List list = (List)eMCursorResult.getData();
        for (int i = 0; i < list.size(); ++i) {
            arrayList.add(new EMChatThread((EMAThreadInfo)list.get(i)));
        }
        eMCursorResult2.setData(arrayList);
        eMCursorResult2.setCursor(eMCursorResult.getCursor());
        return eMCursorResult2;
    }

    public void getChatThreadsFromServer(final String parentId, final int limit, final String cursor, final EMValueCallBack<EMCursorResult<EMChatThread>> callBack) {
        this.mClient.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    EMCursorResult eMCursorResult = EMChatThreadManager.this.getChatThreadsFromServer(parentId, limit, cursor);
                    if (callBack != null) {
                        callBack.onSuccess(eMCursorResult);
                    }
                }
                catch (HyphenateException hyphenateException) {
                    if (callBack != null) {
                        callBack.onError(hyphenateException.getErrorCode(), hyphenateException.getDescription());
                    }
                    EMLog.e(TAG, "getThreadsFromServer error: " + hyphenateException.getErrorCode() + " " + hyphenateException.getDescription());
                }
            }
        });
    }

    private EMCursorResult<EMChatThread> getChatThreadsFromServer(String parentId, int limit, String cursor) throws HyphenateException {
        EMAError eMAError = new EMAError();
        EMCursorResult<EMAThreadInfo> eMCursorResult = this.emaObject.getThreadsFromServer(parentId, limit, cursor, eMAError);
        this.handleError(eMAError);
        EMCursorResult<EMChatThread> eMCursorResult2 = new EMCursorResult<EMChatThread>();
        ArrayList<EMChatThread> arrayList = new ArrayList<EMChatThread>();
        List list = (List)eMCursorResult.getData();
        for (int i = 0; i < list.size(); ++i) {
            arrayList.add(new EMChatThread((EMAThreadInfo)list.get(i)));
        }
        eMCursorResult2.setData(arrayList);
        eMCursorResult2.setCursor(eMCursorResult.getCursor());
        return eMCursorResult2;
    }

    public void getChatThreadLatestMessage(List<String> chatThreadIds, EMValueCallBack<Map<String, EMMessage>> callBack) {
        this.mClient.execute(() -> {
            block3: {
                Map<String, EMMessage> map = null;
                try {
                    map = this.getChatThreadLatestMessage(chatThreadIds);
                    if (callBack != null) {
                        callBack.onSuccess(map);
                    }
                }
                catch (HyphenateException hyphenateException) {
                    if (callBack == null) break block3;
                    callBack.onError(hyphenateException.getErrorCode(), hyphenateException.getDescription());
                }
            }
        });
    }

    private Map<String, EMMessage> getChatThreadLatestMessage(List<String> chatThreadIds) throws HyphenateException {
        EMAError eMAError = new EMAError();
        Map<String, EMAMessage> map = this.emaObject.getThreadsLatestMessage(chatThreadIds, eMAError);
        this.handleError(eMAError);
        HashMap<String, EMMessage> hashMap = new HashMap<String, EMMessage>();
        for (Map.Entry<String, EMAMessage> entry : map.entrySet()) {
            String string = entry.getKey();
            EMMessage eMMessage = new EMMessage(entry.getValue());
            hashMap.put(string, eMMessage);
        }
        return hashMap;
    }

    private void handleError(EMAError error) throws HyphenateException {
        if (error.errCode() != 0) {
            throw new HyphenateException(error);
        }
    }
}

