/*
 * Decompiled with CFR 0.152.
 */
package com.hyphenate.chat;

import android.support.annotation.NonNull;
import android.text.TextUtils;
import com.hyphenate.EMCallBack;
import com.hyphenate.EMChatRoomChangeListener;
import com.hyphenate.EMResultCallBack;
import com.hyphenate.EMValueCallBack;
import com.hyphenate.chat.EMChatRoom;
import com.hyphenate.chat.EMClient;
import com.hyphenate.chat.EMCursorResult;
import com.hyphenate.chat.EMOptions;
import com.hyphenate.chat.EMPageResult;
import com.hyphenate.chat.EMSessionManager;
import com.hyphenate.chat.adapter.EMAChatRoom;
import com.hyphenate.chat.adapter.EMAChatRoomManager;
import com.hyphenate.chat.adapter.EMAChatRoomManagerListener;
import com.hyphenate.chat.adapter.EMAError;
import com.hyphenate.exceptions.HyphenateException;
import com.hyphenate.util.EMLog;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class EMChatRoomManager {
    EMAChatRoomManager emaObject;
    private List<EMChatRoomChangeListener> chatRoomListeners = Collections.synchronizedList(new ArrayList());
    private ExecutorService threadPool = null;
    private List<EMChatRoom> chatRooms = Collections.synchronizedList(new ArrayList());
    EMClient mClient;
    EMAChatRoomManagerListener chatRoomListenerImpl = new EMAChatRoomManagerListener(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onLeaveChatRoom(EMAChatRoom chatroom, int leaveReason) {
            EMClient.getInstance().chatManager().caches.remove(chatroom.getId());
            List list = EMChatRoomManager.this.chatRoomListeners;
            synchronized (list) {
                try {
                    for (EMChatRoomChangeListener eMChatRoomChangeListener : EMChatRoomManager.this.chatRoomListeners) {
                        if (leaveReason == 1) {
                            eMChatRoomChangeListener.onChatRoomDestroyed(chatroom.getId(), chatroom.getName());
                            continue;
                        }
                        eMChatRoomChangeListener.onRemovedFromChatRoom(leaveReason, chatroom.getId(), chatroom.getName(), EMClient.getInstance().getCurrentUser());
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onMemberJoinedChatRoom(EMAChatRoom chatroom, String member) {
            List list = EMChatRoomManager.this.chatRoomListeners;
            synchronized (list) {
                try {
                    for (EMChatRoomChangeListener eMChatRoomChangeListener : EMChatRoomManager.this.chatRoomListeners) {
                        eMChatRoomChangeListener.onMemberJoined(chatroom.getId(), member);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onMemberLeftChatRoom(EMAChatRoom chatroom, String member) {
            List list = EMChatRoomManager.this.chatRoomListeners;
            synchronized (list) {
                try {
                    for (EMChatRoomChangeListener eMChatRoomChangeListener : EMChatRoomManager.this.chatRoomListeners) {
                        eMChatRoomChangeListener.onMemberExited(chatroom.getId(), chatroom.getName(), member);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onAddMuteList(EMAChatRoom chatRoom, List<String> mutes, long expireTime) {
            List list = EMChatRoomManager.this.chatRoomListeners;
            synchronized (list) {
                try {
                    for (EMChatRoomChangeListener eMChatRoomChangeListener : EMChatRoomManager.this.chatRoomListeners) {
                        eMChatRoomChangeListener.onMuteListAdded(chatRoom.getId(), mutes, expireTime);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onRemoveMutes(EMAChatRoom chatRoom, List<String> mutes) {
            List list = EMChatRoomManager.this.chatRoomListeners;
            synchronized (list) {
                try {
                    for (EMChatRoomChangeListener eMChatRoomChangeListener : EMChatRoomManager.this.chatRoomListeners) {
                        eMChatRoomChangeListener.onMuteListRemoved(chatRoom.getId(), mutes);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onWhiteListAdded(EMAChatRoom chatRoom, List<String> members) {
            List list = EMChatRoomManager.this.chatRoomListeners;
            synchronized (list) {
                try {
                    for (EMChatRoomChangeListener eMChatRoomChangeListener : EMChatRoomManager.this.chatRoomListeners) {
                        eMChatRoomChangeListener.onWhiteListAdded(chatRoom.getId(), members);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onWhiteListRemoved(EMAChatRoom chatRoom, List<String> members) {
            List list = EMChatRoomManager.this.chatRoomListeners;
            synchronized (list) {
                try {
                    for (EMChatRoomChangeListener eMChatRoomChangeListener : EMChatRoomManager.this.chatRoomListeners) {
                        eMChatRoomChangeListener.onWhiteListRemoved(chatRoom.getId(), members);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onAllMemberMuteStateChanged(EMAChatRoom chatRoom, boolean isMuted) {
            List list = EMChatRoomManager.this.chatRoomListeners;
            synchronized (list) {
                try {
                    for (EMChatRoomChangeListener eMChatRoomChangeListener : EMChatRoomManager.this.chatRoomListeners) {
                        eMChatRoomChangeListener.onAllMemberMuteStateChanged(chatRoom.getId(), isMuted);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onAddAdmin(EMAChatRoom chatRoom, String admin) {
            List list = EMChatRoomManager.this.chatRoomListeners;
            synchronized (list) {
                try {
                    for (EMChatRoomChangeListener eMChatRoomChangeListener : EMChatRoomManager.this.chatRoomListeners) {
                        eMChatRoomChangeListener.onAdminAdded(chatRoom.getId(), admin);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onRemoveAdmin(EMAChatRoom chatRoom, String admin) {
            List list = EMChatRoomManager.this.chatRoomListeners;
            synchronized (list) {
                try {
                    for (EMChatRoomChangeListener eMChatRoomChangeListener : EMChatRoomManager.this.chatRoomListeners) {
                        eMChatRoomChangeListener.onAdminRemoved(chatRoom.getId(), admin);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onOwnerChanged(EMAChatRoom chatRoom, String newOwner, String oldOwner) {
            List list = EMChatRoomManager.this.chatRoomListeners;
            synchronized (list) {
                try {
                    for (EMChatRoomChangeListener eMChatRoomChangeListener : EMChatRoomManager.this.chatRoomListeners) {
                        eMChatRoomChangeListener.onOwnerChanged(chatRoom.getId(), newOwner, oldOwner);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onAnnouncementChanged(EMAChatRoom chatRoom, String announcement) {
            List list = EMChatRoomManager.this.chatRoomListeners;
            synchronized (list) {
                try {
                    for (EMChatRoomChangeListener eMChatRoomChangeListener : EMChatRoomManager.this.chatRoomListeners) {
                        eMChatRoomChangeListener.onAnnouncementChanged(chatRoom.getId(), announcement);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onUpdateSpecificationFromChatroom(EMAChatRoom chatroom) {
            List list = EMChatRoomManager.this.chatRoomListeners;
            synchronized (list) {
                for (EMChatRoomChangeListener eMChatRoomChangeListener : EMChatRoomManager.this.chatRoomListeners) {
                    try {
                        if (null == chatroom) continue;
                        eMChatRoomChangeListener.onSpecificationChanged(new EMChatRoom(chatroom));
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onAttributesUpdate(String chatRoomId, String attributes, String from) {
            List list = EMChatRoomManager.this.chatRoomListeners;
            synchronized (list) {
                for (EMChatRoomChangeListener eMChatRoomChangeListener : EMChatRoomManager.this.chatRoomListeners) {
                    Map map = EMChatRoomManager.this.parseJsonUpdate(attributes);
                    try {
                        if (null == map || map.size() <= 0) continue;
                        eMChatRoomChangeListener.onAttributesUpdate(chatRoomId, map, from);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onAttributesRemoved(String chatRoomId, String attributes, String from) {
            List list = EMChatRoomManager.this.chatRoomListeners;
            synchronized (list) {
                for (EMChatRoomChangeListener eMChatRoomChangeListener : EMChatRoomManager.this.chatRoomListeners) {
                    List list2 = EMChatRoomManager.this.parseJsonRemove(attributes);
                    try {
                        if (null == list2 || list2.size() <= 0) continue;
                        eMChatRoomChangeListener.onAttributesRemoved(chatRoomId, list2, from);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            }
        }
    };

    public EMChatRoomManager(EMClient client, EMAChatRoomManager manager) {
        this.emaObject = manager;
        this.emaObject.addListener(this.chatRoomListenerImpl);
        this.mClient = client;
        this.threadPool = Executors.newCachedThreadPool();
    }

    public void addChatRoomChangeListener(EMChatRoomChangeListener listener) {
        this.chatRoomListeners.add(listener);
    }

    @Deprecated
    public void removeChatRoomChangeListener(EMChatRoomChangeListener listener) {
        this.removeChatRoomListener(listener);
    }

    public void removeChatRoomListener(EMChatRoomChangeListener listener) {
        this.chatRoomListeners.remove(listener);
    }

    public void joinChatRoom(final String roomId, final EMValueCallBack<EMChatRoom> callback) {
        this.threadPool.submit(new Runnable(){

            @Override
            public void run() {
                EMAError eMAError = new EMAError();
                EMAChatRoom eMAChatRoom = EMChatRoomManager.this.emaObject.joinChatRoom(roomId, eMAError);
                EMChatRoom eMChatRoom = new EMChatRoom(eMAChatRoom);
                if (eMAError.errCode() == 0 || eMAError.errCode() == 701) {
                    callback.onSuccess(eMChatRoom);
                } else {
                    callback.onError(eMAError.errCode(), eMAError.errMsg());
                }
            }
        });
    }

    public void leaveChatRoom(final String roomId) {
        EMChatRoom eMChatRoom = this.getChatRoom(roomId);
        if (eMChatRoom == null) {
            return;
        }
        EMOptions eMOptions = EMClient.getInstance().getOptions();
        boolean bl = eMOptions.isChatroomOwnerLeaveAllowed();
        String string = eMChatRoom.getOwner();
        if (!bl && string.equals(EMSessionManager.getInstance().getLastLoginUser())) {
            return;
        }
        boolean bl2 = eMOptions.isDeleteMessagesAsExitChatRoom();
        if (bl2) {
            EMClient.getInstance().chatManager().deleteConversation(roomId, true);
        }
        this.threadPool.submit(new Runnable(){

            @Override
            public void run() {
                EMAError eMAError = new EMAError();
                EMChatRoomManager.this.emaObject.leaveChatRoom(roomId, eMAError);
            }
        });
    }

    public EMPageResult<EMChatRoom> fetchPublicChatRoomsFromServer(int pageNum, int pageSize) throws HyphenateException {
        EMAError eMAError = new EMAError();
        EMPageResult<EMAChatRoom> eMPageResult = this.emaObject.fetchChatroomsWithPage(pageNum, pageSize, eMAError);
        this.handleError(eMAError);
        List list = (List)eMPageResult.getData();
        int n = eMPageResult.getPageCount();
        EMPageResult<EMChatRoom> eMPageResult2 = new EMPageResult<EMChatRoom>();
        ArrayList<EMChatRoom> arrayList = new ArrayList<EMChatRoom>();
        for (EMAChatRoom eMAChatRoom : list) {
            arrayList.add(new EMChatRoom(eMAChatRoom));
        }
        eMPageResult2.setPageCount(n);
        eMPageResult2.setData(arrayList);
        this.chatRooms.clear();
        this.chatRooms.addAll(arrayList);
        return eMPageResult2;
    }

    @Deprecated
    public EMCursorResult<EMChatRoom> fetchPublicChatRoomsFromServer(int pageSize, String cursor) throws HyphenateException {
        EMAError eMAError = new EMAError();
        EMCursorResult<EMAChatRoom> eMCursorResult = this.emaObject.fetchChatroomsWithCursor(cursor, pageSize, eMAError);
        this.handleError(eMAError);
        EMCursorResult<EMChatRoom> eMCursorResult2 = new EMCursorResult<EMChatRoom>();
        ArrayList<EMChatRoom> arrayList = new ArrayList<EMChatRoom>();
        for (EMAChatRoom eMAChatRoom : (List)eMCursorResult.getData()) {
            arrayList.add(new EMChatRoom(eMAChatRoom));
        }
        eMCursorResult2.setCursor(eMCursorResult.getCursor());
        eMCursorResult2.setData(arrayList);
        this.chatRooms.clear();
        this.chatRooms.addAll(arrayList);
        return eMCursorResult2;
    }

    @Deprecated
    public void asyncFetchPublicChatRoomsFromServer(final int pageSize, final String cursor, final EMValueCallBack<EMCursorResult<EMChatRoom>> callback) {
        EMClient.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    EMCursorResult<EMChatRoom> eMCursorResult = EMChatRoomManager.this.fetchPublicChatRoomsFromServer(pageSize, cursor);
                    callback.onSuccess(eMCursorResult);
                }
                catch (HyphenateException hyphenateException) {
                    callback.onError(hyphenateException.getErrorCode(), hyphenateException.getDescription());
                }
            }
        });
    }

    public void asyncFetchPublicChatRoomsFromServer(final int pageNum, final int pageSize, final EMValueCallBack<EMPageResult<EMChatRoom>> callback) {
        EMClient.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    EMPageResult<EMChatRoom> eMPageResult = EMChatRoomManager.this.fetchPublicChatRoomsFromServer(pageNum, pageSize);
                    callback.onSuccess(eMPageResult);
                }
                catch (HyphenateException hyphenateException) {
                    callback.onError(hyphenateException.getErrorCode(), hyphenateException.getDescription());
                }
            }
        });
    }

    public EMChatRoom fetchChatRoomFromServer(String roomId) throws HyphenateException {
        return this.fetchChatRoomFromServer(roomId, false);
    }

    public EMChatRoom fetchChatRoomFromServer(String roomId, boolean fetchMembers) throws HyphenateException {
        EMAError eMAError = new EMAError();
        EMAChatRoom eMAChatRoom = this.emaObject.fetchChatroomSpecification(roomId, eMAError, fetchMembers);
        this.handleError(eMAError);
        return new EMChatRoom(eMAChatRoom);
    }

    public void asyncFetchChatRoomFromServer(final String roomId, final EMValueCallBack<EMChatRoom> callback) {
        EMClient.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    EMChatRoom eMChatRoom = EMChatRoomManager.this.fetchChatRoomFromServer(roomId);
                    callback.onSuccess(eMChatRoom);
                }
                catch (HyphenateException hyphenateException) {
                    callback.onError(hyphenateException.getErrorCode(), hyphenateException.getDescription());
                }
            }
        });
    }

    public EMChatRoom getChatRoom(String roomId) {
        EMAChatRoom eMAChatRoom = this.emaObject.getChatroom(roomId);
        if (eMAChatRoom == null) {
            return null;
        }
        return new EMChatRoom(eMAChatRoom);
    }

    @Deprecated
    public List<EMChatRoom> getAllChatRooms() {
        return Collections.unmodifiableList(this.chatRooms);
    }

    public EMChatRoom createChatRoom(String subject, String description, String welcomeMessage, int maxUserCount, List<String> members) throws HyphenateException {
        EMAError eMAError = new EMAError();
        EMAChatRoom eMAChatRoom = this.emaObject.createChatRoom(subject, description, welcomeMessage, EMChatRoom.EMChatRoomStyle.EMChatRoomStylePublicOpenJoin.ordinal(), maxUserCount, members, eMAError);
        this.handleError(eMAError);
        return new EMChatRoom(eMAChatRoom);
    }

    public void asyncCreateChatRoom(final String subject, final String description, final String welcomeMessage, final int maxUserCount, final List<String> members, final EMValueCallBack<EMChatRoom> callBack) {
        EMClient.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    callBack.onSuccess(EMChatRoomManager.this.createChatRoom(subject, description, welcomeMessage, maxUserCount, members));
                }
                catch (HyphenateException hyphenateException) {
                    callBack.onError(hyphenateException.getErrorCode(), hyphenateException.getDescription());
                }
            }
        });
    }

    public void destroyChatRoom(String chatRoomId) throws HyphenateException {
        EMAError eMAError = new EMAError();
        this.emaObject.destroyChatroom(chatRoomId, eMAError);
        this.handleError(eMAError);
    }

    public void asyncDestroyChatRoom(final String chatRoomId, final EMCallBack callBack) {
        EMClient.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    EMChatRoomManager.this.destroyChatRoom(chatRoomId);
                    callBack.onSuccess();
                }
                catch (HyphenateException hyphenateException) {
                    callBack.onError(hyphenateException.getErrorCode(), hyphenateException.getDescription());
                }
            }
        });
    }

    public EMChatRoom changeChatRoomSubject(String chatRoomId, String newSubject) throws HyphenateException {
        EMAError eMAError = new EMAError();
        EMAChatRoom eMAChatRoom = this.emaObject.changeChatroomSubject(chatRoomId, newSubject, eMAError);
        this.handleError(eMAError);
        return new EMChatRoom(eMAChatRoom);
    }

    public void asyncChangeChatRoomSubject(final String chatRoomId, final String newSubject, final EMValueCallBack<EMChatRoom> callBack) {
        EMClient.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    callBack.onSuccess(EMChatRoomManager.this.changeChatRoomSubject(chatRoomId, newSubject));
                }
                catch (HyphenateException hyphenateException) {
                    callBack.onError(hyphenateException.getErrorCode(), hyphenateException.getDescription());
                }
            }
        });
    }

    public EMChatRoom changeChatroomDescription(String chatRoomId, String newDescription) throws HyphenateException {
        EMAError eMAError = new EMAError();
        EMAChatRoom eMAChatRoom = this.emaObject.changeChatroomDescription(chatRoomId, newDescription, eMAError);
        this.handleError(eMAError);
        return new EMChatRoom(eMAChatRoom);
    }

    public void asyncChangeChatroomDescription(final String chatRoomId, final String newDescription, final EMValueCallBack<EMChatRoom> callBack) {
        EMClient.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    callBack.onSuccess(EMChatRoomManager.this.changeChatroomDescription(chatRoomId, newDescription));
                }
                catch (HyphenateException hyphenateException) {
                    callBack.onError(hyphenateException.getErrorCode(), hyphenateException.getDescription());
                }
            }
        });
    }

    public EMCursorResult<String> fetchChatRoomMembers(String chatRoomId, String cursor, int pageSize) throws HyphenateException {
        EMAError eMAError = new EMAError();
        EMCursorResult<String> eMCursorResult = this.emaObject.fetchChatroomMembers(chatRoomId, cursor, pageSize, eMAError);
        this.handleError(eMAError);
        return eMCursorResult;
    }

    public void asyncFetchChatRoomMembers(final String chatRoomId, final String cursor, final int pageSize, final EMValueCallBack<EMCursorResult<String>> callBack) {
        EMClient.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    callBack.onSuccess(EMChatRoomManager.this.fetchChatRoomMembers(chatRoomId, cursor, pageSize));
                }
                catch (HyphenateException hyphenateException) {
                    callBack.onError(hyphenateException.getErrorCode(), hyphenateException.getDescription());
                }
            }
        });
    }

    public EMChatRoom muteChatRoomMembers(String chatRoomId, List<String> muteMembers, long duration) throws HyphenateException {
        EMAError eMAError = new EMAError();
        EMAChatRoom eMAChatRoom = this.emaObject.muteChatroomMembers(chatRoomId, muteMembers, duration, eMAError);
        this.handleError(eMAError);
        return new EMChatRoom(eMAChatRoom);
    }

    public void asyncMuteChatRoomMembers(final String chatRoomId, final List<String> muteMembers, final long duration, final EMValueCallBack<EMChatRoom> callBack) {
        EMClient.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    callBack.onSuccess(EMChatRoomManager.this.muteChatRoomMembers(chatRoomId, muteMembers, duration));
                }
                catch (HyphenateException hyphenateException) {
                    callBack.onError(hyphenateException.getErrorCode(), hyphenateException.getDescription());
                }
            }
        });
    }

    public EMChatRoom unMuteChatRoomMembers(String chatRoomId, List<String> members) throws HyphenateException {
        EMAError eMAError = new EMAError();
        EMAChatRoom eMAChatRoom = this.emaObject.unmuteChatRoomMembers(chatRoomId, members, eMAError);
        this.handleError(eMAError);
        return new EMChatRoom(eMAChatRoom);
    }

    public void asyncUnMuteChatRoomMembers(final String chatRoomId, final List<String> members, final EMValueCallBack<EMChatRoom> callBack) {
        EMClient.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    callBack.onSuccess(EMChatRoomManager.this.unMuteChatRoomMembers(chatRoomId, members));
                }
                catch (HyphenateException hyphenateException) {
                    callBack.onError(hyphenateException.getErrorCode(), hyphenateException.getDescription());
                }
            }
        });
    }

    public EMChatRoom changeOwner(String chatRoomId, String newOwner) throws HyphenateException {
        EMAError eMAError = new EMAError();
        EMAChatRoom eMAChatRoom = this.emaObject.transferChatroomOwner(chatRoomId, newOwner, eMAError);
        this.handleError(eMAError);
        return new EMChatRoom(eMAChatRoom);
    }

    public void asyncChangeOwner(final String chatRoomId, final String newOwner, final EMValueCallBack<EMChatRoom> callBack) throws HyphenateException {
        EMClient.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    callBack.onSuccess(EMChatRoomManager.this.changeOwner(chatRoomId, newOwner));
                }
                catch (HyphenateException hyphenateException) {
                    callBack.onError(hyphenateException.getErrorCode(), hyphenateException.getDescription());
                }
            }
        });
    }

    public EMChatRoom addChatRoomAdmin(String chatRoomId, String admin) throws HyphenateException {
        EMAError eMAError = new EMAError();
        EMAChatRoom eMAChatRoom = this.emaObject.addChatroomAdmin(chatRoomId, admin, eMAError);
        this.handleError(eMAError);
        return new EMChatRoom(eMAChatRoom);
    }

    public void asyncAddChatRoomAdmin(final String chatRoomId, final String admin, final EMValueCallBack<EMChatRoom> callBack) {
        EMClient.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    callBack.onSuccess(EMChatRoomManager.this.addChatRoomAdmin(chatRoomId, admin));
                }
                catch (HyphenateException hyphenateException) {
                    callBack.onError(hyphenateException.getErrorCode(), hyphenateException.getDescription());
                }
            }
        });
    }

    public EMChatRoom removeChatRoomAdmin(String chatRoomId, String admin) throws HyphenateException {
        EMAError eMAError = new EMAError();
        EMAChatRoom eMAChatRoom = this.emaObject.removeChatRoomAdmin(chatRoomId, admin, eMAError);
        this.handleError(eMAError);
        return new EMChatRoom(eMAChatRoom);
    }

    public void asyncRemoveChatRoomAdmin(final String chatRoomId, final String admin, final EMValueCallBack<EMChatRoom> callBack) {
        EMClient.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    callBack.onSuccess(EMChatRoomManager.this.removeChatRoomAdmin(chatRoomId, admin));
                }
                catch (HyphenateException hyphenateException) {
                    callBack.onError(hyphenateException.getErrorCode(), hyphenateException.getDescription());
                }
            }
        });
    }

    public Map<String, Long> fetchChatRoomMuteList(String chatRoomId, int pageNum, int pageSize) throws HyphenateException {
        EMAError eMAError = new EMAError();
        Map<String, Long> map = this.emaObject.fetchChatRoomMuteList(chatRoomId, pageNum, pageSize, eMAError);
        this.handleError(eMAError);
        return map;
    }

    public void asyncFetchChatRoomMuteList(final String chatRoomId, final int pageNum, final int pageSize, final EMValueCallBack<Map<String, Long>> callBack) {
        EMClient.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    callBack.onSuccess(EMChatRoomManager.this.fetchChatRoomMuteList(chatRoomId, pageNum, pageSize));
                }
                catch (HyphenateException hyphenateException) {
                    callBack.onError(hyphenateException.getErrorCode(), hyphenateException.getDescription());
                }
            }
        });
    }

    public EMChatRoom removeChatRoomMembers(String chatRoomId, List<String> members) throws HyphenateException {
        EMAError eMAError = new EMAError();
        EMAChatRoom eMAChatRoom = this.emaObject.removeChatRoomMembers(chatRoomId, members, eMAError);
        this.handleError(eMAError);
        return new EMChatRoom(eMAChatRoom);
    }

    public void asyncRemoveChatRoomMembers(final String chatRoomId, final List<String> members, final EMValueCallBack<EMChatRoom> callBack) {
        EMClient.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    callBack.onSuccess(EMChatRoomManager.this.removeChatRoomMembers(chatRoomId, members));
                }
                catch (HyphenateException hyphenateException) {
                    callBack.onError(hyphenateException.getErrorCode(), hyphenateException.getDescription());
                }
            }
        });
    }

    public EMChatRoom blockChatroomMembers(String chatRoomId, List<String> members) throws HyphenateException {
        EMAError eMAError = new EMAError();
        EMAChatRoom eMAChatRoom = this.emaObject.blockChatroomMembers(chatRoomId, members, eMAError);
        this.handleError(eMAError);
        return new EMChatRoom(eMAChatRoom);
    }

    public void asyncBlockChatroomMembers(final String chatRoomId, final List<String> members, final EMValueCallBack<EMChatRoom> callBack) {
        EMClient.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    callBack.onSuccess(EMChatRoomManager.this.blockChatroomMembers(chatRoomId, members));
                }
                catch (HyphenateException hyphenateException) {
                    callBack.onError(hyphenateException.getErrorCode(), hyphenateException.getDescription());
                }
            }
        });
    }

    public EMChatRoom unblockChatRoomMembers(String chatRoomId, List<String> members) throws HyphenateException {
        EMAError eMAError = new EMAError();
        EMAChatRoom eMAChatRoom = this.emaObject.unblockChatRoomMembers(chatRoomId, members, eMAError);
        this.handleError(eMAError);
        return new EMChatRoom(eMAChatRoom);
    }

    public void asyncUnBlockChatRoomMembers(final String chatRoomId, final List<String> members, final EMValueCallBack<EMChatRoom> callBack) {
        EMClient.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    callBack.onSuccess(EMChatRoomManager.this.unblockChatRoomMembers(chatRoomId, members));
                }
                catch (HyphenateException hyphenateException) {
                    callBack.onError(hyphenateException.getErrorCode(), hyphenateException.getDescription());
                }
            }
        });
    }

    public List<String> fetchChatRoomBlackList(String chatRoomId, int pageNum, int pageSize) throws HyphenateException {
        EMAError eMAError = new EMAError();
        List<String> list = this.emaObject.fetchChatRoomBlackList(chatRoomId, pageNum, pageSize, eMAError);
        this.handleError(eMAError);
        return list;
    }

    public void asyncFetchChatRoomBlackList(final String chatRoomId, final int pageNum, final int pageSize, final EMValueCallBack<List<String>> callBack) {
        EMClient.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    callBack.onSuccess(EMChatRoomManager.this.fetchChatRoomBlackList(chatRoomId, pageNum, pageSize));
                }
                catch (HyphenateException hyphenateException) {
                    callBack.onError(hyphenateException.getErrorCode(), hyphenateException.getDescription());
                }
            }
        });
    }

    public void addToChatRoomWhiteList(final String chatRoomId, final List<String> members, final EMValueCallBack<EMChatRoom> callBack) {
        EMClient.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    EMAError eMAError = new EMAError();
                    EMAChatRoom eMAChatRoom = EMChatRoomManager.this.emaObject.addToWhiteList(chatRoomId, members, eMAError);
                    EMChatRoomManager.this.handleError(eMAError);
                    callBack.onSuccess(new EMChatRoom(eMAChatRoom));
                }
                catch (HyphenateException hyphenateException) {
                    callBack.onError(hyphenateException.getErrorCode(), hyphenateException.getDescription());
                }
            }
        });
    }

    public void removeFromChatRoomWhiteList(final String chatRoomId, final List<String> members, final EMValueCallBack<EMChatRoom> callBack) {
        EMClient.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    EMAError eMAError = new EMAError();
                    EMAChatRoom eMAChatRoom = EMChatRoomManager.this.emaObject.removeFromWhiteList(chatRoomId, members, eMAError);
                    EMChatRoomManager.this.handleError(eMAError);
                    callBack.onSuccess(new EMChatRoom(eMAChatRoom));
                }
                catch (HyphenateException hyphenateException) {
                    callBack.onError(hyphenateException.getErrorCode(), hyphenateException.getDescription());
                }
            }
        });
    }

    public void checkIfInChatRoomWhiteList(final String chatRoomId, final EMValueCallBack<Boolean> callBack) {
        EMClient.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    EMAError eMAError = new EMAError();
                    Boolean bl = EMChatRoomManager.this.emaObject.checkIfInWhiteList(chatRoomId, eMAError);
                    EMChatRoomManager.this.handleError(eMAError);
                    callBack.onSuccess(bl);
                }
                catch (HyphenateException hyphenateException) {
                    callBack.onError(hyphenateException.getErrorCode(), hyphenateException.getDescription());
                }
            }
        });
    }

    public void asyncCheckIfInMuteList(final String chatRoomId, final EMValueCallBack<Boolean> callBack) {
        EMClient.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    EMAError eMAError = new EMAError();
                    Boolean bl = EMChatRoomManager.this.emaObject.checkIfBeMuted(chatRoomId, eMAError);
                    EMChatRoomManager.this.handleError(eMAError);
                    callBack.onSuccess(bl);
                }
                catch (HyphenateException hyphenateException) {
                    callBack.onError(hyphenateException.getErrorCode(), hyphenateException.getDescription());
                }
            }
        });
    }

    public void fetchChatRoomWhiteList(final String chatRoomId, final EMValueCallBack<List<String>> callBack) {
        EMClient.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    EMAError eMAError = new EMAError();
                    List<String> list = EMChatRoomManager.this.emaObject.fetchChatRoomWhiteList(chatRoomId, eMAError);
                    EMChatRoomManager.this.handleError(eMAError);
                    callBack.onSuccess(list);
                }
                catch (HyphenateException hyphenateException) {
                    callBack.onError(hyphenateException.getErrorCode(), hyphenateException.getDescription());
                }
            }
        });
    }

    public void muteAllMembers(final String chatRoomId, final EMValueCallBack<EMChatRoom> callBack) {
        EMClient.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    EMAError eMAError = new EMAError();
                    EMAChatRoom eMAChatRoom = EMChatRoomManager.this.emaObject.muteAllMembers(chatRoomId, eMAError);
                    EMChatRoomManager.this.handleError(eMAError);
                    callBack.onSuccess(new EMChatRoom(eMAChatRoom));
                }
                catch (HyphenateException hyphenateException) {
                    callBack.onError(hyphenateException.getErrorCode(), hyphenateException.getDescription());
                }
            }
        });
    }

    public void unmuteAllMembers(final String chatRoomId, final EMValueCallBack<EMChatRoom> callBack) {
        EMClient.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    EMAError eMAError = new EMAError();
                    EMAChatRoom eMAChatRoom = EMChatRoomManager.this.emaObject.unmuteAllMembers(chatRoomId, eMAError);
                    EMChatRoomManager.this.handleError(eMAError);
                    callBack.onSuccess(new EMChatRoom(eMAChatRoom));
                }
                catch (HyphenateException hyphenateException) {
                    callBack.onError(hyphenateException.getErrorCode(), hyphenateException.getDescription());
                }
            }
        });
    }

    public void updateChatRoomAnnouncement(String chatRoomId, String announcement) throws HyphenateException {
        EMAError eMAError = new EMAError();
        this.emaObject.updateChatRoomAnnouncement(chatRoomId, announcement, eMAError);
        this.handleError(eMAError);
    }

    public void asyncUpdateChatRoomAnnouncement(final String chatRoomId, final String announcement, final EMCallBack callBack) {
        EMClient.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    EMChatRoomManager.this.updateChatRoomAnnouncement(chatRoomId, announcement);
                    callBack.onSuccess();
                }
                catch (HyphenateException hyphenateException) {
                    callBack.onError(hyphenateException.getErrorCode(), hyphenateException.getDescription());
                }
            }
        });
    }

    public String fetchChatRoomAnnouncement(String chatRoomId) throws HyphenateException {
        EMAError eMAError = new EMAError();
        String string = this.emaObject.fetchChatRoomAnnouncement(chatRoomId, eMAError);
        this.handleError(eMAError);
        return string;
    }

    public void asyncFetchChatRoomAnnouncement(final String chatRoomId, final EMValueCallBack<String> callBack) {
        EMClient.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    callBack.onSuccess(EMChatRoomManager.this.fetchChatRoomAnnouncement(chatRoomId));
                }
                catch (HyphenateException hyphenateException) {
                    callBack.onError(hyphenateException.getErrorCode(), hyphenateException.getDescription());
                }
            }
        });
    }

    private Map<String, Integer> setChatroomAttribute(String chatRoomId, Map<String, String> attributeMap, boolean autoDelete) throws HyphenateException {
        EMAError eMAError = new EMAError();
        String string = this.emaObject.setChatroomAttributes(chatRoomId, this.toJsonString(attributeMap, autoDelete), false, eMAError);
        this.handlePartialError(eMAError);
        return this.parseCodeJson(string);
    }

    private Map<String, Integer> setChatroomAttributes(String chatRoomId, Map<String, String> attributeMap, boolean autoDelete, EMAError error) {
        String string = this.emaObject.setChatroomAttributes(chatRoomId, this.toJsonString(attributeMap, autoDelete), false, error);
        return this.parseCodeJson(string);
    }

    public void asyncSetChatroomAttributes(final String chatRoomId, final Map<String, String> attributeMap, final boolean autoDelete, final @NonNull EMResultCallBack<Map<String, Integer>> callBack) {
        EMClient.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                if (null == attributeMap || attributeMap.size() == 0) {
                    callBack.onResult(110, new HashMap());
                    return;
                }
                EMAError eMAError = new EMAError();
                Map map = EMChatRoomManager.this.setChatroomAttributes(chatRoomId, attributeMap, autoDelete, eMAError);
                callBack.onResult(eMAError.errCode(), map);
            }
        });
    }

    public void asyncSetChatroomAttribute(final String chatRoomId, final String key, final String value, final boolean autoDelete, final @NonNull EMCallBack callBack) {
        EMClient.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    if (TextUtils.isEmpty((CharSequence)key)) {
                        callBack.onError(110, "add Attributes key Cannot be an empty string");
                        return;
                    }
                    HashMap<String, String> hashMap = new HashMap<String, String>();
                    hashMap.put(key, value);
                    EMChatRoomManager.this.setChatroomAttribute(chatRoomId, hashMap, autoDelete);
                    callBack.onSuccess();
                }
                catch (HyphenateException hyphenateException) {
                    callBack.onError(hyphenateException.getErrorCode(), hyphenateException.getDescription());
                }
            }
        });
    }

    private Map<String, Integer> setChatroomAttributeForced(String chatRoomId, Map<String, String> attributeMap, boolean autoDelete) throws HyphenateException {
        EMAError eMAError = new EMAError();
        String string = this.emaObject.setChatroomAttributes(chatRoomId, this.toJsonString(attributeMap, autoDelete), true, eMAError);
        this.handlePartialError(eMAError);
        return this.parseCodeJson(string);
    }

    private Map<String, Integer> setChatroomAttributesForced(String chatRoomId, Map<String, String> attributeMap, boolean autoDelete, EMAError error) {
        String string = this.emaObject.setChatroomAttributes(chatRoomId, this.toJsonString(attributeMap, autoDelete), true, error);
        return this.parseCodeJson(string);
    }

    public void asyncSetChatroomAttributesForced(final String chatRoomId, final Map<String, String> attributeMap, final boolean autoDelete, final @NonNull EMResultCallBack<Map<String, Integer>> callBack) {
        EMClient.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                if (null == attributeMap || attributeMap.size() == 0) {
                    callBack.onResult(110, new HashMap());
                    return;
                }
                EMAError eMAError = new EMAError();
                Map map = EMChatRoomManager.this.setChatroomAttributesForced(chatRoomId, attributeMap, autoDelete, eMAError);
                callBack.onResult(eMAError.errCode(), map);
            }
        });
    }

    public void asyncSetChatroomAttributeForced(final String chatRoomId, final String key, final String value, final boolean autoDelete, final @NonNull EMCallBack callBack) {
        EMClient.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    if (TextUtils.isEmpty((CharSequence)key)) {
                        callBack.onError(110, "add Attributes key Cannot be an empty string");
                        return;
                    }
                    HashMap<String, String> hashMap = new HashMap<String, String>();
                    hashMap.put(key, value);
                    EMChatRoomManager.this.setChatroomAttributeForced(chatRoomId, hashMap, autoDelete);
                    callBack.onSuccess();
                }
                catch (HyphenateException hyphenateException) {
                    callBack.onError(hyphenateException.getErrorCode(), hyphenateException.getDescription());
                }
            }
        });
    }

    private Map<String, String> fetchChatroomAttributes(String chatRoomId, List<String> keyList) throws HyphenateException {
        EMAError eMAError = new EMAError();
        String string = this.emaObject.fetchChatroomAttributes(chatRoomId, keyList, eMAError);
        this.handleError(eMAError);
        return this.parseJson(string);
    }

    public void asyncFetchChatroomAttributesFromServer(final String chatRoomId, final List<String> keyList, final @NonNull EMValueCallBack<Map<String, String>> callBack) {
        EMClient.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    callBack.onSuccess(EMChatRoomManager.this.fetchChatroomAttributes(chatRoomId, keyList));
                }
                catch (HyphenateException hyphenateException) {
                    callBack.onError(hyphenateException.getErrorCode(), hyphenateException.getDescription());
                }
            }
        });
    }

    public void asyncFetchChatRoomAllAttributesFromServer(final String chatRoomId, final @NonNull EMValueCallBack<Map<String, String>> callBack) {
        EMClient.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    callBack.onSuccess(EMChatRoomManager.this.fetchChatroomAttributes(chatRoomId, null));
                }
                catch (HyphenateException hyphenateException) {
                    callBack.onError(hyphenateException.getErrorCode(), hyphenateException.getDescription());
                }
            }
        });
    }

    private Map<String, Integer> removeChatroomAttribute(String chatRoomId, List<String> keyList) throws HyphenateException {
        EMAError eMAError = new EMAError();
        String string = this.emaObject.removeChatroomAttributes(chatRoomId, keyList, false, eMAError);
        this.handlePartialError(eMAError);
        return this.parseCodeJson(string);
    }

    private Map<String, Integer> removeChatroomAttributes(String chatRoomId, List<String> keyList, EMAError error) {
        String string = this.emaObject.removeChatroomAttributes(chatRoomId, keyList, false, error);
        return this.parseCodeJson(string);
    }

    public void asyncRemoveChatRoomAttributesFromServer(final String chatRoomId, final List<String> keyList, final @NonNull EMResultCallBack<Map<String, Integer>> callBack) {
        EMClient.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                if (null == keyList || keyList.size() == 0) {
                    callBack.onResult(110, new HashMap());
                    return;
                }
                EMAError eMAError = new EMAError();
                Map map = EMChatRoomManager.this.removeChatroomAttributes(chatRoomId, keyList, eMAError);
                callBack.onResult(eMAError.errCode(), map);
            }
        });
    }

    public void asyncRemoveChatRoomAttributeFromServer(final String chatRoomId, final String key, final @NonNull EMCallBack callBack) {
        EMClient.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    if (TextUtils.isEmpty((CharSequence)key)) {
                        callBack.onError(110, "remove Attribute key Cannot be an empty string");
                        return;
                    }
                    ArrayList<String> arrayList = new ArrayList<String>();
                    arrayList.add(key);
                    EMChatRoomManager.this.removeChatroomAttribute(chatRoomId, arrayList);
                    callBack.onSuccess();
                }
                catch (HyphenateException hyphenateException) {
                    callBack.onError(hyphenateException.getErrorCode(), hyphenateException.getDescription());
                }
            }
        });
    }

    private Map<String, Integer> removeChatroomAttributeForced(String chatRoomId, List<String> keyList) throws HyphenateException {
        EMAError eMAError = new EMAError();
        String string = this.emaObject.removeChatroomAttributes(chatRoomId, keyList, true, eMAError);
        this.handlePartialError(eMAError);
        return this.parseCodeJson(string);
    }

    private Map<String, Integer> removeChatroomAttributesForced(String chatRoomId, List<String> keyList, EMAError error) {
        String string = this.emaObject.removeChatroomAttributes(chatRoomId, keyList, true, error);
        return this.parseCodeJson(string);
    }

    public void asyncRemoveChatRoomAttributesFromServerForced(final String chatRoomId, final List<String> keyList, final @NonNull EMResultCallBack<Map<String, Integer>> callBack) {
        EMClient.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                if (null == keyList || keyList.size() == 0) {
                    callBack.onResult(110, new HashMap());
                    return;
                }
                EMAError eMAError = new EMAError();
                Map map = EMChatRoomManager.this.removeChatroomAttributesForced(chatRoomId, keyList, eMAError);
                callBack.onResult(eMAError.errCode(), map);
            }
        });
    }

    public void asyncRemoveChatRoomAttributeFromServerForced(final String chatRoomId, final String key, final @NonNull EMCallBack callBack) {
        EMClient.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    if (TextUtils.isEmpty((CharSequence)key)) {
                        callBack.onError(110, "remove Attribute key Cannot be an empty string");
                        return;
                    }
                    ArrayList<String> arrayList = new ArrayList<String>();
                    arrayList.add(key);
                    EMChatRoomManager.this.removeChatroomAttributeForced(chatRoomId, arrayList);
                    callBack.onSuccess();
                }
                catch (HyphenateException hyphenateException) {
                    callBack.onError(hyphenateException.getErrorCode(), hyphenateException.getDescription());
                }
            }
        });
    }

    private void handleError(EMAError error) throws HyphenateException {
        if (error.errCode() != 0) {
            throw new HyphenateException(error);
        }
    }

    private void handlePartialError(EMAError error) throws HyphenateException {
        if (error.errCode() != 0 && error.errCode() != 7) {
            throw new HyphenateException(error);
        }
    }

    private Map<String, String> parseJson(String jsonString) throws HyphenateException {
        if (TextUtils.isEmpty((CharSequence)jsonString)) {
            return null;
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        try {
            JSONObject jSONObject = new JSONObject(jsonString);
            Iterator iterator = jSONObject.keys();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                String string2 = jSONObject.getString(string);
                hashMap.put(string, string2);
            }
            return hashMap;
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
            throw new HyphenateException(303, "Unknown server error");
        }
    }

    private Map<String, Integer> parseCodeJson(String jsonString) {
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        if (TextUtils.isEmpty((CharSequence)jsonString)) {
            return hashMap;
        }
        try {
            JSONObject jSONObject = new JSONObject(jsonString);
            Iterator iterator = jSONObject.keys();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                int n = jSONObject.getInt(string);
                hashMap.put(string, n);
            }
        }
        catch (JSONException jSONException) {
            EMLog.e("parseCodeJson", jSONException.getMessage());
        }
        return hashMap;
    }

    private Map<String, String> parseJsonUpdate(String jsonString) {
        if (TextUtils.isEmpty((CharSequence)jsonString)) {
            return null;
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        try {
            ArrayList<String> arrayList = new ArrayList<String>();
            JSONObject jSONObject = new JSONObject(jsonString);
            JSONObject jSONObject2 = jSONObject.getJSONObject("result");
            JSONArray jSONArray = jSONObject2.getJSONArray("successKeys");
            for (int i = 0; i < jSONArray.length(); ++i) {
                arrayList.add(jSONArray.getString(i));
            }
            JSONObject jSONObject3 = jSONObject.getJSONObject("properties");
            Iterator iterator = jSONObject3.keys();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                String string2 = jSONObject3.getString(string);
                if (!arrayList.contains(string)) continue;
                hashMap.put(string, string2);
            }
            return hashMap;
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
            return null;
        }
    }

    private List<String> parseJsonRemove(String jsonString) {
        if (TextUtils.isEmpty((CharSequence)jsonString)) {
            return null;
        }
        try {
            ArrayList<String> arrayList = new ArrayList<String>();
            JSONObject jSONObject = new JSONObject(jsonString);
            JSONObject jSONObject2 = jSONObject.getJSONObject("result");
            JSONArray jSONArray = jSONObject2.getJSONArray("successKeys");
            for (int i = 0; i < jSONArray.length(); ++i) {
                arrayList.add(jSONArray.getString(i));
            }
            return arrayList;
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
            return null;
        }
    }

    private String toJsonString(Map<String, String> extJson, boolean autoDelete) {
        JSONObject jSONObject = null;
        try {
            jSONObject = new JSONObject();
            jSONObject.put("metaData", (Object)new JSONObject(extJson));
            if (autoDelete) {
                jSONObject.put("autoDelete", (Object)"DELETE");
            } else {
                jSONObject.put("autoDelete", (Object)"NO_DELETE");
            }
            return jSONObject.toString();
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
            return "";
        }
    }

    void onLogout() {
        this.chatRoomListeners.clear();
    }
}

