/*
 * Decompiled with CFR 0.152.
 */
package com.hyphenate.chat;

import android.graphics.BitmapFactory;
import android.net.Uri;
import android.text.TextUtils;
import android.util.Log;
import com.hyphenate.EMCallBack;
import com.hyphenate.EMConversationListener;
import com.hyphenate.EMMessageListener;
import com.hyphenate.EMValueCallBack;
import com.hyphenate.chat.EMClient;
import com.hyphenate.chat.EMCmdMessageBody;
import com.hyphenate.chat.EMConversation;
import com.hyphenate.chat.EMCursorResult;
import com.hyphenate.chat.EMFileMessageBody;
import com.hyphenate.chat.EMGroupReadAck;
import com.hyphenate.chat.EMImageMessageBody;
import com.hyphenate.chat.EMLanguage;
import com.hyphenate.chat.EMMessage;
import com.hyphenate.chat.EMMessageReaction;
import com.hyphenate.chat.EMMessageReactionChange;
import com.hyphenate.chat.EMOptions;
import com.hyphenate.chat.EMVideoMessageBody;
import com.hyphenate.chat.adapter.EMAChatManager;
import com.hyphenate.chat.adapter.EMAChatManagerListener;
import com.hyphenate.chat.adapter.EMAConversation;
import com.hyphenate.chat.adapter.EMAError;
import com.hyphenate.chat.adapter.EMAGroupReadAck;
import com.hyphenate.chat.adapter.EMAMessageReaction;
import com.hyphenate.chat.adapter.EMAMessageReactionChange;
import com.hyphenate.chat.adapter.EMAReactionManager;
import com.hyphenate.chat.adapter.EMAReactionManagerListener;
import com.hyphenate.chat.adapter.message.EMAFileMessageBody;
import com.hyphenate.chat.adapter.message.EMAMessage;
import com.hyphenate.chat.adapter.message.EMAMessageBody;
import com.hyphenate.chat.core.EMAdvanceDebugManager;
import com.hyphenate.exceptions.HyphenateException;
import com.hyphenate.notification.core.b;
import com.hyphenate.util.EMFileHelper;
import com.hyphenate.util.EMLog;
import com.hyphenate.util.ImageUtils;
import com.hyphenate.util.PathUtil;
import java.io.File;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;

public class EMChatManager {
    EMAChatManager emaObject;
    EMAReactionManager emaReactionObject;
    private static final String TAG = "EMChatManager";
    private static final String INTERNAL_ACTION_PREFIX = "em_";
    EMClient mClient;
    Map<String, EMConversation.MessageCache> caches = new Hashtable<String, EMConversation.MessageCache>();
    private List<EMMessageListener> messageListeners = new CopyOnWriteArrayList<EMMessageListener>();
    private List<EMConversationListener> conversationListeners = Collections.synchronizedList(new ArrayList());
    EMAChatManagerListener chatManagerListenerImpl = new EMAChatManagerListener(){

        @Override
        public void onReceiveMessages(final List<EMAMessage> messages) {
            EMChatManager.this.mClient.executeOnMainQueue(new Runnable(){

                @Override
                public void run() {
                    ArrayList<EMMessage> arrayList = new ArrayList<EMMessage>();
                    for (Iterator iterator : messages) {
                        arrayList.add(new EMMessage((EMAMessage)((Object)iterator)));
                    }
                    ArrayList arrayList2 = new ArrayList();
                    for (EMMessage object : arrayList) {
                        EMConversation eMConversation = EMChatManager.this.getConversation(object.conversationId(), EMConversation.msgType2ConversationType(object.getFrom(), object.getChatType()), false);
                        if (eMConversation == null) {
                            EMLog.d(EMChatManager.TAG, "no conversation");
                            continue;
                        }
                        if (object.getType() != EMMessage.Type.CMD) {
                            eMConversation.getCache().addMessage(object);
                        }
                        arrayList2.add(object);
                    }
                    if (arrayList2.size() <= 0) {
                        EMLog.d(EMChatManager.TAG, "no remainingMsgs");
                        return;
                    }
                    for (EMMessageListener eMMessageListener : EMChatManager.this.messageListeners) {
                        try {
                            EMLog.d(EMChatManager.TAG, "onMessageReceived\uff1a " + eMMessageListener);
                            eMMessageListener.onMessageReceived(arrayList2);
                        }
                        catch (Exception exception) {
                            EMLog.d(EMChatManager.TAG, "onMessageReceived has problem: " + exception.getMessage());
                            exception.printStackTrace();
                        }
                    }
                }
            });
        }

        @Override
        public void onReceiveCmdMessages(final List<EMAMessage> messages) {
            EMChatManager.this.mClient.executeOnMainQueue(new Runnable(){

                @Override
                public void run() {
                    ArrayList<EMMessage> arrayList = new ArrayList<EMMessage>();
                    for (Object object : messages) {
                        EMMessage eMMessage = new EMMessage((EMAMessage)object);
                        String string = ((EMCmdMessageBody)eMMessage.getBody()).action();
                        if (EMChatManager.this.isAdvanceDebugMessage(string)) {
                            EMAdvanceDebugManager.a().a(eMMessage, EMAdvanceDebugManager.Type.valueOf(string));
                            continue;
                        }
                        arrayList.add(eMMessage);
                    }
                    try {
                        for (Object object : EMChatManager.this.messageListeners) {
                            object.onCmdMessageReceived(arrayList);
                        }
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            });
        }

        @Override
        public void onMessageStatusChanged(final EMAMessage message, EMAError error) {
            EMChatManager.this.mClient.executeOnMainQueue(new Runnable(){

                @Override
                public void run() {
                    try {
                        EMMessage eMMessage = new EMMessage(message);
                        for (EMMessageListener eMMessageListener : EMChatManager.this.messageListeners) {
                            eMMessageListener.onMessageChanged(eMMessage, null);
                        }
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            });
        }

        @Override
        public void onMessageAttachmentsStatusChanged(EMAMessage message, EMAError error) {
            try {
                EMMessage eMMessage = new EMMessage(message);
                for (EMMessageListener eMMessageListener : EMChatManager.this.messageListeners) {
                    eMMessageListener.onMessageChanged(eMMessage, null);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }

        @Override
        public void onReceiveRecallMessages(final List<EMAMessage> messages) {
            EMChatManager.this.mClient.executeOnMainQueue(new Runnable(){

                @Override
                public void run() {
                    ArrayList<EMMessage> arrayList = new ArrayList<EMMessage>();
                    for (Object object : messages) {
                        arrayList.add(new EMMessage((EMAMessage)object));
                        EMChatManager.this.getConversation(((EMAMessage)object).conversationId()).getCache().removeMessage(((EMAMessage)object).msgId());
                    }
                    try {
                        for (Object object : EMChatManager.this.messageListeners) {
                            object.onMessageRecalled(arrayList);
                        }
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            });
        }

        @Override
        public void onReceiveHasReadAcks(final List<EMAMessage> messages) {
            EMChatManager.this.mClient.executeOnMainQueue(new Runnable(){

                @Override
                public void run() {
                    ArrayList<EMMessage> arrayList = new ArrayList<EMMessage>();
                    for (Object object : messages) {
                        arrayList.add(new EMMessage((EMAMessage)object));
                    }
                    try {
                        for (Object object : EMChatManager.this.messageListeners) {
                            object.onMessageRead(arrayList);
                        }
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            });
        }

        @Override
        public void onReceiveHasDeliveredAcks(final List<EMAMessage> messages) {
            EMChatManager.this.mClient.executeOnMainQueue(new Runnable(){

                @Override
                public void run() {
                    ArrayList<EMMessage> arrayList = new ArrayList<EMMessage>();
                    for (Object object : messages) {
                        arrayList.add(new EMMessage((EMAMessage)object));
                    }
                    try {
                        for (Object object : EMChatManager.this.messageListeners) {
                            object.onMessageDelivered(arrayList);
                        }
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            });
        }

        @Override
        public void onReceiveReadAckForConversation(final String fromUsername, final String toUsername) {
            EMChatManager.this.mClient.executeOnMainQueue(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    EMLog.d(EMChatManager.TAG, "onReceiveConversationHasReadAcks");
                    List list = EMChatManager.this.conversationListeners;
                    synchronized (list) {
                        Object object;
                        if (!TextUtils.equals((CharSequence)fromUsername, (CharSequence)EMClient.getInstance().getCurrentUser()) && (object = EMClient.getInstance().chatManager().getConversation(fromUsername)) != null) {
                            ((EMConversation)object).loadMoreMsgFromDB(null, ((EMConversation)object).getAllMessages().size());
                        }
                        try {
                            for (EMConversationListener eMConversationListener : EMChatManager.this.conversationListeners) {
                                eMConversationListener.onConversationRead(fromUsername, toUsername);
                            }
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                    }
                }
            });
        }

        @Override
        public void onUpdateConversationList(List<EMAConversation> conversations) {
            EMChatManager.this.mClient.executeOnMainQueue(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    EMLog.d(EMChatManager.TAG, "onUpdateConversationList");
                    List list = EMChatManager.this.conversationListeners;
                    synchronized (list) {
                        try {
                            for (EMConversationListener eMConversationListener : EMChatManager.this.conversationListeners) {
                                eMConversationListener.onConversationUpdate();
                            }
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                    }
                }
            });
        }

        @Override
        public void onReceivePrivateMessages(final List<EMAMessage> messages) {
            EMChatManager.this.mClient.executeOnMainQueue(new Runnable(){

                @Override
                public void run() {
                    EMLog.d(EMChatManager.TAG, "onPrivateMessages");
                    for (EMAMessage eMAMessage : messages) {
                        EMMessage eMMessage = new EMMessage(eMAMessage);
                        b.a().a(eMMessage);
                    }
                }
            });
        }

        @Override
        public void onReceiveReadAcksForGroupMessage(final List<EMAGroupReadAck> acks) {
            EMChatManager.this.mClient.executeOnMainQueue(new Runnable(){

                @Override
                public void run() {
                    EMLog.d(EMChatManager.TAG, "onReceiveReadAcksForGroupMessage");
                    ArrayList<EMGroupReadAck> arrayList = new ArrayList<EMGroupReadAck>();
                    for (Object object : acks) {
                        arrayList.add(new EMGroupReadAck((EMAGroupReadAck)object));
                    }
                    try {
                        for (Object object : EMChatManager.this.messageListeners) {
                            object.onGroupMessageRead(arrayList);
                        }
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            });
        }

        @Override
        public void onUpdateGroupAcks() {
            EMChatManager.this.mClient.executeOnMainQueue(new Runnable(){

                @Override
                public void run() {
                    EMLog.d(EMChatManager.TAG, "onUpdateGroupAcks");
                    try {
                        for (EMMessageListener eMMessageListener : EMChatManager.this.messageListeners) {
                            eMMessageListener.onReadAckForGroupMessageUpdated();
                        }
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            });
        }
    };
    EMAReactionManagerListener mReactionManagerListenerImpl = new EMAReactionManagerListener(){

        @Override
        public void onMessageReactionDidChange(final List<EMAMessageReactionChange> reactionChangeList) {
            EMChatManager.this.mClient.executeOnMainQueue(new Runnable(){

                @Override
                public void run() {
                    EMLog.d(EMChatManager.TAG, "onMessageReactionDidChange");
                    ArrayList<EMMessageReactionChange> arrayList = new ArrayList<EMMessageReactionChange>(reactionChangeList.size());
                    for (Object object : reactionChangeList) {
                        EMMessageReactionChange eMMessageReactionChange = new EMMessageReactionChange((EMAMessageReactionChange)object);
                        arrayList.add(eMMessageReactionChange);
                    }
                    for (Object object : EMChatManager.this.messageListeners) {
                        try {
                            object.onReactionChanged(arrayList);
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                    }
                }
            });
        }
    };
    private static final int LIST_SIZE = 512;

    protected EMChatManager() {
    }

    protected EMChatManager(EMClient client, EMAChatManager manager, EMAReactionManager reactionManager) {
        this.mClient = client;
        this.emaObject = manager;
        this.emaObject.addListener(this.chatManagerListenerImpl);
        this.emaReactionObject = reactionManager;
        this.emaReactionObject.addListener(this.mReactionManagerListenerImpl);
    }

    private boolean isAdvanceDebugMessage(String action) {
        if (action.startsWith(INTERNAL_ACTION_PREFIX)) {
            try {
                EMAdvanceDebugManager.Type.valueOf(action);
                return true;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return false;
    }

    public void sendMessage(final EMMessage msg) {
        msg.makeCallbackStrong();
        boolean bl = msg.getType() != EMMessage.Type.CMD;
        final EMConversation eMConversation = this.getConversation(msg.conversationId(), EMConversation.msgType2ConversationType(msg.getTo(), msg.getChatType()), bl, msg.isChatThreadMessage());
        if (eMConversation != null) {
            boolean bl2;
            boolean bl3 = bl2 = eMConversation.getCache().getMessage(msg.getMsgId()) != null;
            if (!bl2) {
                long l = System.currentTimeMillis();
                EMMessage eMMessage = eMConversation.getLastMessage();
                if (eMMessage != null) {
                    l = l < eMMessage.getMsgTime() ? eMMessage.getMsgTime() : l;
                }
                msg.setMsgTime(l + 1L);
                eMConversation.getCache().addMessage(msg);
            }
        }
        this.mClient.executeOnSendQueue(new Runnable(){

            @Override
            public void run() {
                class HandleError {
                    final /* synthetic */ EMMessage val$msg;

                    HandleError(int code, String desc) {
                        this.val$msg = eMMessage;
                        EMMessage.EMCallbackHolder eMCallbackHolder = this.val$msg.messageStatusCallBack;
                        if (eMCallbackHolder != null) {
                            eMCallbackHolder.onError(code, desc);
                        }
                    }
                }
                try {
                    Object object;
                    String string = null;
                    if (EMChatManager.this.mClient.getOptions().getAutoTransferMessageAttachments()) {
                        if (msg.getType() == EMMessage.Type.IMAGE) {
                            Object object2;
                            msg.setStatus(EMMessage.Status.INPROGRESS);
                            object = (EMImageMessageBody)msg.getBody();
                            if (object == null) {
                                new HandleError(EMChatManager.this, 1, "Message body can not be null", msg);
                                return;
                            }
                            String string2 = ((EMFileMessageBody)object).getLocalUrl();
                            String string3 = ((EMFileMessageBody)object).getRemoteUrl();
                            if (TextUtils.isEmpty((CharSequence)string3) && !EMFileHelper.getInstance().isFileExist(string2)) {
                                new HandleError(EMChatManager.this, 401, "File not exists or can not be read", msg);
                                return;
                            }
                            if (!((EMImageMessageBody)object).isSendOriginalImage() && EMFileHelper.getInstance().isFileExist(string2)) {
                                object2 = ImageUtils.getScaledImageByUri(EMChatManager.this.mClient.getContext(), string2);
                                if (!TextUtils.equals((CharSequence)object2, (CharSequence)string2)) {
                                    string = string2;
                                    long l = EMFileHelper.getInstance().getFileLength(string2);
                                    long l2 = EMFileHelper.getInstance().getFileLength((String)object2);
                                    if (l == 0L) {
                                        EMLog.d(EMChatManager.TAG, "original image size:" + l);
                                        new HandleError(EMChatManager.this, 401, "original image size is 0", msg);
                                        return;
                                    }
                                    EMLog.d(EMChatManager.TAG, "original image size:" + l + " scaled image size:" + l2 + " ratio:" + (int)(l2 / l) + "%");
                                    string2 = object2;
                                    ((EMFileMessageBody)object).setLocalUrl(EMFileHelper.getInstance().formatInUri(string2));
                                    ((EMFileMessageBody)object).setFileLength(l2);
                                }
                                ((EMFileMessageBody)object).setFileName(EMFileHelper.getInstance().getFilename(string2));
                            }
                            if ((object2 = ImageUtils.getBitmapOptions(EMChatManager.this.mClient.getContext(), string2)) != null) {
                                int n = object2.outWidth;
                                int n2 = object2.outHeight;
                                ((EMImageMessageBody)object).setSize(n, n2);
                            }
                        } else if (msg.getType() == EMMessage.Type.VIDEO) {
                            msg.setStatus(EMMessage.Status.INPROGRESS);
                            object = (EMVideoMessageBody)msg.getBody();
                            if (object == null) {
                                new HandleError(EMChatManager.this, 1, "Message body can not be null", msg);
                                return;
                            }
                            Uri uri = ((EMFileMessageBody)object).getLocalUri();
                            String string4 = ((EMFileMessageBody)object).getRemoteUrl();
                            if (TextUtils.isEmpty((CharSequence)string4) && !EMFileHelper.getInstance().isFileExist(uri)) {
                                new HandleError(EMChatManager.this, 401, "File not exists or can not be read", msg);
                                return;
                            }
                            String string5 = EMFileHelper.getInstance().getFilePath(((EMVideoMessageBody)object).getLocalThumbUri());
                            if (!TextUtils.isEmpty((CharSequence)string5)) {
                                BitmapFactory.Options options = ImageUtils.getBitmapOptions(string5);
                                int n = options.outWidth;
                                int n3 = options.outHeight;
                                ((EMVideoMessageBody)object).setThumbnailSize(n, n3);
                            }
                        }
                    }
                    object = msg.getMsgId();
                    EMChatManager.this.setMessageSendCallback(msg, eMConversation, (String)object, string);
                    EMChatManager.this.emaObject.sendMessage((EMAMessage)msg.emaObject);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    new HandleError(EMChatManager.this, 1, "send message failed", msg);
                }
            }
        });
    }

    private void setMessageSendCallback(final EMMessage msg, final EMConversation conv, final String oldId, final String originImagePath) {
        if (msg == null) {
            return;
        }
        msg.setInnerCallback(new EMCallBack(){

            @Override
            public void onSuccess() {
                if (conv != null) {
                    conv.getCache().removeMessage(oldId);
                    conv.getCache().addMessage(msg);
                }
                if (originImagePath != null) {
                    if (!EMFileHelper.getInstance().isFileExist(originImagePath)) {
                        return;
                    }
                    if (msg.getBody() instanceof EMImageMessageBody) {
                        String string = ((EMImageMessageBody)msg.getBody()).getLocalUrl();
                        EMLog.d(EMChatManager.TAG, "origin: + " + originImagePath + ", scale:" + string);
                        if (string != null && !string.equals(originImagePath)) {
                            boolean bl = EMFileHelper.getInstance().deletePrivateFile(string);
                            EMLog.d(EMChatManager.TAG, "Deleted the scale image file: " + bl + " the scale image file path: " + string);
                        }
                        ((EMImageMessageBody)msg.getBody()).setLocalUrl(originImagePath);
                        EMChatManager.this.updateMessage(msg);
                    }
                }
            }

            @Override
            public void onProgress(int progress, String status) {
            }

            @Override
            public void onError(int code, String error) {
            }
        });
    }

    public void ackConversationRead(String conversationId) throws HyphenateException {
        EMAError eMAError = new EMAError();
        this.emaObject.sendReadAckForConversation(conversationId, eMAError);
        this.handleError(eMAError);
    }

    public void ackMessageRead(String to, String messageId) throws HyphenateException {
        EMOptions eMOptions = EMClient.getInstance().getChatConfigPrivate().b();
        if (!eMOptions.getRequireAck()) {
            EMLog.d(TAG, "As the chat option SetRequireAck is set to false, the read receipt is not sent.");
            return;
        }
        if (TextUtils.isEmpty((CharSequence)to)) {
            EMLog.e(TAG, "The to parameter cannot be null.");
            return;
        }
        EMAMessage eMAMessage = this.emaObject.getMessage(messageId);
        if (eMAMessage != null) {
            this.emaObject.sendReadAckForMessage(eMAMessage);
        } else {
            EMAMessage eMAMessage2 = EMAMessage.createReceiveMessage("", EMMessage.self(), null, EMMessage.ChatType.Chat.ordinal());
            eMAMessage2.setMsgId(messageId);
            eMAMessage2.setFrom(to);
            eMAMessage2.setConversationId(to);
            this.emaObject.sendReadAckForMessage(eMAMessage2);
        }
    }

    public void ackGroupMessageRead(String to, String messageId, String ext) throws HyphenateException {
        EMOptions eMOptions = EMClient.getInstance().getChatConfigPrivate().b();
        if (!eMOptions.getRequireAck()) {
            EMLog.d(TAG, "chat option reqire ack set to false. skip send out ask msg read");
            return;
        }
        EMAMessage eMAMessage = this.emaObject.getMessage(messageId);
        if (eMAMessage != null) {
            if (eMAMessage.isNeedGroupAck()) {
                this.emaObject.sendReadAckForGroupMessage(eMAMessage, ext);
            } else {
                EMLog.d(TAG, "normal group message, do not ack it");
            }
        }
    }

    public void recallMessage(EMMessage message) throws HyphenateException {
        EMAError eMAError = new EMAError();
        if (message == null) {
            throw new HyphenateException(500, "The message was not found");
        }
        this.emaObject.recallMessage((EMAMessage)message.emaObject, eMAError);
        this.handleError(eMAError);
        EMConversation eMConversation = this.getConversation(message.getTo(), EMConversation.msgType2ConversationType(message.getMsgId(), message.getChatType()), true, message.isChatThreadMessage());
        if (eMConversation != null) {
            eMConversation.getCache().removeMessage(message.getMsgId());
        }
    }

    public void asyncRecallMessage(final EMMessage message, final EMCallBack callback) {
        EMClient.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    EMChatManager.this.recallMessage(message);
                    callback.onSuccess();
                }
                catch (HyphenateException hyphenateException) {
                    callback.onError(hyphenateException.getErrorCode(), hyphenateException.getDescription());
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EMMessage getMessage(String messageId) {
        Object object = this.caches;
        synchronized (object) {
            for (EMConversation.MessageCache messageCache : this.caches.values()) {
                EMMessage eMMessage = messageCache.getMessage(messageId);
                if (eMMessage == null) continue;
                return eMMessage;
            }
        }
        object = this.emaObject.getMessage(messageId);
        if (object == null) {
            return null;
        }
        EMMessage eMMessage = new EMMessage((EMAMessage)object);
        return eMMessage;
    }

    public EMConversation getConversation(String id) {
        EMAConversation eMAConversation = this.emaObject.conversationWithType(id, EMAConversation.EMAConversationType.CHAT, false, false);
        if (eMAConversation == null) {
            eMAConversation = this.emaObject.conversationWithType(id, EMAConversation.EMAConversationType.GROUPCHAT, false, false);
        }
        if (eMAConversation == null) {
            eMAConversation = this.emaObject.conversationWithType(id, EMAConversation.EMAConversationType.GROUPCHAT, false, true);
        }
        if (eMAConversation == null) {
            eMAConversation = this.emaObject.conversationWithType(id, EMAConversation.EMAConversationType.CHATROOM, false, false);
        }
        if (eMAConversation == null) {
            eMAConversation = this.emaObject.conversationWithType(id, EMAConversation.EMAConversationType.CHATROOM, false, true);
        }
        if (eMAConversation == null) {
            eMAConversation = this.emaObject.conversationWithType(id, EMAConversation.EMAConversationType.DISCUSSIONGROUP, false, false);
        }
        if (eMAConversation == null) {
            eMAConversation = this.emaObject.conversationWithType(id, EMAConversation.EMAConversationType.HELPDESK, false, false);
        }
        return eMAConversation == null ? null : new EMConversation(eMAConversation);
    }

    public EMConversation getConversation(String id, EMConversation.EMConversationType type) {
        EMConversation eMConversation = this.getConversation(id, type, false);
        if (eMConversation == null) {
            return this.getConversation(id, type, false, true);
        }
        return eMConversation;
    }

    public EMConversation getConversation(String username, EMConversation.EMConversationType type, boolean createIfNotExists) {
        EMConversation eMConversation = this.getConversation(username, type, createIfNotExists, false);
        if (eMConversation == null) {
            return this.getConversation(username, type, createIfNotExists, true);
        }
        return eMConversation;
    }

    public EMConversation getConversation(String username, EMConversation.EMConversationType type, boolean createIfNotExists, boolean isChatThread) {
        EMAConversation.EMAConversationType eMAConversationType = EMAConversation.EMAConversationType.CHAT;
        switch (type) {
            case Chat: {
                eMAConversationType = EMAConversation.EMAConversationType.CHAT;
                break;
            }
            case GroupChat: {
                eMAConversationType = EMAConversation.EMAConversationType.GROUPCHAT;
                break;
            }
            case ChatRoom: {
                eMAConversationType = EMAConversation.EMAConversationType.CHATROOM;
                break;
            }
            case DiscussionGroup: {
                eMAConversationType = EMAConversation.EMAConversationType.DISCUSSIONGROUP;
                break;
            }
            case HelpDesk: {
                eMAConversationType = EMAConversation.EMAConversationType.HELPDESK;
            }
        }
        EMAConversation eMAConversation = this.emaObject.conversationWithType(username, eMAConversationType, createIfNotExists, isChatThread);
        if (eMAConversation == null) {
            return null;
        }
        Log.d((String)TAG, (String)("convID:" + eMAConversation.conversationId()));
        return new EMConversation(eMAConversation);
    }

    public void markAllConversationsAsRead() {
        List<EMAConversation> list = this.emaObject.loadAllConversationsFromDB();
        for (EMAConversation eMAConversation : list) {
            eMAConversation.markAllMessagesAsRead(true);
        }
    }

    public int getUnreadMessageCount() {
        List<EMAConversation> list = this.emaObject.getConversations();
        int n = 0;
        for (EMAConversation eMAConversation : list) {
            if (eMAConversation._getType() == EMAConversation.EMAConversationType.CHATROOM) continue;
            n += eMAConversation.unreadMessagesCount();
        }
        return n;
    }

    public void saveMessage(EMMessage message) {
        EMMessage.ChatType chatType = message.getChatType();
        EMConversation.EMConversationType eMConversationType = EMConversation.EMConversationType.Chat;
        switch (chatType) {
            case Chat: {
                eMConversationType = EMConversation.EMConversationType.Chat;
                break;
            }
            case GroupChat: {
                eMConversationType = EMConversation.EMConversationType.GroupChat;
                break;
            }
            case ChatRoom: {
                eMConversationType = EMConversation.EMConversationType.ChatRoom;
            }
        }
        String string = message.getTo();
        if (eMConversationType == EMConversation.EMConversationType.Chat && message.direct() == EMMessage.Direct.RECEIVE) {
            string = message.getFrom();
        }
        if (message.getType() == EMMessage.Type.CMD) {
            return;
        }
        EMConversation eMConversation = this.getConversation(string, eMConversationType, true, message.isChatThreadMessage());
        if (eMConversation == null) {
            EMLog.e(TAG, "Failed to save message because conversation is null, convId: " + string);
            return;
        }
        eMConversation.insertMessage(message);
    }

    public boolean updateMessage(EMMessage message) {
        String string;
        String string2 = string = message.direct() == EMMessage.Direct.RECEIVE ? message.getFrom() : message.getTo();
        if (message.getType() == EMMessage.Type.CMD) {
            return false;
        }
        EMConversation eMConversation = this.getConversation(message.conversationId(), EMConversation.msgType2ConversationType(string, message.getChatType()), true, message.isChatThreadMessage());
        return eMConversation.updateMessage(message);
    }

    public void downloadAttachment(EMMessage msg) {
        if (msg == null) {
            return;
        }
        msg.makeCallbackStrong();
        this.checkContentAttachmentExist(msg);
        this.emaObject.downloadMessageAttachments((EMAMessage)msg.emaObject);
    }

    private void checkContentAttachmentExist(EMMessage msg) {
        List<EMAMessageBody> list = ((EMAMessage)msg.emaObject).bodies();
        if (list != null && !list.isEmpty()) {
            for (EMAMessageBody eMAMessageBody : list) {
                switch (eMAMessageBody.type()) {
                    case 1: 
                    case 2: 
                    case 4: 
                    case 5: {
                        EMAFileMessageBody eMAFileMessageBody = (EMAFileMessageBody)eMAMessageBody;
                        String string = eMAFileMessageBody.getLocalUrl();
                        EMLog.d(TAG, "download before check path = " + string);
                        if (EMFileHelper.getInstance().isFileExist(string)) break;
                        String string2 = eMAFileMessageBody.displayName();
                        String string3 = null;
                        switch (eMAMessageBody.type()) {
                            case 1: {
                                string3 = PathUtil.getInstance().getImagePath() + File.separator + string2;
                                break;
                            }
                            case 2: {
                                string3 = PathUtil.getInstance().getVideoPath() + File.separator + string2;
                                break;
                            }
                            case 4: {
                                string3 = PathUtil.getInstance().getVoicePath() + File.separator + string2;
                                break;
                            }
                            case 5: {
                                string3 = PathUtil.getInstance().getFilePath() + File.separator + string2;
                            }
                        }
                        if (TextUtils.isEmpty(string3)) break;
                        eMAFileMessageBody.setLocalPath(string3);
                        this.updateMessage(msg);
                        EMLog.d(TAG, "download:create new path , path is " + string3);
                    }
                }
            }
        }
    }

    public void downloadThumbnail(EMMessage msg) {
        msg.makeCallbackStrong();
        this.emaObject.downloadMessageThumbnail((EMAMessage)msg.emaObject);
    }

    public synchronized void importMessages(List<EMMessage> msgs) {
        ArrayList<EMAMessage> arrayList = new ArrayList<EMAMessage>();
        for (EMMessage eMMessage : msgs) {
            arrayList.add((EMAMessage)eMMessage.emaObject);
        }
        EMClient.getInstance().getChatConfigPrivate().c(arrayList);
    }

    public List<EMConversation> getConversationsByType(EMConversation.EMConversationType type) {
        List<EMAConversation> list = this.emaObject.getConversations();
        ArrayList<EMConversation> arrayList = new ArrayList<EMConversation>();
        for (EMAConversation eMAConversation : list) {
            if (type.ordinal() != eMAConversation._getType().ordinal()) continue;
            arrayList.add(new EMConversation(eMAConversation));
        }
        return arrayList;
    }

    public Map<String, EMConversation> getAllConversations() {
        List<EMAConversation> list = this.emaObject.getConversations();
        Hashtable<String, EMConversation> hashtable = new Hashtable<String, EMConversation>();
        for (EMAConversation eMAConversation : list) {
            hashtable.put(eMAConversation.conversationId(), new EMConversation(eMAConversation));
        }
        return hashtable;
    }

    public Map<String, EMConversation> fetchConversationsFromServer() throws HyphenateException {
        EMAError eMAError = new EMAError();
        List<EMAConversation> list = this.emaObject.fetchConversationsFromServer(eMAError);
        this.handleError(eMAError);
        Hashtable<String, EMConversation> hashtable = new Hashtable<String, EMConversation>();
        for (EMAConversation eMAConversation : list) {
            hashtable.put(eMAConversation.conversationId(), new EMConversation(eMAConversation));
        }
        return hashtable;
    }

    public void asyncFetchConversationsFromServer(final EMValueCallBack<Map<String, EMConversation>> callBack) {
        EMClient.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    callBack.onSuccess(EMChatManager.this.fetchConversationsFromServer());
                }
                catch (HyphenateException hyphenateException) {
                    callBack.onError(hyphenateException.getErrorCode(), hyphenateException.getDescription());
                }
            }
        });
    }

    Map<String, EMConversation> fetchConversationsFromServer(int pageNum, int pageSize) throws HyphenateException {
        EMAError eMAError = new EMAError();
        List<EMAConversation> list = this.emaObject.fetchConversationsFromServerWithPage(eMAError, pageNum, pageSize);
        this.handleError(eMAError);
        Hashtable<String, EMConversation> hashtable = new Hashtable<String, EMConversation>();
        for (EMAConversation eMAConversation : list) {
            hashtable.put(eMAConversation.conversationId(), new EMConversation(eMAConversation));
        }
        return hashtable;
    }

    public void asyncFetchConversationsFromServer(final int pageNum, final int pageSize, final EMValueCallBack<Map<String, EMConversation>> callBack) {
        EMClient.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    callBack.onSuccess(EMChatManager.this.fetchConversationsFromServer(pageNum, pageSize));
                }
                catch (HyphenateException hyphenateException) {
                    callBack.onError(hyphenateException.getErrorCode(), hyphenateException.getDescription());
                }
            }
        });
    }

    public void loadAllConversations() {
        this.emaObject.loadAllConversationsFromDB();
    }

    public boolean deleteConversation(String username, boolean deleteMessages) {
        EMConversation eMConversation = this.getConversation(username);
        if (eMConversation == null) {
            return false;
        }
        if (!deleteMessages) {
            eMConversation.clear();
        } else {
            eMConversation.clearAllMessages();
        }
        this.emaObject.removeConversation(username, deleteMessages, eMConversation.isChatThread());
        return true;
    }

    public void deleteConversationFromServer(final String username, final EMConversation.EMConversationType type, final boolean isDeleteServerMessages, final EMCallBack deleteCallBack) {
        EMClient.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                EMAConversation.EMAConversationType eMAConversationType = EMAConversation.EMAConversationType.CHAT;
                switch (type) {
                    case Chat: {
                        eMAConversationType = EMAConversation.EMAConversationType.CHAT;
                        break;
                    }
                    case GroupChat: {
                        eMAConversationType = EMAConversation.EMAConversationType.GROUPCHAT;
                        break;
                    }
                    case ChatRoom: {
                        eMAConversationType = EMAConversation.EMAConversationType.CHATROOM;
                        break;
                    }
                    case DiscussionGroup: {
                        eMAConversationType = EMAConversation.EMAConversationType.DISCUSSIONGROUP;
                        break;
                    }
                    case HelpDesk: {
                        eMAConversationType = EMAConversation.EMAConversationType.HELPDESK;
                    }
                }
                EMAError eMAError = EMChatManager.this.emaObject.deleteConversationFromServer(username, eMAConversationType, isDeleteServerMessages);
                if (eMAError.errCode() == 0) {
                    deleteCallBack.onSuccess();
                } else {
                    deleteCallBack.onError(eMAError.errCode(), eMAError.errMsg());
                }
            }
        });
    }

    public void addMessageListener(EMMessageListener listener) {
        if (listener == null) {
            EMLog.d(TAG, "addMessageListener: listener is null");
            return;
        }
        if (!this.messageListeners.contains(listener)) {
            EMLog.d(TAG, "add message listener: " + listener);
            this.messageListeners.add(listener);
        }
    }

    public void removeMessageListener(EMMessageListener listener) {
        if (listener == null) {
            return;
        }
        this.messageListeners.remove(listener);
    }

    public void addConversationListener(EMConversationListener listener) {
        if (!this.conversationListeners.contains(listener)) {
            this.conversationListeners.add(listener);
        }
    }

    public void removeConversationListener(EMConversationListener listener) {
        if (listener == null) {
            return;
        }
        this.conversationListeners.remove(listener);
    }

    public void setVoiceMessageListened(EMMessage message) {
        message.setListened(true);
        this.updateMessage(message);
    }

    void onLogout() {
        this.caches.clear();
    }

    synchronized void loadAllConversationsFromDB() {
        this.emaObject.loadAllConversationsFromDB();
    }

    public boolean updateParticipant(String from, String changeTo) {
        return this.emaObject.updateParticipant(from, changeTo);
    }

    public EMCursorResult<EMGroupReadAck> fetchGroupReadAcks(String msgId, int pageSize, String startAckId) throws HyphenateException {
        EMAError eMAError = new EMAError();
        EMCursorResult<EMGroupReadAck> eMCursorResult = new EMCursorResult<EMGroupReadAck>();
        EMMessage eMMessage = this.getMessage(msgId);
        String string = null;
        if (eMMessage.getChatType() != EMMessage.ChatType.GroupChat || !eMMessage.isNeedGroupAck()) {
            EMLog.e(TAG, "not group msg or don't need ack");
            return eMCursorResult;
        }
        string = eMMessage.conversationId();
        EMCursorResult<EMAGroupReadAck> eMCursorResult2 = this.emaObject.fetchGroupReadAcks(msgId, string, eMAError, pageSize, startAckId);
        this.handleError(eMAError);
        eMCursorResult.setCursor(eMCursorResult2.getCursor());
        ArrayList<EMGroupReadAck> arrayList = new ArrayList<EMGroupReadAck>();
        for (EMAGroupReadAck eMAGroupReadAck : (List)eMCursorResult2.getData()) {
            arrayList.add(new EMGroupReadAck(eMAGroupReadAck));
        }
        eMCursorResult.setData(arrayList);
        return eMCursorResult;
    }

    public void asyncFetchGroupReadAcks(final String msgId, final int pageSize, final String startAckId, final EMValueCallBack<EMCursorResult<EMGroupReadAck>> callBack) {
        EMClient.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    callBack.onSuccess(EMChatManager.this.fetchGroupReadAcks(msgId, pageSize, startAckId));
                }
                catch (HyphenateException hyphenateException) {
                    callBack.onError(hyphenateException.getErrorCode(), hyphenateException.getDescription());
                }
            }
        });
    }

    public EMCursorResult<EMMessage> fetchHistoryMessages(String conversationId, EMConversation.EMConversationType type, int pageSize, String startMsgId) throws HyphenateException {
        return this.fetchHistoryMessages(conversationId, type, pageSize, startMsgId, EMConversation.EMSearchDirection.UP);
    }

    public EMCursorResult<EMMessage> fetchHistoryMessages(String conversationId, EMConversation.EMConversationType type, int pageSize, String startMsgId, EMConversation.EMSearchDirection direction) throws HyphenateException {
        EMAError eMAError = new EMAError();
        EMAConversation.EMASearchDirection eMASearchDirection = direction == EMConversation.EMSearchDirection.UP ? EMAConversation.EMASearchDirection.UP : EMAConversation.EMASearchDirection.DOWN;
        EMCursorResult<EMAMessage> eMCursorResult = this.emaObject.fetchHistoryMessages(conversationId, type.ordinal(), pageSize, startMsgId, eMASearchDirection, eMAError);
        this.handleError(eMAError);
        EMCursorResult<EMMessage> eMCursorResult2 = new EMCursorResult<EMMessage>();
        eMCursorResult2.setCursor(eMCursorResult.getCursor());
        ArrayList<EMMessage> arrayList = new ArrayList<EMMessage>();
        for (EMAMessage eMAMessage : (List)eMCursorResult.getData()) {
            arrayList.add(new EMMessage(eMAMessage));
        }
        eMCursorResult2.setData(arrayList);
        return eMCursorResult2;
    }

    public void asyncFetchHistoryMessage(final String conversationId, final EMConversation.EMConversationType type, final int pageSize, final String startMsgId, final EMValueCallBack<EMCursorResult<EMMessage>> callBack) {
        EMClient.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    callBack.onSuccess(EMChatManager.this.fetchHistoryMessages(conversationId, type, pageSize, startMsgId));
                }
                catch (HyphenateException hyphenateException) {
                    callBack.onError(hyphenateException.getErrorCode(), hyphenateException.getDescription());
                }
            }
        });
    }

    public void asyncFetchHistoryMessage(final String conversationId, final EMConversation.EMConversationType type, final int pageSize, final String startMsgId, final EMConversation.EMSearchDirection direction, final EMValueCallBack<EMCursorResult<EMMessage>> callBack) {
        EMClient.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    callBack.onSuccess(EMChatManager.this.fetchHistoryMessages(conversationId, type, pageSize, startMsgId, direction));
                }
                catch (HyphenateException hyphenateException) {
                    callBack.onError(hyphenateException.getErrorCode(), hyphenateException.getDescription());
                }
            }
        });
    }

    private void handleError(EMAError error) throws HyphenateException {
        if (error.errCode() != 0) {
            throw new HyphenateException(error);
        }
    }

    public List<EMMessage> searchMsgFromDB(EMMessage.Type type, long timeStamp, int maxCount, String from, EMConversation.EMSearchDirection direction) {
        EMAConversation.EMASearchDirection eMASearchDirection = direction == EMConversation.EMSearchDirection.UP ? EMAConversation.EMASearchDirection.UP : EMAConversation.EMASearchDirection.DOWN;
        List<EMAMessage> list = this.emaObject.searchMessages(type.ordinal(), timeStamp, maxCount, from, eMASearchDirection);
        AbstractList abstractList = list.size() > 512 ? new LinkedList() : new ArrayList();
        for (EMAMessage eMAMessage : list) {
            if (eMAMessage == null) continue;
            abstractList.add((EMMessage)new EMMessage(eMAMessage));
        }
        return abstractList;
    }

    public List<EMMessage> searchMsgFromDB(String keywords, long timeStamp, int maxCount, String from, EMConversation.EMSearchDirection direction) {
        EMAConversation.EMASearchDirection eMASearchDirection = direction == EMConversation.EMSearchDirection.UP ? EMAConversation.EMASearchDirection.UP : EMAConversation.EMASearchDirection.DOWN;
        List<EMAMessage> list = this.emaObject.searchMessages(keywords, timeStamp, maxCount, from, eMASearchDirection);
        AbstractList abstractList = list.size() > 512 ? new LinkedList() : new ArrayList();
        for (EMAMessage eMAMessage : list) {
            if (eMAMessage == null) continue;
            abstractList.add((EMMessage)new EMMessage(eMAMessage));
        }
        return abstractList;
    }

    public void deleteMessagesBeforeTimestamp(final long timeStamp, final EMCallBack callback) {
        EMClient.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                boolean bl = EMChatManager.this.emaObject.removeMessagesBeforeTimestamp(timeStamp);
                if (bl) {
                    for (EMConversation.MessageCache messageCache : EMChatManager.this.caches.values()) {
                        for (EMMessage eMMessage : messageCache.getAllMessages()) {
                            if (eMMessage.getMsgTime() >= timeStamp) continue;
                            messageCache.removeMessage(eMMessage.getMsgId());
                        }
                    }
                    callback.onSuccess();
                } else {
                    callback.onError(3, "Database operation failed");
                }
            }
        });
    }

    public void asyncReportMessage(final String msgId, final String reportTarget, final String reportReason, final EMCallBack callBack) {
        EMClient.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    EMChatManager.this.reportMessage(msgId, reportTarget, reportReason);
                    callBack.onSuccess();
                }
                catch (HyphenateException hyphenateException) {
                    callBack.onError(hyphenateException.getErrorCode(), hyphenateException.getDescription());
                }
            }
        });
    }

    public void reportMessage(String msgId, String reportTarget, String reportReason) throws HyphenateException {
        EMAError eMAError = new EMAError();
        this.emaObject.reportMessage(msgId, reportTarget, reportReason, eMAError);
        this.handleError(eMAError);
    }

    public void fetchSupportLanguages(final EMValueCallBack<List<EMLanguage>> callBack) {
        this.mClient.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    ArrayList<EMLanguage> arrayList = new ArrayList<EMLanguage>();
                    EMAError eMAError = new EMAError();
                    List<List<String>> list = EMChatManager.this.emaObject.fetchSupportLanguages(eMAError);
                    EMChatManager.this.handleError(eMAError);
                    for (List<String> list2 : list) {
                        arrayList.add(new EMLanguage(list2.get(0), list2.get(1), list2.get(2)));
                    }
                    callBack.onSuccess(arrayList);
                }
                catch (HyphenateException hyphenateException) {
                    callBack.onError(hyphenateException.getErrorCode(), hyphenateException.getDescription());
                }
            }
        });
    }

    public void translateMessage(final EMMessage message, final List<String> languages, final EMValueCallBack<EMMessage> callBack) {
        this.mClient.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    EMAError eMAError = new EMAError();
                    EMAMessage eMAMessage = EMChatManager.this.emaObject.translateMessage((EMAMessage)message.emaObject, languages, eMAError);
                    EMChatManager.this.handleError(eMAError);
                    callBack.onSuccess(new EMMessage(eMAMessage));
                }
                catch (HyphenateException hyphenateException) {
                    callBack.onError(hyphenateException.getErrorCode(), hyphenateException.getDescription());
                }
            }
        });
    }

    public void addReaction(String messageId, String reaction) throws HyphenateException {
        EMAError eMAError = new EMAError();
        this.emaReactionObject.addReaction(messageId, reaction, eMAError);
        this.handleError(eMAError);
    }

    public void asyncAddReaction(String messageId, String reaction, EMCallBack callback) {
        EMClient.getInstance().execute(() -> {
            block3: {
                try {
                    this.addReaction(messageId, reaction);
                    if (null != callback) {
                        callback.onSuccess();
                    }
                }
                catch (HyphenateException hyphenateException) {
                    EMLog.e(TAG, "asyncAddReaction error code:" + hyphenateException.getErrorCode() + ",error message:" + hyphenateException.getDescription());
                    if (null == callback) break block3;
                    callback.onError(hyphenateException.getErrorCode(), hyphenateException.getDescription());
                }
            }
        });
    }

    public void removeReaction(String messageId, String reaction) throws HyphenateException {
        EMAError eMAError = new EMAError();
        this.emaReactionObject.removeReaction(messageId, reaction, eMAError);
        this.handleError(eMAError);
    }

    public void asyncRemoveReaction(String messageId, String reaction, EMCallBack callback) {
        EMClient.getInstance().execute(() -> {
            block3: {
                try {
                    this.removeReaction(messageId, reaction);
                    if (null != callback) {
                        callback.onSuccess();
                    }
                }
                catch (HyphenateException hyphenateException) {
                    EMLog.e(TAG, "asyncRemoveReaction error code:" + hyphenateException.getErrorCode() + ",error message:" + hyphenateException.getDescription());
                    if (null == callback) break block3;
                    callback.onError(hyphenateException.getErrorCode(), hyphenateException.getDescription());
                }
            }
        });
    }

    public Map<String, List<EMMessageReaction>> getReactionList(List<String> messageIdList, EMMessage.ChatType chatType, String groupId) throws HyphenateException {
        EMAError eMAError = new EMAError();
        String string = "chat";
        if (EMMessage.ChatType.Chat == chatType) {
            string = "chat";
        } else if (EMMessage.ChatType.GroupChat == chatType) {
            string = "groupchat";
        }
        Map<String, List<EMAMessageReaction>> map = this.emaReactionObject.getReactionList(messageIdList, string, groupId, eMAError);
        this.handleError(eMAError);
        HashMap<String, List<EMMessageReaction>> hashMap = new HashMap<String, List<EMMessageReaction>>(map.size());
        if (map.size() > 0) {
            for (Map.Entry<String, List<EMAMessageReaction>> entry : map.entrySet()) {
                ArrayList<EMMessageReaction> arrayList = new ArrayList<EMMessageReaction>(entry.getValue().size());
                for (EMAMessageReaction eMAMessageReaction : entry.getValue()) {
                    if (null == eMAMessageReaction) continue;
                    arrayList.add(new EMMessageReaction(eMAMessageReaction));
                }
                hashMap.put(entry.getKey(), arrayList);
            }
        }
        return hashMap;
    }

    public void asyncGetReactionList(List<String> messageIdList, EMMessage.ChatType chatType, String groupId, EMValueCallBack<Map<String, List<EMMessageReaction>>> callback) {
        EMClient.getInstance().execute(() -> {
            try {
                if (null != callback) {
                    callback.onSuccess(this.getReactionList(messageIdList, chatType, groupId));
                }
            }
            catch (HyphenateException hyphenateException) {
                EMLog.e(TAG, "asyncGetReactionList error code:" + hyphenateException.getErrorCode() + ",error message:" + hyphenateException.getDescription());
                callback.onError(hyphenateException.getErrorCode(), hyphenateException.getDescription());
            }
        });
    }

    public EMCursorResult<EMMessageReaction> getReactionDetail(String messageId, String reaction, String cursor, int pageSize) throws HyphenateException {
        EMAError eMAError = new EMAError();
        EMCursorResult<EMAMessageReaction> eMCursorResult = this.emaReactionObject.getReactionDetail(messageId, reaction, cursor, pageSize, eMAError);
        this.handleError(eMAError);
        EMCursorResult<EMMessageReaction> eMCursorResult2 = new EMCursorResult<EMMessageReaction>();
        eMCursorResult2.setCursor(eMCursorResult.getCursor());
        if (null != eMCursorResult.getData()) {
            ArrayList<EMMessageReaction> arrayList = new ArrayList<EMMessageReaction>(((List)eMCursorResult.getData()).size());
            for (EMAMessageReaction eMAMessageReaction : (List)eMCursorResult.getData()) {
                if (null == eMAMessageReaction) continue;
                arrayList.add(new EMMessageReaction(eMAMessageReaction));
            }
            eMCursorResult2.setData(arrayList);
        }
        return eMCursorResult2;
    }

    public void asyncGetReactionDetail(String messageId, String reaction, String cursor, int pageSize, EMValueCallBack<EMCursorResult<EMMessageReaction>> callback) {
        EMClient.getInstance().execute(() -> {
            try {
                if (null != callback) {
                    callback.onSuccess(this.getReactionDetail(messageId, reaction, cursor, pageSize));
                }
            }
            catch (HyphenateException hyphenateException) {
                EMLog.e(TAG, "asyncGetReactionDetail error code:" + hyphenateException.getErrorCode() + ",error message:" + hyphenateException.getDescription());
                callback.onError(hyphenateException.getErrorCode(), hyphenateException.getDescription());
            }
        });
    }

    protected void removeMessagesFromServer(final String conversationId, final EMConversation.EMConversationType type, final List<String> msgIdList, final EMCallBack callBack) {
        EMClient.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                EMAError eMAError = EMChatManager.this.emaObject.deleteRoamMsgFromServerById(conversationId, type, msgIdList);
                if (eMAError.errCode() == 0) {
                    EMChatManager.this.clearCaches(conversationId, msgIdList);
                    callBack.onSuccess();
                } else {
                    callBack.onError(eMAError.errCode(), eMAError.errMsg());
                }
            }
        });
    }

    protected void removeMessagesFromServer(final String conversationId, final EMConversation.EMConversationType type, final long beforeTimeStamp, final EMCallBack callBack) {
        EMClient.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                EMAError eMAError = EMChatManager.this.emaObject.deleteRoamMsgFromServerByTime(conversationId, type, beforeTimeStamp);
                if (eMAError.errCode() == 0) {
                    EMChatManager.this.clearCaches(conversationId, beforeTimeStamp);
                    callBack.onSuccess();
                } else {
                    callBack.onError(eMAError.errCode(), eMAError.errMsg());
                }
            }
        });
    }

    void clearCaches(String conversationId, long beforeTimeStamp) {
        if (this.caches.containsKey(conversationId) && this.caches.get(conversationId) != null && this.caches.get(conversationId).getAllMessages().size() > 0) {
            for (EMMessage eMMessage : this.caches.get(conversationId).getAllMessages()) {
                if (eMMessage.getMsgTime() > beforeTimeStamp) continue;
                this.caches.get(conversationId).removeMessage(eMMessage.getMsgId());
            }
        }
    }

    void clearCaches(String conversationId, List<String> msgIdList) {
        if (msgIdList != null && msgIdList.size() > 0) {
            for (String string : msgIdList) {
                if (!this.caches.containsKey(conversationId) || this.caches.get(conversationId) == null) continue;
                this.caches.get(conversationId).removeMessage(string);
            }
        }
    }
}

