package com.hyphenate.chat;

import com.hyphenate.chat.adapter.EMASilentModeParam;

/**
 * \~chinese
 * 离线推送设置参数实体类
 *
 * \~english
 * Offline push Settings parameter entity class
 *
 */
public class EMSilentModeParam extends EMBase<EMASilentModeParam> {

    /**
     * \~chinese
     * 离线推送免打扰参数类型枚举类。
     *
     * \~english
     * Offline push DND parameter type Enumeration class.
     */
    public enum EMSilentModeParamType{
        REMIND_TYPE, /** \～chinese 离线推送提醒类型。 \~english  Offline push notification type. */
        SILENT_MODE_DURATION, /** \～chinese 离线推送免打扰时长。 \~english Offline push DND duration.  */
        SILENT_MODE_INTERVAL /** \～chinese 离线推送免打扰时间段。 \~english  Offline push DND period. */
    }

    /**
     * \~chinese
     * 有参构造。
     * @param paramType 参数类型。
     *
     * \~english
     * Have the cords structure.
     * @param paramType The parameter types.
     */
    public EMSilentModeParam(EMSilentModeParamType paramType){
        emaObject = new EMASilentModeParam();
        emaObject.setParamType(paramType.ordinal());
    }

    public EMSilentModeParam(EMASilentModeParam param){
        emaObject = param;
    }

    /**
     * \~chinese
     * 设置参数类型。
     * @param paramType 参数类型。
     *
     * \~english
     * Setting parameter Type.
     * @param paramType The parameter types.
     *
     */
    public EMSilentModeParam setParamType(EMSilentModeParamType paramType){
        emaObject.setParamType(paramType.ordinal());
        return this;
    }

    /**
     * \~chinese
     * 设置离线推送提醒类型。
     * @param remindType 离线推送提醒类型。
     *
     * \~english
     * Set the offline push notification type.
     * @param remindType Offline push notification type.
     *
     */
    public EMSilentModeParam setRemindType(EMPushManager.EMPushRemindType remindType){
        emaObject.setRemindType(remindType.ordinal() + 1);
        return this;
    }

    /**
     * \~chinese
     * 设置离线推送免打扰时长。
     * @param silentDuration 离线推送免打扰时长，单位分钟。
     *
     * \~english
     * Set the offline push DND duration.
     * @param silentDuration Offline push DND duration, units of minutes.
     *
     */
    public EMSilentModeParam setSilentModeDuration(int silentDuration){
        emaObject.setSilentDuration(silentDuration);
        return this;
    }

    /**
     * \~chinese
     * 设置离线推送免打扰时间段。
     * @param startTime 免打扰开始时间。
     * @param endTime 免打扰结束时间。
     *
     * \~english
     * Set the start time of offline push DND.
     * @param startTime Do not disturb start time.
     * @param endTime Do not disturb end time.
     *
     */
    public EMSilentModeParam setSilentModeInterval(EMSilentModeTime startTime, EMSilentModeTime endTime){
        emaObject.setStartTime(startTime.emaObject);
        emaObject.setEndTime(endTime.emaObject);
        return this;
    }
}
