package com.hyphenate;


import java.util.List;
/**
 * Created by linan on 17/4/17.
 */
/**
 * \~chinese
 * 多端多设备事件监听器。
 * 
 * 该监听器用于监听其他设备上当前用户的事件回调，包括联系人变化和群组变化。
 * 
 *     注册监听器：
 * 
 * ```java
 *     EMClient.getInstance().addMultiDeviceListener(mMultiDeviceListener);
 * ```
 *     移除监听器：
 * 
 * ```java
 *     EMClient.getInstance().removeMultiDeviceListener(mMultiDeviceListener);
 *  ```
 *
 * \~english
 * The multi-device event listener.
 * 
 * The listener listens for callbacks for the current user's actions on other devices, including contact changes and group changes.
 * 
 *     Adds a multi-device event listener:
 * 
 * ```java
 *     EMClient.getInstance().addMultiDeviceListener(mMultiDeviceListener);
 * ```
 * 
 *     Removes a multi-device event listener:
 * 
 * ```java
 *     EMClient.getInstance().removeMultiDeviceListener(mMultiDeviceListener);
 * ```
 */
@SuppressWarnings("unused")
public interface EMMultiDeviceListener {

//    /**
//     * \~chinese
//     * 当前用户在其他设备上发起添加好友请求。
//     *
//     * \~english
//     * The current user initiated a friend request on another device.
//     */
//    int CONTACT_ADD = 1;

    /**
     * \~chinese
     * 当前用户在其他设备上删除好友。
     *
     * \~english
     * The current user removed a contact on another device.
     */
    int CONTACT_REMOVE = 2;

    /**
     * \~chinese
     * 当前用户在其他设备上接受好友请求。
     *
     * \~english
     * The current user accepted a friend request on another device.
     */
    int CONTACT_ACCEPT          = 3;

    /**
     * \~chinese
     * 当前用户在其他设备上拒绝好友请求。
     *
     * \~english
     * The current user declined a friend request on another device.
     */
    int CONTACT_DECLINE         = 4;

    /**
     * \~chinese
     * 当前用户在其他设备上将好友加入黑名单。
     *
     * \~english
     * The current user added a contact to the block list on another device.
     */
     int CONTACT_BAN           = 5;

    /**
     * \~chinese
     * 当前用户在其他设备上将好友移出黑名单。
     *
     * \~english
     * The current user removed a contact from the block list on another device.
     */
     int CONTACT_ALLOW         = 6;



    /**
     * \~chinese
     * 当前用户在其他设备上创建群组。
     *
     * \~english
     * The current user created a group on another device.
     */
    int GROUP_CREATE            = 10;

    /**
     * \~chinese
     * 当前用户在其他设备上解散群组。
     *
     * \~english
     * The current user destroyed a group on another device.
     */
    int GROUP_DESTROY           = 11;

    /**
     * \~chinese
     * 当前用户在其他设备上加入群组。
     *
     * \~english
     * The current user joined a group on another device.
     */
    int GROUP_JOIN              = 12;

    /**
     * \~chinese
     * 当前用户在其他设备离开群组。
     *
     * \~english
     * The current user left a group on another device.
     */
    int GROUP_LEAVE             = 13;

    /**
     * \~chinese
     * 当前用户在其他设备上申请加入群组。
     *
     * \~english
     * The current user requested to join a group on another device.
     */
    int GROUP_APPLY             = 14;

    /**
     * \~chinese
     * 当前用户在其他设备接受入群申请。
     *
     * \~english
     * The current user accepted a group request on another device.
     */
    int GROUP_APPLY_ACCEPT      = 15;

    /**
     * \~chinese
     * 当前用户在其他设备上拒绝入群申请。
     *
     * \~english
     * The current user declined a group request on another device.
     */
    int GROUP_APPLY_DECLINE     = 16;

    /**
     * \~chinese
     * 当前用户在其他设备上邀请用户入群。
     *
     * \~english
     * The current user invited a user to join the group on another device.
     */
    int GROUP_INVITE            = 17; //

    /**
     * \~chinese
     * 当前用户在其他设备上接受了入群邀请。
     *
     * \~english
     * The current user accepted a group invitation on another device.
     */
    int GROUP_INVITE_ACCEPT     = 18; //

    /**
     * \~chinese
     * 当前用户在其他设备上拒绝了入群邀请。
     *
     * \~english
     * The current user declined a group invitation on another device.
     */
    int GROUP_INVITE_DECLINE    = 19;

    /**
     * \~chinese
     * 当前用户在其他设备上将成员踢出群。
     *
     * \~english
     * The current user kicked a member out of a group on another device.
     */
    int GROUP_KICK              = 20;

    /**
     * \~chinese
     * 当前用户在其他设备上将成员加入群组黑名单。
     *
     * \~english
     * The current user added a member to a group block list on another device.
     */
    int GROUP_BAN               = 21; //加入群组黑名单

    /**
     * \~chinese
     * 当前用户在其他设备上将成员移除群组黑名单。
     *
     * \~english
     * The current user removed a member from a group block list on another device.
     */
    int GROUP_ALLOW             = 22;

    /**
     * \~chinese
     * 当前用户在其他设备上屏蔽群组。
     *
     * \~english
     * The current user blocked a group on another device.
     */
    int GROUP_BLOCK             = 23;

    /**
     * \~chinese
     * 当前用户在其他设备上取消群组屏蔽。
     *
     * \~english
     * The current user unblocked a group on another device.
     */
    int GROUP_UNBLOCK           = 24;

    /**
     * \~chinese
     * 当前用户在其他设备上转移群组所有权。
     *
     * \~english
     * The current user transferred the group ownership on another device.
     */
    int GROUP_ASSIGN_OWNER      = 25;

    /**
     * \~chinese
     * 当前用户在其他设备上添加管理员。
     *
     * \~english
     * The current user added an admin on another device.
     */
    int GROUP_ADD_ADMIN         = 26;

    /**
     * \~chinese
     * 当前用户在其他设备上移除管理员。
     *
     * \~english
     * The current user removed an admin on another device.
     */
    int GROUP_REMOVE_ADMIN      = 27;

    /**
     * \~chinese
     * 当前用户在其他设备上禁言成员。
     *
     * \~english
     * The current user muted a member on another device.
     */
    int GROUP_ADD_MUTE          = 28;

    /**
     * \~chinese
     * 当前用户在其他设备上解除禁言。
     *
     * \~english
     * The current user unmuted a member on another device.
     */
    int GROUP_REMOVE_MUTE       = 29;

    /**
     * \~chinese
     * 当前用户在其他设备将其他用户加入到群组白名单。
     *
     * \~english
     * The current user adds other users to the group allow list on another device.
     */
    int GROUP_ADD_USER_WHITE_LIST     = 30;

    /**
     * \~chinese
     * 当前用户在其他设备将其他用户移除群组白名单。
     *
     * \~english
     * The current user removes other users from the group allow list on another device.
     */
    int GROUP_REMOVE_USER_WHITE_LIST  = 31;

    /**
     * \~chinese
     * 当前用户在其他设备将全部群组成员禁言。
     *
     * \~english
     * The current user muted all members of a group on another device.
     */
    int GROUP_ALL_BAN                 = 32;

    /**
     * \~chinese
     * 当前用户在其他设备将群组成员解除禁言。
     *
     * \~english
     * The current user unmuted all members of a group on another device.
     */
    int GROUP_REMOVE_ALL_BAN          = 33;

    /**
     * \~chinese
     * 当前用户在其他设备创建子区。
     *
     * \~english
     * The current user created a message thread on another device.
     */
    int THREAD_CREATE                 = 40;// thread创建事件
    /**
     * \~chinese
     * 当前用户在其他设备销毁子区。
     *
     * \~english
     * The current user destroyed a message thread on another device.
     */
    int THREAD_DESTROY                = 41;//销毁
    /**
     * \~chinese
     * 当前用户在其他设备加入子区。
     *
     * \~english
     * The current user joined a message thread on another device.
     */
    int THREAD_JOIN                   = 42; //thread加入事件(自己)
    /**
     * \~chinese
     * 当前用户在其他设备离开子区。
     *
     * \~english
     * The current user left a message thread on another device.
     */
    int THREAD_LEAVE                  = 43; //leave thread
    /**
     * \~chinese
     * 当前用户在其他设备更新子区信息。
     *
     * \~english
     * The current user updated message thread information on another device.
     */
    int THREAD_UPDATE                 = 44;
    /**
     * \~chinese
     * 当前用户在其他设备上将成员踢出子区。
     *
     * \~english
     * The current user kicked a member out of a message thread on another device.
     */
    int THREAD_KICK                   = 45;
    /**
     * \~chinese
     * 当前用户在其他设备上修改群组成员属性。
     *
     * \~english
     * The current user modified custom attributes of a group member on another device.
     */
    int GROUP_METADATA_CHANGED        = 52;


    /**
     * \~chinese
     * 多端多设备联系人事件。
     * 
     * @param event     联系人事件，详见 {@link EMMultiDeviceListener}。
     * @param target    联系人 ID。
     * @param ext       扩展信息。
     *
     * \~english
     * The multi-device contact event.
     * 
     * @param event     The contact event. See {@link EMMultiDeviceListener}.
     * @param target    The contact ID.
     * @param ext       The extension information.
     */
    void onContactEvent(int event, String target, String ext);

    /**
     * \~chinese
     * 多端多设备群组事件。
     * 
     * @param event         群组事件，详见 {@link EMMultiDeviceListener}。
     * @param target        群组 ID。
     * @param usernames     操作目标 ID 列表。
     *
     * \~english
     * The multi-device group event.
     * 
     * @param event         The group event. See {@link EMMultiDeviceListener}.
     * @param target        The group ID.
     * @param usernames     The operation target ID(s).
     */
    void onGroupEvent(int event, String target, List<String> usernames);

    /**
     * \~chinese
     * 多端多设备子区事件。
     * 
     * @param event        子区事件，详见 {@link EMMultiDeviceListener}。
     * @param target       子区 ID。
     * @param usernames     操作目标 ID 列表。
     *
     * \~english
     * The multi-device message thread event.
     * @param event         The message thread event. See {@link EMMultiDeviceListener}.
     * @param target        The message thread ID.
     * @param usernames     The operation target ID(s).
     */
    default void onChatThreadEvent(int event, String target, List<String> usernames) {}

    /**
     * \~chinese
     * 多设备同步漫游删除通知
     * @param conversationId    会话id
     * @param deviceId          设备id
     *
     * \~english
     * Multi device synchronous roaming deletion notification
     * @param conversationId    conversationId
     * @param deviceId          deviceId
     */
    default void onMessageRemoved(String conversationId,String deviceId){}

}
