/*
 * Decompiled with CFR 0.152.
 */
package com.hyphenate.util;

import android.annotation.SuppressLint;
import android.app.ActivityManager;
import android.content.Context;
import android.os.Build;
import android.os.Environment;
import com.hyphenate.util.EMLog;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.security.KeyStore;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;
import java.util.List;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.GZIPOutputStream;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;

public class EasyUtils {
    public static final String TAG = "EasyUtils";
    private static Hashtable<String, String> resourceTable = new Hashtable();

    public static boolean isAppRunningForeground(Context context) {
        ActivityManager activityManager = (ActivityManager)context.getSystemService("activity");
        if (Build.VERSION.SDK_INT > 20) {
            List list = activityManager.getRunningAppProcesses();
            if (list == null) {
                return false;
            }
            String string = context.getPackageName();
            for (ActivityManager.RunningAppProcessInfo runningAppProcessInfo : list) {
                if (runningAppProcessInfo.importance != 100 || !runningAppProcessInfo.processName.equals(string)) continue;
                return true;
            }
            return false;
        }
        try {
            List list = activityManager.getRunningTasks(1);
            if (list == null || list.size() < 1) {
                return false;
            }
            boolean bl = context.getPackageName().equalsIgnoreCase(((ActivityManager.RunningTaskInfo)list.get((int)0)).baseActivity.getPackageName());
            EMLog.d("utils", "app running in foregroud\uff1a" + bl);
            return bl;
        }
        catch (SecurityException securityException) {
            EMLog.d(TAG, "Apk doesn't hold GET_TASKS permission");
            securityException.printStackTrace();
            return false;
        }
    }

    public static String getTopActivityName(Context context) {
        ActivityManager activityManager = (ActivityManager)context.getSystemService("activity");
        try {
            List list = activityManager.getRunningTasks(1);
            if (list == null || list.size() < 1) {
                return "";
            }
            return ((ActivityManager.RunningTaskInfo)list.get((int)0)).topActivity.getClassName();
        }
        catch (SecurityException securityException) {
            EMLog.d(TAG, "Apk doesn't hold GET_TASKS permission");
            securityException.printStackTrace();
            return "";
        }
    }

    public static boolean isSingleActivity(Context context) {
        ActivityManager activityManager = (ActivityManager)context.getSystemService("activity");
        List list = null;
        try {
            list = activityManager.getRunningTasks(1);
        }
        catch (SecurityException securityException) {
            securityException.printStackTrace();
        }
        if (list == null || list.size() < 1) {
            return false;
        }
        return ((ActivityManager.RunningTaskInfo)list.get((int)0)).numRunning == 1;
    }

    public static List<String> getRunningApps(Context context) {
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            ActivityManager activityManager = (ActivityManager)context.getSystemService("activity");
            List list = activityManager.getRunningAppProcesses();
            if (list == null) {
                return arrayList;
            }
            for (ActivityManager.RunningAppProcessInfo runningAppProcessInfo : list) {
                String string = runningAppProcessInfo.processName;
                if (string.contains(":")) {
                    string = string.substring(0, string.indexOf(":"));
                }
                if (arrayList.contains(string)) continue;
                arrayList.add(string);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return arrayList;
    }

    @SuppressLint(value={"SimpleDateFormat"})
    public static String getTimeStamp() {
        Date date = new Date(System.currentTimeMillis());
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMddHHmmss");
        return simpleDateFormat.format(date);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean writeToZipFile(byte[] byArray, String string) {
        FileOutputStream fileOutputStream = null;
        DeflaterOutputStream deflaterOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(string);
            deflaterOutputStream = new GZIPOutputStream(new BufferedOutputStream(fileOutputStream));
            deflaterOutputStream.write(byArray);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            if (deflaterOutputStream != null) {
                try {
                    deflaterOutputStream.close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
            if (fileOutputStream != null) {
                try {
                    ((OutputStream)fileOutputStream).close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
        if (EMLog.debugMode) {
            File file = new File(string);
            DecimalFormat decimalFormat = new DecimalFormat("#.##");
            double d = (double)file.length() / (double)byArray.length * 100.0;
            double d2 = Double.valueOf(decimalFormat.format(d));
            EMLog.d("zip", "data size:" + byArray.length + " zip file size:" + file.length() + "zip file ratio%: " + d2);
        }
        return true;
    }

    public static String getAppResourceString(Context context, String string) {
        String string2 = resourceTable.get(string);
        if (string2 != null) {
            return string2;
        }
        int n = context.getResources().getIdentifier(string, "string", context.getPackageName());
        string2 = context.getString(n);
        if (string2 != null) {
            resourceTable.put(string, string2);
        }
        return string2;
    }

    public static String convertByteArrayToString(byte[] byArray) {
        StringBuilder stringBuilder = new StringBuilder();
        for (byte by : byArray) {
            stringBuilder.append(String.format("0x%02X", by));
        }
        return stringBuilder.toString();
    }

    public static boolean isSDCardExist() {
        return Environment.getExternalStorageState().equals("mounted");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean copyFile(String string, String string2) {
        boolean bl = true;
        InputStream inputStream = null;
        FileOutputStream fileOutputStream = null;
        try {
            int n = 0;
            int n2 = 0;
            File file = new File(string);
            if (file.exists()) {
                inputStream = new FileInputStream(string);
                fileOutputStream = new FileOutputStream(string2);
                byte[] byArray = new byte[1024];
                while ((n2 = inputStream.read(byArray)) != -1) {
                    n += n2;
                    fileOutputStream.write(byArray, 0, n2);
                }
                fileOutputStream.flush();
            } else {
                bl = false;
            }
        }
        catch (Exception exception) {
            bl = false;
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (Exception exception) {}
            }
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (Exception exception) {}
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean copyFolder(String string, String string2) {
        boolean bl = true;
        FileInputStream fileInputStream = null;
        FileOutputStream fileOutputStream = null;
        try {
            new File(string2).mkdirs();
            File file = new File(string);
            String[] stringArray = file.list();
            String string3 = null;
            File file2 = null;
            for (String string4 : stringArray) {
                string3 = string.endsWith(File.separator) ? string + string4 : string + File.separator + string4;
                file2 = new File(string3);
                if (file2.isFile()) {
                    try {
                        int n;
                        fileInputStream = new FileInputStream(file2);
                        fileOutputStream = new FileOutputStream(string2 + "/" + file2.getName());
                        byte[] byArray = new byte[5120];
                        while ((n = fileInputStream.read(byArray)) != -1) {
                            fileOutputStream.write(byArray, 0, n);
                        }
                        fileOutputStream.flush();
                    }
                    catch (Exception exception) {
                        bl = false;
                    }
                    finally {
                        if (fileInputStream != null) {
                            try {
                                fileInputStream.close();
                            }
                            catch (Exception exception) {}
                        }
                        if (fileOutputStream != null) {
                            try {
                                fileOutputStream.close();
                            }
                            catch (Exception exception) {}
                        }
                    }
                }
                if (!file2.isDirectory()) continue;
                EasyUtils.copyFolder(string + "/" + string4, string2 + "/" + string4);
            }
        }
        catch (Exception exception) {
            bl = false;
        }
        return bl;
    }

    public static String useridFromJid(String string) {
        String string2 = "";
        string2 = string.contains("_") && string.contains("@easemob.com") ? string.substring(string.indexOf("_") + 1, string.indexOf("@")) : (string.contains("_") ? string.substring(string.indexOf("_") + 1) : string);
        return string2;
    }

    public static String getMediaRequestUid(String string, String string2) {
        return string + "_" + string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static X509Certificate[] convertToCerts(List<String> list) {
        ArrayList<X509Certificate> arrayList = new ArrayList<X509Certificate>();
        ByteArrayInputStream byteArrayInputStream = null;
        for (int i = 0; i < list.size(); ++i) {
            String string = list.get(i);
            try {
                byteArrayInputStream = new ByteArrayInputStream(string.getBytes(StandardCharsets.UTF_8));
                CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
                X509Certificate x509Certificate = (X509Certificate)certificateFactory.generateCertificate(byteArrayInputStream);
                arrayList.add(x509Certificate);
                continue;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                EMLog.e(TAG, exception.getMessage());
                continue;
            }
            finally {
                if (byteArrayInputStream != null) {
                    try {
                        ((InputStream)byteArrayInputStream).close();
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                }
            }
        }
        X509Certificate[] x509CertificateArray = new X509Certificate[arrayList.size()];
        arrayList.toArray(x509CertificateArray);
        return x509CertificateArray;
    }

    public static X509TrustManager getSystemDefaultTrustManager() {
        try {
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            trustManagerFactory.init((KeyStore)null);
            TrustManager[] trustManagerArray = trustManagerFactory.getTrustManagers();
            for (int i = 0; i < trustManagerArray.length; ++i) {
                if (!(trustManagerArray[i] instanceof X509TrustManager)) continue;
                return (X509TrustManager)trustManagerArray[i];
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return null;
    }
}

