/*
 * Decompiled with CFR 0.152.
 */
package com.hyphenate.chat;

import android.net.Uri;
import com.hyphenate.chat.EMMessageBody;
import com.hyphenate.chat.adapter.message.EMAFileMessageBody;
import com.hyphenate.chat.adapter.message.EMAImageMessageBody;
import com.hyphenate.chat.adapter.message.EMAVideoMessageBody;
import com.hyphenate.chat.adapter.message.EMAVoiceMessageBody;
import com.hyphenate.util.EMFileHelper;
import java.io.File;

public abstract class EMFileMessageBody
extends EMMessageBody {
    public EMFileMessageBody(String string) {
        this(EMFileHelper.getInstance().formatInUri(string));
    }

    public EMFileMessageBody(Uri uri) {
        this(uri, 5);
    }

    EMFileMessageBody(String string, int n) {
        this(Uri.fromFile((File)new File(string)), n);
    }

    EMFileMessageBody(Uri uri, int n) {
        switch (n) {
            case 5: {
                this.emaObject = new EMAFileMessageBody(uri, n);
                this.setFileLength(EMFileHelper.getInstance().getFileLength(uri));
                break;
            }
            case 1: {
                this.emaObject = new EMAImageMessageBody(uri, null);
                this.setFileLength(EMFileHelper.getInstance().getFileLength(uri));
                break;
            }
            case 2: {
                this.emaObject = new EMAVideoMessageBody(uri, null);
                this.setFileLength(EMFileHelper.getInstance().getFileLength(uri));
                break;
            }
            case 4: {
                this.emaObject = new EMAVoiceMessageBody(uri, 0);
                this.setFileLength(EMFileHelper.getInstance().getFileLength(uri));
                break;
            }
        }
    }

    public EMFileMessageBody(EMAFileMessageBody eMAFileMessageBody) {
        this.emaObject = eMAFileMessageBody;
    }

    public String getFileName() {
        return ((EMAFileMessageBody)this.emaObject).displayName();
    }

    public void setFileName(String string) {
        ((EMAFileMessageBody)this.emaObject).setDisplayName(string);
    }

    public String getLocalUrl() {
        return EMFileHelper.getInstance().formatOutLocalUrl(((EMAFileMessageBody)this.emaObject).getLocalUrl());
    }

    public void setLocalUrl(String string) {
        ((EMAFileMessageBody)this.emaObject).setLocalPath(EMFileHelper.getInstance().formatInUriToString(string));
    }

    public Uri getLocalUri() {
        return EMFileHelper.getInstance().formatOutUri(((EMAFileMessageBody)this.emaObject).getLocalUrl());
    }

    public void setLocalUrl(Uri uri) {
        ((EMAFileMessageBody)this.emaObject).setLocalPath(EMFileHelper.getInstance().formatInUriToString(uri));
    }

    public String getRemoteUrl() {
        return ((EMAFileMessageBody)this.emaObject).getRemoteUrl();
    }

    public void setRemoteUrl(String string) {
        ((EMAFileMessageBody)this.emaObject).setRemotePath(string);
    }

    public void setSecret(String string) {
        ((EMAFileMessageBody)this.emaObject).setSecretKey(string);
    }

    public String getSecret() {
        return ((EMAFileMessageBody)this.emaObject).getSecret();
    }

    public String displayName() {
        return ((EMAFileMessageBody)this.emaObject).displayName();
    }

    public void setFileLength(long l) {
        ((EMAFileMessageBody)this.emaObject).setFileLength(l);
    }

    public EMDownloadStatus downloadStatus() {
        EMAFileMessageBody.EMADownloadStatus eMADownloadStatus = ((EMAFileMessageBody)this.emaObject).downloadStatus();
        switch (eMADownloadStatus) {
            case DOWNLOADING: {
                return EMDownloadStatus.DOWNLOADING;
            }
            case SUCCESSED: {
                return EMDownloadStatus.SUCCESSED;
            }
            case FAILED: {
                return EMDownloadStatus.FAILED;
            }
            case PENDING: {
                return EMDownloadStatus.PENDING;
            }
        }
        return EMDownloadStatus.SUCCESSED;
    }

    public void setDownloadStatus(EMDownloadStatus eMDownloadStatus) {
        ((EMAFileMessageBody)this.emaObject).setDownloadStatus(EMAFileMessageBody.EMADownloadStatus.valueOf(eMDownloadStatus.name()));
    }

    public static enum EMDownloadStatus {
        DOWNLOADING,
        SUCCESSED,
        FAILED,
        PENDING;

    }
}

