package com.hyphenate.chat;

import com.hyphenate.chat.adapter.EMAPresence;

import java.util.Map;

/**
 * \~chinese
 * 在线状态属性类，包含发布者的用户 ID、在线设备使用的平台、当前在线状态以及在线状态的扩展信息、更新时间和到期时间。
 * <p>
 * \~english
 * The presence property class that contains presence properties, including the publisher's user ID and current presence state, and the platform used by the online device, as well as the presence's extension information, update time, and subscription expiration time.
 */
public class EMPresence extends EMBase<EMAPresence> {

    public EMPresence(EMAPresence emaPresence) {
        emaObject = emaPresence;
    }


    /**
     * \~chinese
     * @return 状态发布者的用户ID。
     * \~english
     * @return The user ID of the presence publisher.
     */
    public String getPublisher() {
        return emaObject.getPublisher();
    }

    /**
     * \~chinese
     * @return 当前存在状态的详细信息。
     * key:发布者设备所使用的平台，可以是“ios”、“android”、“linux”、“windows”或“webbim”。
     * value：发布者设备的状态
     *
     *\~english
     * @return The details of the current presence state.
     * key:The platform used by the current online device of the publisher, which can be "ios", "android", "linux", "windows", or "webim".
     * value:The current presence state of the publisher.
     */
    public Map<String, Integer> getStatusList() {
        return emaObject.getStatusList();
    }

    /**
     * \~chinese
     * @return 在线状态扩展信息。
     *
     * \~english
     * @return The presence extension information.
     */
    public String getExt() {
        return emaObject.getExt();
    }
    /**
     *  \~chinese
     * @return 在线状态更新时间。该时间由服务器自动生成。
     *
     *  \~english
     *  @return The presence update time, which is generated by the server.
     */
    public long getLatestTime() {
        return emaObject.getLatestTime();
    }
    /**
     *  \~chinese
     * @return  在线状态订阅到期时间。
     *
     *  \~english
     * @return  The expiration time of the presence subscription.
     */
    public long getExpiryTime() {
        return emaObject.getExpiryTime();
    }

    @Override
    public String toString() {
        return "EMPresence{" +
                " \n publisher=" + getPublisher() +
                "，\n ext=" + getExt() +
                "，\n latesttime=" + getLatestTime() +
                "，\n expirytime=" + getExpiryTime() +
                "，\n statusList=" + getStatuListString(getStatusList()) +
                " }";
    }

    private String getStatuListString(Map<String, Integer> map) {
        String statu = "";
        for (Map.Entry<String, Integer> entry : map.entrySet()) {
            statu += "platform=" + entry.getKey() + ",value=" + entry.getValue() + "\n";
        }
        return statu;
    }

}
