/*
 *  * EaseMob CONFIDENTIAL
 * __________________
 * Copyright (C) 2017 EaseMob Technologies. All rights reserved.
 *
 * NOTICE: All information contained herein is, and remains
 * the property of EaseMob Technologies.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from EaseMob Technologies.
 */
package com.hyphenate;

/**
 * \~chinese
 * SDK 中的错误常量类。
 * 定义了 SDK 中常用的错误码。
 *
 * \~english
 * The error constant class in the SDK.
 * Defines error codes commonly used in the SDK.
 */
public class EMError {
    
    /**
     * \~chinese
     * 无错误。
     * 
     * \~english
     * No error.
     */
    public final static int EM_NO_ERROR = 0;

    /**
     * \~chinese
     * 一般错误，未细分错误一般通过此错误码抛出。
     * 
     * \~english
     * The general error. Undefined errors are generally thrown with this error code.
     */
    public final static int GENERAL_ERROR = 1;
    
    /**
     * \~chinese
     * 网络异常。
     * 
     * \~english
     * A network error occurs. 
     */
    public final static int NETWORK_ERROR = 2;

    /**
     * \~chinese
     * 数据库操作失败。
     *
     * \~english
     * A database operation fails.
     */
    public final static int DATABASE_ERROR = 3;

    /**
     * \~chinese
     * 超过服务限制。
     *
     * \~english
     * You have exceeded the service limit. 
     */
    public final static int EXCEED_SERVICE_LIMIT = 4;

    /**
     * \~chinese
     * 余额不足。
     *
     * \~english
     * The balance is insufficient.
     */
    public final static int SERVICE_ARREARAGES = 5;

    /**
     * \~chinese
     * 向服务器上报推送信息失败。
     *
     * \~english
     * Fails to report push information to the server.
     */
    public final static int PUSH_REPORT_ACTION_FAILED = 6;


    /**
     * \~chinese
     * App key 不正确。
     * 
     * \~english
     * The app key is invalid.
     */
    public final static int INVALID_APP_KEY = 100;

    /**
     * \~chinese
     * 用户 ID 不正确。
     * 
     * \~english
     * The user ID is invalid.
     */
    public final static int INVALID_USER_NAME = 101;

    /**
     * \~chinese
     * 密码不正确。
     * 
     * \~english
     * The password is invalid.
     */
    public final static int INVALID_PASSWORD = 102;
    
    /**
     * \~chinese
     * URL 不正确。
     * 
     * \~english
     * The URL is invalid.
     */
    public final static int INVALID_URL = 103;

    /**
     * \~chinese
     * token 不正确。
     *
     * \~english
     * The token is invalid.
     */
    public final static int INVALID_TOKEN = 104;

    /**
     * \~chinese
     * 用户名过长。
     *
     * \~english
     * The username is too long.
     */
    public final static int USER_NAME_TOO_LONG = 105;

    /**
     * \~chinese
     * 无效的会话。
     *
     * \~english
     * Invalid conversation.
     */
    public final static int INVALID_CONVERSATION = 107;

    /**
     * \~chinese
     * 声网 token 已过期。
     *
     * \~english
     *  The Agora token has expired.
     */
    public final static int TOKEN_EXPIRED = 108;

    /**
     * \~chinese
     * 声网 token 即将过期。
     *
     * \~english
     *  The Agora token is about to expire.
     */
    public final static int TOKEN_WILL_EXPIRE = 109;

    /**
     * \~chinese
     * 参数无效。
     *
     * \~english
     * The parameter is invalid.
     */
    public final static int INVALID_PARAM = 110;

    /**
     * \~chinese
     * 不支持的操作。
     *
     * \~english
     *  The operation is not supported.
     */
    public final static int OPERATION_UNSUPPORTED = 111;

    /**
     * \~chinese
     * 参数超过限制
     *
     * \~english
     *  Query param reaches limit
     */
    public final static int QUERY_PARAM_REACHES_LIMIT = 112;

    /**
     * \~chinese
     * 用户已登录。
     * 
     * \~english
     * The user is already logged in.
     */
    public final static int USER_ALREADY_LOGIN = 200;

    /**
     * \~chinese
     * 用户未登录。
     * 
     * \~english
     * The user is not logged in.
     */
    public final static int USER_NOT_LOGIN = 201;

    /**
     * \~chinese
     * 用户 ID 或密码不正确。
     * 
     * \~english
     * The user ID or password is incorrect.
     */
    public final static int USER_AUTHENTICATION_FAILED = 202;

    /**
     * \~chinese
     * 用户已存在。
     * 
     * \~english
     * The user already exists.
     */
    public final static int USER_ALREADY_EXIST = 203;

    /**
     * \~chinese
     * 用户不存在。
     * 
     * \~english
     * The user is not found.
     */
    public final static int USER_NOT_FOUND = 204;

    /**
     * \~chinese
     * 参数不合法。
     * 
     * \~english
     * Invalid parameter.
     */
    public final static int USER_ILLEGAL_ARGUMENT = 205;
    
    /**
     * \~chinese
     * 当前用户在其他设备登录。
     * 
     * \~english
     * The user has logged in from another device.
     */
    public final static int USER_LOGIN_ANOTHER_DEVICE = 206;

    /**
     * \~chinese
     * 当前用户从服务器端被删掉。
     * 
     * \~english
     * The user is removed from the server.
     */
    public final static int USER_REMOVED = 207;

    /**
     * \~chinese
     * 用户注册失败。
     * 
     * \~english
     * The user registration fails.
     */
    public final static int USER_REG_FAILED = 208;

    /**
     * \~chinese
     * 更新用户信息失败。
     * 
     * \~english
     * Fails to update user information.
     */
    public final static int USER_UPDATEINFO_FAILED = 209;

    /**
     * \~chinese
     * 用户无操作权限。
     * 
     * \~english
     * The user has no operation permission.
     */
    public final static int USER_PERMISSION_DENIED = 210;
    
    /**
     * \~chinese
     * 绑定设备 token 失败。
     * 
     * \~english
     * Fails to bind the device token.
     */
    public final static int USER_BINDDEVICETOKEN_FAILED = 211;
    
    /**
     * \~chinese
     * 解绑设备 token 失败。
     * 
     * \~english
     * Fails to unbind the device token.
     */
    public final static int USER_UNBIND_DEVICETOKEN_FAILED = 212;

    /**
     * \~chinese
     * 用户已与其他设备绑定，无法自动登录。
     *
     * \~english
     * The user is bound to another device and automatic login is not allowed.
     */
    public final static int USER_BIND_ANOTHER_DEVICE = 213;

    /**
     * \~chinese
     * 用户登录设备数超过限制。
     *
     * \~english
     * The user is logged in on too many devices. 
     */
    public final static int USER_LOGIN_TOO_MANY_DEVICES = 214;

    /**
     * \~chinese
     * 用户在群组或聊天室中被禁言。
     *
     * \~english
     * The user is muted in the chat group or chat room. 
     */
    public final static int USER_MUTED = 215;

    /**
     * \~chinese
     * 用户密码更新。
     *
     * \~english
     * The user has changed the password.
     */
    public final static int USER_KICKED_BY_CHANGE_PASSWORD = 216;

    /**
     * \~chinese
     * 用户被踢下线。
     *
     * \~english
     * The user is kicked off from another device. 
     */
    public final static int USER_KICKED_BY_OTHER_DEVICE = 217;
    /**
     * \~chinese
     * 其他用户已登录。
     *
     * \~english
     * Another user is already logged in. 
     */
    public final static int USER_ALREADY_LOGIN_ANOTHER = 218;
    /**
     * \~chinese
     * 当前用户被管理员禁言。
     *
     * \~english
     * The user is muted by the admin. 
     */
    public final static int USER_MUTED_BY_ADMIN = 219;

    /**
     * \~chinese
     * 用户登录设备与上次不一致，需重新登录。
     * 注意：默认允许用户登录，但用户在其他设备会被踢下线。该错误在开启不踢掉其他设备上的登录开关后才会生效。
     *
     * \~english
     * The current login device is not the same as last time and you need to log in again.
     * Note: By default, the user is allowed to log in to the current device, but will be kicked off from another device. This method works only when the switch of not kicking off users from other devices is turned on.
     */
    public final static int USER_DEVICE_CHANGED = 220;

    /**
     * \~chinese
     * 用户不是好友，不能够发送消息
     * 注意：默认是可以给陌生人发送消息的，需要开启只有好友才能发送消息的功能，才会报此错
     *
     * \~english
     * User is not your friend, can not send message
     * Note: By default, you can send messages to strangers.
     * You need to turn on the function that only friends can send messages before this error will be reported.
     */
    public final static int USER_NOT_ON_ROSTER = 221;

    /**
     * \~chinese
     * 无法访问到服务器
     *
     * \~english
     * Unable to access the server.
     */
    public final static int SERVER_NOT_REACHABLE = 300;
    
    /**
     * \~chinese
     * 等待服务器响应超时。
     * 
     * \~english
     * The server response times out. 
     */
    public final static int SERVER_TIMEOUT = 301;

    /**
     * \~chinese
     * 服务器繁忙。
     * 
     * \~english
     * The server is busy.
     */
    public final static int SERVER_BUSY = 302;
    
    /**
     * \~chinese
     * 未知服务器错误。
     * 
     * \~english
     * An unknown server error.
     */
    public final static int SERVER_UNKNOWN_ERROR = 303;

    /**
     * \~chinese
     * 获取 DNS 服务器列表失败。
     * 
     * \~english
     * Fails to get the DNS server list.
     */
    public final static int SERVER_GET_DNSLIST_FAILED = 304;

    /**
     * \~chinese
     * chat 功能限制。
     * 
     * \~english
     * The chat function is restricted.
     */
    public final static int SERVER_SERVICE_RESTRICTED = 305;


    /**
     * \~chinese
     * 文件未找到。
     * 
     * \~english
     * The file is not found.
     */
    public final static int FILE_NOT_FOUND = 400;
    
    /**
     * \~chinese
     * 文件不合法。
     * 
     * \~english
     * The file is invalid.
     */
    public final static int FILE_INVALID = 401;
    
    /**
     * \~chinese
     * 文件上传失败。
     * 
     * \~english
     * The file upload fails.
     */
    public final static int FILE_UPLOAD_FAILED = 402;
    
    /**
     * \~chinese
     * 文件下载失败。
     * 
     * \~english
     * The file download fails.
     */
    public final static int FILE_DOWNLOAD_FAILED = 403;

    /**
     * \~chinese
     * 文件删除失败。
     *
     * \~english
     * The file deletion fails.
     */
    public final static int FILE_DELETE_FAILED = 404;

    /**
     * \~chinese
     * 文件太大。
     *
     * \~english
     * The file is too large.
     */
    public final static int FILE_TOO_LARGE = 405;

    /**
     * \~chinese
     * 文件内容不合规。
     *
     * \~english
     * The file contains improper content.
     */
    public final static int FILE_CONTENT_IMPROPER = 406;

    /**
     * \~chinese
     * 消息不合法。
     * 
     * \~english
     * The message is invalid.
     */
    public final static int MESSAGE_INVALID = 500;
 
    /**
     * \~chinese
     * 消息内容包含非法或敏感词。
     * 
     * \~english
     * The message contains invalid content or sensitive words.
     */
    public final static int MESSAGE_INCLUDE_ILLEGAL_CONTENT = 501;

    /**
     * \~chinese
     * 消息发送过快，触发限流。
     * 
     * \~english
     * The traffic limit for message sending is exceeded.
     */
    public final static int MESSAGE_SEND_TRAFFIC_LIMIT = 502;

    /**
     * \~chinese
     * 消息加解密错误。
     * 
     * \~english
     * The message encryption/decryption error.
     */
    public final static int MESSAGE_ENCRYPTION_ERROR = 503;

    /**
     * \~chinese
     * 消息撤回超时。
     *
     * \~english
     * The message recall times out.
     */
    public final static int MESSAGE_RECALL_TIME_LIMIT = 504;

    /**
     * \~chinese
     * 服务未开通。
     *
     * \~english
     * The service is not enabled.
     */
    public final static int SERVICE_NOT_ENABLED = 505;

    /**
     * \~chinese
     * 消息过期。
     *
     * \~english
     * The message has expired.
     */
    public final static int MESSAGE_EXPIRED = 506;

    /**
     * \~chinese
     * 群组或者聊天室开启了全员禁言且用户不在白名单中。
     *
     * \~english
     * All members in a group or chat room are muted and the current user is not on the allowlist.
     */
    public final static int MESSAGE_ILLEGAL_WHITELIST = 507;

    /**
     * \~chinese
     * 消息执行发送前回调，被用户自己的逻辑拦截。
     *
     * \~english
     * A message is blocked by pre-delivery callback.
     */
    public final static int MESSAGE_EXTERNAL_LOGIC_BLOCKED = 508;

    /**
     * \~chinese
     * 消息发送达到上限
     *
     * \~english
     * Message sending limit reached
     */
    public final static int MESSAGE_CURRENT_LIMITING = 509;

    /**
     * \~chinese
     * 群组 ID 不正确
     * 
     * \~english
     * The group ID is incorrect.
     */
    public final static int GROUP_INVALID_ID = 600;     
    /**
     * \~chinese
     * 用户已加入该群组。
     * 
     * \~english
     * The user is already in the group.
     */
    public final static int GROUP_ALREADY_JOINED = 601;
    /**
     * \~chinese
     * 用户未加入该群组。
     * 
     * \~english
     * The user is not in the group.
     */
    public final static int GROUP_NOT_JOINED = 602;
    /**
     * \~chinese
     * 无群组操作权限。
     * 
     * \~english
     * The user does not have group operation permissions.
     */
    public final static int GROUP_PERMISSION_DENIED = 603;      
    /**
     * \~chinese
     * 群成员已满。
     * 
     * \~english
     * The group has reached the maximum member capacity.
     */
    public final static int GROUP_MEMBERS_FULL = 604;
    
    /**
     * \~chinese
     * 群组不存在。
     * 
     * \~english
     * The group does not exist.
     */
    public final static int GROUP_NOT_EXIST = 605;


    /**
     * \~chinese
     * 聊天室 ID 不正确。
     * 
     * \~english
     * The chat room ID is invalid.
     */
    public final static int CHATROOM_INVALID_ID = 700;

    /**
     * \~chinese
     * 已加入聊天室。
     * 
     * \~english
     * The user is already in the chat room.
     */
    public final static int CHATROOM_ALREADY_JOINED = 701;

    /**
     * \~chinese
     * 未加入聊天室。
     * \~english
     * The user is not in the chat room.
     */
    public final static int CHATROOM_NOT_JOINED = 702;

    /**
     * \~chinese
     * 没有权限进行该操作。
     * \~english
     * The user does not have the operation permission.
     */
    public final static int CHATROOM_PERMISSION_DENIED = 703;

    /**
     * \~chinese
     * 聊天室人数已满。
     * 
     * \~english
     * The chat room has reached the maximum member capacity.
     */
    public final static int CHATROOM_MEMBERS_FULL = 704;
    
    /**
     * \~chinese
     * 聊天室不存在。
     * 
     * \~english
     * The chat room does not exist.
     */
    public final static int CHATROOM_NOT_EXIST = 705;

    /**
     * \~chinese
     * 当前设备不支持推送。
     *
     * \~english
     * The current device does not support push.
     */
    public final static int PUSH_NOT_SUPPORT = 900;

    /**
     * \~chinese
     * 推送令牌绑定失败。
     *
     * \~english
     * Fails to bind the push token.
     */
    public final static int PUSH_BIND_FAILED = 901;

    /**
     * \~chinese
     * 推送令牌解除绑定失败。
     *
     * \~english
     * Fails to unbind the push token.
     */
    public final static int PUSH_UNBIND_FAILED = 902;

    /**
     * \~chinese
     * 翻译参数无效。
     *
     * \~english
     * Invalid translation parameters.
     */
    public final static int TRANSLATE_INVALID_PARAMS = 903;

    /**
     * \~chinese
     * 翻译失败。
     *
     * \~english
     * Translation failure.
     */
    public final static int TRANSLATE_FAIL = 904;

    /**
     * \~chinese
     * 没有初始化翻译。
     *
     * \~english
     * The translation is not initialized.
     */
    public final static int TRANSLATE_NOT_INIT = 905;

    /**
     * \~chinese
     * 添加联系人失败。
     *
     * \~english
     * Failed to add a contact
     */
    public final static int CONTACT_ADD_FAILED = 1000;
    /**
     * \~chinese
     * 邀请者好友达到上限。
     *
     * \~english
     * The number of inviter friends reached the upper limit.
     */
    public final static int CONTACT_REACH_LIMIT = 1001;
    /**
     * \~chinese
     * 受邀请者好友达到上限。
     *
     * \~english
     * The number of invitees' friends reached the upper limit.
     */
    public final static int CONTACT_REACH_LIMIT_PEER = 1002;
    
    /**
     * \~chinese
     * 调用presence相关方法时参数长度超出限制
     *
     * \~english
     * The parameter length of the presence method exceeded the upper limit.
     */
    public final static int  PRESENCE_PARAM_LENGTH_EXCEED = 1100;

}
