/*
 * Decompiled with CFR 0.152.
 */
package com.hyphenate.notification;

import android.app.Notification;
import android.app.NotificationChannel;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.os.Build;
import android.support.annotation.IdRes;
import android.support.v4.app.NotificationCompat;
import android.text.TextUtils;
import android.util.Log;
import android.widget.RemoteViews;
import com.hyphenate.notification.a;
import java.lang.ref.SoftReference;
import java.lang.reflect.Method;
import java.text.SimpleDateFormat;
import java.util.Date;

public class EMNotificationBuilder {
    private Context appContext;
    private boolean sound;
    private boolean vibrate;
    private String channelId;
    private String channelName;
    private int channelLevel;
    private boolean autoCancel = true;
    private String title;
    private String content;
    private String formatedDate;
    private SoftReference<Bitmap> iconBitmapRef;
    private EMNotificationDefaultStyle style = new EMNotificationDefaultStyle();
    private PendingIntent pendingIntent;
    private int smallIcon = 17301651;
    private String ticker;
    private PendingIntent fullScreenIntent;

    public EMNotificationBuilder(Context context) {
        if (context == null) {
            throw new IllegalArgumentException("context cannot is null");
        }
        this.appContext = context.getApplicationContext();
    }

    public EMNotificationBuilder setTitle(String string) {
        this.title = string;
        return this;
    }

    public EMNotificationBuilder setContent(String string) {
        this.content = string;
        return this;
    }

    public EMNotificationBuilder setFormatedDate(String string) {
        this.formatedDate = string;
        return this;
    }

    public EMNotificationBuilder setIcon(@IdRes int n) {
        Bitmap bitmap = BitmapFactory.decodeResource((Resources)this.appContext.getResources(), (int)n);
        if (bitmap != null) {
            this.iconBitmapRef = new SoftReference<Bitmap>(bitmap);
        }
        return this;
    }

    public EMNotificationBuilder setIcon(Bitmap bitmap) {
        if (bitmap != null) {
            this.iconBitmapRef = new SoftReference<Bitmap>(bitmap);
        }
        return this;
    }

    public EMNotificationBuilder setSmallIcon(@IdRes int n) {
        this.smallIcon = n;
        return this;
    }

    public EMNotificationBuilder setStyle(EMNotificationDefaultStyle eMNotificationDefaultStyle) {
        this.style = eMNotificationDefaultStyle;
        return this;
    }

    public EMNotificationBuilder setPendingIntent(PendingIntent pendingIntent) {
        this.pendingIntent = pendingIntent;
        return this;
    }

    public EMNotificationBuilder setFullScreenIntent(PendingIntent pendingIntent) {
        this.fullScreenIntent = pendingIntent;
        return this;
    }

    public EMNotificationBuilder setSound(boolean bl) {
        this.sound = bl;
        return this;
    }

    public EMNotificationBuilder setVibrate(boolean bl) {
        this.vibrate = bl;
        return this;
    }

    public EMNotificationBuilder setLevel(int n) {
        this.channelLevel = n;
        return this;
    }

    public EMNotificationBuilder setTicker(String string) {
        this.ticker = string;
        return this;
    }

    public EMNotificationBuilder setChannelId(String string) {
        if (!TextUtils.isEmpty((CharSequence)string)) {
            this.channelId = string;
        }
        return this;
    }

    public EMNotificationBuilder setChannelName(String string) {
        if (!TextUtils.isEmpty((CharSequence)string)) {
            this.channelName = string;
        }
        return this;
    }

    public EMNotificationBuilder setAutoCancel(boolean bl) {
        this.autoCancel = bl;
        return this;
    }

    public Notification build() {
        Object object;
        RemoteViews remoteViews;
        if (this.channelId == null) {
            this.channelId = "chat";
        }
        if (this.channelName == null) {
            this.channelName = "\u6d88\u606f";
        }
        this.createNotificationChannel(this.appContext, this.vibrate, this.channelId, this.channelName, this.channelLevel);
        if (TextUtils.isEmpty((CharSequence)this.formatedDate)) {
            this.formatedDate = new SimpleDateFormat("HH:mm").format(new Date()).toString();
        }
        if ((remoteViews = this.getRemoteView(this.appContext, this.title, this.content, this.iconBitmapRef, this.formatedDate)) == null) {
            this.printLog("remoteViews create failed!");
            return null;
        }
        RemoteViews remoteViews2 = this.getBigRemoteView(this.appContext, this.title, this.content, this.iconBitmapRef, this.formatedDate, this.style);
        if (remoteViews2 == null) {
            this.printLog("bigRemoteViews create failed!");
            return null;
        }
        int n = 0;
        if (this.sound) {
            n = 1;
        }
        if (this.vibrate) {
            n = 2;
        }
        if (this.sound && this.vibrate) {
            n = -1;
        }
        NotificationCompat.Builder builder = new NotificationCompat.Builder(this.appContext);
        try {
            object = NotificationCompat.Builder.class.getDeclaredMethod("setChannelId", String.class);
            ((Method)object).setAccessible(true);
            ((Method)object).invoke((Object)builder, this.channelId);
        }
        catch (Exception exception) {
            // empty catch block
        }
        builder.setSmallIcon(this.smallIcon);
        if (n != 0) {
            builder.setDefaults(n);
        }
        if (this.iconBitmapRef != null && this.iconBitmapRef.get() != null) {
            builder.setLargeIcon(this.iconBitmapRef.get());
        }
        builder.setTicker((CharSequence)this.ticker).setPriority(this.channelLevel - 3).setVisibility(1).setAutoCancel(this.autoCancel).setCustomContentView(remoteViews).setCustomBigContentView(remoteViews2).setContentTitle((CharSequence)this.title).setContentText((CharSequence)this.content).setContentIntent(this.pendingIntent).setWhen(System.currentTimeMillis());
        if (this.fullScreenIntent != null) {
            builder.setFullScreenIntent(this.fullScreenIntent, true);
        }
        if (this.vibrate) {
            object = new long[]{100L, 200L, 300L, 400L, 500L};
            builder.setVibrate((long[])object);
        }
        object = builder.build();
        builder.setPublicVersion((Notification)object);
        return object;
    }

    private void createNotificationChannel(Context context, boolean bl, String string, String string2, int n) {
        if (Build.VERSION.SDK_INT >= 26) {
            int n2 = 3;
            if (n >= 0 && n <= 5) {
                n2 = n;
            }
            NotificationChannel notificationChannel = new NotificationChannel(string, (CharSequence)string2, n2);
            if (bl) {
                notificationChannel.enableVibration(true);
                notificationChannel.setVibrationPattern(new long[]{100L, 200L, 300L, 400L, 500L});
            }
            NotificationManager notificationManager = (NotificationManager)context.getSystemService("notification");
            notificationManager.createNotificationChannel(notificationChannel);
        }
    }

    private RemoteViews getRemoteView(Context context, String string, String string2, SoftReference<Bitmap> softReference, String string3) {
        String string4 = context.getPackageName();
        int n = context.getResources().getIdentifier("em_simple_notification", "layout", string4);
        if (n <= 0) {
            this.printLog("layout id is not exist");
            return null;
        }
        int n2 = context.getResources().getIdentifier("em_notification_icon", "id", string4);
        if (n2 <= 0) {
            this.printLog("icon id is not exist");
            return null;
        }
        int n3 = context.getResources().getIdentifier("em_notification_title", "id", string4);
        if (n3 <= 0) {
            this.printLog("title id is not exist");
            return null;
        }
        int n4 = context.getResources().getIdentifier("em_notification_content", "id", string4);
        if (n4 <= 0) {
            this.printLog("content id is not exist");
            return null;
        }
        int n5 = context.getResources().getIdentifier("em_notification_date", "id", string4);
        if (n5 <= 0) {
            this.printLog("date id is not exist");
            return null;
        }
        RemoteViews remoteViews = new RemoteViews(context.getPackageName(), n);
        remoteViews.setTextViewText(n3, (CharSequence)string);
        remoteViews.setTextViewText(n4, (CharSequence)string2);
        if (softReference != null && softReference.get() != null) {
            remoteViews.setImageViewBitmap(n2, softReference.get());
        } else {
            remoteViews.setViewVisibility(n2, 8);
        }
        remoteViews.setTextViewText(n5, (CharSequence)string3);
        a.a(context).a(remoteViews, n3).b(remoteViews, n4).b(remoteViews, n5);
        return remoteViews;
    }

    private RemoteViews getBigRemoteView(Context context, String string, String string2, SoftReference<Bitmap> softReference, String string3, EMNotificationDefaultStyle eMNotificationDefaultStyle) {
        RemoteViews remoteViews = this.getRemoteView(context, string, string2, softReference, string3);
        if (remoteViews != null) {
            int n = context.getResources().getIdentifier("em_bigview_TextView", "id", context.getPackageName());
            int n2 = context.getResources().getIdentifier("em_bigview_imageView", "id", context.getPackageName());
            remoteViews.setViewVisibility(n, 8);
            remoteViews.setViewVisibility(n2, 8);
            if (eMNotificationDefaultStyle instanceof EMNotificationBigTextStyle) {
                String string4 = ((EMNotificationBigTextStyle)eMNotificationDefaultStyle).getBigTxt();
                if (n <= 0) {
                    this.printLog("bigTxt id is not exist");
                    return null;
                }
                remoteViews.setViewVisibility(n, 0);
                remoteViews.setTextViewText(n, (CharSequence)string4);
                a.a(context).a(remoteViews, n);
            } else if (eMNotificationDefaultStyle instanceof EMNotificationBigPicStyle) {
                Bitmap bitmap = ((EMNotificationBigPicStyle)eMNotificationDefaultStyle).getBigPic();
                if (n2 <= 0) {
                    this.printLog("bigPic id is not exist");
                    return null;
                }
                if (bitmap != null) {
                    remoteViews.setImageViewBitmap(n2, bitmap);
                    remoteViews.setViewVisibility(n2, 0);
                } else {
                    remoteViews.setViewVisibility(n2, 8);
                }
            }
        }
        return remoteViews;
    }

    private void printLog(String string) {
        Log.e((String)"notif_helper", (String)string);
    }

    public static class EMNotificationBigPicStyle
    extends EMNotificationDefaultStyle {
        private SoftReference<Bitmap> bitmapRef;

        public Bitmap getBigPic() {
            if (this.bitmapRef != null && this.bitmapRef.get() != null) {
                return this.bitmapRef.get();
            }
            return null;
        }

        public EMNotificationBigPicStyle setBigPic(Bitmap bitmap) {
            if (bitmap != null) {
                this.bitmapRef = new SoftReference<Bitmap>(bitmap);
            }
            return this;
        }
    }

    public static class EMNotificationBigTextStyle
    extends EMNotificationDefaultStyle {
        private String bigTxt;

        public String getBigTxt() {
            return this.bigTxt;
        }

        public EMNotificationBigTextStyle setBigTxt(String string) {
            this.bigTxt = string;
            return this;
        }
    }

    public static class EMNotificationDefaultStyle {
    }
}

