/*
 * Decompiled with CFR 0.152.
 */
package com.hyphenate.chat;

import android.content.Context;
import android.content.SharedPreferences;
import android.preference.PreferenceManager;
import android.text.TextUtils;
import com.hyphenate.chat.EMClient;
import com.hyphenate.chat.EMContact;
import com.hyphenate.chat.adapter.EMAREncryptUtils;
import com.hyphenate.chat.adapter.EMASessionManager;
import com.hyphenate.util.CryptoUtils;

class EMSessionManager {
    private static final String TAG = "Session";
    private Context appContext = null;
    private static final String PREF_KEY_LOGIN_USER = "easemob.chat.loginuser";
    private static final String PREF_KEY_LOGIN_PWD = "easemob.chat.loginpwd";
    private static final String PREF_KEY_LOGIN_TOKEN = "easemob.chat.login.token";
    private static final String PREF_KEY_LOGIN_WITH_TOKEN = "easemob.chat.login_with_token";
    private static final String PREF_KEY_LOGIN_PWD_GCM = "easemob.chat.loginpwd.gcm";
    private static final String PREF_KEY_LOGIN_TOKEN_GCM = "easemob.chat.login.token.gcm";
    public EMContact currentUser = null;
    private static EMSessionManager instance = new EMSessionManager();
    private String lastLoginUser = null;
    private String lastLoginPwd = null;
    private String lastLoginToken = null;
    EMClient mClient;
    EMASessionManager mSessionManager;
    private EMAREncryptUtils encryptUtils;

    EMSessionManager() {
    }

    static synchronized EMSessionManager getInstance() {
        if (EMSessionManager.instance.appContext == null) {
            EMSessionManager.instance.appContext = EMClient.getInstance().getContext();
        }
        return instance;
    }

    void init(EMClient eMClient, EMASessionManager eMASessionManager) {
        this.mClient = eMClient;
        this.mSessionManager = eMASessionManager;
        this.encryptUtils = new EMAREncryptUtils();
    }

    String getLastLoginUser() {
        if (this.lastLoginUser == null) {
            SharedPreferences sharedPreferences = PreferenceManager.getDefaultSharedPreferences((Context)this.appContext);
            this.lastLoginUser = sharedPreferences.getString(PREF_KEY_LOGIN_USER, "");
            this.currentUser = new EMContact(this.lastLoginUser);
        }
        return this.lastLoginUser;
    }

    void setLastLoginUser(String string) {
        if (string == null) {
            return;
        }
        this.currentUser = new EMContact(string);
        this.lastLoginUser = string;
        SharedPreferences sharedPreferences = PreferenceManager.getDefaultSharedPreferences((Context)this.appContext);
        SharedPreferences.Editor editor = sharedPreferences.edit();
        editor.putString(PREF_KEY_LOGIN_USER, string);
        editor.commit();
    }

    String getLastLoginPwd() {
        if (this.lastLoginPwd == null) {
            SharedPreferences sharedPreferences = PreferenceManager.getDefaultSharedPreferences((Context)this.appContext);
            String string = sharedPreferences.getString(PREF_KEY_LOGIN_PWD_GCM, "");
            if (TextUtils.isEmpty((CharSequence)string)) {
                string = sharedPreferences.getString(PREF_KEY_LOGIN_PWD, "");
                if (TextUtils.isEmpty((CharSequence)string)) {
                    this.lastLoginPwd = "";
                    return this.lastLoginPwd;
                }
                try {
                    CryptoUtils cryptoUtils = EMClient.getInstance().getCryptoUtils();
                    this.lastLoginPwd = cryptoUtils.decryptBase64String(string);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                return this.lastLoginPwd;
            }
            try {
                this.lastLoginPwd = this.decryptData(this.mSessionManager.getEncryptionKey(this.getLastLoginUser()), string);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return this.lastLoginPwd;
    }

    void setLastLoginPwd(String string) {
        if (string == null) {
            return;
        }
        this.lastLoginPwd = string;
        SharedPreferences sharedPreferences = PreferenceManager.getDefaultSharedPreferences((Context)this.appContext);
        SharedPreferences.Editor editor = sharedPreferences.edit();
        try {
            String string2 = this.encryptData(this.mSessionManager.getEncryptionKey(this.getLastLoginUser()), string);
            editor.putString(PREF_KEY_LOGIN_PWD_GCM, string2);
            editor.commit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    String getLastLoginToken() {
        if (this.lastLoginToken == null) {
            SharedPreferences sharedPreferences = PreferenceManager.getDefaultSharedPreferences((Context)this.appContext);
            String string = sharedPreferences.getString(PREF_KEY_LOGIN_TOKEN_GCM, "");
            if (TextUtils.isEmpty((CharSequence)string)) {
                string = sharedPreferences.getString(PREF_KEY_LOGIN_TOKEN, "");
                if (TextUtils.isEmpty((CharSequence)string)) {
                    this.lastLoginToken = "";
                    return this.lastLoginToken;
                }
                try {
                    CryptoUtils cryptoUtils = EMClient.getInstance().getCryptoUtils();
                    this.lastLoginToken = cryptoUtils.decryptBase64String(string);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                return this.lastLoginToken;
            }
            try {
                this.lastLoginToken = this.decryptData(this.mSessionManager.getEncryptionKey(this.getLastLoginUser()), string);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return this.lastLoginToken;
    }

    void setLastLoginToken(String string) {
        if (string == null) {
            return;
        }
        this.lastLoginToken = string;
        SharedPreferences sharedPreferences = PreferenceManager.getDefaultSharedPreferences((Context)this.appContext);
        SharedPreferences.Editor editor = sharedPreferences.edit();
        try {
            String string2 = this.encryptData(this.mSessionManager.getEncryptionKey(this.getLastLoginUser()), string);
            editor.putString(PREF_KEY_LOGIN_TOKEN_GCM, string2);
            editor.commit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    void clearLastLoginUser() {
        try {
            this.lastLoginUser = "";
            this.currentUser.username = "";
            this.currentUser.nick = "";
            SharedPreferences sharedPreferences = PreferenceManager.getDefaultSharedPreferences((Context)this.appContext);
            SharedPreferences.Editor editor = sharedPreferences.edit();
            editor.putString(PREF_KEY_LOGIN_USER, this.lastLoginUser);
            editor.commit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    void clearLastLoginPwd() {
        try {
            this.lastLoginPwd = "";
            SharedPreferences sharedPreferences = PreferenceManager.getDefaultSharedPreferences((Context)this.appContext);
            SharedPreferences.Editor editor = sharedPreferences.edit();
            editor.putString(PREF_KEY_LOGIN_PWD, this.lastLoginPwd);
            editor.putString(PREF_KEY_LOGIN_PWD_GCM, this.lastLoginPwd);
            editor.commit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    void clearLastLoginToken() {
        try {
            this.lastLoginToken = "";
            SharedPreferences sharedPreferences = PreferenceManager.getDefaultSharedPreferences((Context)this.appContext);
            SharedPreferences.Editor editor = sharedPreferences.edit();
            editor.putString(PREF_KEY_LOGIN_TOKEN, this.lastLoginToken);
            editor.putString(PREF_KEY_LOGIN_TOKEN_GCM, this.lastLoginToken);
            editor.commit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    boolean isLastLoginWithToken() {
        SharedPreferences sharedPreferences = PreferenceManager.getDefaultSharedPreferences((Context)this.appContext);
        return sharedPreferences.getBoolean(PREF_KEY_LOGIN_WITH_TOKEN, false);
    }

    void setLastLoginWithToken(boolean bl) {
        SharedPreferences sharedPreferences = PreferenceManager.getDefaultSharedPreferences((Context)this.appContext);
        SharedPreferences.Editor editor = sharedPreferences.edit();
        editor.putBoolean(PREF_KEY_LOGIN_WITH_TOKEN, bl);
        editor.commit();
    }

    public String getLoginUserName() {
        return this.currentUser.username;
    }

    String encryptData(byte[] byArray, String string) {
        this.encryptUtils.initAES(byArray);
        return this.encryptUtils.aesGcmEncrypt(string, 1);
    }

    String decryptData(byte[] byArray, String string) {
        this.encryptUtils.initAES(byArray);
        return this.encryptUtils.aesGcmDecrypt(string, byArray, 1);
    }
}

