/*
 * Decompiled with CFR 0.152.
 */
package com.hyphenate.chat;

import android.text.TextUtils;
import com.hyphenate.EMCallBack;
import com.hyphenate.chat.EMClient;
import com.hyphenate.chat.EMPushConfigs;
import com.hyphenate.chat.adapter.EMAError;
import com.hyphenate.chat.adapter.EMAPushConfigs;
import com.hyphenate.chat.adapter.EMAPushManager;
import com.hyphenate.exceptions.HyphenateException;
import java.util.List;

public class EMPushManager {
    private static final String TAG = EMPushManager.class.getSimpleName();
    EMClient mClient;
    EMAPushManager emaObject;

    EMPushManager(EMClient eMClient, EMAPushManager eMAPushManager) {
        this.emaObject = eMAPushManager;
        this.mClient = eMClient;
    }

    public void enableOfflinePush() throws HyphenateException {
        EMAError eMAError = new EMAError();
        this.emaObject.enableOfflineNotification(eMAError);
        this.handleError(eMAError);
    }

    public void disableOfflinePush(int n, int n2) throws HyphenateException {
        EMAError eMAError = new EMAError();
        this.emaObject.disableOfflineNotification(n, n2, eMAError);
        this.handleError(eMAError);
    }

    public EMPushConfigs getPushConfigs() {
        EMAPushConfigs eMAPushConfigs = this.emaObject.getPushConfigs();
        if (eMAPushConfigs == null) {
            return null;
        }
        return new EMPushConfigs(eMAPushConfigs);
    }

    public EMPushConfigs getPushConfigsFromServer() throws HyphenateException {
        EMAError eMAError = new EMAError();
        EMAPushConfigs eMAPushConfigs = this.emaObject.getPushConfigsFromServer(eMAError);
        this.handleError(eMAError);
        return new EMPushConfigs(eMAPushConfigs);
    }

    public void updatePushServiceForGroup(List<String> list, boolean bl) throws HyphenateException {
        EMAError eMAError = new EMAError();
        this.emaObject.updatePushServiceForGroup(list, bl, eMAError);
        this.handleError(eMAError);
    }

    public void updatePushServiceForUsers(List<String> list, boolean bl) throws HyphenateException {
        EMAError eMAError = new EMAError();
        this.emaObject.updatePushServiceForUsers(list, bl, eMAError);
        this.handleError(eMAError);
    }

    public List<String> getNoPushGroups() {
        return this.emaObject.getNoPushGroups();
    }

    public List<String> getNoPushUsers() {
        return this.emaObject.getNoPushUsers();
    }

    public boolean updatePushNickname(String string) throws IllegalArgumentException, HyphenateException {
        if (TextUtils.isEmpty((CharSequence)string)) {
            throw new IllegalArgumentException("nick name is null or empty");
        }
        String string2 = EMClient.getInstance().getCurrentUser();
        if (TextUtils.isEmpty((CharSequence)string2)) {
            throw new IllegalArgumentException("currentUser is null or empty");
        }
        String string3 = EMClient.getInstance().getAccessToken();
        if (TextUtils.isEmpty((CharSequence)string3)) {
            throw new IllegalArgumentException("token is null or empty");
        }
        EMAError eMAError = new EMAError();
        this.emaObject.updatePushNickname(string, eMAError);
        this.handleError(eMAError);
        return true;
    }

    public void asyncUpdatePushNickname(final String string, final EMCallBack eMCallBack) {
        EMClient.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    EMPushManager.this.updatePushNickname(string);
                    eMCallBack.onSuccess();
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    eMCallBack.onError(205, illegalArgumentException.getMessage());
                }
                catch (HyphenateException hyphenateException) {
                    eMCallBack.onError(hyphenateException.getErrorCode(), hyphenateException.getDescription());
                }
            }
        });
    }

    public void updatePushDisplayStyle(DisplayStyle displayStyle) throws IllegalArgumentException, HyphenateException {
        String string = EMClient.getInstance().getCurrentUser();
        if (TextUtils.isEmpty((CharSequence)string)) {
            throw new IllegalArgumentException("currentUser is null or empty");
        }
        String string2 = EMClient.getInstance().getAccessToken();
        if (TextUtils.isEmpty((CharSequence)string2)) {
            throw new IllegalArgumentException("token is null or empty");
        }
        EMAError eMAError = new EMAError();
        this.emaObject.updatePushDisplayStyle(displayStyle.ordinal(), eMAError);
        this.handleError(eMAError);
    }

    public void asyncUpdatePushDisplayStyle(final DisplayStyle displayStyle, final EMCallBack eMCallBack) {
        EMClient.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    EMPushManager.this.updatePushDisplayStyle(displayStyle);
                    eMCallBack.onSuccess();
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    eMCallBack.onError(205, illegalArgumentException.getMessage());
                }
                catch (HyphenateException hyphenateException) {
                    eMCallBack.onError(hyphenateException.getErrorCode(), hyphenateException.getDescription());
                }
            }
        });
    }

    private void handleError(EMAError eMAError) throws HyphenateException {
        if (eMAError.errCode() != 0) {
            throw new HyphenateException(eMAError);
        }
    }

    public static enum DisplayStyle {
        SimpleBanner,
        MessageSummary;

    }
}

