package com.hyphenate.push.platform.vivo;

import android.content.Context;

import com.hyphenate.EMError;
import com.hyphenate.push.EMPushConfig;
import com.hyphenate.push.EMPushHelper;
import com.hyphenate.push.EMPushType;
import com.hyphenate.push.PushListener;
import com.hyphenate.push.platform.IPush;
import com.vivo.push.IPushActionListener;
import com.vivo.push.PushClient;

/**
 * Created by zhangsong on 19-2-20
 * <p>
 * 文档地址：https://dev.vivo.com.cn/documentCenter/doc/158
 * <p>
 * 应用安装后默认未打开设置中的通知栏通知权限，需要手动打开。
 */
public class EMVivoPush extends IPush {
    private static final String TAG = "EMVivoPush";

    @Override
    public EMPushType getPushType() {
        return EMPushType.VIVOPUSH;
    }

    @Override
    public void onRegister(final Context context, EMPushConfig config, PushListener pushListener) {
        boolean support = PushClient.getInstance(context).isSupport();
        if (!support) {
            EMPushHelper.getInstance().onErrorResponse(getPushType(), EMError.PUSH_NOT_SUPPORT);
            return;
        }

        PushClient.getInstance(context).initialize();
        PushClient.getInstance(context).turnOnPush(new IPushActionListener() {
            @Override
            public void onStateChanged(int state) {
                if (state == 0) {
                    final String regId = PushClient.getInstance(context).getRegId();
                    // send regId to hyphenate server.
                    EMPushHelper.getInstance().onReceiveToken(getPushType(), regId);
                } else {
                    // handle register error.
                    EMPushHelper.getInstance().onErrorResponse(getPushType(), state);
                }
            }
        });
    }

    @Override
    public void onUnregister(Context context) {
    }

    @Override
    public String onGetNotifierName(EMPushConfig config) {
        return config.getVivoAppId() + "#" + config.getVivoAppKey();
    }
}
