package com.hyphenate.push;

import com.hyphenate.push.common.PushUtil;

/**
 * \~chinese
 * 用于设置自定义的推送设置
 *
 * \~english
 * Use to set custom push Settings
 */
public abstract class PushListener {
    public abstract void onError(EMPushType pushType, long errorCode);

    public boolean isSupportPush(EMPushType pushType, EMPushConfig pushConfig) {
        return PushUtil.isSupportPush(pushType, pushConfig);
    }

    /**
     * \~chinese
     * 主要用于获取FCM的token
     * @param pushType      推送类型
     * @param pushConfig    推送配置
     * @return              返回要注册的设备token
     *
     * \~english
     * Use to get FCM token
     * @param pushType      Push type
     * @param pushConfig    Push configs
     * @return              Return the device token
     */
    public String getPushToken(EMPushType pushType,EMPushConfig pushConfig) {
        return "";
    }
}
