package com.hyphenate.push;

import android.text.TextUtils;

/**
 * \~chinese
 * 推送类型枚举类
 *
 * \~english
 * Enum class of push type
 */
public enum EMPushType {
    FCM("FCM"),
    MIPUSH("MI"),
    HMSPUSH("HUAWEI"),
    MEIZUPUSH("MEIZU"),
    OPPOPUSH("OPPO"),
    VIVOPUSH("VIVO"),
    NORMAL("NORMAL");

    private String name;

    EMPushType(String name) {
        this.name = name;
    }

    /**
     * \~chinese
     * 获取推送类型名称
     * @return 推送类型名称
     *
     * \~english
     * Get push type name
     * @return  Push type name
     */
    public String getName() {
        return name;
    }

    /**
     * \~chinese
     * 获取推送类型
     * @param name  推送类型名称
     * @return  推送类型
     *
     * \~english
     * Get push type
     * @param name  Push type name
     * @return  Push type
     */
    public static EMPushType getType(String name) {
        if (TextUtils.isEmpty(name)) {
            return NORMAL;
        } else {
            EMPushType[] var1 = values();
            int var2 = var1.length;

            for (int var3 = 0; var3 < var2; ++var3) {
                EMPushType type = var1[var3];
                if (type.getName().equals(name)) {
                    return type;
                }
            }

            return NORMAL;
        }
    }
}
