package com.hyphenate.chat;


/**
 * \~chinese
 * 用户属性实体类，有关用户的信息,如下属性：
 * <pre>
 *    nickName：昵称
 *    avatarUrl：头像url
 *    email： 邮箱
 *    phoneNumber：电话
 *    gender：性别(默认为0 ,1表示男,2表示女,其他为非法)
 *    signature: 签名
 *    birthday： 生日
 *    userId:  环信ID
 *    ext：扩展字段(用户可自行扩展，建议封装成JSON字符串，也可以设置为空字符串)
 * </pre>
 *
 * \~english
 * User attribute entity class, information about the user,
 * the following attributes:
 * nickName, avatarUrl, email, phoneNumber, isMale,
 * signature, birthday, userId, ext
 */
public class EMUserInfo {
    private String nickName;
    private String avatarUrl;
    private String email;
    private String phoneNumber;
    private int gender = 0;
    private String signature;
    private String birth;
    private String userId;
    private String ext;


    public EMUserInfo(){
    }


    /**
     * 有关用户属性 属性值字段定义如下：
     * NICKNAME 昵称
     * AVATAR_URL  头像
     * EMAIL  邮箱
     * PHONE 电话
     * GENDER  性别
     * SIGN  签名
     * BIRTH 生日
     * EXT  扩展字段
     */
    public enum EMUserInfoType {
        NICKNAME(0,"nickname"),
        AVATAR_URL(1,"avatarurl"),
        EMAIL(2,"mail"),
        PHONE(3,"phone"),
        GENDER(4,"gender"),
        SIGN(5,"sign"),
        BIRTH(6,"birth"),
        EXT(100,"ext");

        private int value;
        private String desc;

        public int getValue() {
            return value;
        }
        public void setValue(int value) {
            this.value = value;
        }
        public String getDesc() {
            return desc;
        }
        public void setDesc(String desc) {
            this.desc = desc;
        }
        private EMUserInfoType(int value, String desc) {
            this.value = value;
            this.desc = desc;
        }
    }

    /**
     * \~chinese
     * 获取用户昵称
     * @return  用户昵称
     *
     * \~english
     * Get user nickname
     * @return  Nickname
     */
    public String getNickName() {
        return nickName;
    }

    /**
     * \~chinese
     * 设置用户昵称
     * @param nickName 用户昵称
     *
     * \~english
     * Set the user nickname
     * @param nickName
     */
    public void setNickName(String nickName) {
        this.nickName = nickName;
    }

    /**
     * \~chinese
     * 获取用户头像地址
     * @return  用户头像地址
     *
     * \~english
     * Get user avatar url
     * @return  Avatar url
     */
    public String getAvatarUrl() {
        return avatarUrl;
    }

    /**
     * \~chinese
     * 设置用户头像地址
     * @param avatarUrl 用户头像地址
     *
     * \~english
     * Set the user avatar url
     * @param avatarUrl
     */
    public void setAvatarUrl(String avatarUrl) {
        this.avatarUrl = avatarUrl;
    }

    /**
     * \~chinese
     * 获取用户邮箱地址
     * @return  用户邮箱地址
     *
     * \~english
     * Get user email
     * @return  Email
     */
    public String getEmail() {
        return email;
    }

    /**
     * \~chinese
     * 设置用户邮箱地址
     * @param email 用户邮箱地址
     *
     * \~english
     * Set the user email
     * @param email
     */
    public void setEmail(String email) {
        this.email = email;
    }

    /**
     * \~chinese
     * 获取用户电话号码
     * @return  用户电话号码
     *
     * \~english
     * Get user phone number
     * @return  Phone number
     */
    public String getPhoneNumber() {
        return phoneNumber;
    }

    /**
     * \~chinese
     * 设置用户电话号码
     * @param phoneNumber 用户电话号码
     *
     * \~english
     * Set the user phone number
     * @param phoneNumber
     */
    public void setPhoneNumber(String phoneNumber) {
        this.phoneNumber = phoneNumber;
    }

    /**
     * \~chinese
     * 获取用户性别
     * @return  用户性别
     *
     * \~english
     * Get user gender
     * @return  Gender
     */
    public int getGender() {
        return gender;
    }

    /**
     * \~chinese
     * 设置用户性别
     * @param gender 用户性别
     *
     * \~english
     * Set the user gender
     * @param gender
     */
    public void setGender(int gender) {
        this.gender = gender;
    }

    /**
     * \~chinese
     * 获取用户签名信息
     * @return  用户签名信息
     *
     * \~english
     * Get user signature
     * @return  Signature
     */
    public String getSignature() {
        return signature;
    }

    /**
     * \~chinese
     * 设置用户签名信息
     * @param signature 用户签名信息
     *
     * \~english
     * Set the user signature
     * @param signature
     */
    public void setSignature(String signature) {
        this.signature = signature;
    }

    /**
     * \~chinese
     * 获取用户生日
     * @return  用户生日
     *
     * \~english
     * Get user birthday
     * @return  Birthday
     */
    public String getBirth() {
        return birth;
    }

    /**
     * \~chinese
     * 设置用户生日
     * @param birth 用户生日
     *
     * \~english
     * Set the user birthday
     * @param birth
     */
    public void setBirth(String birth) {
        this.birth = birth;
    }

    /**
     * \~chinese
     * 获取用户id
     * @return  用户id
     *
     * \~english
     * Get user id
     * @return  User id
     */
    public String getUserId() { return userId; }

    /**
     * \~chinese
     * 设置用户id
     * @param userId 用户id
     *
     * \~english
     * Set the user id
     * @param userId
     */
    public void setUserId(String userId) { this.userId = userId;}

    /**
     * \~chinese
     * 获取用户扩展信息
     * @return  用户扩展信息
     *
     * \~english
     * Get user extension information
     * @return  Nickname
     */
    public String getExt() {
        return ext;
    }

    /**
     * \~chinese
     * 设置用户扩展信息
     * @param ext 用户扩展信息
     *
     * \~english
     * Set the user extension information
     * @param ext
     */
    public void setExt(String ext) {
        this.ext = ext;
    }
}
