/************************************************************
 *  * EaseMob CONFIDENTIAL
 * __________________
 * Copyright (C) 2013-2014 EaseMob Technologies. All rights reserved.
 *
 * NOTICE: All information contained herein is, and remains
 * the property of EaseMob Technologies.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from EaseMob Technologies.
 */
package com.hyphenate.chat;

import android.os.Parcel;
import android.os.Parcelable;

import com.hyphenate.chat.adapter.message.EMATextMessageBody;

/**
 * \~chinese
 * 文本消息体
 * <pre>
 *     EMTextMessageBody body = new EMTextMessageBody("hello hyphenate chat sdk!");
 * </pre>
 *
 * \~english
 * Text message body
 * <pre>
 *     EMTextMessageBody body = new EMTextMessageBody("hello hyphenate chat sdk!");
 * </pre>
 */
public class EMTextMessageBody extends EMMessageBody implements Parcelable {

    /**
     * \~chinese
     * 创建一个文本消息体
     *
     * @param msg 消息内容
     *
     * \~english
     * Create a text message body
     *
     * @param msg text content
     */
    public EMTextMessageBody(String msg) {
        emaObject = new EMATextMessageBody(msg);
    }

    EMTextMessageBody(EMATextMessageBody body) {
        emaObject = body;
    }

    /**
     * \~chinese
     * 获取文本消息内容
     *
     * @return  消息内容
     *
     * \~english
     * Get text message body
     *
     * @return  content
     */
    public String getMessage() {
        return ((EMATextMessageBody) emaObject).text();
    }

    /**
     * \~chinese
     * 设置文本消息内容
     * 注：只能修改本地数据
     *
     * @param message 消息内容
     *
     * \~english
     * Set text message body's content
     * Note: modify local data only
     *
     * @param message Text content
     */
    public void setMessage(String message) {
        ((EMATextMessageBody) emaObject).setText(message);
    }

    public String toString() {
        return "txt:\"" + ((EMATextMessageBody) emaObject).text() + "\"";
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(((EMATextMessageBody) emaObject).text());
    }

    public static final Parcelable.Creator<EMTextMessageBody> CREATOR
            = new Parcelable.Creator<EMTextMessageBody>() {
        public EMTextMessageBody createFromParcel(Parcel in) {
            return new EMTextMessageBody(in);
        }

        public EMTextMessageBody[] newArray(int size) {
            return new EMTextMessageBody[size];
        }
    };

    private EMTextMessageBody(Parcel in) {
        emaObject = new EMATextMessageBody(in.readString());
    }
}
