/************************************************************
 *  * EaseMob CONFIDENTIAL 
 * __________________ 
 * Copyright (C) 2013-2014 EaseMob Technologies. All rights reserved. 
 *  
 * NOTICE: All information contained herein is, and remains 
 * the property of EaseMob Technologies.
 * Dissemination of this information or reproduction of this material 
 * is strictly forbidden unless prior written permission is obtained
 * from EaseMob Technologies.
 */
package com.hyphenate.chat;

import android.content.Context;
import android.content.SharedPreferences;
import android.content.SharedPreferences.Editor;
import android.preference.PreferenceManager;
import android.text.TextUtils;

import com.hyphenate.chat.adapter.EMAREncryptUtils;
import com.hyphenate.chat.adapter.EMASessionManager;
import com.hyphenate.util.CryptoUtils;
import com.hyphenate.util.EMLog;

class EMSessionManager {
	private static final String TAG = "Session";

	private Context appContext = null;

	private final static String PREF_KEY_LOGIN_USER = "easemob.chat.loginuser";
	private final static String PREF_KEY_LOGIN_PWD = "easemob.chat.loginpwd";
	private final static String PREF_KEY_LOGIN_TOKEN = "easemob.chat.login.token";
	private final static String PREF_KEY_LOGIN_WITH_TOKEN = "easemob.chat.login_with_token";
	private final static String PREF_KEY_LOGIN_PWD_GCM = "easemob.chat.loginpwd.gcm";
	private final static String PREF_KEY_LOGIN_TOKEN_GCM = "easemob.chat.login.token.gcm";


	/**
	 * the static variable for current login user
	 */
	public EMContact currentUser = null;
 
	private static EMSessionManager instance = new EMSessionManager();

	private String lastLoginUser = null;
	private String lastLoginPwd = null;
	private String lastLoginToken = null;

	EMClient mClient;
	EMASessionManager mSessionManager;
	private EMAREncryptUtils encryptUtils;


	static synchronized EMSessionManager getInstance(){
		if(instance.appContext == null){
			instance.appContext = EMClient.getInstance().getContext();
		}

		return instance;
	}

	void init(EMClient client, EMASessionManager sessionManager) {
		this.mClient = client;
		this.mSessionManager = sessionManager;
		encryptUtils = new EMAREncryptUtils();
	}

	/**
	 * get the username who has been logined successfully. this method will be
	 * called during sdk init.
	 * 
	 * @return
	 */
	String getLastLoginUser() {
		if (lastLoginUser == null) {
			SharedPreferences setting = PreferenceManager.getDefaultSharedPreferences(appContext);
			lastLoginUser = setting.getString(PREF_KEY_LOGIN_USER, "");
			currentUser = new EMContact(lastLoginUser);
		}
		return lastLoginUser;
	}

	void setLastLoginUser(String username) {
		if(username == null){
			return;
		}
		currentUser = new EMContact(username);
		lastLoginUser = username;
		SharedPreferences setting = PreferenceManager.getDefaultSharedPreferences(appContext);
		Editor editor = setting.edit();
		editor.putString(PREF_KEY_LOGIN_USER, username);
		editor.commit();
	}

	String getLastLoginPwd() {
		if (lastLoginPwd == null) {
			SharedPreferences setting = PreferenceManager.getDefaultSharedPreferences(appContext);
			String encryptedPwd = setting.getString(PREF_KEY_LOGIN_PWD_GCM, "");

            if(TextUtils.isEmpty(encryptedPwd)){
            	encryptedPwd = setting.getString(PREF_KEY_LOGIN_PWD, "");
            	if(TextUtils.isEmpty(encryptedPwd)) {
					lastLoginPwd = "";
					return lastLoginPwd;
            	}
				try {
					CryptoUtils crytoUtils = EMClient.getInstance().getCryptoUtils();
					lastLoginPwd = crytoUtils.decryptBase64String(encryptedPwd);
				} catch (Exception e) {
					e.printStackTrace();
				}
                return lastLoginPwd;
            }

			try {
				lastLoginPwd = decryptData(mSessionManager.getEncryptionKey(getLastLoginUser()), encryptedPwd);
			} catch (Exception e) {
				e.printStackTrace();
			}
		}
		return lastLoginPwd;
	}

	void setLastLoginPwd(String pwd) {
		if(pwd == null){
			return;
		}

		lastLoginPwd = pwd;
		SharedPreferences setting = PreferenceManager.getDefaultSharedPreferences(appContext);
		Editor editor = setting.edit();
		// save password in encryption mode
		try {
			String encrypedPwd = encryptData(mSessionManager.getEncryptionKey(getLastLoginUser()), pwd);
			editor.putString(PREF_KEY_LOGIN_PWD_GCM, encrypedPwd);
			editor.commit();
		} catch (Exception e) {
			e.printStackTrace();
		}
	}

	String getLastLoginToken() {
		if (lastLoginToken == null) {
			SharedPreferences setting = PreferenceManager.getDefaultSharedPreferences(appContext);
			String encryptedToken = setting.getString(PREF_KEY_LOGIN_TOKEN_GCM, "");

			if(TextUtils.isEmpty(encryptedToken)){
				encryptedToken = setting.getString(PREF_KEY_LOGIN_TOKEN, "");
				if(TextUtils.isEmpty(encryptedToken)) {
					lastLoginToken = "";
					return lastLoginToken;
				}
				try {
					CryptoUtils crytoUtils = EMClient.getInstance().getCryptoUtils();
					lastLoginToken = crytoUtils.decryptBase64String(encryptedToken);
				} catch (Exception e) {
					e.printStackTrace();
				}
				return lastLoginToken;
			}

			try {
				lastLoginToken = decryptData(mSessionManager.getEncryptionKey(getLastLoginUser()), encryptedToken);
			} catch (Exception e) {
				e.printStackTrace();
			}
		}
		return lastLoginToken;
	}

	void setLastLoginToken(String token) {
		if(token == null){
			return;
		}

		lastLoginToken = token;
		SharedPreferences setting = PreferenceManager.getDefaultSharedPreferences(appContext);
		Editor editor = setting.edit();
		// save password in encryption mode
		try {
			String encrypedToken = encryptData(mSessionManager.getEncryptionKey(getLastLoginUser()), token);

			editor.putString(PREF_KEY_LOGIN_TOKEN_GCM, encrypedToken);
			editor.commit();
		} catch (Exception e) {
			e.printStackTrace();
		}
	}

	void clearLastLoginUser(){
		try{
			lastLoginUser = "";
			currentUser.username = "";
			currentUser.nick = "";
			SharedPreferences setting = PreferenceManager.getDefaultSharedPreferences(appContext);
			Editor editor = setting.edit();
			editor.putString(PREF_KEY_LOGIN_USER, lastLoginUser);
			editor.commit();
		}catch(Exception e){
			e.printStackTrace();
		}
	}
	
	void clearLastLoginPwd(){
		try{
			lastLoginPwd = "";
			SharedPreferences setting = PreferenceManager.getDefaultSharedPreferences(appContext);
			Editor editor = setting.edit();
			editor.putString(PREF_KEY_LOGIN_PWD, lastLoginPwd);
			editor.putString(PREF_KEY_LOGIN_PWD_GCM, lastLoginPwd);
			editor.commit();
		}catch(Exception e){
			e.printStackTrace();
		}
	}

	void clearLastLoginToken(){
		try{
			lastLoginToken = "";
			SharedPreferences setting = PreferenceManager.getDefaultSharedPreferences(appContext);
			Editor editor = setting.edit();
			editor.putString(PREF_KEY_LOGIN_TOKEN, lastLoginToken);
			editor.putString(PREF_KEY_LOGIN_TOKEN_GCM, lastLoginToken);
			editor.commit();
		}catch(Exception e){
			e.printStackTrace();
		}
	}

	/**
	 * whether last login with token
	 * this method will be called during sdk init.
	 *
	 * @return
	 */
	boolean isLastLoginWithToken() {
		SharedPreferences setting = PreferenceManager.getDefaultSharedPreferences(appContext);
		return setting.getBoolean(PREF_KEY_LOGIN_WITH_TOKEN, false);
	}

	void setLastLoginWithToken(boolean loginWithToken) {
		SharedPreferences setting = PreferenceManager.getDefaultSharedPreferences(appContext);
		Editor editor = setting.edit();
		editor.putBoolean(PREF_KEY_LOGIN_WITH_TOKEN, loginWithToken);
		editor.commit();
	}

	public String getLoginUserName() {
		return currentUser.username;
	}

	String encryptData(byte[] key, String data) {
		encryptUtils.initAES(key);
		return encryptUtils.aesGcmEncrypt(data, 1);
	}

	String decryptData(byte[] key, String encryptData) {
		encryptUtils.initAES(key);
		return encryptUtils.aesGcmDecrypt(encryptData, key, 1);
	}
}