/*
 *  * EaseMob CONFIDENTIAL
 * __________________
 * Copyright (C) 2017 EaseMob Technologies. All rights reserved.
 *
 * NOTICE: All information contained herein is, and remains
 * the property of EaseMob Technologies.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from EaseMob Technologies.
 */
package com.hyphenate.chat;

import com.hyphenate.chat.adapter.EMAPushConfigs;

/**
 * \~chinese
 * 推送配置信息类
 * \~english
 * Push configs info class
 */
public class EMPushConfigs extends EMBase<EMAPushConfigs>{

    public EMPushConfigs(EMAPushConfigs pushConfigs){
        emaObject = pushConfigs;
    }


    /**
     * \~chinese
     * 获取推送昵称
     * @return  推送昵称
     *
     * \~english
     * Get the push nickname
     * @return Push nickname
     */
    public String getDisplayNickname() {
        return emaObject.getDisplayNickname();
    }

//    public void setDisplayNickname(String displayNickname) {
//        this.displayNickname = displayNickname;
//    }

    /**
     * \~chinese
     * 获取是否开启离线推送免打扰
     * 可通过{@link EMPushManager#disableOfflinePush(int, int)}设置
     * @return  是否开启离线推送免打扰
     *
     * \~english
     * Gets whether to enable offline push without disturbing
     * Set by {@link EMPushManager#disableOfflinePush(int, int)}
     * @return WHether to enable offline push without disturbing
     */
    public boolean isNoDisturbOn() {
        return emaObject.isNoDisturbOn();
    }

//    public void setNoDisturbOn(boolean noDisturbOn) {
//        isNoDisturbOn = noDisturbOn;
//    }

    /**
     * \~chinese
     * 获取离线推送免打扰开始的时间
     * @return  ç
     *
     * \~english
     * Gets the start hour of the offline push without disturbing
     * @return Start hour of the offline push without disturbing
     */
    public int getNoDisturbStartHour() {
        return emaObject.getNoDisturbStartHour();
    }

//    public void setNoDisturbStartHour(int noDisturbStartHour) {
//        this.noDisturbStartHour = noDisturbStartHour;
//    }

    /**
     * \~chinese
     * 获取离线推送免打扰结束的时间
     * @return  获取离线推送免打扰结束的时间
     *
     * \~english
     * Gets the end hour of the offline push without disturbing
     * @return End hour of the offline push without disturbing
     */
    public int getNoDisturbEndHour() {
        return emaObject.getNoDisturbEndHour();
    }

//    public void setOnDisturbEndHour(int onDisturbEndHour) {
//        this.onDisturbEndHour = onDisturbEndHour;
//    }

    /**
     * \~chinese
     * 获取离线推送展示类型
     * @return  离线推送展示类型
     *
     * \~english
     * Gets the offline push display type
     * @return Offline push display type
     */
    public EMPushManager.DisplayStyle getDisplayStyle() {
        return EMPushManager.DisplayStyle.values()[emaObject.getDisplayStyle()];
    }
}
