/*
 *  * EaseMob CONFIDENTIAL
 * __________________
 * Copyright (C) 2017 EaseMob Technologies. All rights reserved.
 *
 * NOTICE: All information contained herein is, and remains
 * the property of EaseMob Technologies.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from EaseMob Technologies.
 */
package com.hyphenate.chat;

import java.util.List;

/**
 * \~chinese
 * 分页获取时返回此对象
 * 返回下一页的页数及下一页拥有数据的条数，如果pageCount小于传入的每页要获取的数量，代表没有更多的数据了
 * @param <T> 范型
 *
 * \~english
 * This object is returned when paged
 * Return the next page count and the data count of next page. If pageCount is less than the count which pass,
 * there is no more data on server
 * @param <T>
 */
public class EMPageResult<T> extends EMResult<List<T>> {
    private int pageCount;
    
    void setPageCount(int count) {
        this.pageCount = count;
    }
    
    public int getPageCount() {
        return pageCount;
    }

}
